/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.workorder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.EmployeeView;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EisUtilService;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.AssetsForEstimate;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.tender.EstimateLineItemsForWP;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.tender.TenderResponseActivity;
import org.egov.works.models.tender.TenderResponseContractors;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.TenderResponseService;
import org.egov.works.services.WorkOrderService;
import org.egov.works.services.WorksService;
import org.egov.works.utils.DateConversionUtil;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.egov.works.web.actions.workorder.AjaxWorkOrderAction;
import org.egov.works.web.actions.workorder.WorkOrderNoticeEsimateInfo;
import org.egov.works.workorder.entity.AssetsForWorkOrder;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"print"}, type="stream", location="WorkOrderPDF", params={"inputName", "WorkOrderPDF", "contentType", "application/pdf", "contentDisposition", "no-cache"}), @Result(name={"workOrderNotice"}, type="stream", location="WorkOrderPDF", params={"inputName", "WorkOrderPDF", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=WorkOrderNotice.pdf"}), @Result(name={"new"}, location="workOrder-new.jsp")})
public class WorkOrderAction
extends BaseFormAction {
    private static final long serialVersionUID = -8902400945730474523L;
    private static final String SAVE_ACTION = "save";
    public static final String APPROVED = "APPROVED";
    private final NumberFormat formatter = new DecimalFormat("#0.00");
    private WorkOrder workOrder = new WorkOrder();
    private WorkOrderService workOrderService;
    private WorksService worksService;
    private TenderResponseService tenderResponseService;
    private AbstractEstimateService abstractEstimateService;
    private PersistenceService<OfflineStatus, Long> worksStatusService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EmployeeServiceOld employeeServiceOld;
    @Autowired
    private UserService userService;
    @Autowired
    private DepartmentService departmentService;
    private EisUtilService eisService;
    private Long tenderRespId;
    private TenderResponse tenderResponse;
    private Long deptId;
    private Integer empId;
    private String editableDate;
    private String createdBySelection;
    private String status;
    private Double activityAssignedAmt;
    private Date fromDate;
    private Date toDate;
    private Long assignedTo1;
    private Long assignedTo2;
    private String messageKey;
    private Long id;
    private String setStatus;
    private String mode;
    private static final String PREPARED_BY_LIST = "preparedByList";
    private static final String DEPARTMENT_LIST = "departmentList";
    private static final String ASSIGNED_TO_LIST = "assignedToList";
    private static final String ASSIGNED_USER_LIST1 = "assignedUserList1";
    private static final String ASSIGNED_USER_LIST2 = "assignedUserList2";
    private static final String OBJECT_TYPE = "TenderResponse";
    private static final String WO_OBJECT_TYPE = "WorkOrder";
    private static final String STATUS_OBJECTID = "getStatusDateByObjectId_Type_Desc";
    private static final String WORK_ORDER_CREATIONDATE = "STATUS_FOR_WORKORDER_CREATION";
    private static final String SITE_HAND_OVER = "Site handed over";
    private static final String WORK_COMMENCED = "Work commenced";
    private static final String WF_APPROVED = "APPROVED";
    private static final String SEARCH_WO = "searchWorkOrder";
    private static final String DATE_FORMAT = "dd-MMM-yyyy";
    private static final String SOURCE_INBOX = "inbox";
    private List<Designation> workOrderDesigList = new ArrayList();
    private List<WorkOrder> workOrderList = null;
    private Long workOrderId;
    private String sourcepage = "";
    private String percTenderType = "";
    private String tenderResponseType = null;
    private WorkflowService<WorkOrder> workOrderWorkflowService;
    private OfflineStatus setStatusObj;
    public static final String PRINT = "print";
    private InputStream workOrderPDF;
    private ReportService reportService;
    private String employeeName;
    private String designation;
    private String estimateNumber;
    private String wpNumber;
    private String tenderFileNumber;
    private PersonalInformationService personalInformationService;
    private Long tenderRespContrId;
    private TenderResponseContractors tenderResponseContractor;
    private PersistenceService<TenderResponseContractors, Long> tenderResponseContractorsService;
    private Double securityDepositConfValue;
    private Double labourWelfareFundConfValue;
    private List<WorkOrderActivity> actionWorkOrderActivities = new LinkedList();
    private List<WorkOrderActivity> woActivities = new LinkedList();
    private PersistenceService<Activity, Long> activityService;
    private Integer page = 1;
    private Integer pageSize = 30;
    private EgovPaginatedList pagedResults;
    private String cancellationReason;
    private String cancelRemarks;
    private String workOrderNo;
    private String woStatus;
    private static final Logger logger = Logger.getLogger(WorkOrderAction.class);
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
    private Date contractPeriodCutOffDate;
    private Integer defaultPreparedBy;
    private Long defaultDepartmentId;
    private final String loggedInUserEmployeeCode;
    private Long estimateId;
    private AbstractEstimate abstractEstimate = null;
    private Boolean isWorkCommenced;
    private Integer reportId = -1;
    protected static final String WORKORDERNOTICEPDF = "workOrderNotice";
    public static final String WORKFLOW_ENDS = "END";

    public WorkOrderAction() {
        this.loggedInUserEmployeeCode = null;
        this.addRelatedEntity("contractor", Contractor.class);
        this.addRelatedEntity("engineerIncharge", PersonalInformation.class);
        this.addRelatedEntity("engineerIncharge2", PersonalInformation.class);
        this.addRelatedEntity("workOrderPreparedBy", PersonalInformation.class);
    }

    public void prepare() {
        List tenderTypeList;
        if (this.estimateId != null) {
            this.abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.estimateId, false);
        }
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        AjaxWorkOrderAction ajaxWorkOrderAction = new AjaxWorkOrderAction();
        ajaxWorkOrderAction.setPersistenceService(this.getPersistenceService());
        ajaxWorkOrderAction.setPersonalInformationService(this.personalInformationService);
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        ajaxEstimateAction.setAssignmentService(this.assignmentService);
        ajaxEstimateAction.setAbstractEstimateService(this.abstractEstimateService);
        ajaxEstimateAction.setEisService(this.eisService);
        this.addDropdownData("executingDepartmentList", this.getPersistenceService().findAllBy("from DepartmentImpl order by upper(deptName)", new Object[0]));
        if (this.worksService != null && (tenderTypeList = this.worksService.getTendertypeList()) != null && !tenderTypeList.isEmpty()) {
            this.percTenderType = (String)tenderTypeList.get(0);
        }
        if (this.tenderRespId != null) {
            this.tenderResponse = (TenderResponse)this.tenderResponseService.findById((Serializable)this.tenderRespId, false);
            if (this.tenderRespContrId != null) {
                this.tenderResponseContractor = (TenderResponseContractors)this.tenderResponseContractorsService.findById((Serializable)this.tenderRespContrId, false);
            }
            if (this.tenderResponse.getTenderResponseContractors().size() > 1) {
                this.workOrder.setWorkOrderAmount(0.0);
            } else {
                this.workOrder.setWorkOrderAmount(this.getEstimateAmountAfterNego());
            }
            this.tenderResponse.setActivitiesForWorkorder(this.workOrderService.getActivitiesForWorkorder(this.tenderResponse));
        }
        if (this.id != null) {
            this.workOrder = (WorkOrder)this.workOrderService.findById((Serializable)this.id, false);
            Date woNoticeFlag = this.workOrderService.getWorkCommencedDateByWOId(this.id);
            this.isWorkCommenced = woNoticeFlag != null;
            this.tenderResponse = this.workOrder.getEgwStatus().getCode().equalsIgnoreCase("cancelled") ? (TenderResponse)this.tenderResponseService.findByNamedQuery("getTenderFortenderIdCanceledWO", new Object[]{this.workOrder.getNegotiationNumber(), this.workOrder.getId(), this.workOrder.getTenderNumber(), this.workOrder.getContractor().getId(), this.workOrder.getPackageNumber()}) : (TenderResponse)this.tenderResponseService.findByNamedQuery("getTenderFortenderId", new Object[]{this.workOrder.getTenderNumber()});
            this.tenderRespId = this.tenderResponse.getId();
            this.tenderResponse.setWorkOrderAmount(this.getWorkOrderAmount());
            this.tenderResponseContractor = (TenderResponseContractors)this.tenderResponseContractorsService.find("from TenderResponseContractors where contractor.id=? and tenderResponse.id=?", new Object[]{this.workOrder.getContractor().getId(), this.tenderResponse.getId()});
            this.tenderRespContrId = this.tenderResponseContractor.getId();
            this.setWorkOrderActivities(this.workOrder);
        }
        super.prepare();
        if (this.tenderResponse != null) {
            this.deptId = this.tenderResponse.getTenderEstimate().getAbstractEstimate() == null ? this.tenderResponse.getTenderEstimate().getWorksPackage().getDepartment().getId() : this.tenderResponse.getTenderEstimate().getAbstractEstimate().getExecutingDepartment().getId();
        }
        this.setupDropdownDataExcluding(new String[]{"contractor", "engineerIncharge", "engineerIncharge2", "workOrderPreparedBy"});
        if (StringUtils.isNotBlank((String)this.getCreatedBy()) && "yes".equalsIgnoreCase(this.getCreatedBy())) {
            this.setCreatedBySelection(this.getCreatedBy());
            this.addDropdownData(DEPARTMENT_LIST, this.departmentService.getAllDepartments());
            this.populatePreparedByList(ajaxEstimateAction, this.deptId != null);
        } else {
            List empViewList = this.getUsersInDepartment();
            if (empViewList != null && empViewList.size() == 1) {
                this.defaultPreparedBy = ((EmployeeView)empViewList.get(0)).getId().intValue();
            }
            this.addDropdownData(PREPARED_BY_LIST, empViewList);
            this.defaultDepartmentId = this.deptId;
            if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null && this.tenderResponse.getTenderEstimate().getWorksPackage() != null && this.tenderResponse.getTenderEstimate().getWorksPackage().getDepartment() != null) {
                this.addDropdownData(DEPARTMENT_LIST, Arrays.asList(this.tenderResponse.getTenderEstimate().getWorksPackage().getDepartment()));
            }
            this.setCreatedBySelection(this.getCreatedBy());
        }
        if (StringUtils.isNotBlank((String)this.getPastDate())) {
            this.setEditableDate(this.getPastDate());
        }
        this.populateWorkOrderAssignedToList(ajaxWorkOrderAction, this.deptId != null);
        this.populateWorkOrderUsersList1(ajaxWorkOrderAction, this.assignedTo1 != null, this.deptId != null);
        this.populateWorkOrderUsersList2(ajaxWorkOrderAction, this.assignedTo2 != null, this.deptId != null);
        this.addDropdownData("deptListForSearch", this.departmentService.getAllDepartments());
        this.getDeptList();
        String cutOffDate = this.worksService.getWorksConfigValue("CONTRACT_PERIOD_CUT_OFF_DATE");
        if (StringUtils.isNotBlank((String)cutOffDate)) {
            try {
                this.contractPeriodCutOffDate = this.dateFormatter.parse(cutOffDate);
            }
            catch (ParseException pe) {
                logger.error((Object)"Unable to parse contract period cut off date");
            }
        }
        if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null && this.tenderResponse.getTenderEstimate().getTenderType() != null && this.tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase(this.percTenderType)) {
            this.tenderResponseType = this.tenderResponse.getTenderEstimate().getTenderType();
        }
        if ("cancelWO".equals(this.sourcepage)) {
            this.setWoStatus("APPROVED");
        }
    }

    private List getUsersInDepartment() {
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        ajaxEstimateAction.setAssignmentService(this.assignmentService);
        ajaxEstimateAction.setEisService(this.eisService);
        if (this.deptId != null) {
            ajaxEstimateAction.setExecutingDepartment(this.deptId);
        } else if (this.tenderResponse != null) {
            if (this.tenderResponse.getTenderEstimate().getAbstractEstimate() == null) {
                ajaxEstimateAction.setExecutingDepartment(this.tenderResponse.getTenderEstimate().getWorksPackage().getDepartment().getId());
            } else {
                ajaxEstimateAction.setExecutingDepartment(this.tenderResponse.getTenderEstimate().getAbstractEstimate().getExecutingDepartment().getId());
            }
        }
        ajaxEstimateAction.setEmployeeCode(this.loggedInUserEmployeeCode);
        ajaxEstimateAction.usersInExecutingDepartment();
        return ajaxEstimateAction.getUsersInExecutingDepartment();
    }

    @Action(value="/workorder/worksOrder-newform")
    public String newform() {
        this.workOrder.setSecurityDeposit(this.getSecurityDepositConfValue() / 100.0 * this.workOrder.getWorkOrderAmount());
        this.workOrder.setLabourWelfareFund(this.getLabourWelfareFundConfValue() / 100.0 * this.workOrder.getWorkOrderAmount());
        return "new";
    }

    public String save() {
        String actionName = ((String[])this.parameters.get("actionName"))[0];
        if (this.workOrder.getEgwStatus() == null || "REJECTED".equalsIgnoreCase(this.workOrder.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.workOrder.getEgwStatus().getCode())) {
            this.workOrder.getWorkOrderEstimates().clear();
            this.populateWorkOrderActivities();
        }
        try {
            this.workOrderService.setWorkOrderNumber(this.tenderResponse.getTenderEstimate().getAbstractEstimate(), this.workOrder, this.tenderResponse.getTenderEstimate().getWorksPackage());
        }
        catch (ValidationException sequenceException) {
            this.setSourcepage(SOURCE_INBOX);
            List errorList = sequenceException.getErrors();
            for (ValidationError error : errorList) {
                if (!error.getMessage().contains("DatabaseSequenceFirstTimeException")) continue;
                this.prepare();
                throw new ValidationException(Arrays.asList(new ValidationError("error", error.getMessage())));
            }
        }
        if (this.workOrder.getEgwStatus() == null || "REJECTED".equalsIgnoreCase(this.workOrder.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.workOrder.getEgwStatus().getCode())) {
            this.validateWorkOrderDate();
        }
        if (SAVE_ACTION.equals(actionName) && this.workOrder.getEgwStatus() == null) {
            this.workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(WO_OBJECT_TYPE, "NEW"));
        }
        this.workOrder = (WorkOrder)this.workOrderService.persist((Object)this.workOrder);
        this.workOrder = (WorkOrder)this.workOrderWorkflowService.transition(actionName, (StateAware)this.workOrder, "");
        if (this.workOrder.getEgwStatus() != null && "APPROVED".equalsIgnoreCase(this.workOrder.getEgwStatus().getCode())) {
            this.messageKey = "workOrder.approved";
            this.workOrder.setApprovedDate(new Date());
        } else {
            this.messageKey = "workorder.save.success";
        }
        this.addActionMessage(this.getText(this.messageKey, this.messageKey));
        this.getDesignation(this.workOrder);
        if (this.workOrder.getEgwStatus() == null || "REJECTED".equalsIgnoreCase(this.workOrder.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.workOrder.getEgwStatus().getCode())) {
            this.setWorkOrderActivities(this.workOrder);
        }
        if (SAVE_ACTION.equals(actionName)) {
            this.sourcepage = SOURCE_INBOX;
        }
        return SAVE_ACTION.equals(actionName) ? "edit" : "success";
    }

    public String cancel() {
        String actionName = ((String[])this.parameters.get("actionName"))[0];
        if (this.workOrder.getId() != null) {
            this.workOrderWorkflowService.transition(actionName, (StateAware)this.workOrder, "");
            this.workOrder = (WorkOrder)this.workOrderService.persist((Object)this.workOrder);
        }
        this.messageKey = "workorder.cancel";
        return "success";
    }

    public void getDesignation(WorkOrder workOrder) {
        String result;
        if (workOrder.getEgwStatus() != null && !"NEW".equalsIgnoreCase(workOrder.getEgwStatus().getCode()) && (result = this.worksService.getEmpNameDesignation(workOrder.getState().getOwnerPosition(), workOrder.getState().getCreatedDate())) != null && !"@".equalsIgnoreCase(result)) {
            String empName = result.substring(0, result.lastIndexOf(64));
            String designation = result.substring(result.lastIndexOf(64) + 1, result.length());
            this.setEmployeeName(empName);
            this.setDesignation(designation);
        }
    }

    private void validateWorkOrderDate() {
        if (this.getWorkOrderCreationDate() == null && this.workOrder.getWorkOrderDate() != null && this.tenderResponse.getEgwStatus() != null && TenderResponse.TenderResponseStatus.APPROVED.toString().equals(this.tenderResponse.getEgwStatus().getCode()) && DateConversionUtil.isBeforeByDate((Date)this.workOrder.getWorkOrderDate(), (Date)this.tenderResponse.getState().getCreatedDate())) {
            throw new ValidationException(Arrays.asList(new ValidationError("workorder.workorderDate.lessthan.approvedDate", "workorder.workorderDate.lessthan.approvedDate")));
        }
        if (this.getWorkOrderCreationDate() != null && this.workOrder.getWorkOrderDate() != null && DateConversionUtil.isBeforeByDate((Date)this.workOrder.getWorkOrderDate(), (Date)this.getWorkOrderCreationDate())) {
            throw new ValidationException(Arrays.asList(new ValidationError("workorder.workorderDate.lessthan.statusDate", this.getText("workorder.workorderDate.lessthan.statusDate", new String[]{this.setStatusObj.getEgwStatus().getDescription()}))));
        }
    }

    @SkipValidation
    public String viewWorkOrderPdf() throws JRException, Exception {
        ReportRequest reportRequest = null;
        Map reportParams = null;
        Double quotedPerc = null;
        Double negotiatedPerc = null;
        Double quotedAmount = null;
        Double negotiatedAmount = null;
        Double estimateAmt = null;
        TenderResponse tenderResponse = this.workOrder.getEgwStatus().getCode().equalsIgnoreCase("cancelled") ? (TenderResponse)this.persistenceService.findByNamedQuery("getTenderFortenderIdCanceledWO", new Object[]{this.workOrder.getNegotiationNumber(), this.workOrder.getId(), this.workOrder.getTenderNumber(), this.workOrder.getContractor().getId(), this.workOrder.getPackageNumber()}) : (TenderResponse)this.persistenceService.findByNamedQuery("getTenderFortenderId", new Object[]{this.workOrder.getTenderNumber()});
        List tenderTypeList = this.worksService.getTendertypeList();
        if (tenderTypeList != null && !tenderTypeList.isEmpty()) {
            this.percTenderType = (String)tenderTypeList.get(0);
        }
        if (tenderResponse != null && tenderResponse.getTenderEstimate() != null && tenderResponse.getTenderEstimate().getTenderType() != null && tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase(this.percTenderType)) {
            quotedPerc = tenderResponse.getPercQuotedRate();
            negotiatedPerc = tenderResponse.getPercNegotiatedAmountRate();
            quotedAmount = null;
            negotiatedAmount = null;
            estimateAmt = tenderResponse.getTenderResponseContractors().size() > 1 ? (negotiatedPerc >= 0.0 ? Double.valueOf(this.workOrder.getWorkOrderAmount() / (1.0 + Math.abs(negotiatedPerc) / 100.0)) : Double.valueOf(this.workOrder.getWorkOrderAmount() / (1.0 - Math.abs(negotiatedPerc) / 100.0))) : Double.valueOf(this.getWorkOrderAmount());
            quotedAmount = quotedPerc >= 0.0 ? Double.valueOf(estimateAmt + estimateAmt * (Math.abs(quotedPerc) / 100.0)) : Double.valueOf(estimateAmt - estimateAmt * (Math.abs(quotedPerc) / 100.0));
            negotiatedAmount = negotiatedPerc >= 0.0 ? Double.valueOf(estimateAmt + estimateAmt * (Math.abs(negotiatedPerc) / 100.0)) : Double.valueOf(estimateAmt - estimateAmt * (Math.abs(negotiatedPerc) / 100.0));
        }
        if (this.workOrder.getPackageNumber() == null) {
            reportParams = this.workOrderService.createHeaderParams(this.workOrder, "estimate");
            reportParams.put("WORKORDER_BILLOFQUANTITIES_LIST", this.workOrderService.getActivitiesForWorkorder(this.workOrder));
            reportParams.put("quotedAmount", quotedAmount);
            reportParams.put("quotedPerc", quotedPerc);
            reportParams.put("negotiatedAmount", negotiatedAmount);
            reportParams.put("negotiatedPerc", negotiatedPerc);
            reportParams.put("estimateAmt", estimateAmt);
            reportRequest = new ReportRequest("workorderForEstimate", (Object)this.workOrder, reportParams);
        } else {
            reportParams = this.workOrderService.createHeaderParams(this.workOrder, "wp");
            reportParams.put("WORKORDER_BILLOFQUANTITIES_LIST", this.workOrderService.getActivitiesForWorkorder(this.workOrder));
            reportParams.put("quotedAmount", quotedAmount);
            reportParams.put("quotedPerc", quotedPerc);
            reportParams.put("negotiatedAmount", negotiatedAmount);
            reportParams.put("negotiatedPerc", negotiatedPerc);
            reportRequest = new ReportRequest("workorderForWp", (Collection)this.workOrderService.getAeForWp(this.workOrder), reportParams);
            reportParams.put("estimateAmt", estimateAmt);
        }
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.workOrderPDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return PRINT;
    }

    private void populateWorkOrderActivities() {
        block9: {
            block7: {
                block8: {
                    if (this.tenderResponse == null || this.tenderResponse.getTenderResponseContractors().size() != 1) break block7;
                    if (this.tenderResponse.getTenderEstimate().getWorksPackage() != null) break block8;
                    WorkOrderEstimate workOrderEstimate = new WorkOrderEstimate();
                    workOrderEstimate.setEstimate(this.tenderResponse.getTenderEstimate().getAbstractEstimate());
                    workOrderEstimate.setWorkOrder(this.workOrder);
                    for (TenderResponseActivity tenderResponseActivity : this.tenderResponse.getTenderResponseActivities()) {
                        this.addTenderResponseActivities(workOrderEstimate, tenderResponseActivity);
                    }
                    workOrderEstimate = this.populateAssets(workOrderEstimate, this.tenderResponse.getTenderEstimate().getAbstractEstimate());
                    this.workOrder.addWorkOrderEstimate(workOrderEstimate);
                    break block9;
                }
                if (this.tenderResponse.getTenderEstimate().getAbstractEstimate() != null) break block9;
                for (AbstractEstimate estimate : this.tenderResponse.getTenderEstimate().getWorksPackage().getAllEstimates()) {
                    WorkOrderEstimate workOrderEstimate = new WorkOrderEstimate();
                    workOrderEstimate.setEstimate(estimate);
                    workOrderEstimate.setWorkOrder(this.workOrder);
                    for (TenderResponseActivity tenderResponseActivity : this.tenderResponse.getTenderResponseActivities()) {
                        for (Activity act : estimate.getActivities()) {
                            if (!act.getId().equals(tenderResponseActivity.getActivity().getId())) continue;
                            this.addTenderResponseActivities(workOrderEstimate, tenderResponseActivity);
                        }
                    }
                    workOrderEstimate = this.populateAssets(workOrderEstimate, estimate);
                    this.workOrder.addWorkOrderEstimate(workOrderEstimate);
                }
                break block9;
            }
            HashMap<Long, WorkOrderEstimate> workOrderEstimateMap = new HashMap<Long, WorkOrderEstimate>();
            for (WorkOrderActivity woActivity : this.getActionWorkOrderActivityList()) {
                if (!workOrderEstimateMap.containsKey(woActivity.getActivity().getAbstractEstimate().getId())) {
                    WorkOrderEstimate workOrderEstimate = new WorkOrderEstimate();
                    workOrderEstimate.setEstimate(woActivity.getActivity().getAbstractEstimate());
                    workOrderEstimate.setWorkOrder(this.workOrder);
                    workOrderEstimate = this.populateAssets(workOrderEstimate, woActivity.getActivity().getAbstractEstimate());
                    workOrderEstimateMap.put(woActivity.getActivity().getAbstractEstimate().getId(), workOrderEstimate);
                }
                WorkOrderActivity workOrderActivity = new WorkOrderActivity();
                workOrderActivity.setActivity(woActivity.getActivity());
                workOrderActivity.setApprovedRate(woActivity.getApprovedRate());
                workOrderActivity.setApprovedQuantity(woActivity.getApprovedQuantity());
                workOrderActivity.setApprovedAmount(new Money(woActivity.getApprovedRate() * woActivity.getApprovedQuantity() * woActivity.getActivity().getConversionFactor()).getValue());
                WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)workOrderEstimateMap.get(woActivity.getActivity().getAbstractEstimate().getId());
                workOrderActivity.setWorkOrderEstimate(workOrderEstimate);
                workOrderEstimate.addWorkOrderActivity(workOrderActivity);
            }
            for (WorkOrderEstimate workOrderEstimate : workOrderEstimateMap.values()) {
                this.workOrder.addWorkOrderEstimate(workOrderEstimate);
            }
        }
    }

    public String edit() {
        if (SOURCE_INBOX.equalsIgnoreCase(this.sourcepage)) {
            User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
            boolean isValidUser = this.worksService.validateWorkflowForUser((StateAware)this.workOrder, user);
            if (isValidUser) {
                throw new ApplicationRuntimeException("Error: Invalid Owner - No permission to view this page.");
            }
        } else if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = "search";
        }
        return "edit";
    }

    public Collection<EstimateLineItemsForWP> getActivitiesForWorkorder() {
        Collection li = null;
        if (this.id == null) {
            this.tenderResponse.setWorkOrderAmount(this.getWorkOrderAmount());
            li = this.workOrderService.getActivitiesForWorkorder(this.tenderResponse);
        } else {
            li = this.workOrderService.getActivitiesForWorkorder(this.workOrder);
        }
        return li;
    }

    public Object getModel() {
        return this.workOrder;
    }

    @ValidationErrorPage(value="searchWorkOrder")
    public String searchWorkOrder() {
        return SEARCH_WO;
    }

    public List<EgwStatus> getWorkOrderStatuses() {
        List woStatusList = this.egwStatusHibernateDAO.getStatusByModule(WorkOrder.class.getSimpleName());
        woStatusList.remove(this.egwStatusHibernateDAO.getStatusByModuleAndCode(WorkOrder.class.getSimpleName(), "NEW"));
        return woStatusList;
    }

    public List<EgwStatus> getWorkOrderStatusesForMBCreation() {
        return this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList(WorkOrder.class.getSimpleName(), this.worksService.getNatureOfWorkAppConfigValues("Works", "WORKORDER_STATUS"));
    }

    public String getWOCreationForEstimateOrWP() {
        return this.worksService.getWorksConfigValue("ESTIMATE_OR_WP_FOR_WO");
    }

    private WorkOrderEstimate populateAssets(WorkOrderEstimate workOrderEstimate, AbstractEstimate estimate) {
        for (AssetsForEstimate assetValue : estimate.getAssetValues()) {
            AssetsForWorkOrder assetsForWorkOrder = new AssetsForWorkOrder();
            assetsForWorkOrder.setAsset(assetValue.getAsset());
            assetsForWorkOrder.setWorkOrderEstimate(workOrderEstimate);
            workOrderEstimate.addAssetValue(assetsForWorkOrder);
        }
        return workOrderEstimate;
    }

    private void addTenderResponseActivities(WorkOrderEstimate workOrderEstimate, TenderResponseActivity tenderResponseActivity) {
        WorkOrderActivity workOrderActivity = new WorkOrderActivity();
        workOrderActivity.setActivity(tenderResponseActivity.getActivity());
        workOrderActivity.setApprovedRate(tenderResponseActivity.getNegotiatedRate());
        workOrderActivity.setApprovedQuantity(tenderResponseActivity.getNegotiatedQuantity());
        workOrderActivity.setApprovedAmount(new Money(workOrderActivity.getApprovedRate() * workOrderActivity.getApprovedQuantity() * tenderResponseActivity.getActivity().getConversionFactor()).getValue());
        workOrderActivity.setWorkOrderEstimate(workOrderEstimate);
        workOrderEstimate.addWorkOrderActivity(workOrderActivity);
    }

    private Date getWorkOrderCreationDate() {
        String statusForCreation = this.getWorkOrderCreationConfValue();
        this.setStatusObj = "0".equals(statusForCreation) ? (OfflineStatus)this.getPersistenceService().findByNamedQuery("getmaxStatusByObjectId", new Object[]{this.tenderRespId, this.tenderRespId, OBJECT_TYPE}) : (OfflineStatus)this.getPersistenceService().findByNamedQuery(STATUS_OBJECTID, new Object[]{this.tenderRespId, OBJECT_TYPE, statusForCreation});
        if (this.setStatusObj != null) {
            return this.setStatusObj.getStatusDate();
        }
        return null;
    }

    private String getWorkOrderCreationConfValue() {
        return this.worksService.getWorksConfigValue(WORK_ORDER_CREATIONDATE);
    }

    public double getWorkOrderAmount() {
        double totalAmt = 0.0;
        for (EstimateLineItemsForWP act : this.workOrderService.getActivitiesForWorkorder(this.tenderResponse)) {
            totalAmt += act.getAmt();
        }
        return totalAmt;
    }

    public String getEstimateAmount() {
        double totalAmt = 0.0;
        for (EstimateLineItemsForWP act : this.workOrderService.getActivitiesForWorksPackage(this.tenderResponse)) {
            totalAmt += act.getAmt();
        }
        return this.formatter.format(totalAmt);
    }

    public double getEstimateAmountAfterNego() {
        double totalAmt = 0.0;
        for (EstimateLineItemsForWP act : this.workOrderService.getActivitiesForWorkorder(this.tenderResponse)) {
            totalAmt += act.getAmt();
        }
        if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null && this.tenderResponse.getTenderEstimate().getTenderType() != null && this.tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase(this.percTenderType)) {
            totalAmt = this.tenderResponse.getPercNegotiatedAmountRate() >= 0.0 ? (totalAmt += totalAmt * Math.abs(this.tenderResponse.getPercNegotiatedAmountRate()) / 100.0) : (totalAmt -= totalAmt * Math.abs(this.tenderResponse.getPercNegotiatedAmountRate()) / 100.0);
        }
        return totalAmt;
    }

    @ValidationErrorPage(value="searchWorkOrder")
    public String searchWorkOrderDetails() {
        HashMap<String, Object> criteriaMap = new HashMap<String, Object>();
        ArrayList paramList = new ArrayList();
        if (StringUtils.isNotBlank((String)this.status) && !this.getStatus().equals("-1")) {
            criteriaMap.put("STATUS", this.status);
        }
        if (StringUtils.isNotBlank((String)this.workOrder.getWorkOrderNumber())) {
            criteriaMap.put("WORKORDER_NO", this.workOrder.getWorkOrderNumber());
        }
        if (StringUtils.isNotBlank((String)this.getEstimateNumber())) {
            criteriaMap.put("ESTIMATE_NO", this.getEstimateNumber());
        }
        if (this.getDeptId() != null && this.getDeptId() > 0L) {
            criteriaMap.put("DEPT_ID", this.getDeptId());
        }
        if (StringUtils.isNotBlank((String)this.getWpNumber())) {
            criteriaMap.put("WP_NO", this.getWpNumber());
        }
        if (StringUtils.isNotBlank((String)this.getTenderFileNumber())) {
            criteriaMap.put("TENDER_FILE_NO", this.getTenderFileNumber());
        }
        if (this.workOrder.getContractor() != null && this.workOrder.getContractor().getId() != -1L) {
            criteriaMap.put("CONTRACTOR_ID", this.workOrder.getContractor().getId());
        }
        if (this.fromDate != null && this.toDate != null && !DateUtils.compareDates((Date)this.getToDate(), (Date)this.getFromDate())) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.fromDate"));
        }
        if (this.toDate != null && !DateUtils.compareDates((Date)new Date(), (Date)this.getToDate())) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.currentdate"));
        }
        if (!this.getFieldErrors().isEmpty()) {
            return SEARCH_WO;
        }
        if (this.fromDate != null && this.toDate == null) {
            criteriaMap.put("FROM_DATE", new Date(DateUtils.getFormattedDate((Date)this.getFromDate(), (String)DATE_FORMAT)));
        } else if (this.toDate != null && this.fromDate == null) {
            criteriaMap.put("TO_DATE", new Date(DateUtils.getFormattedDate((Date)this.getToDate(), (String)DATE_FORMAT)));
        } else if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
            criteriaMap.put("FROM_DATE", new Date(DateUtils.getFormattedDate((Date)this.getFromDate(), (String)DATE_FORMAT)));
            criteriaMap.put("TO_DATE", new Date(DateUtils.getFormattedDate((Date)this.getToDate(), (String)DATE_FORMAT)));
        }
        criteriaMap.put("sourcepage", this.sourcepage);
        if ("searchWOForMBCreation".equals(this.sourcepage)) {
            this.workOrderList = this.workOrderService.searchWOForMB(criteriaMap);
        } else if ("searchWOForBillCreation".equals(this.sourcepage)) {
            this.workOrderList = this.workOrderService.searchWOForBilling(criteriaMap);
        } else {
            Page resPage;
            Long count;
            List qryObj = this.workOrderService.searchWOToPaginatedView(criteriaMap, paramList);
            if (paramList.isEmpty()) {
                Object params = null;
                count = (Long)this.persistenceService.find((String)qryObj.get(0));
                Query qryWithNoParam = this.persistenceService.getSession().createQuery((String)qryObj.get(1));
                resPage = new Page(qryWithNoParam, this.page, this.pageSize);
            } else {
                Object[] params = new Object[paramList.size()];
                params = paramList.toArray(params);
                count = (Long)this.persistenceService.find((String)qryObj.get(0), params);
                resPage = this.persistenceService.findPageBy((String)qryObj.get(1), this.page, this.pageSize, params);
            }
            this.pagedResults = new EgovPaginatedList(resPage, count.intValue());
            List list = this.workOrderList = this.pagedResults != null ? this.pagedResults.getList() : null;
        }
        if (!this.workOrderList.isEmpty()) {
            this.workOrderList = this.getPositionAndUser(this.workOrderList);
        }
        if (!"searchWOForBillCreation".equals(this.sourcepage) && !"searchWOForMBCreation".equals(this.sourcepage)) {
            this.pagedResults.setList(this.workOrderList);
        }
        return SEARCH_WO;
    }

    protected List<WorkOrder> getPositionAndUser(List<WorkOrder> results) {
        ArrayList<WorkOrder> workOrderList = new ArrayList<WorkOrder>();
        for (WorkOrder workOrder : results) {
            PersonalInformation emp;
            if (workOrder.getCurrentState() != null && !workOrder.getEgwStatus().getCode().equalsIgnoreCase("APPROVED") && !workOrder.getEgwStatus().getCode().equalsIgnoreCase("CANCELLED") && (emp = this.employeeServiceOld.getEmployeeforPosition(workOrder.getCurrentState().getOwnerPosition())) != null && StringUtils.isNotBlank((String)emp.getEmployeeName())) {
                workOrder.setOwner(emp.getEmployeeName());
            }
            workOrderList.add(workOrder);
            if (workOrder.getEgwStatus() != null && workOrder.getEgwStatus().getCode().equals("APPROVED")) {
                OfflineStatus set_status = (OfflineStatus)this.persistenceService.findByNamedQuery("getmaxStatusByObjectId_Type", new Object[]{workOrder.getId(), workOrder.getId(), WorkOrder.class.getSimpleName(), WorkOrder.class.getSimpleName()});
                if (set_status == null) {
                    workOrder.setStatus(workOrder.getEgwStatus().getCode());
                } else {
                    workOrder.setStatus(set_status.getEgwStatus().getCode());
                }
            } else if (workOrder.getEgwStatus() != null) {
                workOrder.setStatus(workOrder.getEgwStatus().getCode());
            }
            String approved = this.getApprovedValue();
            String actions = this.worksService.getWorksConfigValue("WORKORDER_SHOW_ACTIONS");
            if (!StringUtils.isNotBlank((String)actions)) continue;
            String setStat = "";
            String workCommencedStatus = "";
            OfflineStatus lastStatus = null;
            workOrder.getWorkOrderActions().addAll(Arrays.asList(actions.split(",")));
            if (workOrder.getId() != null && this.getLastStatus() != null) {
                lastStatus = (OfflineStatus)this.worksStatusService.findByNamedQuery(STATUS_OBJECTID, new Object[]{workOrder.getId(), WO_OBJECT_TYPE, this.getLastStatus()});
            }
            if (lastStatus != null || "view".equalsIgnoreCase(this.setStatus)) {
                setStat = this.worksService.getWorksConfigValue("WORKS_VIEW_OFFLINE_STATUS_VALUE");
            } else if (lastStatus == null && StringUtils.isNotBlank((String)approved) && workOrder.getEgwStatus() != null && approved.equals(workOrder.getEgwStatus().getCode())) {
                setStat = this.worksService.getWorksConfigValue("WORKS_SETSTATUS_VALUE");
            }
            if (StringUtils.isNotBlank((String)setStat)) {
                workOrder.getWorkOrderActions().add(setStat);
            }
            if (lastStatus == null || !lastStatus.getEgwStatus().getCode().equalsIgnoreCase(WORK_COMMENCED) || !StringUtils.isNotBlank((String)(workCommencedStatus = this.worksService.getWorksConfigValue("WORK_ORDER_NOTICE")))) continue;
            workOrder.getWorkOrderActions().add(workCommencedStatus);
        }
        return workOrderList;
    }

    public String getApprovedValue() {
        return "APPROVED";
    }

    public String getLastStatus() {
        return this.worksService.getWorksConfigValue("WorkOrder.laststatus");
    }

    public double getWorkOrderActvitiesAmount(WorkOrder workOrder) {
        double totalAmt = 0.0;
        for (WorkOrderEstimate workOrderEstimate : workOrder.getWorkOrderEstimates()) {
            for (WorkOrderActivity woAct : workOrderEstimate.getWorkOrderActivities()) {
                totalAmt += woAct.getApprovedAmount();
            }
        }
        return totalAmt;
    }

    public List<WorkflowAction> getValidActions() {
        return this.workOrderWorkflowService.getValidActions((StateAware)this.workOrder);
    }

    public String getPastDate() {
        return this.worksService.getWorksConfigValue("WORK_ORDER_PASTDATE");
    }

    private String getMBCreationBySelection() {
        return this.worksService.getWorksConfigValue("MB_CREATED_BY_SELECTION");
    }

    public void getDeptList() {
        if (StringUtils.isNotBlank((String)this.getMBCreationBySelection())) {
            if ("no".equals(this.getMBCreationBySelection())) {
                List deptList = this.worksService.getAllDeptmentsForLoggedInUser();
                this.addDropdownData("deptListForMB", deptList);
            } else {
                this.addDropdownData("deptListForMB", this.departmentService.getAllDepartments());
            }
        } else {
            this.addDropdownData("deptListForMB", Collections.EMPTY_LIST);
        }
    }

    public String getCreatedBy() {
        return this.worksService.getWorksConfigValue("WORK_ORDER_CREATEDBY");
    }

    private void populatePreparedByList(AjaxEstimateAction ajaxEstimateAction, boolean executingDeptPopulated) {
        if (executingDeptPopulated) {
            ajaxEstimateAction.setExecutingDepartment(this.deptId);
            ajaxEstimateAction.usersInExecutingDepartment();
            this.addDropdownData(PREPARED_BY_LIST, ajaxEstimateAction.getUsersInExecutingDepartment());
        } else {
            this.addDropdownData(PREPARED_BY_LIST, Collections.EMPTY_LIST);
        }
    }

    private void populateWorkOrderAssignedToList(AjaxWorkOrderAction ajaxWorkOrderAction, boolean executingDeptPopulated) {
        if (executingDeptPopulated && this.deptId > 0L) {
            ajaxWorkOrderAction.setDepartmentName(this.departmentService.getDepartmentById(Long.valueOf(this.deptId)).getName());
            ajaxWorkOrderAction.getDesignationByDeptId();
            this.addDropdownData(ASSIGNED_TO_LIST, ajaxWorkOrderAction.getWorkOrderDesigList());
        } else {
            this.addDropdownData(ASSIGNED_TO_LIST, Collections.EMPTY_LIST);
        }
    }

    private void populateWorkOrderUsersList1(AjaxWorkOrderAction ajaxWorkOrderAction, boolean desgId, boolean executingDeptPopulated) {
        if (desgId && executingDeptPopulated && this.deptId > 0L) {
            ajaxWorkOrderAction.setDesgId(this.getAssignedTo1());
            ajaxWorkOrderAction.setExecutingDepartment(this.deptId);
            ajaxWorkOrderAction.getUsersForDesg();
            this.addDropdownData(ASSIGNED_USER_LIST1, ajaxWorkOrderAction.getUserList());
        } else {
            this.addDropdownData(ASSIGNED_USER_LIST1, Collections.EMPTY_LIST);
        }
    }

    private void populateWorkOrderUsersList2(AjaxWorkOrderAction ajaxWorkOrderAction, boolean desgId, boolean executingDeptPopulated) {
        if (desgId && executingDeptPopulated && this.deptId > 0L) {
            ajaxWorkOrderAction.setDesgId(this.getAssignedTo2());
            ajaxWorkOrderAction.setExecutingDepartment(this.deptId);
            ajaxWorkOrderAction.getUsersForDesg();
            this.addDropdownData(ASSIGNED_USER_LIST2, ajaxWorkOrderAction.getUserList());
        } else {
            this.addDropdownData(ASSIGNED_USER_LIST2, Collections.EMPTY_LIST);
        }
    }

    public String viewWorkOrderNotice() {
        String nameOfWO = "";
        Locale LOCALE = new Locale("en", "IN");
        SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
        Date wOCommencedDate = this.workOrderService.getWorkCommencedDateByWOId(this.id);
        String workCommencedDate = DDMMYYYYFORMATS.format(wOCommencedDate);
        String approverName = this.getApproverName(this.workOrder);
        List estimates = this.getEstimatesForWO(this.workOrder);
        nameOfWO = estimates.size() == 1 ? ((WorkOrderEstimate)this.workOrder.getWorkOrderEstimates().get(0)).getEstimate().getName() : this.workOrderService.getWorksPackageName(this.workOrder.getPackageNumber());
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("executingDept", ((WorkOrderEstimate)this.workOrder.getWorkOrderEstimates().get(0)).getEstimate().getExecutingDepartment().getName());
        reportParams.put("workOrderNo", this.workOrder.getWorkOrderNumber());
        reportParams.put("contractorNC", this.workOrder.getContractor().getName() + " / " + this.workOrder.getContractor().getCode());
        reportParams.put("contractPeriod", this.workOrder.getContractPeriod());
        reportParams.put("defectLiability", this.workOrder.getDefectLiabilityPeriod());
        reportParams.put("allottedTo", this.workOrder.getEngineerIncharge().getName());
        reportParams.put("nameOfWO", nameOfWO);
        reportParams.put("valueOfWO", NumberUtil.formatNumber((BigDecimal)BigDecimal.valueOf(this.workOrder.getWorkOrderAmount())));
        reportParams.put("workCommencedDate", workCommencedDate);
        reportParams.put("approverName", approverName);
        ReportRequest reportRequest = new ReportRequest("WorkOrderNotice", (Collection)estimates, reportParams);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.workOrderPDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return WORKORDERNOTICEPDF;
    }

    protected String getApproverName(WorkOrder wo) {
        String approver = "";
        List history = wo.getStateHistory();
        for (StateHistory st : history) {
            PersonalInformation pInfo;
            if (!st.getValue().equalsIgnoreCase(WORKFLOW_ENDS) || (pInfo = this.employeeServiceOld.getEmployeeforPosition(st.getOwnerPosition())) == null || !StringUtils.isNotBlank((String)pInfo.getName())) continue;
            approver = approver + pInfo.getName();
        }
        return approver;
    }

    protected List<WorkOrderNoticeEsimateInfo> getEstimatesForWO(WorkOrder wo) {
        ArrayList<WorkOrderNoticeEsimateInfo> woEstimateList = new ArrayList<WorkOrderNoticeEsimateInfo>();
        Double woEstimateAmount = 0.0;
        Object[] obj = (Object[])this.workOrderService.getTenderNegotiationInfo(this.workOrder.getNegotiationNumber());
        String tenderType = (String)obj[1];
        for (WorkOrderEstimate woe : wo.getWorkOrderEstimates()) {
            WorkOrderNoticeEsimateInfo estimateInfo = new WorkOrderNoticeEsimateInfo();
            estimateInfo.setEstimateNumber(woe.getEstimate().getEstimateNumber());
            estimateInfo.setWorkName(woe.getEstimate().getName());
            estimateInfo.setWorkDescription(woe.getEstimate().getDescription());
            if (StringUtils.isNotBlank((String)tenderType) && tenderType.equalsIgnoreCase("Percentage-Tender")) {
                Double estimateAmt = woe.getEstimate().getWorkValue();
                woEstimateAmount = estimateAmt + estimateAmt * (Double)obj[0] / 100.0;
            } else {
                for (WorkOrderActivity woa : woe.getWorkOrderActivities()) {
                    woEstimateAmount = woEstimateAmount + woa.getApprovedAmount();
                }
            }
            estimateInfo.setEstimateValue(NumberUtil.formatNumber((BigDecimal)BigDecimal.valueOf(woEstimateAmount)));
            woEstimateList.add(estimateInfo);
        }
        return woEstimateList;
    }

    public Double getSecurityDepositConfValue() {
        this.securityDepositConfValue = this.workOrderService.getSecurityDepositConfValue();
        return this.securityDepositConfValue;
    }

    public void setSecurityDepositConfValue(Double securityDepositConfValue) {
        this.securityDepositConfValue = securityDepositConfValue;
    }

    public Double getLabourWelfareFundConfValue() {
        this.labourWelfareFundConfValue = this.workOrderService.getLabourWelfareFundConfValue();
        return this.labourWelfareFundConfValue;
    }

    public void setLabourWelfareFundConfValue(Double labourWelfareFundConfValue) {
        this.labourWelfareFundConfValue = labourWelfareFundConfValue;
    }

    public String getAssignedToRequiredOrNot() {
        return this.worksService.getWorksConfigValue("WORKORDER_ASSIGNEDTO_REQUIRED");
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public String getCreatedBySelection() {
        return this.createdBySelection;
    }

    public void setCreatedBySelection(String createdBySelection) {
        this.createdBySelection = createdBySelection;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setTenderResponseService(TenderResponseService tenderResponseService) {
        this.tenderResponseService = tenderResponseService;
    }

    public TenderResponse getTenderResponse() {
        return this.tenderResponse;
    }

    public void setTenderResponse(TenderResponse tenderResponse) {
        this.tenderResponse = tenderResponse;
    }

    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public String getEditableDate() {
        return this.editableDate;
    }

    public void setEditableDate(String editableDate) {
        this.editableDate = editableDate;
    }

    public Integer getEmpId() {
        return this.empId;
    }

    public Collection<EstimateLineItemsForWP> getActivitiesForWorkorderList() {
        return this.tenderResponse.getActivitiesForWorkorder();
    }

    public void setEmpId(Integer empId) {
        this.empId = empId;
    }

    public Long getTenderRespId() {
        return this.tenderRespId;
    }

    public void setTenderRespId(Long tenderRespId) {
        this.tenderRespId = tenderRespId;
    }

    public List<Designation> getWorkOrderDesigList() {
        return this.workOrderDesigList;
    }

    public void setWorkOrderDesigList(List<Designation> workOrderDesigList) {
        this.workOrderDesigList = workOrderDesigList;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public Long getAssignedTo1() {
        return this.assignedTo1;
    }

    public void setAssignedTo1(Long assignedTo1) {
        this.assignedTo1 = assignedTo1;
    }

    public Long getAssignedTo2() {
        return this.assignedTo2;
    }

    public void setAssignedTo2(Long assignedTo2) {
        this.assignedTo2 = assignedTo2;
    }

    public List<WorkOrder> getWorkOrderList() {
        return this.workOrderList;
    }

    public void setWorkOrderList(List<WorkOrder> workOrderList) {
        this.workOrderList = workOrderList;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Map<String, Object> getContractorForApprovedWorkOrder() {
        HashMap<String, Object> contractorsWithWOList = new HashMap<String, Object>();
        if (this.workOrderService.getContractorsWithWO() != null) {
            for (Contractor contractor : this.workOrderService.getContractorsWithWO()) {
                contractorsWithWOList.put(contractor.getId() + "", contractor.getCode() + " - " + contractor.getName());
            }
        }
        return contractorsWithWOList;
    }

    public Long getWorkOrderId() {
        return this.workOrderId;
    }

    public void setWorkOrderId(Long workOrderId) {
        this.workOrderId = workOrderId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setWorkOrderWorkflowService(WorkflowService<WorkOrder> workOrderWorkflowService) {
        this.workOrderWorkflowService = workOrderWorkflowService;
    }

    public String getSetStatus() {
        return this.setStatus;
    }

    public void setSetStatus(String setStatus) {
        this.setStatus = setStatus;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public InputStream getWorkOrderPDF() {
        return this.workOrderPDF;
    }

    public void setWorkOrderPDF(InputStream workOrderPDF) {
        this.workOrderPDF = workOrderPDF;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    public Long getDeptId() {
        return this.deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public void setWorksStatusService(PersistenceService<OfflineStatus, Long> worksStatusService) {
        this.worksStatusService = worksStatusService;
    }

    public Date getSiteHandOverDate() {
        OfflineStatus objStatusForSite;
        if (this.id != null && (objStatusForSite = (OfflineStatus)this.worksStatusService.findByNamedQuery(STATUS_OBJECTID, new Object[]{this.id, WO_OBJECT_TYPE, SITE_HAND_OVER})) != null) {
            return objStatusForSite.getStatusDate();
        }
        return null;
    }

    public Date getWorkCommencedDate() {
        OfflineStatus objStatusForSite;
        if (this.id != null && (objStatusForSite = (OfflineStatus)this.worksStatusService.findByNamedQuery(STATUS_OBJECTID, new Object[]{this.id, WO_OBJECT_TYPE, WORK_COMMENCED})) != null) {
            return objStatusForSite.getStatusDate();
        }
        return null;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public String getWpNumber() {
        return this.wpNumber;
    }

    public void setWpNumber(String wpNumber) {
        this.wpNumber = wpNumber;
    }

    public String getTenderFileNumber() {
        return this.tenderFileNumber;
    }

    public void setTenderFileNumber(String tenderFileNumber) {
        this.tenderFileNumber = tenderFileNumber;
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
        this.personalInformationService = personalInformationService;
    }

    public Long getTenderRespContrId() {
        return this.tenderRespContrId;
    }

    public void setTenderRespContrId(Long tenderRespContrId) {
        this.tenderRespContrId = tenderRespContrId;
    }

    public TenderResponseContractors getTenderResponseContractor() {
        return this.tenderResponseContractor;
    }

    public void setTenderResponseContractor(TenderResponseContractors tenderResponseContractor) {
        this.tenderResponseContractor = tenderResponseContractor;
    }

    public void setTenderResponseContractorsService(PersistenceService<TenderResponseContractors, Long> tenderResponseContractorsService) {
        this.tenderResponseContractorsService = tenderResponseContractorsService;
    }

    public List<WorkOrderActivity> getActionWorkOrderActivities() {
        return this.actionWorkOrderActivities;
    }

    public void setActionWorkOrderActivities(List<WorkOrderActivity> actionWorkOrderActivities) {
        this.actionWorkOrderActivities = actionWorkOrderActivities;
    }

    public void setActivityService(PersistenceService<Activity, Long> activityService) {
        this.activityService = activityService;
    }

    public Collection<WorkOrderActivity> getActionWorkOrderActivityList() {
        Collection woActivityList = this.workOrderService.getActionWorkOrderActivitiesList(this.actionWorkOrderActivities);
        for (WorkOrderActivity workOrderActivity : woActivityList) {
            workOrderActivity.setActivity((Activity)this.activityService.findById((Serializable)workOrderActivity.getActivity().getId(), false));
            workOrderActivity.setUnAssignedQuantity(workOrderActivity.getActivity().getQuantity() - this.getAssignedQuantity(workOrderActivity.getActivity().getId(), this.workOrder.getNegotiationNumber()));
        }
        return woActivityList;
    }

    public List<WorkOrderActivity> getWoActivities() {
        return this.woActivities;
    }

    public void setWoActivities(List<WorkOrderActivity> woActivities) {
        this.woActivities = woActivities;
    }

    public void setWorkOrderActivities(WorkOrder workorder) {
        this.woActivities.clear();
        for (WorkOrderEstimate workOrderEstimate : workorder.getWorkOrderEstimates()) {
            if (workOrderEstimate == null) continue;
            for (WorkOrderActivity workOrderActivity : workOrderEstimate.getWorkOrderActivities()) {
                workOrderActivity.setUnAssignedQuantity(workOrderActivity.getActivity().getQuantity() - this.getAssignedQuantity(workOrderActivity.getActivity().getId(), workOrderActivity.getWorkOrderEstimate().getWorkOrder().getNegotiationNumber()));
                this.woActivities.add(workOrderActivity);
            }
        }
    }

    public void validate() {
        String actionName;
        Collection woActivityList = this.workOrderService.getActionWorkOrderActivitiesList(this.actionWorkOrderActivities);
        String contractPrd = this.workOrder.getContractPeriod().toString();
        if (this.parameters.get("actionName") != null && !(actionName = ((String[])this.parameters.get("actionName"))[0]).equalsIgnoreCase("reject")) {
            if (!(this.workOrder.getEgwStatus() != null || this.id != null || "searchWOForMBCreation".equals(this.sourcepage) || "searchWOForBillCreation".equals(this.sourcepage) || "cancelWO".equals(this.sourcepage) || this.estimateId == null && (this.tenderRespId == null || this.tenderRespContrId == null) || !SAVE_ACTION.equals(actionName) && !"submit_for_approval".equals(actionName))) {
                this.validateMandatoryFields();
                this.validateContractPeriod(contractPrd);
            }
            if (this.workOrder.getEgwStatus() != null && (this.workOrder.getEgwStatus().getCode().equalsIgnoreCase("NEW") || this.workOrder.getEgwStatus().getCode().equalsIgnoreCase("REJECTED")) && this.id != null) {
                this.validateMandatoryFields();
                if (this.contractPeriodCutOffDate != null) {
                    Date createdDate;
                    Date date = createdDate = this.workOrder.getCreatedDate() == null ? new Date() : this.workOrder.getCreatedDate();
                    if (createdDate.after(this.contractPeriodCutOffDate)) {
                        this.validateContractPeriod(contractPrd);
                    }
                }
            }
            if (!actionName.equalsIgnoreCase("cancel")) {
                for (WorkOrderActivity workOrderActivity : woActivityList) {
                    if (workOrderActivity.getApprovedRate() == 0.0) {
                        this.addActionError(this.getText("WorkOrderActivity.approvedRate.non.negative"));
                    }
                    if (workOrderActivity.getApprovedQuantity() != 0.0) continue;
                    this.addActionError(this.getText("WorkOrderActivity.approvedQuantity.non.negative"));
                }
            }
            this.validateDLP();
        }
        if (!(this.workOrder.getEgwStatus() != null || this.id != null || "searchWOForMBCreation".equals(this.sourcepage) || "searchWOForBillCreation".equals(this.sourcepage) || "cancelWO".equals(this.sourcepage) || this.tenderRespId == null || this.tenderRespContrId == null)) {
            if (this.tenderResponse.getTenderResponseContractors().size() > 1) {
                this.multipleContractorsValidation();
            } else {
                this.singleContractorValidation();
            }
        }
    }

    private void validateContractPeriod(String contractPrd) {
        if (StringUtils.isBlank((String)contractPrd)) {
            this.addActionError(this.getText("contractPeriod.null"));
        }
        if (StringUtils.isNotBlank((String)contractPrd) && Integer.parseInt(contractPrd) <= 0) {
            this.addActionError(this.getText("contractPeriod.greater.than.zero"));
        }
    }

    private void validateMandatoryFields() {
        if (this.workOrder.getWorkOrderDate() == null) {
            this.addActionError(this.getText("workorder.date.null"));
        }
        if (this.workOrder.getEmdAmountDeposited() == 0.0) {
            this.addActionError(this.getText("workOrder.emdAmount.invalid"));
        }
    }

    private void singleContractorValidation() {
        WorkOrder woObj;
        if (this.id == null && (woObj = (WorkOrder)this.persistenceService.find("from WorkOrder wo where wo.negotiationNumber = ? and wo.egwStatus.code!='CANCELLED' ", new Object[]{this.workOrder.getNegotiationNumber()})) != null) {
            this.addActionError(this.getText("workOrder.tenderNegotiation.uniqueCheck.message"));
        }
    }

    private void multipleContractorsValidation() {
        if (this.id == null) {
            String woaQuery = "select sum(woa.approvedQuantity) from WorkOrderActivity woa where woa.workOrderEstimate.workOrder.negotiationNumber=? and woa.workOrderEstimate.workOrder.egwStatus.code !='CANCELLED' ";
            Double countWoaIds = (Double)this.persistenceService.find("select sum(woa.approvedQuantity) from WorkOrderActivity woa where woa.workOrderEstimate.workOrder.negotiationNumber=? and woa.workOrderEstimate.workOrder.egwStatus.code !='CANCELLED' ", new Object[]{this.workOrder.getNegotiationNumber()});
            String traQuery = "select sum(tra.negotiatedQuantity) from TenderResponseActivity tra where tra.tenderResponse.negotiationNumber = ? and tra.tenderResponse.egwStatus.code != 'CANCELLED'";
            Double countTraIds = (Double)this.persistenceService.find("select sum(tra.negotiatedQuantity) from TenderResponseActivity tra where tra.tenderResponse.negotiationNumber = ? and tra.tenderResponse.egwStatus.code != 'CANCELLED'", new Object[]{this.workOrder.getNegotiationNumber()});
            if (countWoaIds != null && countTraIds != null && countTraIds != 0.0 && countWoaIds != 0.0 && countWoaIds >= countTraIds) {
                this.addActionError(this.getText("workOrder.tenderNegotiation.uniqueCheck.multipleContractor.message"));
            }
        }
    }

    private void validateDLP() {
        if (this.workOrder.getDefectLiabilityPeriod() <= 0.0) {
            this.addActionError(this.getText("defectLiabilityPeriod.validate"));
        }
    }

    private double getAssignedQuantity(Long activityId, String negotiationNumber) {
        Object[] params = new Object[]{negotiationNumber, "CANCELLED", activityId};
        Double assignedQty = (Double)this.getPersistenceService().findByNamedQuery("getAssignedQuantityForActivity", params);
        if (assignedQty == null) {
            return 0.0;
        }
        return assignedQty;
    }

    @ValidationErrorPage(value="searchWorkOrder")
    public String cancelApprovedWO() {
        WorkOrder workOrder = (WorkOrder)this.workOrderService.findById((Serializable)this.workOrderId, false);
        this.validateARFForWO(workOrder);
        workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(WO_OBJECT_TYPE, "CANCELLED"));
        if (workOrder.getCurrentState() != null) {
            PersonalInformation prsnlInfo = this.employeeServiceOld.getEmpForUserId(this.worksService.getCurrentLoggedInUserId());
            String empName = "";
            if (prsnlInfo.getEmployeeFirstName() != null) {
                empName = prsnlInfo.getEmployeeFirstName();
            }
            if (prsnlInfo.getEmployeeLastName() != null) {
                empName = empName.concat(" ").concat(prsnlInfo.getEmployeeLastName());
            }
            if (this.cancelRemarks != null && StringUtils.isNotBlank((String)this.cancelRemarks)) {
                this.cancellationReason.concat(" : ").concat(this.cancelRemarks).concat(". ").concat(this.getText("workOrder.cancel.cancelledby")).concat(": ").concat(empName);
            } else {
                this.cancellationReason.concat(". ").concat(this.getText("workOrder.cancel.cancelledby")).concat(": ").concat(empName);
            }
        }
        this.workOrderNo = workOrder.getWorkOrderNumber();
        this.messageKey = this.workOrderNo + " : " + this.getText("workorder.cancel");
        return "success";
    }

    private void validateARFForWO(WorkOrder workOrder) {
        String arfNo = "";
        String estimateNo = "";
        for (WorkOrderEstimate woe : workOrder.getWorkOrderEstimates()) {
            for (ContractorAdvanceRequisition arf : woe.getContractorAdvanceRequisitions()) {
                if (!arf.getStatus().getCode().equalsIgnoreCase(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString())) {
                    arfNo = !arfNo.equals("") ? arfNo.concat(", ARF#:").concat(arf.getAdvanceRequisitionNumber()) : arfNo.concat(arf.getAdvanceRequisitionNumber());
                }
                if (arf.getWorkOrderEstimate().getEstimate().getEgwStatus().getCode().equalsIgnoreCase(AbstractEstimate.EstimateStatus.CANCELLED.toString())) continue;
                if (!estimateNo.equals("")) {
                    estimateNo = estimateNo.concat(", ").concat(arf.getWorkOrderEstimate().getEstimate().getEstimateNumber());
                    continue;
                }
                estimateNo = estimateNo.concat(arf.getWorkOrderEstimate().getEstimate().getEstimateNumber());
            }
        }
        if (!arfNo.equals("")) {
            throw new ValidationException(Arrays.asList(new ValidationError("cancelWO.arf.created.message", this.getText("cancelWO.arf.created.message", new String[]{arfNo, estimateNo}))));
        }
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public String getPercTenderType() {
        return this.percTenderType;
    }

    public String getTenderResponseType() {
        return this.tenderResponseType;
    }

    public Double getActivityAssignedAmt() {
        return this.activityAssignedAmt;
    }

    public void setActivityAssignedAmt(Double activityAssignedAmt) {
        this.activityAssignedAmt = activityAssignedAmt;
    }

    public EgovPaginatedList getPagedResults() {
        return this.pagedResults;
    }

    public void setPagedResults(EgovPaginatedList pagedResults) {
        this.pagedResults = pagedResults;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancelRemarks() {
        return this.cancelRemarks;
    }

    public void setCancelRemarks(String cancelRemarks) {
        this.cancelRemarks = cancelRemarks;
    }

    public String getWorkOrderNo() {
        return this.workOrderNo;
    }

    public void setWorkOrderNo(String workOrderNo) {
        this.workOrderNo = workOrderNo;
    }

    public String getWoStatus() {
        return this.woStatus;
    }

    public void setWoStatus(String woStatus) {
        this.woStatus = woStatus;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Date getContractPeriodCutOffDate() {
        return this.contractPeriodCutOffDate;
    }

    public void setContractPeriodCutOffDate(Date contractPeriodCutOffDate) {
        this.contractPeriodCutOffDate = contractPeriodCutOffDate;
    }

    public Integer getDefaultPreparedBy() {
        return this.defaultPreparedBy;
    }

    public Long getDefaultDepartmentId() {
        return this.defaultDepartmentId;
    }

    public String getLoggedInUserEmployeeCode() {
        return this.loggedInUserEmployeeCode;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public Boolean getIsWorkCommenced() {
        return this.isWorkCommenced;
    }

    public void setIsWorkCommenced(Boolean isWorkCommenced) {
        this.isWorkCommenced = isWorkCommenced;
    }

    public Integer getReportId() {
        return this.reportId;
    }

    public void setReportId(Integer reportId) {
        this.reportId = reportId;
    }
}

