/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.revisionEstimate;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.commons.EgwTypeOfWork;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.masters.NatureOfWork;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorkOrderService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.egov.works.workorder.entity.WorkOrder;

@ParentPackage(value="egov")
@Result(name={"searchWO"}, location="searchEstimateForRE-searchWO.jsp")
public class SearchEstimateForREAction
extends SearchFormAction {
    private static final long serialVersionUID = -8446251759865551258L;
    private AbstractEstimate estimates = new AbstractEstimate();
    private WorkOrder workOrder = new WorkOrder();
    private String searchType = "searchType";
    private Date fromDate;
    private Date toDate;
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final String SEARCH_WO = "searchWO";
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
    private WorkOrderService workOrderService;
    private Integer deptId;
    private WorksService worksService;
    public static final String APPROVED = "APPROVED";
    private String estimateNumber;
    private Long typeId;
    private String workOrderNumber;
    private Long parentCategory;
    private Long category;
    private Long contractorId;
    private Long execDept;
    private AbstractEstimateService abstractEstimateService;

    public SearchEstimateForREAction() {
        this.addRelatedEntity("category", EgwTypeOfWork.class);
        this.addRelatedEntity("parentCategory", EgwTypeOfWork.class);
        this.addRelatedEntity("executingDepartment", Department.class);
        this.addRelatedEntity("natureOfWork", NatureOfWork.class);
    }

    public Object getModel() {
        return this.estimates;
    }

    public void prepare() {
        super.prepare();
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        this.addDropdownData("executingDepartmentList", this.worksService.getAllDeptmentsForLoggedInUser());
        this.addDropdownData("typeList", this.persistenceService.findAllBy("from NatureOfWork ", new Object[0]));
        this.addDropdownData("parentCategoryList", this.getPersistenceService().findAllBy("from EgwTypeOfWork etw1 where etw1.parentid is null", new Object[0]));
        this.addDropdownData("categoryList", Collections.emptyList());
        this.populateCategoryList(ajaxEstimateAction, this.estimates.getParentCategory() != null);
        if (this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser() != null) {
            this.execDept = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser().getDepartment().getId();
        }
    }

    @ValidationErrorPage(value="searchWO")
    @Action(value="/revisionEstimate/searchEstimateForRE-searchWO")
    public String searchWorkOrder() {
        return SEARCH_WO;
    }

    private Map getQuery() {
        StringBuffer query = new StringBuffer(700);
        ArrayList<Object> paramList = new ArrayList<Object>();
        HashMap<String, Object> queryAndParams = new HashMap<String, Object>();
        query.append("from WorkOrderEstimate woe where woe.workOrder.id is not null and woe.workOrder.parent is null and woe.workOrder.egwStatus.code<>? and woe.workOrder.egwStatus.code = ? and woe.estimate.parent is null");
        paramList.add("NEW");
        paramList.add(APPROVED);
        if (this.getDeptId() != null && this.getDeptId() != -1) {
            query.append(" and woe.estimate.executingDepartment.id=? ");
            paramList.add(this.getDeptId());
        }
        if (this.getTypeId() != -1L) {
            query.append(" and woe.estimate.natureOfWork.id=? ");
            paramList.add(this.getTypeId());
        }
        if (StringUtils.isNotBlank((String)this.getEstimateNumber())) {
            query.append(" and UPPER(woe.estimate.estimateNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.getEstimateNumber()).toUpperCase());
        }
        if (StringUtils.isNotBlank((String)this.getWorkOrderNumber())) {
            query.append(" and UPPER(woe.workOrder.workOrderNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.getWorkOrderNumber()).toUpperCase());
        }
        if (this.estimates.getCategory() != null) {
            query.append(" and woe.estimate.category.id=?");
            paramList.add(this.estimates.getCategory().getId());
        }
        if (this.estimates.getParentCategory() != null) {
            query.append(" and woe.estimate.parentCategory.id=?");
            paramList.add(this.estimates.getParentCategory().getId());
        }
        if (this.getContractorId() != -1L) {
            query.append(" and woe.workOrder.contractor.id=? ");
            paramList.add(this.getContractorId());
        }
        if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
            query.append(" and woe.workOrder.workOrderDate between ? and ? ");
            paramList.add(this.fromDate);
            paramList.add(this.toDate);
        }
        query.append("and woe.id not in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where mbh.egwStatus.code = ? and (mbh.egBillregister.billstatus <> ? and mbh.egBillregister.billtype = ?) and mbh.workOrderEstimate.workOrder.egwStatus.code='APPROVED' and mbh.workOrderEstimate.estimate.egwStatus.code=?) and woe.estimate.id not in (select ae.parent.id from AbstractEstimate ae where ae.parent is not null and ae.egwStatus.code not in ('APPROVED','CANCELLED'))");
        paramList.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
        paramList.add(MBHeader.MeasurementBookStatus.CANCELLED.toString());
        paramList.add(this.getFinalBillTypeConfigValue());
        paramList.add(AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString());
        queryAndParams.put("query", query.toString());
        queryAndParams.put("params", paramList);
        return queryAndParams;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        String query = null;
        String countQuery = null;
        Map queryAndParms = null;
        List paramList = new ArrayList();
        queryAndParms = this.getQuery();
        paramList = (List)queryAndParms.get("params");
        query = (String)queryAndParms.get("query");
        countQuery = "select count(distinct woe.id) " + query;
        query = "select distinct woe " + query;
        return new SearchQueryHQL(query, countQuery, paramList);
    }

    public String search() {
        boolean isError = false;
        if (this.fromDate != null && this.toDate == null) {
            this.addFieldError("enddate", this.getText("search.endDate.null"));
            isError = true;
        }
        if (this.toDate != null && this.fromDate == null) {
            this.addFieldError("startdate", this.getText("search.startDate.null"));
            isError = true;
        }
        if (!DateUtils.compareDates((Date)this.getToDate(), (Date)this.getFromDate())) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.fromDate"));
            isError = true;
        }
        if (isError) {
            return SEARCH_WO;
        }
        this.setPageSize(30);
        super.search();
        return SEARCH_WO;
    }

    protected void populateCategoryList(AjaxEstimateAction ajaxEstimateAction, boolean categoryPopulated) {
        if (categoryPopulated) {
            ajaxEstimateAction.setCategory(this.estimates.getParentCategory().getId());
            ajaxEstimateAction.subcategories();
            this.addDropdownData("categoryList", ajaxEstimateAction.getSubCategories());
        } else {
            this.addDropdownData("categoryList", Collections.emptyList());
        }
    }

    public Map<String, Object> getContractorForApprovedWorkOrder() {
        LinkedHashMap<String, Object> contractorsWithWOList = new LinkedHashMap<String, Object>();
        if (this.workOrderService.getContractorsWithWO() != null) {
            for (Contractor contractor : this.workOrderService.getContractorsWithWO()) {
                contractorsWithWOList.put(contractor.getId() + "", contractor.getCode() + " - " + contractor.getName());
            }
        }
        return contractorsWithWOList;
    }

    public String getFinalBillTypeConfigValue() {
        return this.worksService.getWorksConfigValue("FinalBillType");
    }

    public String getApprovedValue() {
        return APPROVED;
    }

    public AbstractEstimate getEstimates() {
        return this.estimates;
    }

    public void setEstimates(AbstractEstimate estimates) {
        this.estimates = estimates;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public Integer getDeptId() {
        return this.deptId;
    }

    public void setDeptId(Integer deptId) {
        this.deptId = deptId;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public Long getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public Long getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(Long parentCategory) {
        this.parentCategory = parentCategory;
    }

    public Long getCategory() {
        return this.category;
    }

    public void setCategory(Long category) {
        this.category = category;
    }

    public Long getContractorId() {
        return this.contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public Long getExecDept() {
        return this.execDept;
    }

    public void setExecDept(Long execDept) {
        this.execDept = execDept;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }
}

