/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.reports;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.gis.model.GeoLatLong;
import org.egov.infra.gis.model.GeoLocation;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.tender.TenderEstimate;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.tender.TenderResponseActivity;
import org.egov.works.models.tender.WorksPackageDetails;
import org.egov.works.services.WorkOrderService;
import org.egov.works.services.WorksService;
import org.egov.works.workorder.entity.WorkOrder;

public class WorksGISReportAction
extends BaseFormAction {
    private static final long serialVersionUID = -6987141628565169146L;
    private static final Logger LOGGER = Logger.getLogger(WorksGISReportAction.class);
    private final String AFTER_SEARCH = "afterSearch";
    private final String GMAP = "gmap";
    private Integer zoneId;
    private Integer wardId;
    private Long parentCategory;
    private Long category;
    private Long expenditureType;
    private Long contractorId;
    private WorkOrderService workOrderService;
    private List<GeoLocation> locationList;
    private final DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private String resultStatus = "beforeSearch";
    private String estimatenumber;
    private WorksService worksService;
    private List<String> tenderTypeList = null;

    public Long getContractorId() {
        return this.contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public Object getModel() {
        return null;
    }

    public void prepare() {
        super.prepare();
        List zoneList = this.persistenceService.findAllBy("from Boundary BI  where upper(BI.boundaryType.name) = 'ZONE' order by BI.id", new Object[0]);
        this.addDropdownData("zoneList", zoneList);
        this.addDropdownData("wardList", Collections.emptyList());
        this.addDropdownData("typeList", this.getPersistenceService().findAllBy("from NatureOfWork dt", new Object[0]));
        this.addDropdownData("parentCategoryList", this.getPersistenceService().findAllBy("from EgwTypeOfWork etw1 where etw1.parentid is null", new Object[0]));
        this.addDropdownData("categoryList", Collections.emptyList());
    }

    public String beforeSearch() {
        return "gmap";
    }

    private String generateQuery() {
        StringBuffer query = new StringBuffer(1024);
        String columnsToShow = " absEst.id, absEst.lat, absEst.lon, absEst.estimateNumber,absEst.name, coalesce(absEst.workValue,0),  (select sum(coalesce(ovr.amount,0)) from OverheadValue ovr where ovr.abstractEstimate=absEst)  ,  (select wpd.worksPackage.wpNumber from WorksPackageDetails wpd where wpd.estimate=absEst and wpd.worksPackage.egwStatus.code not in ('NEW','CANCELLED') ),  (select to_char(offLineStatus.statusDate,'dd/MM/YYYY') from OfflineStatus offLineStatus where offLineStatus.objectId = ( select wpd.worksPackage.id from WorksPackageDetails wpd where wpd.estimate=absEst and wpd.worksPackage.egwStatus.code not in ('NEW','CANCELLED')  ) and offLineStatus.egwStatus.code='Tender document released' and objectType='WorksPackage' ),  absEst.parentCategory.description, workSubType.description, projcode.id ";
        String columnsToShowWhenWOEIsJoined = " absEst.id, absEst.lat, absEst.lon, absEst.estimateNumber,absEst.name, coalesce(absEst.workValue,0), (select sum(coalesce(ovr.amount,0)) from OverheadValue ovr where ovr.abstractEstimate=absEst)  , (select wpd.worksPackage.wpNumber from WorksPackageDetails wpd where wpd.estimate=absEst  and wpd.worksPackage.egwStatus.code not in ('NEW','CANCELLED') ),  (select to_char(offLineStatus.statusDate,'dd/MM/YYYY') from OfflineStatus offLineStatus where offLineStatus.objectId = ( select wpd.worksPackage.id from WorksPackageDetails wpd where wpd.estimate=absEst and wpd.worksPackage.egwStatus.code not in ('NEW','CANCELLED') ) and offLineStatus.egwStatus.code='Tender document released' and objectType='WorksPackage' ),  absEst.parentCategory.description, workSubType.description , projcode.id,   to_char(wo.workOrderDate,'dd/MM/YYYY'), wo.contractPeriod, wo.contractor.name,  (select to_char(offLineStatus.statusDate,'dd/MM/YYYY') from OfflineStatus offLineStatus where offLineStatus.objectId= wo.id      and offLineStatus.egwStatus.code='Work commenced' and objectType='WorkOrder') ";
        if (this.contractorId != null && this.contractorId != -1L) {
            query.append("select  absEst.id, absEst.lat, absEst.lon, absEst.estimateNumber,absEst.name, coalesce(absEst.workValue,0), (select sum(coalesce(ovr.amount,0)) from OverheadValue ovr where ovr.abstractEstimate=absEst)  , (select wpd.worksPackage.wpNumber from WorksPackageDetails wpd where wpd.estimate=absEst  and wpd.worksPackage.egwStatus.code not in ('NEW','CANCELLED') ),  (select to_char(offLineStatus.statusDate,'dd/MM/YYYY') from OfflineStatus offLineStatus where offLineStatus.objectId = ( select wpd.worksPackage.id from WorksPackageDetails wpd where wpd.estimate=absEst and wpd.worksPackage.egwStatus.code not in ('NEW','CANCELLED') ) and offLineStatus.egwStatus.code='Tender document released' and objectType='WorksPackage' ),  absEst.parentCategory.description, workSubType.description , projcode.id,   to_char(wo.workOrderDate,'dd/MM/YYYY'), wo.contractPeriod, wo.contractor.name,  (select to_char(offLineStatus.statusDate,'dd/MM/YYYY') from OfflineStatus offLineStatus where offLineStatus.objectId= wo.id      and offLineStatus.egwStatus.code='Work commenced' and objectType='WorkOrder')  from AbstractEstimate absEst left join absEst.category workSubType left join absEst.projectCode projcode , WorkOrder wo, WorkOrderEstimate woe ");
            query.append(" where  absEst.id=woe.estimate.id and wo.id=woe.workOrder.id  and wo.contractor.id=" + this.contractorId);
            query.append(" and absEst.parent is null ");
        } else {
            query.append("select  absEst.id, absEst.lat, absEst.lon, absEst.estimateNumber,absEst.name, coalesce(absEst.workValue,0),  (select sum(coalesce(ovr.amount,0)) from OverheadValue ovr where ovr.abstractEstimate=absEst)  ,  (select wpd.worksPackage.wpNumber from WorksPackageDetails wpd where wpd.estimate=absEst and wpd.worksPackage.egwStatus.code not in ('NEW','CANCELLED') ),  (select to_char(offLineStatus.statusDate,'dd/MM/YYYY') from OfflineStatus offLineStatus where offLineStatus.objectId = ( select wpd.worksPackage.id from WorksPackageDetails wpd where wpd.estimate=absEst and wpd.worksPackage.egwStatus.code not in ('NEW','CANCELLED')  ) and offLineStatus.egwStatus.code='Tender document released' and objectType='WorksPackage' ),  absEst.parentCategory.description, workSubType.description, projcode.id  from AbstractEstimate absEst left join absEst.category workSubType left join absEst.projectCode projcode ");
            query.append(" where absEst.parent is null ");
        }
        query.append(" and absEst.lat is not null and absEst.lon is not null and absEst.egwStatus.code not in ('NEW','CANCELLED') ");
        if (this.zoneId != null && this.zoneId != -1) {
            query.append(" and absEst.ward.parent.id=" + this.zoneId);
        }
        if (this.wardId != null && this.wardId != -1) {
            query.append(" and absEst.ward.id=" + this.wardId);
        }
        if (this.category != null && this.category != -1L) {
            query.append(" and absEst.category.id=" + this.category);
        } else if (this.parentCategory != null && this.parentCategory != -1L) {
            query.append(" and absEst.parentCategory.id=" + this.parentCategory);
        }
        if (this.expenditureType != null && this.expenditureType != -1L) {
            query.append(" and absEst.type.id=" + this.expenditureType);
        }
        if (StringUtils.isNotBlank((String)this.estimatenumber)) {
            query.append(" and UPPER(absEst.estimateNumber) like '%" + this.estimatenumber.toUpperCase() + "%'");
        }
        query.append(" order by absEst.id ");
        return query.toString();
    }

    public String search() {
        List findAll = null;
        this.locationList = new ArrayList();
        GeoLatLong latlong = new GeoLatLong();
        HashMap<String, String> markerdata = null;
        String query = this.generateQuery();
        try {
            LOGGER.info((Object)("HQl query=" + query.toString()));
            findAll = this.persistenceService.findAllBy(query.toString(), new Object[0]);
            LOGGER.info((Object)("HQl query RESULT " + findAll.size()));
            GeoLocation geoLocation = null;
            for (Object[] columnOutput : findAll) {
                String tenderAmount;
                Long contractPeriod = null;
                Long projcodeId = null;
                Long estId = null;
                BigDecimal estLon = null;
                BigDecimal estLat = null;
                String workCommencedDt = null;
                String contractorName = null;
                String workOrderDate = null;
                String subTypeOfWork = null;
                String typeOfWork = null;
                String tenderDocReleasedDt = null;
                String wpno = null;
                String estWorkName = null;
                String estNumber = null;
                Money workValue = null;
                Double ovrheads = null;
                estId = (Long)columnOutput[0];
                estLat = (BigDecimal)columnOutput[1];
                estLon = (BigDecimal)columnOutput[2];
                estNumber = (String)columnOutput[3];
                estWorkName = (String)columnOutput[4];
                workValue = (Money)columnOutput[5];
                ovrheads = (Double)columnOutput[6];
                wpno = (String)columnOutput[7];
                tenderDocReleasedDt = (String)columnOutput[8];
                typeOfWork = (String)columnOutput[9];
                subTypeOfWork = (String)columnOutput[10];
                projcodeId = (Long)columnOutput[11];
                geoLocation = new GeoLocation();
                if (null != estLat && null != estLon) {
                    latlong = new GeoLatLong();
                    latlong.setLatitude(estLat);
                    latlong.setLongitude(estLat);
                }
                geoLocation.setGeoLatLong(latlong);
                geoLocation.setUrlRedirect("../estimate/abstractEstimate!edit.action?id=" + estId + "&sourcepage=search~" + estNumber);
                String max50CharName = "";
                max50CharName = null != estWorkName && estWorkName.length() >= 50 ? estWorkName.substring(0, 50) + "..." : estWorkName;
                geoLocation.setInfo2("Work Name=" + max50CharName);
                if (workValue != null || ovrheads != null) {
                    BigDecimal amt = workValue != null ? new BigDecimal(workValue.getValue()) : BigDecimal.ZERO;
                    amt = amt.add(ovrheads != null ? new BigDecimal(ovrheads) : BigDecimal.ZERO);
                    geoLocation.setInfo3("Estimate Value(Rs)=" + NumberUtil.formatNumber((BigDecimal)amt, (NumberUtil.NumberFormatStyle)NumberUtil.NumberFormatStyle.CRORES));
                } else {
                    geoLocation.setInfo3("Estimate Value(Rs)=0.00");
                }
                if (wpno != null) {
                    geoLocation.setInfo4("Works Package Number=" + wpno);
                }
                markerdata = new HashMap<String, String>();
                if (typeOfWork != null) {
                    geoLocation.appendToInfo5("Type of Work=" + typeOfWork);
                    if (typeOfWork.equalsIgnoreCase("Bridges")) {
                        markerdata.put("icon", "purple");
                    } else if (typeOfWork.equalsIgnoreCase("Buildings")) {
                        markerdata.put("icon", "yellow");
                    } else if (typeOfWork.equalsIgnoreCase("Electrical")) {
                        markerdata.put("icon", "green");
                    } else if (typeOfWork.equalsIgnoreCase("Roads")) {
                        markerdata.put("icon", "orange");
                    } else if (typeOfWork.equalsIgnoreCase("Storm Water Drain")) {
                        markerdata.put("icon", "blue");
                    }
                }
                if (subTypeOfWork != null) {
                    geoLocation.appendToInfo5("Subtype of Work=" + subTypeOfWork);
                }
                if (tenderDocReleasedDt != null) {
                    geoLocation.appendToInfo5("Tender Document Released Date=" + tenderDocReleasedDt);
                }
                if (StringUtils.isNotBlank((String)(tenderAmount = this.getTenderAmount((Object)estId)))) {
                    geoLocation.appendToInfo5("Tender Finalized Value(Rs)=" + tenderAmount);
                }
                if (this.contractorId != null && this.contractorId != -1L) {
                    String paymentAmt;
                    workOrderDate = (String)columnOutput[12];
                    if (columnOutput[13] != null) {
                        contractPeriod = Long.parseLong(columnOutput[13].toString());
                    }
                    contractorName = (String)columnOutput[14];
                    workCommencedDt = (String)columnOutput[15];
                    if (workOrderDate != null) {
                        geoLocation.appendToInfo5("Work Order Date=" + workOrderDate);
                    }
                    if (workCommencedDt != null) {
                        geoLocation.appendToInfo5("Work Commenced Date=" + workCommencedDt);
                    }
                    if (contractPeriod != null) {
                        geoLocation.appendToInfo5("Contract Period In Days=" + contractPeriod);
                    }
                    if (workCommencedDt != null && contractPeriod != null) {
                        Date woDate = new Date(workCommencedDt);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(woDate);
                        cal.add(5, new Long(contractPeriod).intValue());
                        geoLocation.appendToInfo5("Expected Date Of Completion =" + this.sdf.format(cal.getTime()));
                    }
                    if (projcodeId != null && (paymentAmt = this.getPaymentAmount((Object)projcodeId)) != null) {
                        geoLocation.appendToInfo5("Payment Released(Rs)=" + paymentAmt);
                    }
                    if (contractorName != null) {
                        geoLocation.appendToInfo5("Contractor Name=" + contractorName);
                    }
                } else {
                    List woList = this.persistenceService.findAllBy("  select woe.workOrder from WorkOrderEstimate woe where woe.estimate.id=? and upper(woe.workOrder.egwStatus.code) not in ('NEW','CANCELLED') ", new Object[]{estId});
                    if (woList != null && woList.size() > 0) {
                        String paymentAmt;
                        StringBuffer workOrderDatesBuf = new StringBuffer("");
                        StringBuffer workCommencedDateBuf = new StringBuffer("");
                        StringBuffer contractorNameBuf = new StringBuffer("");
                        StringBuffer workExpectedCompletionDateBuf = new StringBuffer("");
                        StringBuffer workOrderContractPeriodBuf = new StringBuffer("");
                        for (WorkOrder wo : woList) {
                            Long workOrderContractPeriod = null;
                            workOrderDatesBuf.append(this.sdf.format(wo.getWorkOrderDate()) + ",");
                            contractorNameBuf.append(wo.getContractor().getName() + ",");
                            if (wo.getContractPeriod() != null) {
                                workOrderContractPeriod = (long)wo.getContractPeriod();
                                workOrderContractPeriodBuf.append(wo.getContractPeriod() + ",");
                            } else {
                                workOrderContractPeriodBuf.append("NA,");
                            }
                            boolean workCommencedPresent = false;
                            boolean workExpectedCompletedPresent = false;
                            for (OfflineStatus ss : wo.getOfflineStatuses()) {
                                if (!ss.getEgwStatus().getCode().equalsIgnoreCase("Work commenced")) continue;
                                workCommencedDateBuf.append(this.sdf.format(ss.getStatusDate()) + ",");
                                workCommencedPresent = true;
                                if (workOrderContractPeriod == null) continue;
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(wo.getWorkOrderDate());
                                cal.add(5, workOrderContractPeriod.intValue());
                                workExpectedCompletionDateBuf.append(this.sdf.format(cal.getTime()) + ",");
                                workExpectedCompletedPresent = true;
                            }
                            if (!workCommencedPresent) {
                                workCommencedDateBuf.append("NA,");
                            }
                            if (workExpectedCompletedPresent) continue;
                            workExpectedCompletionDateBuf.append("NA,");
                        }
                        geoLocation.appendToInfo5("Work Order Date=" + workOrderDatesBuf.deleteCharAt(workOrderDatesBuf.lastIndexOf(",")).toString());
                        if (StringUtils.isNotBlank((String)workCommencedDateBuf.toString())) {
                            geoLocation.appendToInfo5("Work Commenced Date=" + workCommencedDateBuf.deleteCharAt(workCommencedDateBuf.lastIndexOf(",")).toString());
                        }
                        if (StringUtils.isNotBlank((String)workOrderContractPeriodBuf.toString())) {
                            geoLocation.appendToInfo5("Contract Period In Days=" + workOrderContractPeriodBuf.deleteCharAt(workOrderContractPeriodBuf.lastIndexOf(",")).toString());
                        }
                        if (StringUtils.isNotBlank((String)workExpectedCompletionDateBuf.toString())) {
                            geoLocation.appendToInfo5("Expected Date Of Completion=" + workExpectedCompletionDateBuf.deleteCharAt(workExpectedCompletionDateBuf.lastIndexOf(",")).toString());
                        }
                        if (projcodeId != null && (paymentAmt = this.getPaymentAmount((Object)projcodeId)) != null) {
                            geoLocation.appendToInfo5("Payment Released(Rs)=" + paymentAmt);
                        }
                        geoLocation.appendToInfo5("Contractor Name=" + contractorNameBuf.deleteCharAt(contractorNameBuf.lastIndexOf(",")).toString());
                    }
                }
                geoLocation.setMarkerOptionData(markerdata);
                this.locationList.add(geoLocation);
            }
            ServletActionContext.getRequest().setAttribute("kmlfilename", (Object)"coczone");
            ServletActionContext.getRequest().setAttribute("geoLocationList", (Object)this.locationList);
            this.resultStatus = "afterSearch";
            if (this.locationList != null && this.locationList.size() >= 1) {
                return "gmap";
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return "gmap";
    }

    private String getTenderAmount(Object estimateId) {
        List wpdDetailsList = this.persistenceService.findAllBy("select wpd from WorksPackageDetails wpd where wpd.estimate.id=?  ", new Object[]{(Long)estimateId});
        if (this.tenderTypeList == null || this.tenderTypeList.size() == 0) {
            this.tenderTypeList = this.worksService.getTendertypeList();
        }
        double totalAmt = 0.0;
        if (wpdDetailsList != null) {
            for (WorksPackageDetails wpd : wpdDetailsList) {
                block1: for (TenderEstimate te : wpd.getWorksPackage().getTenderEstimateSet()) {
                    for (TenderResponse tr : te.getTenderResponseSet()) {
                        if (!"APPROVED".equals(tr.getEgwStatus().getCode())) continue;
                        List trAct = this.persistenceService.findAllBy("from TenderResponseActivity trAct where trAct.activity.abstractEstimate.id=? and trAct.tenderResponse.id=? and trAct.tenderResponse.egwStatus.code='APPROVED' ", new Object[]{wpd.getEstimate().getId(), tr.getId()});
                        for (TenderResponseActivity act : trAct) {
                            if (!tr.getTenderEstimate().getTenderType().equals(this.tenderTypeList.get(1))) continue;
                            totalAmt += act.getNegotiatedQuantity() * act.getNegotiatedRate() * act.getActivity().getConversionFactor();
                        }
                        if (!tr.getTenderEstimate().getTenderType().equals(this.tenderTypeList.get(0))) continue block1;
                        totalAmt += wpd.getEstimate().getWorkValue() + wpd.getEstimate().getWorkValue() * tr.getPercNegotiatedAmountRate() / 100.0;
                        continue block1;
                    }
                }
            }
        }
        if (totalAmt != 0.0) {
            return NumberUtil.formatNumber((BigDecimal)new BigDecimal(totalAmt), (NumberUtil.NumberFormatStyle)NumberUtil.NumberFormatStyle.CRORES);
        }
        return null;
    }

    private String getPaymentAmount(Object object) {
        try {
            BigDecimal amt = this.worksService.getTotalPaymentForProjectCode((Long)object);
            if (amt != null) {
                return NumberUtil.formatNumber((BigDecimal)amt, (NumberUtil.NumberFormatStyle)NumberUtil.NumberFormatStyle.CRORES);
            }
            return null;
        }
        catch (ApplicationException e) {
            return null;
        }
    }

    public Map<String, Object> getContractorForApprovedWorkOrder() {
        HashMap<String, Object> contractorsWithWOList = new HashMap<String, Object>();
        if (this.workOrderService.getContractorsWithWO() != null) {
            for (Contractor contractor : this.workOrderService.getContractorsWithWO()) {
                contractorsWithWOList.put(contractor.getId() + "", contractor.getName() + " - " + contractor.getCode());
            }
        }
        return contractorsWithWOList;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public Integer getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Integer zoneId) {
        this.zoneId = zoneId;
    }

    public Integer getWardId() {
        return this.wardId;
    }

    public void setWardId(Integer wardId) {
        this.wardId = wardId;
    }

    public Long getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(Long parentCategory) {
        this.parentCategory = parentCategory;
    }

    public Long getCategory() {
        return this.category;
    }

    public void setCategory(Long category) {
        this.category = category;
    }

    public Long getExpenditureType() {
        return this.expenditureType;
    }

    public void setExpenditureType(Long expenditureType) {
        this.expenditureType = expenditureType;
    }

    public List<GeoLocation> getLocationList() {
        return this.locationList;
    }

    public void setLocationList(List<GeoLocation> locationList) {
        this.locationList = locationList;
    }

    public String getResultStatus() {
        return this.resultStatus;
    }

    public String getEstimatenumber() {
        return this.estimatenumber;
    }

    public void setEstimatenumber(String estimatenumber) {
        this.estimatenumber = estimatenumber;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }
}

