/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.masters;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.dao.FundSourceHibernateDAO;
import org.egov.commons.repository.CFinancialYearRepository;
import org.egov.egf.commons.EgovCommon;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.ProjectCodeGenerator;
import org.egov.works.master.service.DepositCodeService;
import org.egov.works.models.masters.DepositCode;
import org.egov.works.models.masters.DepositCodeGenerator;
import org.egov.works.services.ContractorBillService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.egov.works.web.actions.estimate.AjaxFinancialDetailAction;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="depositCode-new.jsp"), @Result(name={"success"}, location="depositCode-success.jsp"), @Result(name={"search"}, location="depositCode-search.jsp")})
public class DepositCodeAction
extends BaseFormAction {
    private static final long serialVersionUID = 3780456881338376293L;
    @Required(message="sor.category.not.null")
    private DepositCode depositCode = new DepositCode();
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private WorksService worksService;
    @Autowired
    private FundSourceHibernateDAO fundSourceHibernateDAO;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    private String currentFinancialYearId;
    private List<String> list;
    private boolean depCode;
    private EgovCommon egovCommon;
    private DepositCodeGenerator depositCodeGenerator;
    private static final boolean ISACTIVE = true;
    private String codeName;
    private String description;
    private String estimateNumber;
    private Date completionDate;
    private String lastVoucherDate;
    private final Map<String, Object> projectDetails = new HashMap();
    @Autowired
    private DepositCodeService depositCodeService;
    @Autowired
    private CFinancialYearRepository cFinancialYearRepository;
    public static final String SEARCH = "search";
    private List<DepositCode> depositCodeList = null;

    public Object getModel() {
        return this.depositCode;
    }

    @Action(value="/masters/depositCode-search")
    public String searchDepositCode() {
        this.setDepositCodeList(this.depositCodeService.getAllDepositCodes());
        return SEARCH;
    }

    public void prepare() {
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        ajaxEstimateAction.setAssignmentService(this.assignmentService);
        AjaxFinancialDetailAction ajaxFinancialDetailAction = new AjaxFinancialDetailAction();
        ajaxFinancialDetailAction.setPersistenceService(this.getPersistenceService());
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"typeOfWork", "subTypeOfWork", "fundSource", "function", "ward", "zone", "fund", "scheme", "subScheme"});
        this.addDropdownData("financialYearList", this.cFinancialYearRepository.getAllFinancialYears());
        this.addDropdownData("fundList", this.fundHibernateDAO.findAllActiveFunds());
        try {
            this.addDropdownData("fundSourceList", this.fundSourceHibernateDAO.findAllActiveIsLeafFundSources());
        }
        catch (Exception e) {
            this.addFieldError("fundsourceunavailable", this.getText("deposit.fundsourc.load"));
        }
    }

    public String execute() {
        return "success";
    }

    public String changeStatus() {
        return "changeStatus";
    }

    public String searchProjectDetails() {
        this.search();
        return "changeStatus";
    }

    private void search() {
        AbstractEstimate estimate;
        String queryStr = "from DepositCode ";
        if (this.estimateNumber != null && !StringUtils.isEmpty((String)this.estimateNumber)) {
            queryStr = queryStr + " and upper(ae.estimateNumber) like '%'||:estimateNumber||'%'";
        }
        Query query = this.getPersistenceService().getSession().createQuery(queryStr);
        if (this.estimateNumber != null && !StringUtils.isEmpty((String)this.estimateNumber)) {
            query.setString("estimateNumber", this.estimateNumber);
        }
        if ((estimate = (AbstractEstimate)query.uniqueResult()) == null) {
            this.addActionError(this.getText("search.noresultfound"));
        } else {
            this.egovCommon.getExpenditureDetailsforProject(estimate.getProjectCode().getId(), new Date());
            this.projectDetails.put("estimate", estimate);
        }
    }

    public DepositCodeAction() {
        this.addRelatedEntity("fundSource", Fundsource.class);
        this.addRelatedEntity("fund", Fund.class);
        this.addRelatedEntity("financialYear", CFinancialYear.class);
    }

    @Action(value="/masters/depositcode-save")
    public String save() {
        this.depositCode.setCode(this.depositCodeGenerator.getAutoGeneratedDepositCode(this.depositCode));
        this.depositCode.setIsActive(Boolean.valueOf(true));
        this.depositCode = (DepositCode)this.depositCodeService.persist((Object)this.depositCode);
        this.depositCodeService.createAccountDetailKey(this.depositCode);
        return "success";
    }

    @Action(value="/masters/depositCode-newform")
    public String newform() {
        return "new";
    }

    public WorksService getWorksService() {
        return this.worksService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String getCurrentFinancialYearId() {
        return this.currentFinancialYearId;
    }

    public void setCurrentFinancialYearId(String currentFinancialYearId) {
        this.currentFinancialYearId = currentFinancialYearId;
    }

    public List<String> getList() {
        return this.list;
    }

    public void setList(List<String> list) {
        this.list = list;
    }

    public DepositCode getDepositCode() {
        return this.depositCode;
    }

    public void setDepositCode(DepositCode depositCode) {
        this.depositCode = depositCode;
    }

    public void setDepositCodeGenerator(DepositCodeGenerator depositCodeGenerator) {
        this.depositCodeGenerator = depositCodeGenerator;
    }

    public boolean isDepCode() {
        return this.depCode;
    }

    public void setDepCode(boolean depCode) {
        this.depCode = depCode;
    }

    public void setProjectcodeGenerator(ProjectCodeGenerator projectcodeGenerator) {
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public Map<String, Object> getProjectDetails() {
        return this.projectDetails;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public void setContractorBillService(ContractorBillService contractorBillService) {
    }

    public String getLastVoucherDate() {
        return this.lastVoucherDate;
    }

    public List<DepositCode> getDepositCodeList() {
        return this.depositCodeList;
    }

    public void setDepositCodeList(List<DepositCode> depositCodeList) {
        this.depositCodeList = depositCodeList;
    }
}

