/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FunctionaryHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.dao.FundSourceHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.BudgetGroup;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateAppropriation;
import org.egov.works.abstractestimate.entity.BudgetFolioDetail;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.entity.FinancingSource;
import org.egov.works.abstractestimate.entity.MultiYearEstimate;
import org.egov.works.models.masters.DepositCode;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.DepositWorksUsageService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxFinancialDetailAction;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"print"}, type="stream", location="budgetFolioPDF", params={"inputName", "budgetFolioPDF", "contentType", "application/pdf", "contentDisposition", "no-cache"}), @Result(name={"new"}, location="financialDetail-add.jsp")})
public class FinancialDetailAction
extends BaseFormAction {
    private static final long serialVersionUID = -8120661601900686441L;
    private static final String BUDGET_DETAILS_SAVE = "budget_details_save";
    private static final Logger logger = Logger.getLogger(FinancialDetailAction.class);
    private static final String BUDGET_GROUP_LIST = "budgetGroupList";
    private FinancialDetail financialDetail = new FinancialDetail();
    private AbstractEstimateService abstractEstimateService;
    @Autowired
    private UserService userService;
    private WorkflowService<AbstractEstimate> estimateWorkflowService;
    private static final String MODULE_NAME = "Works";
    private static final String KEY_NAME = "SKIP_BUDGET_CHECK";
    private AbstractEstimate abstractEstimate;
    private List<FinancingSource> financingSourceList = new LinkedList();
    private List<MultiYearEstimate> actionMultiYearEstimateValues = new LinkedList();
    private List<Fundsource> fundSourceList;
    private Long estimateId;
    private Long id;
    @Autowired
    private FinancialYearHibernateDAO finHibernateDao;
    private String status = "TECH_SANCTIONED";
    public static final String ADD = "add";
    private BudgetGroupDAO budgetGroupDAO;
    private Date financialYearStartDate;
    private Integer approverUserId;
    private Long departmentId;
    private Integer designationId;
    private String approverComments;
    private boolean skipBudget = false;
    private String isEnableSelect = "false";
    private String source = " ";
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    String employeeName;
    String designation;
    private WorksService worksService;
    public static final String PRINT = "print";
    private List<BudgetFolioDetail> approvedBudgetFolioDetails;
    private BigDecimal totalGrant = BigDecimal.ZERO;
    private BigDecimal totalGrantPerc = BigDecimal.ZERO;
    private InputStream budgetFolioPDF;
    private ReportService reportService;
    private Double latestCumulative = 0.0;
    private BigDecimal latestBalance = BigDecimal.ZERO;
    private BigDecimal totalDepositAmount = BigDecimal.ZERO;
    private Double latestCumulativeExpense = 0.0;
    private static final String SEARCH_BUDGET_FOLIO = "searchBudgetFolio";
    private static final String SEARCH_DEPOSIT_WORKS_FOLIO = "searchDepositWorksFolio";
    private static final String BUDGET_GROUP_SEARCH_LIST = "budgetHeadList";
    private Map<String, Object> queryParamMap = new HashMap();
    private Long userDepartment;
    private Date reportDate;
    private BudgetDetailsDAO budgetDetailsDAO;
    private Map<String, String> mandatoryFields = new HashMap();
    private String option;
    private String deptName = "";
    private static final String Fund = "fund";
    private static final String FUNCTION = "function";
    private static final String COA_LIST = "coaList";
    private static final String APP = "app";
    private static final String KEY_DEPOSIT = "WORKS_DEPOSIT_OTHER_WORKS";
    private static final String SOURCE_INBOX = "inbox";
    private Long depositCodeId;
    private String sourcepage;
    private String appValue;
    private String appValueLabel;
    private DepositWorksUsageService depositWorksUsageService;
    private PersistenceService<DepositCode, Long> depositCodeService;
    public static final String RESULTS = "searchResult";
    private Date asOnDate;
    private String code;
    private Integer fundId;
    private Long glcodeId;
    private Integer functionId;
    private String roadCutDepCodeFlag;
    public Integer finYearId;
    private String finYearRangeStr;
    private String currentFinancialYearId;
    @Autowired
    private FundSourceHibernateDAO fundSourceDAO;
    @Autowired
    private FundHibernateDAO fundDao;
    @Autowired
    private FunctionHibernateDAO functionHibDao;
    @Autowired
    private FunctionaryHibernateDAO functionaryDao;
    private static final String SCHEME_MANDATORYCHECK_BUDGETHEAD = "SCHEME_MANDATORYCHECK_BUDGETHEAD";
    private String budgetHeadGlcode;

    public FinancialDetail getFinancialDetail() {
        return this.financialDetail;
    }

    public void setFinancialDetail(FinancialDetail financialDetail) {
        this.financialDetail = financialDetail;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public FinancialDetailAction() {
        this.addRelatedEntity(Fund, Fund.class);
        this.addRelatedEntity(FUNCTION, CFunction.class);
        this.addRelatedEntity("functionary", Functionary.class);
        this.addRelatedEntity("scheme", Scheme.class);
        this.addRelatedEntity("subScheme", SubScheme.class);
        this.addRelatedEntity("budgetGroup", BudgetGroup.class);
        this.addRelatedEntity("coa", CChartOfAccounts.class);
    }

    public String execute() {
        return ADD;
    }

    @Action(value="/estimate/financialDetail-add")
    public String add() {
        if (SOURCE_INBOX.equalsIgnoreCase(this.sourcepage)) {
            User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
            boolean isValidUser = this.worksService.validateWorkflowForUser((StateAware)this.abstractEstimate, user);
            if (isValidUser) {
                throw new ApplicationRuntimeException("Error: Invalid Owner - No permission to view this page.");
            }
        } else if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = "search";
        }
        return ADD;
    }

    public String edit() {
        this.setBudgetHeadGlcode(this.worksService.getWorksConfigValue(SCHEME_MANDATORYCHECK_BUDGETHEAD));
        if (SOURCE_INBOX.equalsIgnoreCase(this.sourcepage)) {
            User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
            boolean isValidUser = this.worksService.validateWorkflowForUser((StateAware)this.abstractEstimate, user);
            if (isValidUser) {
                throw new ApplicationRuntimeException("Error: Invalid Owner - No permission to view this page.");
            }
        } else if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = "search";
        }
        return ADD;
    }

    public String save() {
        this.setBudgetHeadGlcode(this.worksService.getWorksConfigValue(SCHEME_MANDATORYCHECK_BUDGETHEAD));
        this.populateFinancialDetail();
        this.persistFinancialDetail();
        if (this.financialDetail.getAbstractEstimate() != null && this.financialDetail.getAbstractEstimate().getMultiYearEstimates() != null && this.actionMultiYearEstimateValues.size() != 0) {
            this.populateMultiYearEstimates();
        }
        this.addActionMessage("The financial details for estimate " + this.abstractEstimate.getEstimateNumber() + " was saved successfully");
        return "edit";
    }

    public String saveAndSubmit() {
        String result;
        this.setBudgetHeadGlcode(this.worksService.getWorksConfigValue(SCHEME_MANDATORYCHECK_BUDGETHEAD));
        this.populateFinancialDetail();
        this.persistFinancialDetail();
        if (this.financialDetail.getAbstractEstimate() != null && this.financialDetail.getAbstractEstimate().getMultiYearEstimates() != null && this.actionMultiYearEstimateValues.size() != 0) {
            this.populateMultiYearEstimates();
        }
        String actionName = ((String[])this.parameters.get("actionName"))[0];
        this.abstractEstimate.setApproverUserId(this.approverUserId);
        Long finYearId = null;
        Boolean isApprYearEntry = Boolean.FALSE;
        finYearId = this.abstractEstimateService.isPreviousYearApprRequired((FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0)) != false ? Long.valueOf(Long.parseLong(this.finHibernateDao.getPrevYearFiscalId())) : Long.valueOf(Long.parseLong(this.finHibernateDao.getCurrYearFiscalId()));
        if (!this.isSkipBudgetCheck().booleanValue()) {
            for (MultiYearEstimate multiYearEstimate : this.financialDetail.getAbstractEstimate().getMultiYearEstimates()) {
                if (multiYearEstimate == null || multiYearEstimate.getFinancialYear().getId().compareTo(finYearId) != 0 || !(multiYearEstimate.getPercentage() > 0.0)) continue;
                isApprYearEntry = Boolean.TRUE;
            }
        } else {
            isApprYearEntry = Boolean.TRUE;
        }
        if (!isApprYearEntry.booleanValue()) {
            throw new ValidationException(Arrays.asList(new ValidationError("There is no entry in the year wise estimate for selected appropriation year", "There is no entry in the year wise estimate for selected appropriation year")));
        }
        try {
            this.abstractEstimate = (AbstractEstimate)this.estimateWorkflowService.transition(actionName, (StateAware)this.abstractEstimate, this.approverComments);
        }
        catch (ValidationException exp) {
            List errorList = exp.getErrors();
            Iterator iterator = errorList.iterator();
            if (iterator.hasNext()) {
                ValidationError error = (ValidationError)iterator.next();
                if (error.getMessage().contains("DatabaseSequenceFirstTimeException")) {
                    this.abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.estimateId, false);
                    this.financialDetail.setAbstractEstimate(this.abstractEstimate);
                    this.prepare();
                    throw new ValidationException(Arrays.asList(new ValidationError("error", error.getMessage())));
                }
                throw new ValidationException(Arrays.asList(new ValidationError("error", error.getMessage())));
            }
            throw exp;
        }
        this.addActionMessage("The financial details for estimate " + this.abstractEstimate.getEstimateNumber() + " was submitted successfully.");
        if (this.abstractEstimate.getEgwStatus() != null && !"NEW".equalsIgnoreCase(this.abstractEstimate.getEgwStatus().getCode()) && (result = this.worksService.getEmpNameDesignation(this.abstractEstimate.getState().getOwnerPosition(), this.abstractEstimate.getState().getCreatedDate())) != null && !"@".equalsIgnoreCase(result)) {
            String empName = result.substring(0, result.lastIndexOf(64));
            String designation = result.substring(result.lastIndexOf(64) + 1, result.length());
            this.setEmployeeName(empName);
            this.setDesignation(designation);
        }
        return "success";
    }

    private void populateFinancialDetail() {
        this.financialDetail.getFinancingSources().clear();
        this.populateFinancingSourceDetails();
        if (this.isSkipBudget()) {
            this.financialDetail.setBudgetGroup(null);
        } else {
            this.financialDetail.setCoa(null);
        }
    }

    private void persistFinancialDetail() {
        if (this.depositCodeId != null && this.depositCodeId != -1L) {
            this.abstractEstimate.setDepositCode((DepositCode)this.depositCodeService.findById((Serializable)this.depositCodeId, false));
        }
        if (this.getMaxFinancingSource(this.financingSourceList).getFundSource() != null && this.fundSourceDAO.fundsourceById(Integer.valueOf(this.getMaxFinancingSource(this.financingSourceList).getFundSource().getId().intValue())) != null) {
            this.abstractEstimate.setFundSource(this.fundSourceDAO.fundsourceById(Integer.valueOf(this.getMaxFinancingSource(this.financingSourceList).getFundSource().getId().intValue())));
        }
        this.abstractEstimate = this.abstractEstimateService.persistFinancialDetail(this.financialDetail, this.abstractEstimate);
        ((FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0)).getId();
        this.financialDetail = (FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0);
    }

    public boolean getIsPreviousApprAllowed() {
        return "yes".equalsIgnoreCase(this.worksService.getWorksConfigValue("PREVIOUS_YEAR_APPROPRIATION_ALLOWED"));
    }

    public void prepare() {
        AjaxFinancialDetailAction ajaxFinancialDetailAction = new AjaxFinancialDetailAction();
        ajaxFinancialDetailAction.setPersistenceService(this.getPersistenceService());
        ajaxFinancialDetailAction.setBudgetGroupDAO(this.budgetGroupDAO);
        this.abstractEstimateService.setBudgetGroupDAO(this.budgetGroupDAO);
        this.abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.estimateId, false);
        if (this.abstractEstimate != null) {
            if (this.abstractEstimate.getParent() != null) {
                this.financialDetail = (FinancialDetail)this.abstractEstimate.getParent().getFinancialDetails().get(0);
            }
            if (this.abstractEstimate.getFinancialDetails() != null && this.abstractEstimate.getFinancialDetails().size() > 0) {
                this.financialDetail = (FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0);
            }
            this.financialDetail.setAbstractEstimate(this.abstractEstimate);
        }
        super.prepare();
        if (this.financialDetail.getApprYear() == null) {
            this.financialDetail.setApprYear("running");
        }
        this.setupDropdownDataExcluding(new String[]{Fund, FUNCTION, "functionary", "scheme", "subScheme", "budgetGroup", "coa"});
        this.addDropdownData("fundList", this.fundDao.findAllActiveIsLeafFunds());
        this.addDropdownData("functionList", this.functionHibDao.getAllActiveFunctions());
        this.addDropdownData("functionaryList", this.functionaryDao.findAllActiveFunctionary());
        List departmentList = this.getPersistenceService().findAllBy("from DepartmentImpl", new Object[0]);
        this.addDropdownData("userDepartmentList", departmentList);
        this.addDropdownData("executingDepartmentList", departmentList);
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true", new Object[0]));
        List finYrList = this.worksService.getAllFinancialYearsForWorks();
        this.addDropdownData("finYearList", finYrList);
        this.finYearRangeStr = this.generateFinYrList(finYrList);
        CFinancialYear financialYear = this.finHibernateDao.getFinYearByDate(new Date());
        if (financialYear != null) {
            this.currentFinancialYearId = financialYear.getId().toString();
        }
        try {
            this.addDropdownData(BUDGET_GROUP_LIST, Collections.EMPTY_LIST);
            this.addDropdownData(BUDGET_GROUP_SEARCH_LIST, new ArrayList());
        }
        catch (Exception e) {
            logger.error((Object)("---Budgetunavailable : Unable to load budget information---" + e.getMessage()));
            this.addFieldError("budgetunavailable", "Unable to load budget information");
        }
        this.populateSchemeList(ajaxFinancialDetailAction, this.financialDetail.getFund() != null, this.financialDetail.getAbstractEstimate() != null);
        this.populateSubSchemeList(ajaxFinancialDetailAction, this.financialDetail.getScheme() != null, this.financialDetail.getAbstractEstimate() != null);
        try {
            this.populateBudgetGroupList(ajaxFinancialDetailAction, this.financialDetail.getFunction() != null, this.financialDetail.getAbstractEstimate() != null);
            this.populateBudgetHeadList(ajaxFinancialDetailAction, this.financialDetail.getFunction() != null, this.getReportDate() != null);
        }
        catch (ApplicationException e) {
            logger.error((Object)("---Budgetunavailable: Unable to load budget data---" + e.getMessage()));
            this.addFieldError("budgetunavailable", "Unable to load budget data");
        }
        catch (Exception e) {
            logger.error((Object)("---Budgetunavailable: Unable to load budget data from database---" + e.getMessage()));
            this.addFieldError("budgetunavailable", "Unable to load budget data from database");
        }
        if (this.getDropdownData().get(BUDGET_GROUP_LIST) == null) {
            this.addDropdownData(BUDGET_GROUP_LIST, new ArrayList());
        }
        this.fundSourceList = this.fundSourceDAO.findAllActiveIsLeafFundSources();
        if (this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser() != null) {
            this.departmentId = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser().getDepartment().getId();
        }
        this.checkMandataryFields();
        if (this.isSkipBudgetCheck().booleanValue()) {
            if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(KEY_DEPOSIT))) {
                this.addDropdownData(COA_LIST, this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(KEY_DEPOSIT))));
            } else {
                this.addDropdownData(COA_LIST, Collections.EMPTY_LIST);
            }
        } else {
            this.addDropdownData(COA_LIST, Collections.EMPTY_LIST);
        }
        if (!StringUtils.isBlank((String)this.option) && ("input".equalsIgnoreCase(this.option) || "searchDepositWorksFolioDetails".equalsIgnoreCase(this.option))) {
            this.asOnDate = new Date();
            try {
                String config = this.worksService.getWorksConfigValue("SLDEPOSITCODE_SHOW_FUNDS");
                ArrayList<String> code = new ArrayList<String>();
                if (config == null) {
                    this.addDropdownData("fundList", code);
                } else {
                    for (int i = 0; i < config.split(",").length; ++i) {
                        code.add(config.split(",")[i]);
                    }
                    this.addDropdownData("fundList", this.getPersistenceService().findAllByNamedQuery("getListOfFundsForCodes", new Object[]{code}));
                }
            }
            catch (Exception v) {
                logger.error((Object)("---Unable to load funds for Deposit Works folio Reports---" + v.getMessage()));
                this.addFieldError("Fund.notfound", "depositWorksFolioReport.loadFund.error");
            }
            if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(KEY_DEPOSIT))) {
                this.addDropdownData(COA_LIST, this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(KEY_DEPOSIT))));
            } else {
                this.addDropdownData(COA_LIST, Collections.EMPTY_LIST);
            }
        }
        this.budgetHeadGlcode = this.worksService.getWorksConfigValue(SCHEME_MANDATORYCHECK_BUDGETHEAD);
    }

    public void checkMandataryFields() {
        List appConfigList = this.worksService.getAppConfigValue("EGF", "budgetaryCheck_groupby_values");
        AppConfigValues appConfigValues = null;
        if (appConfigList != null) {
            appConfigValues = (AppConfigValues)appConfigList.get(0);
        }
        if (appConfigValues != null) {
            if (appConfigValues.getValue().indexOf(",") == -1) {
                this.mandatoryFields.put(appConfigValues.getValue(), "M");
            } else {
                String[] values;
                for (String value : values = StringUtils.split((String)appConfigValues.getValue(), (String)",")) {
                    this.mandatoryFields.put(value, "M");
                }
            }
        }
    }

    protected void populateSubSchemeList(AjaxFinancialDetailAction ajaxFinancialDetailAction, boolean schemePopulated, boolean datePresent) {
        if (schemePopulated && datePresent) {
            ajaxFinancialDetailAction.setSchemeId(this.financialDetail.getScheme().getId());
            ajaxFinancialDetailAction.setEstimateDate(this.financialDetail.getAbstractEstimate().getEstimateDate());
            ajaxFinancialDetailAction.loadSubSchemes();
            this.addDropdownData("subSchemeList", ajaxFinancialDetailAction.getSubSchemes());
        } else {
            this.addDropdownData("subSchemeList", Collections.emptyList());
        }
    }

    protected void populateSchemeList(AjaxFinancialDetailAction ajaxFinancialDetailAction, boolean fundPopulated, boolean datePresent) {
        if (fundPopulated && datePresent) {
            ajaxFinancialDetailAction.setFundId(this.financialDetail.getFund().getId());
            ajaxFinancialDetailAction.setEstimateDate(this.financialDetail.getAbstractEstimate().getEstimateDate());
            ajaxFinancialDetailAction.loadSchemes();
            this.addDropdownData("schemeList", ajaxFinancialDetailAction.getSchemes());
        } else {
            this.addDropdownData("schemeList", Collections.emptyList());
        }
    }

    protected void populateBudgetGroupList(AjaxFinancialDetailAction ajaxFinancialDetailAction, boolean functionPopulated, boolean datePresent) throws Exception {
        if (functionPopulated && datePresent) {
            ajaxFinancialDetailAction.setFunctionId(this.financialDetail.getFunction().getId());
            ajaxFinancialDetailAction.setEstimateDate(this.financialDetail.getAbstractEstimate().getEstimateDate());
            ajaxFinancialDetailAction.loadBudgetGroups();
            this.addDropdownData(BUDGET_GROUP_LIST, ajaxFinancialDetailAction.getBudgetGroups());
        } else if (!functionPopulated) {
            try {
                this.addDropdownData(BUDGET_GROUP_LIST, this.budgetGroupDAO.getBudgetGroupList());
            }
            catch (ApplicationRuntimeException e) {
                logger.error((Object)("---Unable to load budget head---" + e.getMessage()));
                this.addFieldError("budgetheadexception", "Unable to load budget head ");
            }
        }
    }

    protected void populateBudgetHeadList(AjaxFinancialDetailAction ajaxFinancialDetailAction, boolean functionPopulated, boolean datePresent) throws Exception {
        if (functionPopulated && datePresent) {
            ajaxFinancialDetailAction.setFunctionId(this.financialDetail.getFunction().getId());
            ajaxFinancialDetailAction.setEstimateDate(this.getReportDate());
            ajaxFinancialDetailAction.loadBudgetGroups();
            this.addDropdownData(BUDGET_GROUP_SEARCH_LIST, ajaxFinancialDetailAction.getBudgetGroups());
        } else {
            this.addDropdownData(BUDGET_GROUP_SEARCH_LIST, new ArrayList());
        }
    }

    protected void populateFinancingSourceDetails() {
        for (FinancingSource finSource : this.financingSourceList) {
            if (!this.validFinancingSource(finSource)) continue;
            finSource.setFundSource((Fundsource)this.getPersistenceService().find("from Fundsource where id = ? ", new Object[]{finSource.getFundSource().getId()}));
            this.financialDetail.addFinancingSource(finSource);
        }
    }

    protected void populateMultiYearEstimates() {
        this.financialDetail.getAbstractEstimate().getMultiYearEstimates().clear();
        ArrayList<ValidationError> multiYearErrors = new ArrayList<ValidationError>();
        double totalPerc = 0.0;
        Boolean isPercError = Boolean.FALSE;
        Boolean isFinYearError = Boolean.FALSE;
        for (MultiYearEstimate multiYearEstimate : this.actionMultiYearEstimateValues) {
            if (multiYearEstimate == null) continue;
            if (multiYearEstimate.getFinancialYear() != null && multiYearEstimate.getFinancialYear().getId() != null && multiYearEstimate.getFinancialYear().getId() != -1L) {
                multiYearEstimate.setFinancialYear((CFinancialYear)this.getPersistenceService().find("from CFinancialYear where id = ?", new Object[]{multiYearEstimate.getFinancialYear().getId()}));
            }
            multiYearEstimate.setAbstractEstimate(this.financialDetail.getAbstractEstimate());
            totalPerc += multiYearEstimate.getPercentage();
            this.financialDetail.getAbstractEstimate().addMultiYearEstimate(multiYearEstimate);
            if (!isPercError.booleanValue() && multiYearEstimate != null && multiYearEstimate.getPercentage() <= 0.0) {
                multiYearErrors.add(new ValidationError("percentage", "multiYearEstimate.percentage.percentage_greater_than_0"));
                isPercError = Boolean.TRUE;
            }
            if (isFinYearError.booleanValue() || multiYearEstimate.getFinancialYear() != null && (multiYearEstimate.getFinancialYear() == null || multiYearEstimate.getFinancialYear().getId() != null && multiYearEstimate.getFinancialYear().getId() != -1L)) continue;
            multiYearErrors.add(new ValidationError("financialYear", "multiYeareEstimate.financialYear.null"));
            isFinYearError = Boolean.TRUE;
        }
        if (totalPerc < 100.0) {
            multiYearErrors.add(new ValidationError("percentage", "multiYearEstimate.percentage.percentage_equals_100"));
        }
        if (totalPerc > 100.0) {
            multiYearErrors.add(new ValidationError("percentage", "multiYearEstimate.percentage.percentage_greater_than_100"));
        }
        if (multiYearErrors.size() != 0) {
            throw new ValidationException(multiYearErrors);
        }
    }

    protected boolean validFinancingSource(FinancingSource finSource) {
        return finSource != null && finSource.getFundSource() != null && finSource.getFundSource().getId() != null;
    }

    public Object getModel() {
        return this.financialDetail;
    }

    protected void setModel(FinancialDetail financialDetail) {
        this.financialDetail = financialDetail;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List getEstimateStatuses() {
        return this.persistenceService.findAllBy("from EgwStatus s where moduletype=? and s.code<> 'BUDGETARY_APPR_VALIDATED' order by orderId", new Object[]{AbstractEstimate.class.getSimpleName()});
    }

    public void setBudgetGroupDAO(BudgetGroupDAO budgetGroupDAO) {
        this.budgetGroupDAO = budgetGroupDAO;
    }

    public BudgetGroupDAO getBudgetGroupDAO() {
        return this.budgetGroupDAO;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<FinancingSource> getFinancingSourceList() {
        return this.financingSourceList;
    }

    public void setFinancingSourceList(List<FinancingSource> financingSourceList) {
        this.financingSourceList = financingSourceList;
    }

    public List<Fundsource> getFundSourceList() {
        return this.fundSourceList;
    }

    public void setFundSourceList(List<Fundsource> fundSourceList) {
        this.fundSourceList = fundSourceList;
    }

    public void setEstimateWorkflowService(WorkflowService<AbstractEstimate> workflow) {
        this.estimateWorkflowService = workflow;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public Date getFinancialYearStartDate() {
        this.financialYearStartDate = this.finHibernateDao.getFinancialYearByFinYearRange(this.worksService.getWorksConfigValue("FINANCIAL_YEAR_RANGE")).getStartingDate();
        return this.financialYearStartDate;
    }

    public void setFinancialYearStartDate(Date financialYearStartDate) {
        this.financialYearStartDate = financialYearStartDate;
    }

    public Integer getApproverUserId() {
        return this.approverUserId;
    }

    public void setApproverUserId(Integer approverUserId) {
        this.approverUserId = approverUserId;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public Integer getDesignationId() {
        return this.designationId;
    }

    public void setDesignationId(Integer designationId) {
        this.designationId = designationId;
    }

    public String getApproverComments() {
        return this.approverComments;
    }

    public void setApproverComments(String approverComments) {
        this.approverComments = approverComments;
    }

    @ValidationErrorPage(value="searchBudgetFolio")
    public String searchBudgetFolio() {
        if (!StringUtils.isBlank((String)this.option) && "searchdetails".equalsIgnoreCase(this.option)) {
            this.search("menu");
        }
        return SEARCH_BUDGET_FOLIO;
    }

    public String searchDepositWorksFolio() {
        if (!StringUtils.isBlank((String)this.option) && "searchDepositWorksFolioDetails".equalsIgnoreCase(this.option)) {
            this.viewDepositWorksFolioReport();
        }
        return SEARCH_DEPOSIT_WORKS_FOLIO;
    }

    public String viewDepositFolio() {
        Fund fund = this.fundDao.fundById(this.fundId, false);
        DepositCode depositCode = (DepositCode)this.depositCodeService.findById((Serializable)this.depositCodeId, false);
        CChartOfAccounts coa = this.chartOfAccountsHibernateDAO.findById((Number)this.glcodeId, false);
        this.financialDetail.setCoa(coa);
        this.financialDetail.setFund(fund);
        this.code = depositCode.getCode() + "-" + depositCode.getCodeName();
        this.asOnDate = new Date();
        this.isEnableSelect = "true";
        return SEARCH_DEPOSIT_WORKS_FOLIO;
    }

    public String viewDepositWorksFolio() {
        this.financialDetail = this.abstractEstimate.getParent() != null ? (FinancialDetail)this.abstractEstimate.getParent().getFinancialDetails().get(0) : (FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0);
        this.code = this.abstractEstimate.getDepositCode().getCode() + "-" + this.abstractEstimate.getDepositCode().getCodeName();
        this.depositCodeId = this.abstractEstimate.getDepositCode().getId();
        AbstractEstimateAppropriation astractEstimateAppropriation = (AbstractEstimateAppropriation)this.abstractEstimateService.getEstimateAppropriationService().findByNamedQuery("getLatestDepositWorksUsageForEstimate", new Object[]{this.abstractEstimate.getId()});
        if (astractEstimateAppropriation != null) {
            this.asOnDate = astractEstimateAppropriation.getDepositWorksUsage().getAppropriationDate();
        }
        this.isEnableSelect = "true";
        return SEARCH_DEPOSIT_WORKS_FOLIO;
    }

    public String viewDepositWorksFolioReport() throws ValidationException {
        Fund fund = null;
        CChartOfAccounts coa = null;
        try {
            AbstractEstimate abstractEstimate = new AbstractEstimate();
            Accountdetailtype accountdetailtype = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where name=?", new Object[]{"DEPOSITCODE"});
            fund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.financialDetail.getFund().getId()});
            coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{this.financialDetail.getCoa().getId()});
            Map reportParams = this.getDepositFolioDetails(abstractEstimate, fund, coa, accountdetailtype, this.depositCodeId, this.asOnDate);
            this.totalDepositAmount = (BigDecimal)reportParams.get("totalDeposit");
            if (this.latestCumulative != 0.0 || this.totalDepositAmount != BigDecimal.ZERO) {
                BudgetFolioDetail e = new BudgetFolioDetail();
                e.setSrlNo(Integer.getInteger(""));
                e.setBudgetApprNo("<b>Latest Status :</b>");
                e.setEstimateNo("");
                e.setNameOfWork("");
                e.setEstimateDate("");
                e.setCumulativeTotal(this.latestCumulative);
                e.setBalanceAvailable(this.totalDepositAmount);
                e.setCumulativeExpensesIncurred(this.latestCumulativeExpense);
                e.setActualBalanceAvailable(Double.valueOf(this.totalDepositAmount.doubleValue() - this.latestCumulativeExpense));
                ArrayList<BudgetFolioDetail> tempList = new ArrayList<BudgetFolioDetail>();
                tempList.add(e);
                if (this.approvedBudgetFolioDetails == null || this.approvedBudgetFolioDetails.isEmpty()) {
                    this.approvedBudgetFolioDetails = new ArrayList();
                } else {
                    this.approvedBudgetFolioDetails.add(e);
                }
            } else {
                this.approvedBudgetFolioDetails = new ArrayList();
            }
        }
        catch (ValidationException e) {
            logger.error((Object)("GlCodeValidation >>" + ((ValidationError)e.getErrors().get(0)).getMessage()));
            this.addFieldError("glCodeValidate", ((ValidationError)e.getErrors().get(0)).getMessage());
        }
        return RESULTS;
    }

    public void search(String src) {
        if (APP.equalsIgnoreCase(src) && this.abstractEstimate != null && this.abstractEstimate.getFinancialDetails().get(0) != null) {
            this.financialDetail = (FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0);
        }
        if (this.financialDetail != null && this.financialDetail.getFund() != null && this.financialDetail.getFund().getId() != null && this.financialDetail.getFund().getId() != -1) {
            this.queryParamMap.put("fundid", this.financialDetail.getFund().getId());
        }
        if (this.financialDetail != null && this.financialDetail.getFunction() != null && this.financialDetail.getFunction().getId() != null && this.financialDetail.getFunction().getId() != -1L) {
            this.queryParamMap.put("functionid", this.financialDetail.getFunction().getId());
        }
        if (this.financialDetail != null && this.financialDetail.getBudgetGroup() != null && this.financialDetail.getBudgetGroup().getId() != null && this.financialDetail.getBudgetGroup().getId() != -1L) {
            ArrayList<BudgetGroup> budgetheadid = new ArrayList<BudgetGroup>();
            budgetheadid.add(this.financialDetail.getBudgetGroup());
            this.queryParamMap.put("budgetheadid", budgetheadid);
        }
        if (APP.equalsIgnoreCase(src) && this.financialDetail != null && this.financialDetail.getAbstractEstimate().getUserDepartment() != null) {
            this.queryParamMap.put("deptid", this.financialDetail.getAbstractEstimate().getUserDepartment().getId());
        } else if (this.getUserDepartment() != null && this.getUserDepartment() != -1L) {
            this.queryParamMap.put("deptid", this.getUserDepartment());
        }
        if (APP.equalsIgnoreCase(src) && this.abstractEstimate != null && this.abstractEstimate.getLeastFinancialYearForEstimate() != null && this.abstractEstimate.getLeastFinancialYearForEstimate().getId() != null) {
            this.queryParamMap.put("financialyearid", this.financialDetail.getAbstractEstimate().getLeastFinancialYearForEstimate().getId());
            this.queryParamMap.put("fromDate", this.financialDetail.getAbstractEstimate().getLeastFinancialYearForEstimate().getStartingDate());
            this.queryParamMap.put("toDate", new Date());
        } else if (this.getReportDate() != null) {
            if (!DateUtils.compareDates((Date)new Date(), (Date)this.getReportDate())) {
                throw new ValidationException(Arrays.asList(new ValidationError("greaterthan.currentDate.reportDate", this.getText("greaterthan.currentDate.reportDate"))));
            }
            CFinancialYear finyear = null;
            try {
                finyear = this.abstractEstimateService.getCurrentFinancialYear(this.getReportDate());
            }
            catch (ApplicationRuntimeException noFinYearExp) {
                if (noFinYearExp.getMessage().equals("Financial Year Id does not exist.")) {
                    throw new ValidationException(Arrays.asList(new ValidationError(noFinYearExp.getMessage(), noFinYearExp.getMessage())));
                }
                throw noFinYearExp;
            }
            if (finyear != null && finyear.getId() != null) {
                this.queryParamMap.put("financialyearid", finyear.getId());
            }
            this.queryParamMap.put("toDate", this.getReportDate());
        }
        if (!this.queryParamMap.isEmpty() && this.getFieldErrors().isEmpty()) {
            BigDecimal planningBudgetPerc = new BigDecimal(0);
            try {
                this.totalGrant = this.budgetDetailsDAO.getBudgetedAmtForYear(this.queryParamMap);
                planningBudgetPerc = this.getPlanningBudgetPercentage(this.queryParamMap);
            }
            catch (ValidationException valEx) {
                logger.error((Object)valEx);
            }
            if (planningBudgetPerc != null && !planningBudgetPerc.equals(0)) {
                this.setAppValueLabel(planningBudgetPerc.toString());
                this.totalGrantPerc = this.totalGrant.multiply(planningBudgetPerc.divide(new BigDecimal(100)));
                this.queryParamMap.put("totalGrantPerc", this.totalGrantPerc);
            }
            Map approvedBudgetFolioDetailsMap = this.abstractEstimateService.getApprovedAppropriationDetailsForBugetHead(this.queryParamMap);
            this.approvedBudgetFolioDetails = new ArrayList();
            if (approvedBudgetFolioDetailsMap != null && !approvedBudgetFolioDetailsMap.isEmpty()) {
                this.approvedBudgetFolioDetails = (List)approvedBudgetFolioDetailsMap.get("budgetFolioList");
                this.setReportLatestValues(approvedBudgetFolioDetailsMap);
            }
        }
    }

    private BigDecimal getPlanningBudgetPercentage(Map<String, Object> queryParamMap) {
        return this.budgetDetailsDAO.getPlanningPercentForYear(queryParamMap);
    }

    public String viewBudgetFolio() {
        this.financialDetail = this.abstractEstimate.getParent() != null ? (FinancialDetail)this.abstractEstimate.getParent().getFinancialDetails().get(0) : (FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0);
        this.setUserDepartment(this.abstractEstimate.getUserDepartment().getId());
        this.addDropdownData(BUDGET_GROUP_SEARCH_LIST, (List)this.dropdownData.get(BUDGET_GROUP_LIST));
        AbstractEstimateAppropriation astractEstimateAppropriation = (AbstractEstimateAppropriation)this.abstractEstimateService.getEstimateAppropriationService().findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{this.abstractEstimate.getId()});
        if (astractEstimateAppropriation != null) {
            this.reportDate = new Date(astractEstimateAppropriation.getBudgetUsage().getUpdatedTime().getTime());
        }
        this.isEnableSelect = "true";
        return SEARCH_BUDGET_FOLIO;
    }

    public String viewBudgetFolioPdf() throws JRException, Exception {
        Map<String, String> reportParams = new HashMap();
        if (!StringUtils.isBlank((String)this.option) && "searchPdf".equalsIgnoreCase(this.option)) {
            this.search("menu");
            if (this.getUserDepartment() != null && this.getUserDepartment() != -1L) {
                reportParams.put("departmentName", this.deptName);
            }
            if (this.financialDetail != null && this.financialDetail.getFunction() != null && this.financialDetail.getFunction() != null && this.financialDetail.getFunction().getName() != null) {
                reportParams.put("functionCenter", this.financialDetail.getFunction().getName());
            }
            if (this.financialDetail != null && this.financialDetail.getBudgetGroup() != null && this.financialDetail.getBudgetGroup().getId() != null && this.financialDetail.getBudgetGroup().getId() != -1L) {
                reportParams.put("budgetHead", this.financialDetail.getBudgetGroup().getName());
            }
            if (this.financialDetail != null && this.financialDetail.getFund() != null && this.financialDetail.getFund().getId() != null && this.financialDetail.getFund().getId() != -1) {
                reportParams.put(Fund, this.financialDetail.getFund().getName());
            }
            reportParams.put("totalGrant", (String)((Object)this.totalGrant));
            reportParams.put("totalGrantPer", (String)((Object)this.totalGrantPerc));
            reportParams.put("appValueLabel", this.appValueLabel);
        } else {
            this.search(APP);
            reportParams = this.abstractEstimateService.createBudgetFolioHeaderJasperObject(this.abstractEstimate, this.totalGrant, this.totalGrantPerc);
            reportParams.put("appValueLabel", this.appValueLabel);
        }
        reportParams.put("latestCumulative", (String)((Object)this.latestCumulative));
        reportParams.put("latestBalance", (String)((Object)this.latestBalance));
        ReportRequest reportRequest = new ReportRequest("BudgetFolio", (Collection)this.approvedBudgetFolioDetails, reportParams);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.budgetFolioPDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return PRINT;
    }

    public String viewDepositFolioPDF() throws ParseException {
        Map reportParams = null;
        Fund fund = null;
        CChartOfAccounts coa = null;
        CFunction function = null;
        Date appropriationDate = new Date();
        Accountdetailtype accountdetailtype = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where name=?", new Object[]{"DEPOSITCODE"});
        if (this.abstractEstimate != null && this.abstractEstimate.getFinancialDetails() != null && !this.abstractEstimate.getFinancialDetails().isEmpty() && this.abstractEstimate.getFinancialDetails().get(0) != null && this.parameters.get("fundId") == null) {
            fund = ((FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0)).getFund();
            coa = ((FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0)).getCoa();
            if (this.abstractEstimate.getDepositCode() != null) {
                this.depositCodeId = this.abstractEstimate.getDepositCode().getId();
            }
            function = ((FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0)).getFunction();
        } else {
            Integer fundId = 0;
            Long glcodeId = null;
            Long functionId = null;
            if (this.parameters.get("fundId") != null) {
                fundId = Integer.parseInt(((String[])this.parameters.get("fundId"))[0]);
            }
            if (this.parameters.get("glcodeId") != null) {
                glcodeId = Long.valueOf(((String[])this.parameters.get("glcodeId"))[0]);
            }
            if (this.parameters.get("depositCodeId") != null) {
                this.depositCodeId = Long.valueOf(((String[])this.parameters.get("depositCodeId"))[0]);
            }
            if (this.parameters.get("functionId") != null) {
                functionId = Long.valueOf(((String[])this.parameters.get("functionId"))[0]);
                function = (CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{functionId});
            }
            if (this.parameters.get("asOnDate") != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", new Locale("en", "IN"));
                appropriationDate = sdf.parse(((String[])this.parameters.get("asOnDate"))[0]);
            }
            fund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{fundId});
            coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{glcodeId});
        }
        reportParams = this.getDepositFolioDetails(this.abstractEstimate, fund, coa, accountdetailtype, this.depositCodeId, appropriationDate);
        if (function != null) {
            reportParams.put(FUNCTION, function.getName());
        }
        reportParams.put("ABSTRACT_ESTIMATE", this.abstractEstimate);
        ReportRequest reportRequest = new ReportRequest("DepositFolio", (Collection)this.approvedBudgetFolioDetails, reportParams);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.budgetFolioPDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return PRINT;
    }

    public Map<String, Object> getDepositFolioDetails(AbstractEstimate abstractEstimate, Fund fund, CChartOfAccounts coa, Accountdetailtype accountdetailtype, Long depositCodeId, Date appropriationDate) {
        DepositCode depositCode = (DepositCode)this.persistenceService.find("from DepositCode where id=?", new Object[]{depositCodeId});
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        Map approvedBudgetFolioDetailsMap = this.depositWorksUsageService.getDepositFolioDetails(abstractEstimate, fund, coa, accountdetailtype, depositCodeId, appropriationDate);
        BigDecimal getTotalDepositAmount = this.depositWorksUsageService.getTotalDepositWorksAmount(fund, coa, accountdetailtype, depositCodeId, appropriationDate);
        if (approvedBudgetFolioDetailsMap.isEmpty()) {
            this.latestCumulative = 0.0;
            this.latestCumulativeExpense = 0.0;
        } else {
            this.approvedBudgetFolioDetails = new ArrayList();
            this.approvedBudgetFolioDetails = (List)approvedBudgetFolioDetailsMap.get("depositFolioList");
            List calculatedValuesList = (List)approvedBudgetFolioDetailsMap.get("calculatedValues");
            this.latestCumulative = (Double)calculatedValuesList.get(0);
            this.latestCumulativeExpense = (Double)((List)approvedBudgetFolioDetailsMap.get("totalCumulativeExpensesIncurred")).get(0);
        }
        reportParams.put(Fund, fund.getName());
        reportParams.put("depositCode", depositCode.getCode());
        reportParams.put("depositworksName", depositCode.getCodeName());
        reportParams.put("totalDeposit", getTotalDepositAmount);
        reportParams.put("latestCumulative", this.latestCumulative);
        reportParams.put("latestBalance", new BigDecimal(getTotalDepositAmount.doubleValue() - this.latestCumulative));
        reportParams.put("latestCumulativeExpense", this.latestCumulativeExpense);
        reportParams.put("totalActualBalanceAvailable", getTotalDepositAmount.doubleValue() - this.latestCumulativeExpense);
        return reportParams;
    }

    public void setReportLatestValues(Map<String, List> approvedBudgetFolioDetailsMap) {
        List calculatedValuesList = approvedBudgetFolioDetailsMap.get("calculatedValues");
        this.latestCumulative = (Double)calculatedValuesList.get(0);
        this.latestBalance = (BigDecimal)calculatedValuesList.get(1);
    }

    public BigDecimal getTotalGrant() {
        return this.totalGrant;
    }

    public BigDecimal getTotalGrantPerc() {
        return this.totalGrantPerc;
    }

    public List<BudgetFolioDetail> getApprovedBudgetFolioDetails() {
        return this.approvedBudgetFolioDetails;
    }

    public InputStream getBudgetFolioPDF() {
        return this.budgetFolioPDF;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setApprovedBudgetFolioDetails(List<BudgetFolioDetail> approvedBudgetFolioDetails) {
        this.approvedBudgetFolioDetails = approvedBudgetFolioDetails;
    }

    public Double getLatestCumulative() {
        return this.latestCumulative;
    }

    public BigDecimal getLatestBalance() {
        return this.latestBalance;
    }

    public Map<String, Object> getQueryParamMap() {
        return this.queryParamMap;
    }

    public void setQueryParamMap(Map<String, Object> queryParamMap) {
        this.queryParamMap = queryParamMap;
    }

    public Date getReportDate() {
        return this.reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public Map<String, String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    public void setMandatoryFields(Map<String, String> mandatoryFields) {
        this.mandatoryFields = mandatoryFields;
    }

    public void validate() {
        if (this.skipBudget && this.parameters.get("actionName") != null) {
            if (this.financialDetail.getCoa() == null || this.financialDetail.getCoa() != null && (this.financialDetail.getCoa().getId() == null || this.financialDetail.getCoa().getId() == -1L)) {
                this.addFieldError("depoist.accountCode", this.getText("estimate.deposit.accountCode.mandatory"));
            }
            if (this.depositCodeId == null || this.depositCodeId == -1L) {
                this.addFieldError("depoistCode", this.getText("estimate.depositCode.mandatory"));
            }
        }
        if (this.parameters.get("actionName") != null && ((String[])this.parameters.get("actionName"))[0] != null && ((String[])this.parameters.get("actionName"))[0].equals(BUDGET_DETAILS_SAVE) && this.financialDetail.getBudgetGroup() != null && this.financialDetail.getBudgetGroup().getId() != null && this.financialDetail.getBudgetGroup().getId() != -1L && this.financialDetail.getBudgetGroup().getMaxCode().getGlcode().startsWith(this.worksService.getWorksConfigValue(SCHEME_MANDATORYCHECK_BUDGETHEAD))) {
            if (this.financialDetail.getScheme() == null || this.financialDetail.getScheme() != null && this.financialDetail.getScheme().getId() == null || this.financialDetail.getScheme() != null && this.financialDetail.getScheme().getId() == -1) {
                this.addActionError(this.getText("mandatory.scheme"));
            }
            if (this.financialDetail.getSubScheme() == null || this.financialDetail.getSubScheme() != null && this.financialDetail.getSubScheme().getId() == null || this.financialDetail.getSubScheme() != null && this.financialDetail.getSubScheme().getId() == -1) {
                this.addActionError(this.getText("mandatory.subScheme"));
            }
        }
        if ("searchdetails".equalsIgnoreCase(this.option)) {
            if (!(StringUtils.isBlank((String)((String)this.mandatoryFields.get(Fund))) || this.financialDetail.getFund() != null && this.financialDetail.getFund().getId() != null && this.financialDetail.getFund().getId() != -1)) {
                this.addFieldError(Fund, this.getText("budgetfolio.fund.mandatory"));
            }
            if (!(StringUtils.isBlank((String)((String)this.mandatoryFields.get("department"))) || this.userDepartment != null && this.userDepartment != -1L)) {
                this.addFieldError("userDepartment", this.getText("budgetfolio.user.department.mandatory"));
            }
            if (this.financialDetail.getFunction() == null || this.financialDetail.getFunction().getId() == null || this.financialDetail.getFunction().getId() == -1L) {
                this.addFieldError(FUNCTION, this.getText("budgetfolio.function.mandatory"));
            }
            if (this.financialDetail.getBudgetGroup() == null || this.financialDetail.getBudgetGroup().getId() == null || this.financialDetail.getBudgetGroup().getId() == -1L) {
                this.addFieldError("budgetGroup", this.getText("budgetfolio.budgetGroup.mandatory"));
            }
            if (this.finYearId == null || this.finYearId == -1) {
                this.addFieldError("finYearId", this.getText("budgetfolio.finYear.mandatory"));
            }
        }
    }

    public Boolean isSkipBudgetCheck() {
        List depositTypeList = this.getAppConfigValuesToSkipBudget();
        logger.info((Object)("lenght of appconfig values>>>>>> " + depositTypeList.size()));
        if (this.abstractEstimate != null && this.abstractEstimate.getId() != null) {
            for (String type : depositTypeList) {
                if (!type.equals(this.abstractEstimate.getNatureOfWork().getName())) continue;
                this.skipBudget = true;
            }
        }
        return this.skipBudget;
    }

    private FinancingSource getMaxFinancingSource(List<FinancingSource> financingSources) {
        double max = 0.0;
        FinancingSource maxFinSource = null;
        for (FinancingSource finSource : financingSources) {
            if (finSource == null || !(finSource.getPercentage() > max)) continue;
            max = finSource.getPercentage();
            maxFinSource = finSource;
        }
        return maxFinSource;
    }

    private String generateFinYrList(List<CFinancialYear> finYrList) {
        Date todaysDate = new Date();
        StringBuffer finStrBfr = new StringBuffer();
        for (CFinancialYear yr : finYrList) {
            if (yr.getStartingDate().compareTo(todaysDate) <= 0 && yr.getEndingDate().compareTo(todaysDate) >= 0) {
                finStrBfr.append("id:" + yr.getId() + "--" + DateUtils.getFormattedDate((Date)yr.getStartingDate(), (String)"dd/MM/yyyy") + "--" + DateUtils.getFormattedDate((Date)todaysDate, (String)"dd/MM/yyyy"));
                continue;
            }
            finStrBfr.append("id:" + yr.getId() + "--" + DateUtils.getFormattedDate((Date)yr.getStartingDate(), (String)"dd/MM/yyyy") + "--" + DateUtils.getFormattedDate((Date)yr.getEndingDate(), (String)"dd/MM/yyyy"));
        }
        return finStrBfr.toString();
    }

    public String getDeptName() {
        return this.deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public List<String> getAppConfigValuesToSkipBudget() {
        return this.worksService.getNatureOfWorkAppConfigValues(MODULE_NAME, KEY_NAME);
    }

    public String getAppValue() {
        return this.appValue;
    }

    public void setAppValue(String appValue) {
        this.appValue = appValue;
    }

    public AbstractEstimateService getAbstractEstimateService() {
        return this.abstractEstimateService;
    }

    public String getAppValueLabel() {
        return this.appValueLabel;
    }

    public void setAppValueLabel(String appValueLabel) {
        this.appValueLabel = appValueLabel;
    }

    public void setDepositWorksUsageService(DepositWorksUsageService depositWorksUsageService) {
        this.depositWorksUsageService = depositWorksUsageService;
    }

    public boolean isSkipBudget() {
        return this.skipBudget;
    }

    public void setSkipBudget(boolean skipBudget) {
        this.skipBudget = skipBudget;
    }

    public Long getDepositCodeId() {
        return this.depositCodeId;
    }

    public void setDepositCodeId(Long depositCodeId) {
        this.depositCodeId = depositCodeId;
    }

    public void setDepositCodeService(PersistenceService<DepositCode, Long> depositCodeService) {
        this.depositCodeService = depositCodeService;
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public void setLatestCumulative(Double latestCumulative) {
        this.latestCumulative = latestCumulative;
    }

    public BigDecimal getTotalDepositAmount() {
        return this.totalDepositAmount;
    }

    public void setTotalDepositAmount(BigDecimal totalDepositAmount) {
        this.totalDepositAmount = totalDepositAmount;
    }

    public void setLatestBalance(BigDecimal latestBalance) {
        this.latestBalance = latestBalance;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getIsEnableSelect() {
        return this.isEnableSelect;
    }

    public void setIsEnableSelect(String isEnableSelect) {
        this.isEnableSelect = isEnableSelect;
    }

    public Integer getFundId() {
        return this.fundId;
    }

    public void setFundId(Integer fundId) {
        this.fundId = fundId;
    }

    public Long getGlcodeId() {
        return this.glcodeId;
    }

    public void setGlcodeId(Long glcodeId) {
        this.glcodeId = glcodeId;
    }

    public Integer getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(Integer functionId) {
        this.functionId = functionId;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<MultiYearEstimate> getActionMultiYearEstimateValues() {
        return this.actionMultiYearEstimateValues;
    }

    public void setActionMultiYearEstimateValues(List<MultiYearEstimate> actionMultiYearEstimateValues) {
        this.actionMultiYearEstimateValues = actionMultiYearEstimateValues;
    }

    public String getRoadCutDepCodeFlag() {
        return this.roadCutDepCodeFlag;
    }

    public void setRoadCutDepCodeFlag(String roadCutDepCodeFlag) {
        this.roadCutDepCodeFlag = roadCutDepCodeFlag;
    }

    public Long getUserDepartment() {
        return this.userDepartment;
    }

    public void setUserDepartment(Long userDepartment) {
        this.userDepartment = userDepartment;
    }

    public String getCurrentFinancialYearId() {
        return this.currentFinancialYearId;
    }

    public void setCurrentFinancialYearId(String currentFinancialYearId) {
        this.currentFinancialYearId = currentFinancialYearId;
    }

    public String getFinYearRangeStr() {
        return this.finYearRangeStr;
    }

    public Integer getFinYearId() {
        return this.finYearId;
    }

    public void setFinYearId(Integer finYearId) {
        this.finYearId = finYearId;
    }

    public String getBudgetHeadGlcode() {
        return this.budgetHeadGlcode;
    }

    public void setBudgetHeadGlcode(String budgetHeadGlcode) {
        this.budgetHeadGlcode = budgetHeadGlcode;
    }
}

