/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.contractoradvance;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;

public class AjaxContractorAdvanceAction
extends BaseFormAction {
    private static final long serialVersionUID = 1017466477668341059L;
    private static final Logger LOGGER = Logger.getLogger(AjaxContractorAdvanceAction.class);
    private static final String ESTIMATE_NUMBER_SEARCH_RESULTS = "estimateNoSearchResults";
    private static final String WORKORDER_NUMBER_SEARCH_RESULTS = "workOrderNoSearchResults";
    private static final String WP_NUMBER_SEARCH_RESULTS = "wpNoSearchResults";
    private static final String TN_NUMBER_SEARCH_RESULTS = "tenderNegotiationNoSearchResults";
    private static final String DRAWINGOFFICER_SEARCH_RESULTS = "drawingOfficers";
    private String query;
    private List<String> estimateNumberSearchList = new LinkedList();
    private List<String> workOrderNumberSearchList = new LinkedList();
    private List<String> wpNumberSearchList = new LinkedList();
    private List<String> tenderNegotiationNumberSearchList = new LinkedList();
    private List<HashMap> drawingOfficerList = new LinkedList();
    private ContractorAdvanceService contractorAdvanceService;
    private Date advanceRequisitionDate;

    public String execute() {
        return "success";
    }

    public Object getModel() {
        return null;
    }

    public String searchEstimateNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct(woe.estimate.estimateNumber) from WorkOrderEstimate woe where woe.estimate.parent is null and NOT EXISTS (select 1 from MBHeader mbh where mbh.workOrderEstimate.id = woe.id and mbh.egwStatus.code = ? and (mbh.egBillregister is not null and mbh.egBillregister.billstatus <> ?)) and woe.workOrder.egwStatus.code = ? and UPPER(woe.estimate.estimateNumber) like '%'||?||'%' and woe.estimate.egwStatus.code = ? order by woe.estimate.estimateNumber";
            params.add(MBHeader.MeasurementBookStatus.APPROVED.toString());
            params.add(ContractorBillRegister.BillStatus.CANCELLED.toString());
            params.add("APPROVED".toString());
            params.add(this.query.toUpperCase());
            params.add(AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString());
            this.estimateNumberSearchList = this.persistenceService.findAllBy(strquery, params.toArray());
        }
        return ESTIMATE_NUMBER_SEARCH_RESULTS;
    }

    public String searchWPNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct(woe.workOrder.packageNumber) from WorkOrderEstimate woe where woe.workOrder.parent is null  and woe.workOrder.egwStatus.code = ?  and UPPER(woe.workOrder.packageNumber) like '%'||?||'%' order by woe.workOrder.packageNumber";
            params.add("APPROVED".toString());
            params.add(this.query.toUpperCase());
            this.wpNumberSearchList = this.persistenceService.findAllBy(strquery, params.toArray());
        }
        return WP_NUMBER_SEARCH_RESULTS;
    }

    public String searchTNNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct(woe.workOrder.negotiationNumber) from WorkOrderEstimate woe where woe.workOrder.parent is null  and woe.workOrder.egwStatus.code = ?  and UPPER(woe.workOrder.negotiationNumber) like '%'||?||'%' order by woe.workOrder.negotiationNumber";
            params.add("APPROVED".toString());
            params.add(this.query.toUpperCase());
            this.tenderNegotiationNumberSearchList = this.persistenceService.findAllBy(strquery, params.toArray());
        }
        return TN_NUMBER_SEARCH_RESULTS;
    }

    public String searchWorkOrderNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct(woe.workOrder.workOrderNumber) from WorkOrderEstimate woe where woe.workOrder.parent is null  and woe.workOrder.egwStatus.code = ?  and UPPER(woe.workOrder.workOrderNumber) like '%'||?||'%' order by woe.workOrder.workOrderNumber";
            params.add("APPROVED".toString());
            params.add(this.query.toUpperCase());
            this.workOrderNumberSearchList = this.persistenceService.findAllBy(strquery, params.toArray());
        }
        return WORKORDER_NUMBER_SEARCH_RESULTS;
    }

    public String searchDrawingOfficer() {
        try {
            this.drawingOfficerList = this.contractorAdvanceService.getDrawingOfficerListForARF(this.query, this.advanceRequisitionDate);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in method searchDrawingOfficer:::" + e.getMessage()));
        }
        return DRAWINGOFFICER_SEARCH_RESULTS;
    }

    public String searchEstimateNumberFromARF() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct(arf.workOrderEstimate.estimate.estimateNumber) from ContractorAdvanceRequisition arf where arf.status.code <> ? and UPPER(arf.workOrderEstimate.estimate.estimateNumber) like '%'||?||'%'  order by arf.workOrderEstimate.estimate.estimateNumber";
            params.add(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.NEW.toString());
            params.add(this.query.toUpperCase());
            this.estimateNumberSearchList = this.persistenceService.findAllBy(strquery, params.toArray());
        }
        return ESTIMATE_NUMBER_SEARCH_RESULTS;
    }

    public String searchWorkOrderNumberFromARF() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct(arf.workOrderEstimate.workOrder.workOrderNumber) from ContractorAdvanceRequisition arf where arf.status.code <> ? and UPPER(arf.workOrderEstimate.workOrder.workOrderNumber) like '%'||?||'%'  order by arf.workOrderEstimate.workOrder.workOrderNumber";
            params.add(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.NEW.toString());
            params.add(this.query.toUpperCase());
            this.workOrderNumberSearchList = this.persistenceService.findAllBy(strquery, params.toArray());
        }
        return WORKORDER_NUMBER_SEARCH_RESULTS;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<String> getEstimateNumberSearchList() {
        return this.estimateNumberSearchList;
    }

    public List<String> getWorkOrderNumberSearchList() {
        return this.workOrderNumberSearchList;
    }

    public List<String> getWpNumberSearchList() {
        return this.wpNumberSearchList;
    }

    public List<String> getTenderNegotiationNumberSearchList() {
        return this.tenderNegotiationNumberSearchList;
    }

    public List<HashMap> getDrawingOfficerList() {
        return this.drawingOfficerList;
    }

    public void setDrawingOfficerList(List<HashMap> drawingOfficerList) {
        this.drawingOfficerList = drawingOfficerList;
    }

    public ContractorAdvanceService getContractorAdvanceService() {
        return this.contractorAdvanceService;
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }

    public Date getAdvanceRequisitionDate() {
        return this.advanceRequisitionDate;
    }

    public void setAdvanceRequisitionDate(Date advanceRequisitionDate) {
        this.advanceRequisitionDate = advanceRequisitionDate;
    }
}

