/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.reports;

import java.util.Collections;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.EgwTypeOfWorkHibernateDAO;
import org.egov.commons.service.FinancialYearService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.services.masters.SchemeService;
import org.egov.works.lineestimate.entity.enums.Beneficiary;
import org.egov.works.lineestimate.entity.enums.TypeOfSlum;
import org.egov.works.master.service.NatureOfWorkService;
import org.egov.works.reports.entity.EstimateAbstractReport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/reports/estimateabstractreport"})
public class EstimateAbstractReportController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private FinancialYearService financialYearService;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private EgwTypeOfWorkHibernateDAO egwTypeOfWorkHibernateDAO;

    @RequestMapping(value={"/departmentwise-searchform"}, method={RequestMethod.GET})
    public String departmentWiseShowSearchForm(@ModelAttribute EstimateAbstractReport estimateAbstractReport, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        CFinancialYear currentFinancialYear = this.financialYearService.getCurrentFinancialYear();
        estimateAbstractReport.setFinancialYear(currentFinancialYear.getId());
        estimateAbstractReport.setCurrentFinancialYearId(currentFinancialYear.getId());
        model.addAttribute("estimateAbstractReport", (Object)estimateAbstractReport);
        return "estimateAbstractReportByDepartmentWise-search";
    }

    @RequestMapping(value={"/typeofworkwise-searchform"}, method={RequestMethod.GET})
    public String typeOfWorkWiseShowSearchForm(@ModelAttribute EstimateAbstractReport estimateAbstractReport, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        CFinancialYear currentFinancialYear = this.financialYearService.getCurrentFinancialYear();
        estimateAbstractReport.setFinancialYear(currentFinancialYear.getId());
        estimateAbstractReport.setCurrentFinancialYearId(currentFinancialYear.getId());
        model.addAttribute("estimateAbstractReport", (Object)estimateAbstractReport);
        return "estimateAbstractReportByTypeOfWorkWise-search";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("financialyears", (Object)this.financialYearService.getAll());
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("schemes", (Object)this.schemeService.findAll());
        model.addAttribute("subSchemes", Collections.emptyList());
        model.addAttribute("natureOfWork", (Object)this.natureOfWorkService.findAll());
        model.addAttribute("typeOfSlum", (Object)TypeOfSlum.values());
        model.addAttribute("beneficiary", (Object)Beneficiary.values());
        model.addAttribute("typeOfWork", (Object)this.egwTypeOfWorkHibernateDAO.getTypeOfWorkForPartyTypeContractor());
    }
}

