/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.milestone;

import java.util.List;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.EgwTypeOfWorkHibernateDAO;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.milestone.entity.SearchRequestMilestone;
import org.egov.works.milestone.entity.enums.MilestoneActivityStatus;
import org.egov.works.models.masters.MilestoneTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/milestone"})
public class SearchMilestoneController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwTypeOfWorkHibernateDAO egwTypeOfWorkHibernateDAO;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;

    @RequestMapping(value={"/search-form"}, method={RequestMethod.GET})
    public String showSearchMilestoneForm(@ModelAttribute SearchRequestMilestone searchRequestMilestone, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestMilestone.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute("currentStatus", (Object)MilestoneActivityStatus.values());
        model.addAttribute("searchRequestMilestone", (Object)searchRequestMilestone);
        return "searchmilestone-form";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("typeOfWork", (Object)this.egwTypeOfWorkHibernateDAO.getTypeOfWorkForPartyTypeContractor());
    }

    @RequestMapping(value={"/searchmilestonetemplate"}, method={RequestMethod.GET})
    public String showSearchMilestoneTemplate(@ModelAttribute MilestoneTemplate milestoneTemplate, Model model) throws ApplicationException {
        model.addAttribute("typeOfWork", (Object)this.egwTypeOfWorkHibernateDAO.getTypeOfWorkForPartyTypeContractor());
        return "milestoneTemplate-search";
    }

    @RequestMapping(value={"/searchtoview-form"}, method={RequestMethod.GET})
    public String searchMilestoneForm(@ModelAttribute SearchRequestMilestone searchRequestMilestone, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestMilestone.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute("searchRequestMilestone", (Object)searchRequestMilestone);
        model.addAttribute("egwStatus", (Object)this.egwStatusDAO.getStatusByModule("Milestone"));
        return "viewMilestone-form";
    }

    @RequestMapping(value={"/searchtracked-form"}, method={RequestMethod.GET})
    public String searchTrackedMilestoneForm(@ModelAttribute SearchRequestMilestone searchRequestMilestone, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestMilestone.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute("searchRequestMilestone", (Object)searchRequestMilestone);
        model.addAttribute("egwStatus", (Object)this.egwStatusDAO.getStatusByModule("Milestone"));
        return "searchTrackMilestone-form";
    }
}

