/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.milestone;

import javax.servlet.http.HttpServletRequest;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.SearchRequestMilestone;
import org.egov.works.milestone.service.MilestoneService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/milestone"})
public class CancelMilestoneController
extends GenericWorkFlowController {
    @Autowired
    private MilestoneService milestoneService;
    @Autowired
    private ResourceBundleMessageSource messageSource;

    @RequestMapping(value={"/cancel/search"}, method={RequestMethod.GET})
    public String showSearchMilestoneForm(@ModelAttribute SearchRequestMilestone searchRequestMilestone, Model model) throws ApplicationException {
        model.addAttribute("searchRequestMilestone", (Object)searchRequestMilestone);
        return "milestonecancel-form";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancelMilestone(HttpServletRequest request, Model model) throws ApplicationException {
        Long milestoneId = Long.parseLong(request.getParameter("id"));
        String cancellationReason = request.getParameter("cancellationReason");
        String cancellationRemarks = request.getParameter("cancellationRemarks");
        Milestone milestone = this.milestoneService.getMilestoneById(milestoneId);
        milestone.setCancellationReason(cancellationReason);
        milestone.setCancellationRemarks(cancellationRemarks);
        milestone = this.milestoneService.cancel(milestone);
        model.addAttribute("message", (Object)this.messageSource.getMessage("msg.milestone.cancel.success", (Object[])new String[]{milestone.getWorkOrderEstimate().getWorkOrder().getEstimateNumber()}, null));
        return "milestone-success";
    }
}

