/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.lineestimate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.EgwTypeOfWorkHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.services.masters.SchemeService;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.enums.Beneficiary;
import org.egov.works.lineestimate.entity.enums.LineEstimateStatus;
import org.egov.works.lineestimate.entity.enums.ModeOfAllotment;
import org.egov.works.lineestimate.entity.enums.TypeOfSlum;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.egov.works.lineestimate.service.LineEstimateAppropriationService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.master.service.NatureOfWorkService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/lineestimate"})
public class CreateLineEstimateController
extends GenericWorkFlowController {
    private static final int BUFFER_SIZE = 4096;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    @Autowired
    private FunctionHibernateDAO functionHibernateDAO;
    @Autowired
    private BudgetGroupDAO budgetGroupDAO;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private EgwTypeOfWorkHibernateDAO egwTypeOfWorkHibernateDAO;
    @Autowired
    private ResourceBundleMessageSource messageSource;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private LineEstimateAppropriationService lineEstimateAppropriationService;
    @Autowired
    private BoundaryService boundaryService;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewLineEstimateForm(@ModelAttribute(value="lineEstimate") LineEstimate lineEstimate, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        model.addAttribute("lineEstimate", (Object)lineEstimate);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            lineEstimate.setExecutingDepartment((Department)departments.get(0));
        }
        model.addAttribute("stateType", (Object)lineEstimate.getClass().getSimpleName());
        this.prepareWorkflow(model, (StateAware)lineEstimate, new WorkflowContainer());
        model.addAttribute("mode", null);
        return "newLineEstimate-form";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="lineEstimate") LineEstimate lineEstimate, RedirectAttributes redirectAttributes, Model model, BindingResult errors, @RequestParam(value="file") MultipartFile[] files, HttpServletRequest request, @RequestParam String workFlowAction) throws ApplicationException, IOException {
        this.setDropDownValues(model);
        this.validateBudgetHead(lineEstimate, errors);
        if (errors.hasErrors()) {
            model.addAttribute("stateType", (Object)lineEstimate.getClass().getSimpleName());
            this.prepareWorkflow(model, (StateAware)lineEstimate, new WorkflowContainer());
            model.addAttribute("mode", null);
            return "newLineEstimate-form";
        }
        if (lineEstimate.getState() == null) {
            lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CREATED.toString()));
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        LineEstimate newLineEstimate = this.lineEstimateService.create(lineEstimate, files, approvalPosition, approvalComment, null, workFlowAction);
        model.addAttribute("lineEstimate", (Object)newLineEstimate);
        String pathVars = this.worksUtils.getPathVars(newLineEstimate.getStatus(), newLineEstimate.getState(), newLineEstimate.getId(), approvalPosition);
        return "redirect:/lineestimate/lineestimate-success?pathVars=" + pathVars;
    }

    private void validateBudgetHead(LineEstimate lineEstimate, BindingResult errors) {
        if (lineEstimate.getBudgetHead() != null) {
            Boolean check = false;
            ArrayList accountDetails = new ArrayList();
            accountDetails.addAll(lineEstimate.getBudgetHead().getMaxCode().getChartOfAccountDetails());
            for (CChartOfAccountDetail detail : accountDetails) {
                if (detail.getDetailTypeId() == null || !detail.getDetailTypeId().getName().equalsIgnoreCase("PROJECTCODE")) continue;
                check = true;
            }
            if (!check.booleanValue()) {
                errors.reject("error.budgethead.validate", "error.budgethead.validate");
            }
        }
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("funds", (Object)this.fundHibernateDAO.findAllActiveFunds());
        model.addAttribute("functions", (Object)this.functionHibernateDAO.getAllActiveFunctions());
        model.addAttribute("schemes", (Object)this.schemeService.findAll());
        model.addAttribute("departments", (Object)this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser()));
        model.addAttribute("workCategory", (Object)WorkCategory.values());
        model.addAttribute("typeOfSlum", (Object)TypeOfSlum.values());
        model.addAttribute("beneficiary", (Object)Beneficiary.values());
        model.addAttribute("modeOfAllotment", (Object)ModeOfAllotment.values());
        model.addAttribute("typeOfWork", (Object)this.egwTypeOfWorkHibernateDAO.getTypeOfWorkForPartyTypeContractor());
        model.addAttribute("natureOfWork", (Object)this.natureOfWorkService.findAll());
        model.addAttribute("locations", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Locality", "LOCATION"));
    }

    @RequestMapping(value={"/downloadLineEstimateDoc"}, method={RequestMethod.GET})
    public void getLineEstimateDoc(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext context = request.getServletContext();
        String fileStoreId = request.getParameter("fileStoreId");
        String fileName = "";
        File downloadFile = this.fileStoreService.fetch(fileStoreId, "WMS");
        FileInputStream inputStream = new FileInputStream(downloadFile);
        LineEstimate lineEstimate = this.lineEstimateService.getLineEstimateById(Long.valueOf(Long.parseLong(request.getParameter("lineEstimateId"))));
        lineEstimate = this.getEstimateDocuments(lineEstimate);
        for (DocumentDetails doc : lineEstimate.getDocumentDetails()) {
            if (!doc.getFileStore().getFileStoreId().equalsIgnoreCase(fileStoreId)) continue;
            fileName = doc.getFileStore().getFileName();
        }
        String mimeType = context.getMimeType(downloadFile.getAbsolutePath());
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        response.setContentType(mimeType);
        response.setContentLength((int)downloadFile.length());
        String headerKey = "Content-Disposition";
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
        ServletOutputStream outStream = response.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        outStream.close();
    }

    private LineEstimate getEstimateDocuments(LineEstimate lineEstimate) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(lineEstimate.getId(), "LineEstimate");
        lineEstimate.setDocumentDetails(documentDetailsList);
        return lineEstimate;
    }

    @RequestMapping(value={"/lineestimate-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute LineEstimate lineEstimate, HttpServletRequest request, Model model, ModelMap modelMap) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            lineEstimate = this.lineEstimateService.getLineEstimateById(id);
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        String message = this.getMessageByStatus(lineEstimate, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString())) {
            ArrayList<String> basMessages = new ArrayList<String>();
            Integer count = 1;
            for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                LineEstimateAppropriation lea = this.lineEstimateAppropriationService.findLatestByLineEstimateDetails_EstimateNumber(led.getEstimateNumber());
                String tempMessage = this.messageSource.getMessage("msg.lineestimatedetails.budgetsanction.success", (Object[])new String[]{count.toString(), led.getEstimateNumber(), lea.getBudgetUsage().getAppropriationnumber()}, null);
                basMessages.add(tempMessage);
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            model.addAttribute("basMessages", basMessages);
        }
        return new ModelAndView("lineestimate-success", "lineEstimate", (Object)lineEstimate);
    }

    private String getMessageByStatus(LineEstimate lineEstimate, String approverName, String nextDesign) {
        String message = "";
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CREATED.toString()) && !lineEstimate.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.lineestimate.create.success", (Object[])new String[]{approverName, nextDesign, lineEstimate.getLineEstimateNumber()}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CHECKED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.check.success", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), approverName, nextDesign}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.budgetsanction.success", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), approverName, nextDesign}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.adminsanction.success", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), approverName, nextDesign, lineEstimate.getAdminSanctionNumber()}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.TECHNICAL_SANCTIONED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.techsanction.success", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), lineEstimate.getTechnicalSanctionNumber()}, null);
        } else if (lineEstimate.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.lineestimate.reject", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), approverName, nextDesign}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CANCELLED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.cancel", (Object[])new String[]{lineEstimate.getLineEstimateNumber()}, null);
        }
        return message;
    }
}

