/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptance;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.models.workorder.WorkOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class CancelLetterOfAcceptanceController
extends GenericWorkFlowController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ResourceBundleMessageSource messageSource;

    @RequestMapping(value={"/cancel/search"}, method={RequestMethod.GET})
    public String showSearchLetterOfAcceptanceForm(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, Model model) throws ApplicationException {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestLetterOfAcceptance.setDepartmentName(((Department)departments.get(0)).getId());
        }
        model.addAttribute("searchRequestContractorBill", (Object)searchRequestLetterOfAcceptance);
        return "searchloa-cancel";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancelLetterOfAcceptance(HttpServletRequest request, Model model) throws ApplicationException {
        Long letterOfAcceptanceId = Long.parseLong(request.getParameter("id"));
        String cancellationReason = request.getParameter("cancellationReason");
        String cancellationRemarks = request.getParameter("cancellationRemarks");
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(letterOfAcceptanceId);
        String billNumbers = this.letterOfAcceptanceService.checkIfBillsCreated(workOrder.getId());
        if (!billNumbers.equals("")) {
            String message = this.messageSource.getMessage("error.loa.bills.created", (Object[])new String[]{billNumbers}, null);
            model.addAttribute("errorMessage", (Object)message);
            return "letterofacceptance-success";
        }
        if (this.letterOfAcceptanceService.checkIfMileStonesCreated(workOrder)) {
            model.addAttribute("errorMessage", (Object)this.messageSource.getMessage("error.loa.milestone.created", (Object[])new String[0], null));
            return "letterofacceptance-success";
        }
        workOrder.setCancellationReason(cancellationReason);
        workOrder.setCancellationRemarks(cancellationRemarks);
        workOrder = this.letterOfAcceptanceService.cancel(workOrder);
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("mode", (Object)"cancel");
        return "letterofacceptance-success";
    }
}

