/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchTrackMilestoneJsonAdaptor
implements JsonSerializer<TrackMilestone> {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(TrackMilestone trackMilestone, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (trackMilestone != null) {
            if (trackMilestone.getMilestone().getWorkOrderEstimate().getWorkOrder().getEstimateNumber() != null) {
                LineEstimateDetails led = this.lineEstimateService.findByEstimateNumber(trackMilestone.getMilestone().getWorkOrderEstimate().getWorkOrder().getEstimateNumber());
                jsonObject.addProperty("estimateNumber", led.getEstimateNumber());
                jsonObject.addProperty("workIdentificationNumber", led.getProjectCode().getCode());
                jsonObject.addProperty("nameOfWork", led.getNameOfWork());
                jsonObject.addProperty("department", led.getLineEstimate().getExecutingDepartment().getName());
                if (led.getLineEstimate().getTypeOfWork() != null) {
                    jsonObject.addProperty("typeOfWork", led.getLineEstimate().getTypeOfWork().getDescription());
                }
                if (led.getLineEstimate().getSubTypeOfWork() != null) {
                    jsonObject.addProperty("subTypeOfWork", led.getLineEstimate().getSubTypeOfWork().getDescription());
                }
                jsonObject.addProperty("lineEstimateId", (Number)led.getLineEstimate().getId());
            } else {
                jsonObject.addProperty("estimateNumber", "");
                jsonObject.addProperty("workIdentificationNumber", "");
                jsonObject.addProperty("nameOfWork", "");
                jsonObject.addProperty("department", "");
                jsonObject.addProperty("typeOfWork", "");
                jsonObject.addProperty("subTypeOfWork", "");
                jsonObject.addProperty("lineEstimateId", "");
            }
            if (trackMilestone.getMilestone().getWorkOrderEstimate().getWorkOrder() != null) {
                jsonObject.addProperty("agreementAmount", (Number)trackMilestone.getMilestone().getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount());
                jsonObject.addProperty("workOrderNumber", trackMilestone.getMilestone().getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber());
                jsonObject.addProperty("workOrderId", (Number)trackMilestone.getMilestone().getWorkOrderEstimate().getWorkOrder().getId());
            } else {
                jsonObject.addProperty("agreementAmount", "");
                jsonObject.addProperty("workOrderNumber", "");
                jsonObject.addProperty("workOrderId", "");
            }
            if (trackMilestone.getStatus() != null) {
                jsonObject.addProperty("status", trackMilestone.getStatus().getCode());
            } else {
                jsonObject.addProperty("status", "");
            }
            jsonObject.addProperty("id", (Number)trackMilestone.getMilestone().getId());
            jsonObject.addProperty("total", (Number)trackMilestone.getTotalPercentage());
        }
        return jsonObject;
    }
}

