/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchContractorBillsToCancelJsonAdaptor
implements JsonSerializer<ContractorBillRegister> {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(ContractorBillRegister contractorBillRegister, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (contractorBillRegister != null) {
            if (contractorBillRegister.getBillnumber() != null) {
                jsonObject.addProperty("billNumber", contractorBillRegister.getBillnumber());
            } else {
                jsonObject.addProperty("billNumber", "");
            }
            if (contractorBillRegister.getBilldate() != null) {
                jsonObject.addProperty("billDate", contractorBillRegister.getBilldate().toString());
            } else {
                jsonObject.addProperty("billDate", "");
            }
            if (contractorBillRegister.getWorkOrder().getEstimateNumber() != null) {
                LineEstimateDetails led = this.lineEstimateService.findByEstimateNumber(contractorBillRegister.getWorkOrder().getEstimateNumber());
                jsonObject.addProperty("estimateNumber", led.getEstimateNumber());
                String workIdentificationNumber = led.getProjectCode().getCode();
                jsonObject.addProperty("workIdentificationNumber", workIdentificationNumber);
            } else {
                jsonObject.addProperty("estimateNumber", "");
                jsonObject.addProperty("workIdentificationNumber", "");
            }
            if (contractorBillRegister.getWorkOrder() != null) {
                jsonObject.addProperty("workOrderNumber", contractorBillRegister.getWorkOrder().getWorkOrderNumber());
            } else {
                jsonObject.addProperty("workOrderNumber", "");
            }
            if (contractorBillRegister.getWorkOrder().getContractor() != null) {
                jsonObject.addProperty("contractorName", contractorBillRegister.getWorkOrder().getContractor().getName());
            } else {
                jsonObject.addProperty("contractorName", "");
            }
            if (contractorBillRegister.getWorkOrder().getContractor() != null) {
                jsonObject.addProperty("contractorCode", contractorBillRegister.getWorkOrder().getContractor().getCode());
            } else {
                jsonObject.addProperty("contractorCode", "");
            }
            if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getVoucherHeader() != null && contractorBillRegister.getEgBillregistermis().getVoucherHeader().getStatus() != 4) {
                jsonObject.addProperty("voucherNumber", contractorBillRegister.getEgBillregistermis().getVoucherHeader().getVoucherNumber());
            } else {
                jsonObject.addProperty("voucherNumber", "");
            }
            jsonObject.addProperty("id", (Number)contractorBillRegister.getId());
        }
        return jsonObject;
    }
}

