/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.tender;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.models.tender.WorksPackageDetails;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorksPackageService;
import org.egov.works.services.WorksService;
import org.egov.works.utils.DateConversionUtil;
import org.egov.works.utils.WorksConstants;
import org.egov.works.web.actions.tender.AjaxWorksPackageAction;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="print", type="stream", location="WorkspackagePDF", params={"inputName", "WorkspackagePDF", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=WorksPackage.pdf"}), @Result(name="new", location="worksPackage-new.jsp"), @Result(name="edit", location="worksPackage-edit.jsp"), @Result(name="success", location="worksPackage-success.jsp")})
public class WorksPackageAction
extends GenericWorkFlowAction {
    private static final long serialVersionUID = -6365331777546797839L;
    private WorksService worksService;
    private WorksPackage worksPackage = new WorksPackage();
    private String designation;
    private Integer empId;
    private Long[] estId;
    private String sourcepage;
    private Money worktotalValue;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private WorksPackageService workspackageService;
    private AbstractEstimateService abstractEstimateService;
    private List<AbstractEstimate> abstractEstimateList = new ArrayList();
    private Long id;
    private String messageKey;
    private String nextEmployeeName;
    private String nextDesignation;
    private String packageNumber;
    private static final String DEPARTMENT_LIST = "departmentList";
    public static final String WORKSPACKAGE = "WorksPackage";
    public static final String PRINT = "print";
    private InputStream WorkspackagePDF;
    private ReportService reportService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<AbstractEstimate> worksPackageWorkflowService;

    public WorksPackageAction() {
        this.addRelatedEntity("department", Department.class);
    }

    public void prepare() {
        super.prepare();
        if (this.id != null) {
            this.worksPackage = (WorksPackage)this.workspackageService.findById((Serializable)this.id, false);
            this.worksPackage = (WorksPackage)this.workspackageService.merge((Object)this.worksPackage);
        }
        if (this.id == null && this.packageNumber != null && StringUtils.isNotBlank((String)this.packageNumber)) {
            this.worksPackage = (WorksPackage)this.workspackageService.find("from WorksPackage where wpNumber=? and egwStatus.code='APPROVED'", new Object[]{this.packageNumber});
        }
        this.setupDropdownDataExcluding(new String[]{"department"});
        if (this.worksPackage.getId() == null || this.worksPackage.getId() != null && (this.worksPackage.getEgwStatus().getCode().equalsIgnoreCase(WorksPackage.WorkPacakgeStatus.REJECTED.toString()) || this.worksPackage.getEgwStatus().getCode().equalsIgnoreCase("NEW"))) {
            this.addDropdownData(DEPARTMENT_LIST, this.worksService.getAllDeptmentsForLoggedInUser());
        } else {
            this.addDropdownData(DEPARTMENT_LIST, Arrays.asList(this.worksPackage.getDepartment()));
        }
        Assignment latestAssignment = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser();
        if (latestAssignment != null) {
            this.approverDepartment = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser().getDepartment().getId().toString();
            if (this.worksPackage.getDepartment() == null) {
                this.worksPackage.setDepartment(latestAssignment.getDepartment());
            }
        }
    }

    @Action(value="/tender/worksPackage-newform")
    public String newform() {
        return "new";
    }

    @Action(value="/tender/worksPackage-edit")
    public String edit() {
        if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = "search";
        }
        this.abstractEstimateList = this.workspackageService.getAbStractEstimateListByWorksPackage(this.worksPackage);
        this.setWorktotalValue(this.abstractEstimateService.getWorkValueIncludingTaxesForEstList(this.abstractEstimateList));
        return "edit";
    }

    @Action(value="/tender/worksPackage-save")
    public String save() {
        if (this.validTenderFileNo()) {
            throw new ValidationException(Arrays.asList(new ValidationError("wp.tenderfilenumber.isunique", "wp.tenderfilenumber.isunique")));
        }
        if (this.worksPackage.getId() != null && (this.worksPackage.getEgwStatus().getCode().equalsIgnoreCase(WorksPackage.WorkPacakgeStatus.REJECTED.toString()) || this.worksPackage.getEgwStatus().getCode().equalsIgnoreCase("NEW"))) {
            this.worksPackage.getWorksPackageDetails().clear();
        }
        if (this.worksPackage.getId() == null || this.worksPackage.getEgwStatus().getCode().equalsIgnoreCase(WorksPackage.WorkPacakgeStatus.REJECTED.toString()) || this.worksPackage.getEgwStatus().getCode().equalsIgnoreCase("NEW")) {
            this.populateEstimatesList(this.estId);
        }
        if (this.worksPackage.getId() == null && this.worksPackage.getEgwStatus() == null && this.abstractEstimateList.size() > 0) {
            this.validateFinancingSource(this.abstractEstimateList);
            this.validateEstimateForUniqueness();
        }
        this.validateWorksPackageDate();
        this.transitionWorkFlow(this.worksPackage);
        this.abstractEstimateService.applyAuditing((AbstractAuditable)this.worksPackage.getState());
        this.workspackageService.setWorksPackageNumber(this.worksPackage, this.abstractEstimateService.getCurrentFinancialYear(this.worksPackage.getWpDate()));
        if (this.worksPackage.getEgwStatus() != null && this.worksPackage.getEgwStatus().getCode().equals(WorksPackage.WorkPacakgeStatus.APPROVED.toString())) {
            this.worksPackage.setApprovedDate(new Date());
        }
        this.worksPackage = (WorksPackage)this.workspackageService.persist((Object)this.worksPackage);
        this.messageKey = "worksPackage." + this.workFlowAction;
        this.addActionMessage(this.getText(this.messageKey, "The Works Package was saved successfully"));
        if ("Save".equals(this.workFlowAction)) {
            this.sourcepage = "inbox";
        }
        return "Save".equals(this.workFlowAction) ? "edit" : "success";
    }

    private void validateWorksPackageDate() {
        if (this.worksPackage.getWpDate() != null && DateConversionUtil.isBeforeByDate((Date)new Date(), (Date)this.worksPackage.getWpDate())) {
            throw new ValidationException(Arrays.asList(new ValidationError("invalid.wpDate", "invalid.wpDate")));
        }
    }

    private void validateFinancingSource(List<AbstractEstimate> estimateList) {
        Integer fundSourceId1 = ((AbstractEstimate)this.abstractEstimateList.get(0)).getFundSource().getId().intValue();
        for (int i = 1; i < this.abstractEstimateList.size(); ++i) {
            if (fundSourceId1.intValue() == ((AbstractEstimate)this.abstractEstimateList.get(i)).getFundSource().getId().intValue()) continue;
            throw new ValidationException(Arrays.asList(new ValidationError("wp.estimate.different.fund.source.not.allowed", "wp.estimate.different.fund.source.not.allowed")));
        }
    }

    private void validateEstimateForUniqueness() {
        WorksPackage wp = null;
        HashMap wpMap = new HashMap();
        ArrayList<AbstractEstimate> estimateList = null;
        for (AbstractEstimate estimate : this.abstractEstimateList) {
            wp = this.workspackageService.getWorksPackageForAbstractEstimate(estimate);
            if (wp == null) continue;
            String wpString = wp.getWpNumber() + "~!" + (wp.getEgwStatus().getDescription() != null ? wp.getEgwStatus().getDescription() : " ");
            if (wpMap.get(wpString) == null) {
                estimateList = new ArrayList<AbstractEstimate>();
                estimateList.add(estimate);
                wpMap.put(wpString, estimateList);
                continue;
            }
            ((List)wpMap.get(wpString)).add(estimate);
        }
        if (!wpMap.isEmpty()) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            for (String wpnumber : wpMap.keySet()) {
                List estList = (List)wpMap.get(wpnumber);
                StringBuffer estimatesSting = null;
                for (AbstractEstimate absEstimate : estList) {
                    if (estimatesSting == null) {
                        estimatesSting = new StringBuffer();
                        estimatesSting.append(absEstimate.getEstimateNumber());
                        continue;
                    }
                    estimatesSting.append(", ").append(absEstimate.getEstimateNumber());
                }
                String[] str = StringUtils.split((String)wpnumber, (String)"~!");
                errors.add(new ValidationError("worksPackage.uniqueCheck.message", "worksPackage.uniqueCheck.message", new String[]{str[0], estimatesSting.toString(), str[1]}));
            }
            throw new ValidationException(errors);
        }
    }

    private void transitionWorkFlow(WorksPackage worksPackage) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position position = null;
        Assignment wfInitiator = null;
        wfInitiator = this.getWorkflowInitiator(worksPackage);
        if ("Cancel".equals(this.workFlowAction)) {
            if (wfInitiator.equals(userAssignment)) {
                worksPackage.transition(true).end().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(WorksPackage.WorkPacakgeStatus.CANCELLED.toString()).withDateInfo(currentDate.toDate()).withNextAction("END");
                worksPackage.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(WORKSPACKAGE, WorksPackage.WorkPacakgeStatus.CANCELLED.toString()));
            }
        } else if (WorksConstants.REJECT_ACTION.equals(this.workFlowAction)) {
            worksPackage.transition(true).withSenderName(user.getName()).withComments(this.approverComments).withStateValue(WorksPackage.WorkPacakgeStatus.REJECTED.toString()).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("");
            worksPackage.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(WORKSPACKAGE, WorksPackage.WorkPacakgeStatus.REJECTED.toString()));
        } else if ("Save".equals(this.workFlowAction)) {
            if (worksPackage.getState() == null) {
                WorkFlowMatrix wfmatrix = this.worksPackageWorkflowService.getWfMatrix(worksPackage.getStateType(), null, null, this.getAdditionalRule(), this.currentState, null);
                worksPackage.transition().start().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getCurrentState()).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition());
                worksPackage.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(WORKSPACKAGE, "NEW"));
            }
        } else {
            if (null != this.approverPositionId && this.approverPositionId != -1L) {
                position = (Position)this.persistenceService.find("from Position where id=?", new Object[]{this.approverPositionId});
            }
            if (worksPackage.getState() == null) {
                WorkFlowMatrix wfmatrix = this.worksPackageWorkflowService.getWfMatrix(worksPackage.getStateType(), null, null, this.getAdditionalRule(), this.currentState, null);
                worksPackage.transition().start().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(position).withNextAction(wfmatrix.getNextAction());
                worksPackage.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(WORKSPACKAGE, wfmatrix.getNextStatus()));
            } else {
                WorkFlowMatrix wfmatrix = this.worksPackageWorkflowService.getWfMatrix(worksPackage.getStateType(), null, null, this.getAdditionalRule(), worksPackage.getCurrentState().getValue(), null);
                if (wfmatrix.getNextAction() != null && wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    worksPackage.transition(true).end().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withNextAction(wfmatrix.getNextAction());
                } else {
                    worksPackage.transition(true).withSenderName(user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(position).withNextAction(wfmatrix.getNextAction());
                }
                worksPackage.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(WORKSPACKAGE, wfmatrix.getNextStatus()));
            }
        }
        if (!"Cancel".equals(this.workFlowAction) && !"Save".equals(this.workFlowAction)) {
            this.setApproverAndDesignation(worksPackage);
        }
    }

    private Assignment getWorkflowInitiator(WorksPackage worksPackage) {
        Assignment wfInitiator = worksPackage.getCreatedBy() == null ? this.assignmentService.getPrimaryAssignmentForUser(this.worksService.getCurrentLoggedInUserId()) : this.assignmentService.getPrimaryAssignmentForUser(worksPackage.getCreatedBy().getId());
        return wfInitiator;
    }

    public StateAware getModel() {
        return this.worksPackage;
    }

    public void setModel(WorksPackage worksPackage) {
        this.worksPackage = worksPackage;
    }

    protected void populateEstimatesList(Long[] estimateID) {
        if (estimateID == null || estimateID.length <= 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("estimates.null", "estimates.null")));
        }
        this.abstractEstimateList = this.abstractEstimateService.getAbEstimateListById(StringUtils.join((Object[])this.estId, (String)"`~`"));
        this.setWorktotalValue(this.abstractEstimateService.getWorkValueIncludingTaxesForEstList(this.abstractEstimateList));
        this.setWPDetails();
    }

    private void setWPDetails() {
        if (!this.abstractEstimateList.isEmpty()) {
            for (AbstractEstimate ab : this.abstractEstimateList) {
                WorksPackageDetails wpDetails = new WorksPackageDetails();
                wpDetails.setEstimate(ab);
                wpDetails.setWorksPackage(this.worksPackage);
                User user = this.worksService.getCurrentLoggedInUser();
                wpDetails.setCreatedBy(user);
                wpDetails.setCreatedDate(new Date());
                wpDetails.setModifiedBy(user);
                wpDetails.setModifiedDate(new Date());
                this.worksPackage.addEstimates(wpDetails);
            }
        }
    }

    public boolean validTenderFileNo() {
        boolean status = false;
        if (this.worksPackage != null && this.worksPackage.getTenderFileNumber() != null) {
            AjaxWorksPackageAction ajaxWorksPackageAction = new AjaxWorksPackageAction();
            ajaxWorksPackageAction.setPersistenceService(this.getPersistenceService());
            ajaxWorksPackageAction.setWorkspackageService(this.workspackageService);
            ajaxWorksPackageAction.setTenderFileNumber(this.worksPackage.getTenderFileNumber());
            ajaxWorksPackageAction.setId(this.id);
            if (ajaxWorksPackageAction.getTenderFileNumberCheck()) {
                status = true;
            }
        }
        return status;
    }

    @SkipValidation
    @Action(value="/tender/worksPackage-viewWorksPackagePdf")
    public String viewWorksPackagePdf() throws JRException, Exception {
        ReportRequest reportRequest = new ReportRequest("Workspackage", this.worksPackage.getActivitiesForEstimate(), this.createHeaderParams());
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.WorkspackagePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return PRINT;
    }

    private Map createHeaderParams() {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        List worksPackageDetails = this.worksPackage.getWorksPackageDetails();
        AbstractEstimate estimate = ((WorksPackageDetails)worksPackageDetails.get(0)).getEstimate();
        Boundary b = this.getTopLevelBoundary(estimate.getWard());
        reportParams.put("financialYear", this.abstractEstimateService.getCurrentFinancialYear(new Date()).getFinYearRange());
        reportParams.put("total", this.worksPackage.getTotalAmount());
        reportParams.put("cityName", b == null ? "" : b.getName());
        reportParams.put("workPackageName", this.worksPackage.getName());
        reportParams.put("worksPackageNumber", this.worksPackage.getWpNumber());
        reportParams.put("departmentName", this.worksPackage.getDepartment().getName());
        reportParams.put("tenderFileNumber", this.worksPackage.getTenderFileNumber());
        reportParams.put("estimateNumbers", this.getEstimateNumbers(this.worksPackage));
        return reportParams;
    }

    private String getEstimateNumbers(WorksPackage wp) {
        String estimateNumbers = "";
        for (WorksPackageDetails wpDetail : wp.getWorksPackageDetails()) {
            estimateNumbers = estimateNumbers.concat(wpDetail.getEstimate().getEstimateNumber()).concat(",");
        }
        if (estimateNumbers.length() > 1) {
            estimateNumbers = estimateNumbers.substring(0, estimateNumbers.length() - 1);
        }
        return estimateNumbers;
    }

    protected Boundary getTopLevelBoundary(Boundary boundary) {
        Boundary b;
        for (b = boundary; b != null && b.getParent() != null; b = b.getParent()) {
        }
        return b;
    }

    private void setApproverAndDesignation(WorksPackage worksPackage) {
        if (worksPackage.getEgwStatus() != null && !"NEW".equalsIgnoreCase(worksPackage.getEgwStatus().getCode())) {
            String result;
            Date date = new Date();
            if (worksPackage.getState().getCreatedDate() != null) {
                date = worksPackage.getState().getCreatedDate();
            }
            if ((result = this.worksService.getEmpNameDesignation(worksPackage.getState().getOwnerPosition(), date)) != null && !"@".equalsIgnoreCase(result)) {
                String empName = result.substring(0, result.lastIndexOf(64));
                String designation = result.substring(result.lastIndexOf(64) + 1, result.length());
                this.setNextEmployeeName(empName);
                this.setNextDesignation(designation);
            }
        }
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public Integer getEmpId() {
        return this.empId;
    }

    public void setEmpId(Integer empId) {
        this.empId = empId;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public void setWorkspackageService(WorksPackageService workspackageService) {
        this.workspackageService = workspackageService;
    }

    public Long[] getEstId() {
        return this.estId;
    }

    public void setEstId(Long[] estId) {
        this.estId = estId;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public List<AbstractEstimate> getAbstractEstimateList() {
        return this.abstractEstimateList;
    }

    public void setAbstractEstimateList(List<AbstractEstimate> abstractEstimateList) {
        this.abstractEstimateList = abstractEstimateList;
    }

    public Money getWorktotalValue() {
        return this.worktotalValue;
    }

    public void setWorktotalValue(Money worktotalValue) {
        this.worktotalValue = worktotalValue;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    public static String getPRINT() {
        return PRINT;
    }

    public InputStream getWorkspackagePDF() {
        return this.WorkspackagePDF;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setWorkspackagePDF(InputStream workspackagePDF) {
        this.WorkspackagePDF = workspackagePDF;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String getNextEmployeeName() {
        return this.nextEmployeeName;
    }

    public void setNextEmployeeName(String nextEmployeeName) {
        this.nextEmployeeName = nextEmployeeName;
    }

    public String getNextDesignation() {
        return this.nextDesignation;
    }

    public void setNextDesignation(String nextDesignation) {
        this.nextDesignation = nextDesignation;
    }

    public void setUserService(UserService userService) {
    }

    public String getPackageNumber() {
        return this.packageNumber;
    }

    public void setPackageNumber(String packageNumber) {
        this.packageNumber = packageNumber;
    }
}

