/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.tender;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorksPackageService;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="success", location="searchWorksPackage.jsp")})
public class SearchWorksPackageAction
extends SearchFormAction {
    private static final long serialVersionUID = -6268869129605734393L;
    private WorksPackage worksPackage = new WorksPackage();
    private List<WorksPackage> results = new LinkedList();
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private Date fromDate;
    private Date toDate;
    private String status;
    private String offlinestatus;
    private String setStatus;
    private Boolean checkRetenderedWP;
    private AbstractEstimateService abstractEstimateService;
    private WorksService worksService;
    private String negoCreatedBy;
    private String statusReq;
    private Long execDept;
    private String source;
    private String option = "";
    private String estimateOrWpSearchReq;
    public static final String OBJECT_TYPE = "WorksPackage";
    private Long wpCancelId;
    private String cancelRemarks;
    private String cancellationReason;
    private String worksPackageNumber;
    private String messageKey;
    private static final String CANCEL_SUCCESS = "cancelSuccessful";
    private String estimateNumber;
    private WorksPackageService workspackageService;
    private PersistenceService<OfflineStatus, Long> worksStatusService;
    private static final String STATUS_OBJECTID = "getStatusDateByObjectId_Type_Desc";

    public Object getModel() {
        return this.worksPackage;
    }

    public SearchWorksPackageAction() {
        this.addRelatedEntity("department", Department.class);
    }

    public void prepare() {
        super.prepare();
        this.setupDropdownDataExcluding(new String[0]);
        this.addDropdownData("offlineStatusList", this.getAllOfflineStatus());
        if ("createNegotiationForWP".equalsIgnoreCase(this.source)) {
            this.perform();
        }
    }

    public List<EgwStatus> getAllOfflineStatus() {
        String status = this.worksService.getWorksConfigValue("WP_OFFLINE_STATUS");
        ArrayList<String> statList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)status)) {
            List<String> statusList = Arrays.asList(status.split(","));
            for (String stat : statusList) {
                statList.add(stat);
            }
        }
        LinkedList<EgwStatus> returnList = new LinkedList<EgwStatus>();
        EgwStatus cancelledStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode(OBJECT_TYPE, WorksPackage.WorkPacakgeStatus.CANCELLED.toString());
        if (cancelledStatus != null) {
            returnList.add(cancelledStatus);
        }
        if (!statList.isEmpty()) {
            returnList.addAll(this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList(OBJECT_TYPE, statList));
        }
        return returnList;
    }

    public void perform() {
        if (this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser() != null) {
            this.execDept = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser().getDepartment().getId();
        }
        this.negoCreatedBy = this.worksService.getWorksConfigValue("TENDER_NEGOTIATION_CREATED_BY_SELECTION");
        this.statusReq = this.worksService.getWorksConfigValue("WP_LAST_STATUS");
        this.estimateOrWpSearchReq = this.worksService.getWorksConfigValue("ESTIMATE_OR_WP_SEARCH_REQ");
        this.addDropdownData("departmentList", this.worksService.getAllDeptmentsForLoggedInUser());
        if (StringUtils.isNotBlank((String)this.statusReq)) {
            this.setStatus(this.statusReq);
        }
    }

    public String execute() {
        return "index";
    }

    private void getPositionAndUser() {
        ArrayList<WorksPackage> wpList = new ArrayList<WorksPackage>();
        Iterator i = this.searchResult.getList().iterator();
        String lastStatusDescription = this.getLastStatus();
        AbstractList worksPackageActions = null;
        while (i.hasNext()) {
            WorksPackage wp = (WorksPackage)i.next();
            if (wp.getCurrentState() == null) continue;
            if (!wp.getEgwStatus().getCode().equalsIgnoreCase("APPROVED") && !wp.getEgwStatus().getCode().equalsIgnoreCase("CANCELLED")) {
                String posName = wp.getState().getOwnerPosition().getName();
                Assignment assignment = this.assignmentService.getPrimaryAssignmentForPositon(wp.getState().getOwnerPosition().getId());
                if (assignment != null) {
                    wp.setEmployeeName(posName + " / " + assignment.getEmployee().getName());
                } else {
                    wp.setEmployeeName(posName);
                }
            }
            String approved = this.getApprovedValue();
            OfflineStatus lastStatus = (OfflineStatus)this.worksStatusService.findByNamedQuery(STATUS_OBJECTID, new Object[]{wp.getId(), OBJECT_TYPE, lastStatusDescription});
            worksPackageActions = new LinkedList();
            worksPackageActions.add(0, "View");
            worksPackageActions.add(1, "View PDF");
            worksPackageActions.add(2, "WorkFlow History");
            worksPackageActions.add(3, "View Document");
            String setStat = "";
            if (lastStatus != null || "view".equalsIgnoreCase(this.setStatus) && wp.getOfflineStatuses() != null && !wp.getOfflineStatuses().isEmpty()) {
                setStat = "View offline status";
            } else if (lastStatus == null && StringUtils.isNotBlank((String)approved) && wp.getEgwStatus() != null && approved.equals(wp.getEgwStatus().getCode()) && "create".equalsIgnoreCase(this.setStatus)) {
                setStat = "Set offline status";
            }
            if (StringUtils.isNotBlank((String)setStat)) {
                worksPackageActions.add(setStat);
            }
            wp.setWorksPackageActions((List)worksPackageActions);
            this.setOnlineOrOfflineStatusForWp(wp);
            wpList.add(wp);
        }
        this.searchResult.getList().clear();
        this.searchResult.getList().addAll(wpList);
        if (worksPackageActions == null) {
            worksPackageActions = new ArrayList();
        }
    }

    private void setOnlineOrOfflineStatusForWp(WorksPackage wp) {
        if (wp.getEgwStatus() != null && wp.getEgwStatus().getCode().equals("APPROVED")) {
            if (wp.getLatestOfflineStatus() != null && wp.getLatestOfflineStatus().getEgwStatus() != null && StringUtils.isNotBlank((String)wp.getLatestOfflineStatus().getEgwStatus().getDescription())) {
                wp.setWorksPackageStatus(wp.getLatestOfflineStatus().getEgwStatus().getDescription());
            } else {
                wp.setWorksPackageStatus(wp.getEgwStatus().getDescription());
            }
        } else if (wp.getEgwStatus() != null) {
            wp.setWorksPackageStatus(wp.getEgwStatus().getDescription());
        }
    }

    public String getApprovedValue() {
        return WorksPackage.WorkPacakgeStatus.APPROVED.toString();
    }

    public String getLastStatus() {
        return this.worksService.getWorksConfigValue("WP_LAST_STATUS");
    }

    public List<EgwStatus> getPackageStatuses() {
        ArrayList<String> statList = new ArrayList<String>();
        for (WorksPackage.WorkPacakgeStatus stat : Arrays.asList(WorksPackage.WorkPacakgeStatus.values())) {
            statList.add(stat.toString());
        }
        String status = this.worksService.getWorksConfigValue("WP_OFFLINE_STATUS");
        String lastStatus = this.worksService.getWorksConfigValue("WP_LAST_STATUS");
        if (StringUtils.isNotBlank((String)status) && StringUtils.isNotBlank((String)lastStatus)) {
            List<String> statusList = Arrays.asList(status.split(","));
            for (String stat : statusList) {
                if (stat.equals(lastStatus)) {
                    statList.add(stat);
                    break;
                }
                statList.add(stat);
            }
        }
        return this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList(WorksPackage.class.getSimpleName(), statList);
    }

    public List<EgwStatus> getCancelPackageStatuses() {
        List statuses = this.getPackageStatuses();
        ArrayList<EgwStatus> resultStatuses = new ArrayList<EgwStatus>();
        if (statuses != null && !statuses.isEmpty()) {
            for (EgwStatus status : statuses) {
                if (status.getCode().equalsIgnoreCase("CREATED") || status.getCode().equalsIgnoreCase("CHECKED") || status.getCode().equalsIgnoreCase("REJECTED") || status.getCode().equalsIgnoreCase("CANCELLED") || status.getCode().equalsIgnoreCase("RESUBMITTED") || status.getCode().equalsIgnoreCase("NEW")) continue;
                resultStatuses.add(status);
            }
        }
        return resultStatuses;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<WorksPackage> getResults() {
        return this.results;
    }

    public void setResults(List<WorksPackage> results) {
        this.results = results;
    }

    public void setModel(WorksPackage worksPackage) {
        this.worksPackage = worksPackage;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public String getNegoCreatedBy() {
        return this.negoCreatedBy;
    }

    public String getStatusReq() {
        return this.statusReq;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setNegoCreatedBy(String negoCreatedBy) {
        this.negoCreatedBy = negoCreatedBy;
    }

    public void setStatusReq(String statusReq) {
        this.statusReq = statusReq;
    }

    public Long getExecDept() {
        return this.execDept;
    }

    public void setExecDept(Long execDept) {
        this.execDept = execDept;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSetStatus() {
        return this.setStatus;
    }

    public void setSetStatus(String setStatus) {
        this.setStatus = setStatus;
    }

    public String getEstimateOrWpSearchReq() {
        return this.estimateOrWpSearchReq;
    }

    public void setEstimateOrWpSearchReq(String estimateOrWpSearchReq) {
        this.estimateOrWpSearchReq = estimateOrWpSearchReq;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        StringBuilder sb = new StringBuilder(300);
        ArrayList<Object> paramList = new ArrayList<Object>();
        if ("createNegotiationForWP".equals(this.source)) {
            sb.append("from WorksPackage as wp where wp.egwStatus.code=? and wp.id in(select stat.objectId from OfflineStatus stat where stat.egwStatus.code= ? and stat.id = (select max(stat1.id) from OfflineStatus stat1 where stat1.objectType='WorksPackage' and wp.id=stat1.objectId)) ");
            paramList.add(WorksPackage.WorkPacakgeStatus.APPROVED.toString());
            paramList.add(this.getStatus());
        } else {
            List<String> statusList = Arrays.asList(WorksPackage.WorkPacakgeStatus.values().toString());
            if (this.checkRetenderedWP != null && this.checkRetenderedWP.booleanValue()) {
                if (StringUtils.isNotBlank((String)this.getOfflinestatus()) && this.getOfflinestatus().equals(WorksPackage.WorkPacakgeStatus.CANCELLED.toString())) {
                    sb.append("from WorksPackage as wp where wp.egwStatus.code= ? ");
                    paramList.add(this.getOfflinestatus());
                } else if (StringUtils.isNotBlank((String)this.getOfflinestatus()) && !this.getOfflinestatus().equals("-1")) {
                    sb.append("from WorksPackage as wp where wp.egwStatus.code= ? or (wp.egwStatus.code= ? and wp.id in(select stat.objectId from OfflineStatus stat where stat.egwStatus.code= ? and stat.id = (select max(stat1.id) from OfflineStatus stat1 where wp.id=stat1.objectId and stat1.objectType='WorksPackage' ) and stat.objectType='WorksPackage')) ");
                    paramList.add(this.getOfflinestatus());
                    paramList.add(WorksPackage.WorkPacakgeStatus.APPROVED.toString());
                    paramList.add(this.getOfflinestatus());
                } else if (StringUtils.isNotBlank((String)this.getOfflinestatus()) && this.getOfflinestatus().equals("-1")) {
                    sb.append("from WorksPackage as wp where wp.egwStatus.code<>'NEW'");
                }
                this.status = this.offlinestatus;
            } else if (StringUtils.isNotBlank((String)this.getStatus()) && this.getStatus().equals(WorksPackage.WorkPacakgeStatus.APPROVED.toString())) {
                sb.append("from WorksPackage as wp where wp.egwStatus.code= ? and  wp.id not in (select objectId from OfflineStatus where objectType='WorksPackage')");
                paramList.add(this.getStatus());
            } else if (StringUtils.isNotBlank((String)this.getStatus()) && this.getStatus().equals(WorksPackage.WorkPacakgeStatus.CANCELLED.toString())) {
                sb.append("from WorksPackage as wp where wp.egwStatus.code= ?  ");
                paramList.add(this.getStatus());
            } else if (StringUtils.isNotBlank((String)this.getStatus()) && !this.getStatus().equals("-1") && !this.getStatus().equals(WorksPackage.WorkPacakgeStatus.APPROVED.toString()) && "view".equalsIgnoreCase(this.setStatus) && statusList.contains(this.getStatus())) {
                sb.append("from WorksPackage as wp where wp.egwStatus.code= ? and  wp.id not in (select objectId from OfflineStatus where objectType='WorksPackage')");
                paramList.add(this.getStatus());
            } else if (StringUtils.isNotBlank((String)this.getStatus()) && !this.getStatus().equals("-1")) {
                sb.append("from WorksPackage as wp where wp.egwStatus.code= ? or (wp.egwStatus.code= ? and wp.id in(select stat.objectId from OfflineStatus stat where stat.egwStatus.code= ? and stat.id = (select max(stat1.id) from OfflineStatus stat1 where wp.id=stat1.objectId and stat1.objectType='WorksPackage' ) and stat.objectType='WorksPackage')) ");
                paramList.add(this.getStatus());
                paramList.add(WorksPackage.WorkPacakgeStatus.APPROVED.toString());
                paramList.add(this.getStatus());
            } else if (StringUtils.isNotBlank((String)this.getStatus()) && this.getStatus().equals("-1")) {
                sb.append("from WorksPackage as wp where wp.egwStatus.code<>'NEW'");
            }
        }
        if (this.worksPackage.getDepartment() != null && this.worksPackage.getDepartment().getId() != null) {
            sb.append(" and wp.department.id= ?");
            paramList.add(this.worksPackage.getDepartment().getId());
        }
        if (StringUtils.isNotBlank((String)this.worksPackage.getWpNumber())) {
            sb.append(" and wp.wpNumber like ?");
            paramList.add("%" + this.worksPackage.getWpNumber() + "%");
        }
        if (StringUtils.isNotBlank((String)this.estimateNumber)) {
            sb.append(" and wp.id in (select wpd.worksPackage.id from WorksPackageDetails wpd where wpd.estimate.estimateNumber like ?) ");
            paramList.add("%" + this.estimateNumber + "%");
        }
        if (StringUtils.isNotBlank((String)this.source) && this.source.equalsIgnoreCase("cancelWP")) {
            sb.append(" and wp.egwStatus.code<> ? ");
            paramList.add("CANCELLED");
        }
        if (this.fromDate != null && this.toDate == null) {
            this.addFieldError("enddate", this.getText("search.endDate.null"));
        }
        if (this.toDate != null && this.fromDate == null) {
            this.addFieldError("startdate", this.getText("search.startDate.null"));
        }
        if (!DateUtils.compareDates((Date)this.getToDate(), (Date)this.getFromDate())) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.fromDate"));
        }
        if (this.checkRetenderedWP != null && this.checkRetenderedWP.booleanValue()) {
            sb.append(" and wp.id in (select r.worksPackage.id from Retender r where r.worksPackage.id=wp.id ) ");
            if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
                sb.append(" and wp.id in (select r.worksPackage.id from Retender r where r.worksPackage.id=wp.id and r.retenderDate between ? and ?   and r.id=(select max(r1.id) from Retender r1 where r1.worksPackage.id=wp.id )  ) ");
                paramList.add(this.fromDate);
                paramList.add(this.toDate);
            }
        } else if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
            sb.append(" and wp.wpDate between ? and ? ");
            paramList.add(this.fromDate);
            paramList.add(this.toDate);
        }
        if (StringUtils.isNotBlank((String)this.worksPackage.getTenderFileNumber())) {
            sb.append(" and wp.tenderFileNumber like ?");
            paramList.add("%" + this.worksPackage.getTenderFileNumber() + "%");
        }
        if ("createNegotiationForWP".equals(this.source)) {
            sb.append(" and wp.id not in(select tr.tenderEstimate.worksPackage.id from TenderResponse tr where tr.egwStatus.code !='CANCELLED' and wp.id=tr.tenderEstimate.worksPackage.id) and wp.id not in(select tr1.tenderEstimate.worksPackage.id from TenderResponse tr1 where tr1.egwStatus.code ='NEW' and wp.id=tr1.tenderEstimate.worksPackage.id)");
        }
        String query = sb.toString();
        String countQuery = "select count(*) " + query;
        return new SearchQueryHQL(query, countQuery, paramList);
    }

    public String cancelWP() {
        WorksPackage worksPackage = (WorksPackage)this.workspackageService.findById((Serializable)this.wpCancelId, false);
        Employee employee = this.employeeService.getEmployeeById(this.worksService.getCurrentLoggedInUserId());
        worksPackage.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(OBJECT_TYPE, "CANCELLED"));
        if (this.cancelRemarks != null && StringUtils.isNotBlank((String)this.cancelRemarks)) {
            this.getText("wp.canceled.by", new String[]{this.cancellationReason + " : " + this.cancelRemarks, employee.getName()});
        } else {
            this.getText("wp.canceled.by", new String[]{this.cancellationReason, employee.getName()});
        }
        this.worksPackageNumber = worksPackage.getWpNumber();
        this.messageKey = this.worksPackageNumber + ": " + this.getText("workspackage.cancel.successful");
        return CANCEL_SUCCESS;
    }

    @Action(value="/tender/searchWorksPackage-search")
    public String search() {
        this.setPageSize(30);
        String retVal = super.search();
        this.getPositionAndUser();
        if (this.searchResult.getFullListSize() == 0) {
            this.addFieldError("search.result.empty", this.getText("search.result.empty"));
        }
        return retVal;
    }

    public void setWpCancelId(Long wpCancelId) {
        this.wpCancelId = wpCancelId;
    }

    public String getCancelRemarks() {
        return this.cancelRemarks;
    }

    public void setCancelRemarks(String cancelRemarks) {
        this.cancelRemarks = cancelRemarks;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public void setWorkspackageService(WorksPackageService workspackageService) {
        this.workspackageService = workspackageService;
    }

    public PersistenceService<OfflineStatus, Long> getWorksStatusService() {
        return this.worksStatusService;
    }

    public void setWorksStatusService(PersistenceService<OfflineStatus, Long> worksStatusService) {
        this.worksStatusService = worksStatusService;
    }

    public Boolean getCheckRetenderedWP() {
        return this.checkRetenderedWP;
    }

    public void setCheckRetenderedWP(Boolean checkRetenderedWP) {
        this.checkRetenderedWP = checkRetenderedWP;
    }

    public String getOfflinestatus() {
        return this.offlinestatus;
    }

    public void setOfflinestatus(String offlinestatus) {
        this.offlinestatus = offlinestatus;
    }
}

