/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.measurementbook;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.EgwStatus;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.measurementbook.MBDetails;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.WorkOrderActivity;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.services.MeasurementBookService;
import org.egov.works.services.WorkOrderService;
import org.egov.works.utils.AbstractPDFGenerator;
import org.springframework.beans.factory.annotation.Autowired;

public class MeasurementBookPDFGenerator
extends AbstractPDFGenerator {
    private static final Logger logger = Logger.getLogger(MeasurementBookPDFGenerator.class);
    private PersistenceService persistenceService = new PersistenceService();
    private MeasurementBookService measurementBookService;
    private WorkOrderService workOrderService;
    public static final String MEASUREMENTBOOK_PDF_ERROR = "measurementbook.pdf.error";
    @Autowired
    private EmployeeServiceOld employeeService;
    private final Map<String, String> pdfLabel;
    private final MBHeader mbHeader;
    private final NumberFormat formatter = new DecimalFormat("#0.00");
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.US);
    private boolean includeRevisionTypeColumn;

    public MeasurementBookPDFGenerator(MBHeader mbHeader, OutputStream out, Map<String, String> pdfLabel) {
        super(out, "landscape");
        this.pdfLabel = pdfLabel;
        this.mbHeader = mbHeader;
    }

    public void generatePDF() {
        String headerText = (String)this.pdfLabel.get("mbpdf.header");
        try {
            Paragraph headerTextPara = new Paragraph(new Chunk(headerText, new Font(-1, 14.0f, 1)));
            headerTextPara.setAlignment(1);
            this.document.add((Element)headerTextPara);
            this.document.add((Element)this.spacer());
            if (this.mbHeader != null) {
                String toPageno = "";
                toPageno = this.mbHeader.getToPageNo() == null || this.mbHeader.getToPageNo() == 0 ? this.mbHeader.getFromPageNo().toString() : this.mbHeader.getToPageNo().toString();
                this.document.add((Element)this.makeParaWithFont(8.0f, (Object)(" \t  \t  \t  \t \t " + (String)this.pdfLabel.get("mbpdf.refno") + this.mbHeader.getMbRefNo() + " \t  \t  \t  \t \t  \t  \t  \t \t  \t  \t  \t \t  \t  \t  \t \t  \t  \t  \t \t  \t  \t " + (String)this.pdfLabel.get("mbpdf.pageno") + " : " + this.mbHeader.getFromPageNo() + " to " + toPageno + " \t  \t  \t  \t \t  \t  \t  \t \t  \t  \t  \t \t  \t  \t  \t \t  \t  \t  \t \t  \t  \t " + (String)this.pdfLabel.get("mbpdf.date") + this.sdf.format(this.mbHeader.getMbDate())), 0));
            }
            this.document.add((Element)this.spacer());
            this.includeRevisionTypeColumn = false;
            this.areNTOrLSItemsPresent(this.mbHeader);
            PdfPTable mbTable = this.createMbTable();
            if (this.mbHeader != null) {
                mbTable = this.createMbData(mbTable, this.mbHeader);
            }
            this.document.add((Element)mbTable);
            this.document.add((Element)this.spacer());
            this.document.newPage();
            PdfPTable approvaldetailsTable = null;
            if (this.mbHeader != null) {
                approvaldetailsTable = this.createApprovalDetailsTable(this.mbHeader);
            }
            this.document.add((Element)this.makePara(8.0f, this.pdfLabel.get("mbpdf.approvaldetails")));
            this.document.add((Element)this.spacer());
            this.document.add((Element)approvaldetailsTable);
            this.document.close();
        }
        catch (DocumentException e) {
            throw new ApplicationRuntimeException(MEASUREMENTBOOK_PDF_ERROR, (Throwable)e);
        }
        catch (ApplicationException ex) {
            throw new ApplicationRuntimeException(MEASUREMENTBOOK_PDF_ERROR, (Throwable)ex);
        }
    }

    private void areNTOrLSItemsPresent(MBHeader mbHeader) {
        if (mbHeader != null && mbHeader.getMbDetails() != null && mbHeader.getMbDetails().size() > 0) {
            for (MBDetails mbdetails : mbHeader.getMbDetails()) {
                if (mbdetails.getWorkOrderActivity() == null || mbdetails.getWorkOrderActivity().getActivity() == null || mbdetails.getWorkOrderActivity().getActivity().getRevisionType() == null) continue;
                this.includeRevisionTypeColumn = true;
            }
        }
    }

    private PdfPTable createApprovalDetailsTable(MBHeader mbHeader) throws DocumentException {
        try {
            PdfPTable approvaldetailsTable = new PdfPTable(5);
            approvaldetailsTable.setWidthPercentage(100.0f);
            approvaldetailsTable.setWidths(new float[]{2.0f, 1.0f, 1.0f, 1.5f, 2.0f});
            this.addRow(approvaldetailsTable, true, new Paragraph[]{this.makePara(8.0f, this.pdfLabel.get("mbpdf.aprvalstep")), this.centerPara(8.0f, this.pdfLabel.get("mbpdf.name")), this.centerPara(8.0f, this.pdfLabel.get("mbpdf.designation")), this.centerPara(8.0f, this.pdfLabel.get("mbpdf.aprvdon")), this.centerPara(8.0f, this.pdfLabel.get("mbpdf.remarks"))});
            List history = null;
            String code = "";
            if (mbHeader.getCurrentState() != null && mbHeader.getCurrentState().getHistory() != null) {
                history = mbHeader.getStateHistory();
            }
            if (history != null) {
                Collections.reverse(history);
                for (StateHistory ad : history) {
                    if (ad.getValue().equals("NEW") || ad.getValue().equals("END")) continue;
                    String nextAction = "";
                    if (ad.getNextAction() != null) {
                        nextAction = ad.getNextAction();
                    }
                    Long positionId = null;
                    String desgName = null;
                    DeptDesig deptdesig = null;
                    positionId = ad.getOwnerPosition().getId();
                    deptdesig = ad.getOwnerPosition().getDeptDesig();
                    desgName = deptdesig.getDesignation().getName();
                    PersonalInformation emp = this.employeeService.getEmpForPositionAndDate(ad.getCreatedDate(), Integer.valueOf(Integer.parseInt(positionId.toString())));
                    code = ad.getValue();
                    EgwStatus status = (EgwStatus)this.getPersistenceService().find("from EgwStatus where moduletype=? and code=?", new Object[]{"MBHeader", code});
                    String state = status.getDescription();
                    if (!nextAction.equalsIgnoreCase("")) {
                        state = status.getDescription() + " - " + nextAction;
                    }
                    this.addRow(approvaldetailsTable, true, new Paragraph[]{this.makePara(8.0f, (Object)state), this.makePara(8.0f, (Object)emp.getEmployeeName()), this.makePara(8.0f, (Object)desgName), this.makePara(8.0f, (Object)this.getDateInFormat(ad.getCreatedDate().toString())), this.rightPara(8.0f, (Object)ad.getComments())});
                }
            }
            return approvaldetailsTable;
        }
        catch (Exception e) {
            throw new DocumentException("Exception occured while getting approval details " + e);
        }
    }

    private String getDateInFormat(String date) throws DocumentException {
        String dateInFormat = null;
        try {
            dateInFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US).format(new SimpleDateFormat("yyyy-MM-dd", Locale.US).parse(date));
        }
        catch (Exception e) {
            throw new DocumentException("Exception occured while parsing date := " + e);
        }
        return dateInFormat;
    }

    private PdfPTable createMbTable() throws DocumentException, ApplicationException {
        PdfPTable mbTable;
        if (this.includeRevisionTypeColumn) {
            mbTable = new PdfPTable(12);
            mbTable.setWidths(new float[]{1.0f, 1.5f, 4.0f, 1.4f, 1.9f, 1.6f, 1.4f, 1.8f, 1.9f, 1.9f, 1.9f, 1.6f});
        } else {
            mbTable = new PdfPTable(11);
            mbTable.setWidths(new float[]{1.0f, 1.5f, 4.0f, 1.9f, 1.6f, 1.4f, 1.8f, 1.9f, 1.9f, 1.9f, 1.6f});
        }
        mbTable.setWidthPercentage(100.0f);
        try {
            Font font = new Font();
            font.setSize(8.0f);
            mbTable.getDefaultCell().setPadding(3.0f);
            mbTable.getDefaultCell().setBorderWidth(1.0f);
            mbTable.getDefaultCell().setHorizontalAlignment(1);
            mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.slno"), font)));
            mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.schno"), font)));
            mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.descofwork"), font)));
            if (this.includeRevisionTypeColumn) {
                mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.revisiontype"), font)));
            }
            mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.completedmeasurement"), font)));
            mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.unitrate"), font)));
            mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.unit"), font)));
            mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.totalvalueofcomplwork"), font)));
            PdfPTable previousMbTable = this.createPreviousMbTable();
            PdfPCell previousMbCell = new PdfPCell(previousMbTable);
            previousMbCell.setColspan(2);
            mbTable.addCell(previousMbCell);
            mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.currentmeasurement"), font)));
            mbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.currentcost"), font)));
        }
        catch (DocumentException e) {
            throw new ApplicationRuntimeException(MEASUREMENTBOOK_PDF_ERROR, (Throwable)e);
        }
        catch (ApplicationException ex) {
            throw new ApplicationRuntimeException(MEASUREMENTBOOK_PDF_ERROR, (Throwable)ex);
        }
        return mbTable;
    }

    public PdfPTable createPreviousMbTable() throws DocumentException, ApplicationException {
        PdfPTable previousMbTable = new PdfPTable(2);
        Font font = new Font();
        font.setSize(8.0f);
        previousMbTable.getDefaultCell().setBorderWidth(1.0f);
        previousMbTable.getDefaultCell().setHorizontalAlignment(1);
        previousMbTable.getDefaultCell().setColspan(2);
        previousMbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.previousmeasurement"), font)));
        previousMbTable.getDefaultCell().setColspan(1);
        previousMbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.pageno"), font)));
        previousMbTable.addCell(new PdfPCell(new Phrase((String)this.pdfLabel.get("mbpdf.measurements"), font)));
        return previousMbTable;
    }

    private PdfPTable createMbData(PdfPTable mbTable, MBHeader mbHeader) throws DocumentException, ApplicationException {
        Integer i = 0;
        double uomFactor = 0.0;
        for (MBDetails mbDetails : mbHeader.getMbDetails()) {
            String description = "";
            String per = "";
            String schNo = "";
            double currentMeasurement = 0.0;
            currentMeasurement = mbDetails.getQuantity();
            i = i + 1;
            mbTable.getDefaultCell().setHorizontalAlignment(0);
            mbTable.addCell((Phrase)this.rightPara(8.0f, (Object)i.toString()));
            WorkOrderActivity workOrderActivity = mbDetails.getWorkOrderActivity();
            Activity activity = workOrderActivity.getActivity();
            if (activity != null) {
                if (activity.getSchedule() != null && activity.getSchedule().getCode() != null) {
                    schNo = activity.getSchedule().getCode();
                }
                mbTable.addCell((Phrase)this.rightPara(8.0f, (Object)schNo));
                if (activity.getSchedule() != null && activity.getSchedule().getDescription() != null) {
                    description = activity.getSchedule().getDescription();
                }
                if (activity.getNonSor() != null && activity.getNonSor().getDescription() != null) {
                    description = activity.getNonSor().getDescription();
                }
                mbTable.addCell((Phrase)this.makeParaWithFont(8.0f, (Object)description, 0));
            }
            if (this.includeRevisionTypeColumn) {
                if (activity.getRevisionType() == null) {
                    mbTable.addCell((Phrase)this.makePara(8.0f, (Object)""));
                }
                if (activity.getRevisionType() != null && activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString())) {
                    mbTable.addCell((Phrase)this.makePara(8.0f, (Object)"Non Tendered"));
                }
                if (activity.getRevisionType() != null && activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.LUMP_SUM_ITEM.toString())) {
                    mbTable.addCell((Phrase)this.makePara(8.0f, (Object)"Lump Sum"));
                }
            }
            double completedMeasurement = 0.0;
            double cumlPrevMb = 0.0;
            try {
                long woaId = 0L;
                if (workOrderActivity.getId() != null) {
                    woaId = workOrderActivity.getId();
                }
                cumlPrevMb = this.measurementBookService.prevCumulativeQuantityIncludingCQ(Long.valueOf(woaId), mbHeader.getId(), workOrderActivity.getActivity().getId(), mbHeader.getWorkOrder());
            }
            catch (Exception e) {
                cumlPrevMb = 0.0;
            }
            completedMeasurement = cumlPrevMb + currentMeasurement;
            mbTable.getDefaultCell().setHorizontalAlignment(2);
            mbTable.addCell((Phrase)this.rightPara(8.0f, (Object)completedMeasurement));
            double approveRateWo = 0.0;
            approveRateWo = workOrderActivity.getApprovedRate();
            mbTable.getDefaultCell().setHorizontalAlignment(2);
            mbTable.addCell((Phrase)this.rightPara(8.0f, (Object)this.formatter.format(approveRateWo)));
            if (activity != null) {
                uomFactor = activity.getConversionFactor();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("----------uomFactor------------" + uomFactor));
                }
                mbTable.getDefaultCell().setHorizontalAlignment(1);
                if (activity.getSchedule() != null && activity.getSchedule().getUom() != null && activity.getSchedule().getUom().getUom() != null) {
                    per = activity.getSchedule().getUom().getUom();
                }
                if (activity.getNonSor() != null && activity.getNonSor().getUom() != null && activity.getNonSor().getUom().getUom() != null) {
                    per = activity.getNonSor().getUom().getUom();
                }
                mbTable.addCell((Phrase)this.centerPara(8.0f, (Object)per));
            }
            double workCompleted = completedMeasurement * approveRateWo * uomFactor;
            mbTable.getDefaultCell().setHorizontalAlignment(2);
            mbTable.addCell((Phrase)this.rightPara(8.0f, (Object)this.formatter.format(workCompleted)));
            Integer frompageNo = null;
            Integer topageNo = null;
            MBHeader resultHeader = this.workOrderService.findLastMBPageNoForLineItem(workOrderActivity, mbHeader.getId());
            if (resultHeader != null) {
                frompageNo = resultHeader.getFromPageNo();
                topageNo = resultHeader.getToPageNo();
            }
            String pageNoInfo = "";
            if (frompageNo != null) {
                pageNoInfo = resultHeader.getMbRefNo() + "/" + frompageNo.toString();
            }
            if (topageNo != null) {
                pageNoInfo = pageNoInfo + "-" + topageNo;
            }
            mbTable.addCell((Phrase)this.rightPara(8.0f, (Object)pageNoInfo));
            mbTable.addCell((Phrase)this.rightPara(8.0f, (Object)cumlPrevMb));
            mbTable.addCell((Phrase)this.rightPara(8.0f, (Object)currentMeasurement));
            double currentCost = 0.0;
            currentCost = currentMeasurement * approveRateWo * uomFactor;
            mbTable.addCell((Phrase)this.rightPara(8.0f, (Object)this.formatter.format(currentCost)));
        }
        return mbTable;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public EmployeeServiceOld getEmployeeService() {
        return this.employeeService;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public void setMeasurementBookService(MeasurementBookService measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }
}

