/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.measurementbook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.dao.DesignationMasterDAO;
import org.egov.pims.service.EisUtilService;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderActivity;
import org.egov.works.services.MeasurementBookService;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;

public class AjaxMeasurementBookAction
extends BaseFormAction {
    private static final long serialVersionUID = 3154955519825652739L;
    private static final Logger logger = Logger.getLogger(AjaxMeasurementBookAction.class);
    private static final String USERS_IN_DEPT = "usersInDept";
    private static final String DESIGN_FOR_EMP = "designForEmp";
    private static final String WORK_ORDER_DETAILS = "workOrderDetails";
    private static final String ACTIVITY_DETAILS = "activityDetails";
    private static final String WORKFLOW_USER_LIST = "workflowUsers";
    private static final String WORKFLOW_DESIG_LIST = "workflowDesignations";
    private static final String CHANGE_QUANTITY = "CHANGE_QUANTITY";
    private MeasurementBookService measurementBookService;
    @Autowired
    private AssignmentService assignmentService;
    private Assignment assignment;
    private Long empID;
    private Long executingDepartment;
    private List usersInExecutingDepartment;
    private WorkOrder workOrder;
    private String workOrderNumber;
    private Long woActivityId;
    private Long mbHeaderId;
    private WorkOrderActivity workOrderActivity;
    private Double prevCulmEntry;
    private Double totalEstQuantity;
    private EisUtilService eisService;
    private Integer departmentId;
    private Integer designationId;
    private String scriptName;
    private String stateName;
    private Long modelId;
    private String modelType;
    private Integer wardId;
    private List workflowKDesigList;
    private List workflowUsers;
    private PersonalInformationService personalInformationService;
    private WorksService worksService;
    private String activityRemarks;
    private String query = "";
    private List<AbstractEstimate> estimateList = new LinkedList();
    private List<WorkOrder> workOrderList = new LinkedList();
    private List<MBHeader> mbHeaderList = new LinkedList();
    private Long estId;
    private Date latestMBDate;
    private Long woId;
    @Autowired
    private ScriptService scriptService;

    public Object getModel() {
        return null;
    }

    public String designationForUser() {
        try {
            this.assignment = this.assignmentService.getPrimaryAssignmentForEmployee(this.empID);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        return DESIGN_FOR_EMP;
    }

    public String usersInExecutingDepartment() {
        try {
            HashMap<String, Long> criteriaParams = new HashMap<String, Long>();
            criteriaParams.put("departmentId", this.executingDepartment);
            this.usersInExecutingDepartment = this.executingDepartment == null || this.executingDepartment == -1L ? Collections.EMPTY_LIST : this.personalInformationService.getListOfEmployeeViewBasedOnCriteria(criteriaParams, Integer.valueOf(-1), Integer.valueOf(-1));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        logger.info((Object)"Success ajax call to 'usersInExecutingDepartment' ----------------------------------------------------------");
        return USERS_IN_DEPT;
    }

    public String workOrderDetails() {
        try {
            this.workOrder = (WorkOrder)this.persistenceService.find("from WorkOrder where workOrderNumber=?", new Object[]{this.workOrderNumber});
            if (this.workOrder != null) {
                HashMap<String, Object> criteriaParams = new HashMap<String, Object>();
                criteriaParams.put("departmentId", this.executingDepartment);
                criteriaParams.put("isPrimary", "Y");
                this.usersInExecutingDepartment = this.executingDepartment == null || this.executingDepartment == -1L ? Collections.EMPTY_LIST : this.personalInformationService.getListOfEmployeeViewBasedOnCriteria(criteriaParams, Integer.valueOf(-1), Integer.valueOf(-1));
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("workorder.find.error", (Throwable)e);
        }
        logger.info((Object)"Success ajax call to 'workOrderDetails' ----------------------------------------------------------");
        return WORK_ORDER_DETAILS;
    }

    public String activityDetails() {
        this.prevCulmEntry = null;
        this.activityRemarks = "";
        try {
            this.workOrderActivity = (WorkOrderActivity)this.persistenceService.find("from WorkOrderActivity where id=?", new Object[]{this.woActivityId});
            this.prevCulmEntry = this.measurementBookService.prevCumulativeQuantityIncludingCQ(this.woActivityId, this.mbHeaderId, this.workOrderActivity.getActivity().getId(), this.workOrderActivity.getWorkOrderEstimate().getWorkOrder());
            this.totalEstQuantity = this.modelType != null && this.modelType.equalsIgnoreCase("MB") ? Double.valueOf(this.measurementBookService.totalEstimatedQuantity(this.woActivityId, null, this.workOrderActivity.getActivity().getId(), this.workOrderActivity.getWorkOrderEstimate().getWorkOrder())) : Double.valueOf(this.measurementBookService.totalEstimatedQuantityForRE(this.woActivityId, null, this.workOrderActivity.getActivity().getId(), this.workOrderActivity.getWorkOrderEstimate().getWorkOrder()));
            WorkOrderActivity revWorkOrderActivity = (WorkOrderActivity)this.persistenceService.find("from WorkOrderActivity where activity.parent.id=? and workOrderEstimate.estimate.egwStatus.code !='CANCELLED'  ", new Object[]{this.workOrderActivity.getActivity().getId()});
            if (revWorkOrderActivity != null) {
                this.activityRemarks = CHANGE_QUANTITY;
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("activity.find.error", (Throwable)e);
        }
        return ACTIVITY_DETAILS;
    }

    public String getWorkFlowUsers() {
        if (this.designationId != -1) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (this.departmentId != null && this.departmentId != -1) {
                paramMap.put("departmentId", this.departmentId.toString());
            }
            if (this.wardId != null && this.wardId != -1) {
                paramMap.put("boundaryId", this.wardId.toString());
            }
            paramMap.put("designationId", this.designationId.toString());
            List roleList = this.worksService.getWorksRoles();
            if (roleList != null) {
                paramMap.put("roleList", roleList);
            }
            this.workflowUsers = this.eisService.getEmployeeInfoList(paramMap);
        }
        return WORKFLOW_USER_LIST;
    }

    public String getDesgByDeptAndType() {
        this.workflowKDesigList = new ArrayList();
        String departmentName = "";
        Department department = null;
        if (this.departmentId != -1) {
            department = (Department)this.getPersistenceService().find("from Department where id=?", new Object[]{this.departmentId});
            departmentName = department.getName();
        }
        Designation designation = null;
        MBHeader mbHeader = null;
        if (this.modelId != null) {
            mbHeader = (MBHeader)this.getPersistenceService().find("from MBHeader where id=?", new Object[]{this.modelId});
        }
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"state", this.stateName, "department", departmentName, "wfItem", mbHeader});
        List list = (List)this.scriptService.executeScript(this.scriptName, scriptContext);
        for (String desgName : list) {
            if (desgName.trim().length() == 0) continue;
            try {
                designation = new DesignationMasterDAO().getDesignationByDesignationName(desgName);
                this.workflowKDesigList.add(designation);
            }
            catch (NoSuchObjectException e) {
                logger.error((Object)e);
            }
        }
        return WORKFLOW_DESIG_LIST;
    }

    public String searchEstimateNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select woe.estimate from WorkOrderEstimate woe where woe.workOrder.parent is null and woe.estimate.estimateNumber like '%'||?||'%'  and woe.id in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where mbh.egwStatus.code <> ? )";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.estimateList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "estimateNoSearchResults";
    }

    public String searchWorkOrderNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct mbh.workOrder from MBHeader mbh where mbh.workOrder.parent is null and mbh.workOrder.workOrderNumber like '%'||?||'%' and mbh.egwStatus.code <> ? ";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.workOrderList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "workOrderNoSearchResults";
    }

    public String searchMbRefNo() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = " from MBHeader mbh where mbh.mbRefNo like '%'||?||'%' and mbh.egwStatus.code <> ? ";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.mbHeaderList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "mbRefNoSearchResults";
    }

    public String getLatestMBDateforSelectedEstimate() {
        this.latestMBDate = this.measurementBookService.getLastMBCreatedDate(this.woId, this.estId);
        return "mblatestDateResult";
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public void setEmpID(Long empID) {
        this.empID = empID;
    }

    public List getUsersInExecutingDepartment() {
        return this.usersInExecutingDepartment;
    }

    public void setExecutingDepartment(Long executingDepartment) {
        this.executingDepartment = executingDepartment;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public void setWoActivityId(Long woActivityId) {
        this.woActivityId = woActivityId;
    }

    public WorkOrderActivity getWorkOrderActivity() {
        return this.workOrderActivity;
    }

    public Double getPrevCulmEntry() {
        return this.prevCulmEntry;
    }

    public void setMbHeaderId(Long mbHeaderId) {
        this.mbHeaderId = mbHeaderId;
    }

    public void setMeasurementBookService(MeasurementBookService measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public Integer getDesignationId() {
        return this.designationId;
    }

    public void setDesignationId(Integer designationId) {
        this.designationId = designationId;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public Integer getWardId() {
        return this.wardId;
    }

    public void setWardId(Integer wardId) {
        this.wardId = wardId;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public List getWorkflowKDesigList() {
        return this.workflowKDesigList;
    }

    public List getWorkflowUsers() {
        return this.workflowUsers;
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
        this.personalInformationService = personalInformationService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<AbstractEstimate> getEstimateList() {
        return this.estimateList;
    }

    public void setEstimateList(List<AbstractEstimate> estimateList) {
        this.estimateList = estimateList;
    }

    public List<WorkOrder> getWorkOrderList() {
        return this.workOrderList;
    }

    public void setWorkOrderList(List<WorkOrder> workOrderList) {
        this.workOrderList = workOrderList;
    }

    public List<MBHeader> getMbHeaderList() {
        return this.mbHeaderList;
    }

    public void setMbHeaderList(List<MBHeader> mbHeaderList) {
        this.mbHeaderList = mbHeaderList;
    }

    public Double getTotalEstQuantity() {
        return this.totalEstQuantity;
    }

    public String getActivityRemarks() {
        return this.activityRemarks;
    }

    public Long getEstId() {
        return this.estId;
    }

    public void setEstId(Long estId) {
        this.estId = estId;
    }

    public Date getLatestMBDate() {
        return this.latestMBDate;
    }

    public void setLatestMBDate(Date latestMBDate) {
        this.latestMBDate = latestMBDate;
    }

    public Long getWoId() {
        return this.woId;
    }

    public void setWoId(Long woId) {
        this.woId = woId;
    }
}

