/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.masters;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bank;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.master.service.ContractorGradeService;
import org.egov.works.master.service.ContractorService;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.masters.ContractorDetail;
import org.egov.works.services.WorksService;
import org.elasticsearch.common.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="contractor-new.jsp"), @Result(name="searchContractor", location="contractor-searchContractor.jsp"), @Result(name="search", location="contractor-search.jsp"), @Result(name="success", location="contractor-success.jsp"), @Result(name="edit", location="contractor-edit.jsp"), @Result(name="view", location="contractor-view.jsp")})
public class ContractorAction
extends SearchFormAction {
    private static final long serialVersionUID = 3167651186547987956L;
    private static final Logger logger = Logger.getLogger(ContractorAction.class);
    public static final String SEARCH_CONTRACTOR = "searchContractor";
    public static final String SEARCH = "search";
    public static final String SUCCESS = "success";
    public static final String EDIT = "edit";
    public static final String VIEW = "view";
    @Autowired
    private ContractorService contractorService;
    private Contractor contractor = new Contractor();
    private Map<String, String> exmptionMap = ContractorService.exemptionForm;
    private List<Contractor> contractorList = null;
    private List<ContractorDetail> actionContractorDetails = new LinkedList();
    private Long id;
    private String mode;
    @Autowired
    private UserService userService;
    private WorksService worksService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibDAO;
    @Autowired
    private ContractorGradeService contractorGradeService;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    private String contractorName;
    private String contractorCode;
    private Long departmentId;
    private Long gradeId;
    private Date searchDate;
    private boolean sDisabled;
    private Integer statusId;
    private List<ContractorDetail> contractorDetailList = null;
    private PersistenceService<ContractorDetail, Long> contractorDetailService;
    private Integer rowId;
    private Map<String, Object> criteriaMap = null;

    public ContractorAction() {
        this.addRelatedEntity("bank", Bank.class);
    }

    public String execute() {
        return this.list();
    }

    @Action(value="/masters/contractor-newform")
    public String newform() {
        return "new";
    }

    public String list() {
        this.contractorList = this.contractorService.getAllContractors();
        return SUCCESS;
    }

    @Action(value="/masters/contractor-edit")
    public String edit() {
        this.contractor = (Contractor)this.contractorService.findById((Serializable)this.contractor.getId(), false);
        if (this.mode.equals(EDIT)) {
            return EDIT;
        }
        return VIEW;
    }

    @Action(value="/masters/contractor-search")
    public String search() {
        return SEARCH_CONTRACTOR;
    }

    @Action(value="/masters/contractor-searchContractor")
    public String searchContractor() {
        return SEARCH_CONTRACTOR;
    }

    @Action(value="/masters/contractor-viewResult")
    public String viewResult() {
        this.setPageSize(30);
        this.contractorList = this.contractorService.getContractorListForCriterias(this.createCriteriaMap());
        super.search();
        return SEARCH_CONTRACTOR;
    }

    @Action(value="/masters/contractor-save")
    public String save() {
        this.populateContractorDetails(this.mode);
        this.contractor = (Contractor)this.contractorService.persist((Object)this.contractor);
        if (this.mode == null || this.mode.equals("")) {
            this.contractorService.createAccountDetailKey(this.contractor);
        }
        this.contractorService.persist((Object)this.contractor);
        if (StringUtils.isBlank((CharSequence)this.mode)) {
            this.addActionMessage(this.getText("contractor.save.success", new String[]{this.contractor.getCode()}));
        } else {
            this.addActionMessage(this.getText("contractor.modified.success"));
        }
        return SUCCESS;
    }

    @Action(value="/masters/contractor-searchPage")
    public String searchPage() {
        String negDate = (String)this.request.get("negDate");
        if (negDate != null) {
            SimpleDateFormat dftDateFormatter = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
            try {
                this.searchDate = dftDateFormatter.parse(negDate);
            }
            catch (ParseException e) {
                logger.error((Object)"Negotiation date is not valid, should be in dd/MM/yyyy format");
            }
        }
        return SEARCH;
    }

    @Action(value="/masters/contractor-searchResult")
    public String searchResult() {
        this.contractorService.searchContractor(this.createCriteriaMap());
        return SEARCH;
    }

    protected void populateContractorDetails(String mode) {
        this.contractor.getContractorDetails().clear();
        for (ContractorDetail contractorDetail : this.actionContractorDetails) {
            if (this.validContractorDetail(contractorDetail)) {
                contractorDetail.setDepartment(this.departmentService.getDepartmentById(contractorDetail.getDepartment().getId()));
                contractorDetail.setStatus(this.egwStatusHibDAO.findById(contractorDetail.getStatus().getId(), false));
                if (contractorDetail.getGrade().getId() == null) {
                    contractorDetail.setGrade(null);
                } else {
                    contractorDetail.setGrade(this.contractorGradeService.getContractorGradeById(contractorDetail.getGrade().getId()));
                }
                contractorDetail.setContractor(this.contractor);
                if (mode.equals(EDIT)) {
                    this.setPrimaryDetails(contractorDetail);
                }
                this.contractor.addContractorDetail(contractorDetail);
                continue;
            }
            if (contractorDetail == null) continue;
            if (contractorDetail.getDepartment() == null || contractorDetail.getDepartment().getId() == null) {
                contractorDetail.setDepartment(null);
            } else {
                contractorDetail.setDepartment(this.departmentService.getDepartmentById(contractorDetail.getDepartment().getId()));
            }
            if (contractorDetail.getStatus() == null || contractorDetail.getStatus().getId() == null) {
                contractorDetail.setStatus(null);
            } else {
                contractorDetail.setStatus(this.egwStatusHibDAO.findById(contractorDetail.getStatus().getId(), false));
            }
            if (contractorDetail.getGrade() == null || contractorDetail.getGrade().getId() == null) {
                contractorDetail.setGrade(null);
            } else {
                contractorDetail.setGrade(this.contractorGradeService.getContractorGradeById(contractorDetail.getGrade().getId()));
            }
            contractorDetail.setContractor(this.contractor);
            if (mode.equals(EDIT)) {
                this.setPrimaryDetails(contractorDetail);
            }
            this.contractor.addContractorDetail(contractorDetail);
        }
    }

    protected boolean validContractorDetail(ContractorDetail contractorDetail) {
        return contractorDetail != null && contractorDetail.getDepartment() != null && contractorDetail.getStatus() != null && contractorDetail.getDepartment().getId() != null && contractorDetail.getStatus().getId() != null;
    }

    public Object getModel() {
        return this.contractor;
    }

    public List<Contractor> getContractorList() {
        return this.contractorList;
    }

    public void prepare() {
        if (this.id != null) {
            this.contractor = (Contractor)this.contractorService.findById((Serializable)this.id, false);
        }
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"bank"});
        this.addDropdownData("departmentList", this.departmentService.getAllDepartments());
        this.addDropdownData("gradeList", this.contractorGradeService.getAllContractorGrades());
        this.addDropdownData("bankList", this.bankHibernateDAO.findAll());
        this.addDropdownData("statusList", this.egwStatusHibDAO.getStatusByModule("Contractor"));
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Contractor getContractor() {
        return this.contractor;
    }

    public void setContractor(Contractor contractor) {
        this.contractor = contractor;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<ContractorDetail> getActionContractorDetails() {
        return this.actionContractorDetails;
    }

    public void setActionContractorDetails(List<ContractorDetail> actionContractorDetails) {
        this.actionContractorDetails = actionContractorDetails;
    }

    public String getContractorName() {
        return this.contractorName;
    }

    public void setContractorName(String contractorName) {
        this.contractorName = contractorName;
    }

    public String getContractorCode() {
        return this.contractorCode;
    }

    public void setContractorCode(String contractorCode) {
        this.contractorCode = contractorCode;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public Long getGradeId() {
        return this.gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public Date getSearchDate() {
        return this.searchDate;
    }

    public void setSearchDate(Date searchDate) {
        this.searchDate = searchDate;
    }

    public Map<String, String> getExmptionMap() {
        return this.exmptionMap;
    }

    public void setExmptionMap(Map<String, String> exmptionMap) {
        this.exmptionMap = exmptionMap;
    }

    public Integer getStatusId() {
        return this.statusId;
    }

    public void setStatusId(Integer statusId) {
        this.statusId = statusId;
    }

    public List<ContractorDetail> getContractorDetailList() {
        return this.contractorDetailList;
    }

    public void setContractorDetailList(List<ContractorDetail> contractorDetailList) {
        this.contractorDetailList = contractorDetailList;
    }

    public PersistenceService<ContractorDetail, Long> getContractorDetailService() {
        return this.contractorDetailService;
    }

    public void setContractorDetailService(PersistenceService<ContractorDetail, Long> contractorDetailService) {
        this.contractorDetailService = contractorDetailService;
    }

    public boolean isSDisabled() {
        return this.sDisabled;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        return this.contractorService.prepareQuery(this.createCriteriaMap());
    }

    public Integer getRowId() {
        return this.rowId;
    }

    public void setRowId(Integer rowId) {
        this.rowId = rowId;
    }

    private ContractorDetail setPrimaryDetails(ContractorDetail contractorDetail) {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        contractorDetail.setCreatedBy(user);
        contractorDetail.setCreatedDate(new Date());
        return contractorDetail;
    }

    private Map<String, Object> createCriteriaMap() {
        this.criteriaMap = new HashMap();
        this.criteriaMap.put("contractorName", this.contractorName);
        this.criteriaMap.put("contractorCode", this.contractorCode);
        this.criteriaMap.put("departmentId", this.departmentId);
        this.criteriaMap.put("statusId", this.statusId);
        this.criteriaMap.put("gradeId", this.gradeId);
        this.criteriaMap.put("searchDate", this.searchDate);
        return this.criteriaMap;
    }
}

