/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.AssetsForEstimate;
import org.egov.works.abstractestimate.entity.MultiYearEstimate;
import org.egov.works.abstractestimate.entity.NonSor;
import org.egov.works.abstractestimate.entity.OverheadValue;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name="success", location="copyEstimate-success.jsp")
public class CopyEstimateAction
extends BaseFormAction {
    private static final long serialVersionUID = 4934369735700310753L;
    private Long estimateId;
    private String copyCancelledEstNum;
    private AbstractEstimate copyEstimate = new AbstractEstimate();
    private AbstractEstimateService abstractEstimateService;
    @Autowired
    private EmployeeServiceOld employeeService;
    private Date financialYearStartDate;
    private String messageKey;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private FinancialYearHibernateDAO finHibernateDo;
    private WorksService worksService;

    public void prepare() {
        super.prepare();
    }

    public String copyEstimate() {
        AbstractEstimate abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.estimateId, false);
        this.employeeService.getEmpForUserId(this.worksService.getCurrentLoggedInUserId());
        this.copyEstimate.setWard(abstractEstimate.getWard());
        this.copyEstimate.setName(abstractEstimate.getName());
        this.copyEstimate.setEstimateDate(abstractEstimate.getEstimateDate());
        this.copyEstimate.setDescription(abstractEstimate.getDescription());
        this.copyEstimate.setLocation(abstractEstimate.getLocation());
        this.copyEstimate.setNatureOfWork(abstractEstimate.getNatureOfWork());
        this.copyEstimate.setCategory(abstractEstimate.getCategory());
        this.copyEstimate.setParentCategory(abstractEstimate.getParentCategory());
        this.copyEstimate.setUserDepartment(abstractEstimate.getUserDepartment());
        this.copyEstimate.setExecutingDepartment(abstractEstimate.getExecutingDepartment());
        this.copyEstimate.setFundSource(abstractEstimate.getFundSource());
        this.copyEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", "NEW"));
        this.copyEstimate.setOverheadValues(this.cloneOverheadValue(abstractEstimate.getOverheadValues()));
        this.copyEstimate.setActivities(this.cloneActivity(abstractEstimate.getActivities()));
        this.copyEstimate.setAssetValues(this.closeAssetForEstimate(abstractEstimate.getAssetValues()));
        this.copyEstimate.setMultiYearEstimates(this.cloneMultiYearEstimate(abstractEstimate.getMultiYearEstimates()));
        this.copyEstimate.setWorkValue(abstractEstimate.getWorkValue());
        this.copyEstimate.setCopiedEstimate(true);
        this.copyEstimate = (AbstractEstimate)this.abstractEstimateService.persist((Object)this.copyEstimate);
        if (abstractEstimate.getEstimateNumber().endsWith("/C") && this.copyCancelledEstNum.equals("yes")) {
            String estNum = abstractEstimate.getEstimateNumber().substring(0, abstractEstimate.getEstimateNumber().length() - 2);
            this.copyEstimate.setEstimateNumber(estNum);
        } else {
            this.abstractEstimateService.setEstimateNumber(this.copyEstimate);
        }
        this.messageKey = "The estimate was copied successfully from estimate " + abstractEstimate.getEstimateNumber() + " to estimate " + this.copyEstimate.getEstimateNumber();
        return "success";
    }

    private List<OverheadValue> cloneOverheadValue(List<OverheadValue> overHeadValueList) {
        ArrayList<OverheadValue> newOverHeadList = new ArrayList<OverheadValue>();
        for (OverheadValue overhead : overHeadValueList) {
            OverheadValue newOverhead = new OverheadValue();
            newOverhead.setAmount(overhead.getAmount());
            newOverhead.setOverhead(overhead.getOverhead());
            newOverhead.setAbstractEstimate(this.copyEstimate);
            newOverHeadList.add(newOverhead);
        }
        return newOverHeadList;
    }

    private List<MultiYearEstimate> cloneMultiYearEstimate(List<MultiYearEstimate> multiYearEstList) {
        ArrayList<MultiYearEstimate> newMultiYearEstList = new ArrayList<MultiYearEstimate>();
        for (MultiYearEstimate multiYearEst : multiYearEstList) {
            MultiYearEstimate newMultiYearEst = new MultiYearEstimate();
            newMultiYearEst.setAbstractEstimate(this.copyEstimate);
            newMultiYearEst.setFinancialYear(multiYearEst.getFinancialYear());
            newMultiYearEst.setPercentage(multiYearEst.getPercentage());
            newMultiYearEstList.add(newMultiYearEst);
        }
        return newMultiYearEstList;
    }

    private List<Activity> cloneActivity(List<Activity> activityList) {
        ArrayList<Activity> newActivityList = new ArrayList<Activity>();
        for (Activity activity : activityList) {
            Activity newActivity = new Activity();
            newActivity.setUom(activity.getUom());
            newActivity.setSchedule(activity.getSchedule());
            newActivity.setServiceTaxPerc(activity.getServiceTaxPerc());
            newActivity.setQuantity(activity.getQuantity());
            newActivity.setRate(activity.getRate());
            newActivity.setAbstractEstimate(this.copyEstimate);
            if (activity.getNonSor() != null) {
                NonSor nonSORObj = new NonSor();
                nonSORObj.setDescription(activity.getNonSor().getDescription());
                nonSORObj.setUom(activity.getNonSor().getUom());
                newActivity.setNonSor(nonSORObj);
            } else {
                newActivity.setNonSor(null);
            }
            newActivityList.add(newActivity);
        }
        return newActivityList;
    }

    private List<AssetsForEstimate> closeAssetForEstimate(List<AssetsForEstimate> assetEstList) {
        ArrayList<AssetsForEstimate> newAssetEstList = new ArrayList<AssetsForEstimate>();
        for (AssetsForEstimate asset : assetEstList) {
            AssetsForEstimate newAssetEst = new AssetsForEstimate();
            newAssetEst.setAbstractEstimate(this.copyEstimate);
            newAssetEst.setAsset(asset.getAsset());
            newAssetEstList.add(newAssetEst);
        }
        return newAssetEstList;
    }

    public Object getModel() {
        return null;
    }

    public Date getFinancialYearStartDate() {
        this.financialYearStartDate = this.finHibernateDo.getFinancialYearByFinYearRange(this.worksService.getWorksConfigValue("FINANCIAL_YEAR_RANGE")).getStartingDate();
        return this.financialYearStartDate;
    }

    public void setFinancialYearStartDate(Date financialYearStartDate) {
        this.financialYearStartDate = financialYearStartDate;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public AbstractEstimateService getAbstractEstimateService() {
        return this.abstractEstimateService;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public EmployeeServiceOld getEmployeeService() {
        return this.employeeService;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public WorksService getWorksService() {
        return this.worksService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String getCopyCancelledEstNum() {
        return this.copyCancelledEstNum;
    }

    public void setCopyCancelledEstNum(String copyCancelledEstNum) {
        this.copyCancelledEstNum = copyCancelledEstNum;
    }

    public AbstractEstimate getCopyEstimate() {
        return this.copyEstimate;
    }

    public void setCopyEstimate(AbstractEstimate copyEstimate) {
        this.copyEstimate = copyEstimate;
    }

    public void setEstimateWorkflowService(WorkflowService<AbstractEstimate> workflow) {
    }
}

