/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.EstimatePDFGenerator;
import org.springframework.beans.factory.annotation.Autowired;

@Result(name="success", type="stream", location="estimatePDF", params={"inputName", "estimatePDF", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=AbstractEstimatePDF.pdf"})
@ParentPackage(value="egov")
public class AbstractEstimatePDFAction
extends BaseFormAction {
    private static final long serialVersionUID = 8202192351878784580L;
    private static final Logger logger = Logger.getLogger(AbstractEstimatePDFAction.class);
    private Long estimateID;
    private InputStream estimatePDF;
    private AbstractEstimateService abstractEstimateService;
    @Autowired
    private AssignmentService assignmentService;
    private WorksService worksService;

    public Object getModel() {
        return null;
    }

    public String execute() {
        if (this.estimateID != null) {
            AbstractEstimate estimate = this.getAbstractEstimate();
            Boundary b = this.getTopLevelBoundary(estimate.getWard());
            ByteArrayOutputStream out = new ByteArrayOutputStream(102400);
            EstimatePDFGenerator pdfGenerator = new EstimatePDFGenerator(estimate, b == null ? "" : b.getName(), (OutputStream)out);
            pdfGenerator.setPersistenceService(this.getPersistenceService());
            pdfGenerator.setAssignmentService(this.assignmentService);
            pdfGenerator.setBudgetDetailsDAO(this.abstractEstimateService.getBudgetDetailsDAO());
            pdfGenerator.setAbstractEstimateService(this.abstractEstimateService);
            pdfGenerator.setWorksService(this.worksService);
            try {
                pdfGenerator.generatePDF();
            }
            catch (ValidationException e) {
                logger.debug((Object)("exception " + (Object)((Object)e)));
            }
            this.estimatePDF = new ByteArrayInputStream(out.toByteArray());
        }
        return "success";
    }

    private AbstractEstimate getAbstractEstimate() {
        return (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.estimateID, false);
    }

    protected Boundary getTopLevelBoundary(Boundary boundary) {
        Boundary b;
        for (b = boundary; b != null && b.getParent() != null; b = b.getParent()) {
        }
        return b;
    }

    public void setEstimateID(Long estimateID) {
        this.estimateID = estimateID;
    }

    public InputStream getEstimatePDF() {
        return this.estimatePDF;
    }

    public AbstractEstimateService getAbstractEstimateService() {
        return this.abstractEstimateService;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }
}

