/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.Fund;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

public class WorksService {
    private static final Logger logger = Logger.getLogger(WorksService.class);
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private PersistenceService persistenceService;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yyyy", Locale.getDefault());
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;

    public List<AppConfigValues> getAppConfigValue(String moduleName, String key) {
        return this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, key);
    }

    public List<String> getNatureOfWorkAppConfigValues(String moduleName, String key) {
        List appValuesList = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, key);
        ArrayList<String> natureOfWorksList = new ArrayList<String>();
        if (appValuesList != null && !appValuesList.isEmpty()) {
            for (AppConfigValues appValue : appValuesList) {
                natureOfWorksList.add(appValue.getValue());
            }
        }
        return natureOfWorksList;
    }

    public String getWorksConfigValue(String key) {
        List<AppConfigValues> configList = this.getAppConfigValue("Works Management", key);
        if (!configList.isEmpty()) {
            return configList.get(0).getValue();
        }
        return null;
    }

    public Accountdetailtype getAccountdetailtypeByName(String name) {
        return this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName(name);
    }

    public Double getConfigval() {
        String configVal = this.getWorksConfigValue("MAXEXTRALINEITEMPERCENTAGE");
        Double extraPercentage = null;
        extraPercentage = StringUtils.isNotBlank((String)configVal) ? Double.valueOf(configVal) : Double.valueOf("1");
        return extraPercentage;
    }

    public String getEmpNameDesignation(Position position, Date date) {
        String empName = "";
        String designationName = "";
        DeptDesig deptDesig = position.getDeptDesig();
        Designation designationMaster = deptDesig.getDesignation();
        designationName = designationMaster.getName();
        Employee employee = this.assignmentService.getPrimaryAssignmentForPositionAndDate(position.getId(), date).getEmployee();
        if (employee != null && employee.getName() != null) {
            empName = employee.getName();
        }
        return empName + "@" + designationName;
    }

    public boolean checkBigDecimalValue(BigDecimal obj1, BigDecimal obj2) {
        if (obj1 == null) {
            return true;
        }
        if (obj2 == null) {
            return true;
        }
        if (obj1.compareTo(obj2) == -1) {
            return false;
        }
        return obj1.compareTo(obj2) != 0;
    }

    public List<EgwStatus> getStatusesByParams(String objStatus, String objSetStatus, String objLastStatus, String objType) {
        ArrayList<String> statList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)objStatus)) {
            statList.add(objStatus);
        }
        if (StringUtils.isNotBlank((String)objSetStatus) && StringUtils.isNotBlank((String)objLastStatus)) {
            List<String> statusList = Arrays.asList(objSetStatus.split(","));
            for (String stat : statusList) {
                if (stat.equals(objLastStatus)) {
                    statList.add(stat);
                    break;
                }
                statList.add(stat);
            }
        }
        return this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList(objType, statList);
    }

    public void createAccountDetailKey(Long id, String type) {
        Accountdetailtype accountdetailtype = this.getAccountdetailtypeByName(type);
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(id.intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }

    public List getWorksRoles() {
        String configVal = this.getWorksConfigValue("WORKS_ROLES");
        ArrayList<String> rolesList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)configVal)) {
            String[] configVals;
            for (String configVal2 : configVals = configVal.split(",")) {
                rolesList.add(configVal2);
            }
        }
        return rolesList;
    }

    public List<String> getTendertypeList() {
        String tenderConfigValues = this.getWorksConfigValue("TENDER_TYPE");
        return Arrays.asList(tenderConfigValues.split(","));
    }

    public boolean validateWorkflowForUser(StateAware wfObj, User user) {
        boolean validateUser = true;
        List assignmentList = null;
        ArrayList<Position> positionList = new ArrayList<Position>();
        if (user != null && wfObj.getCurrentState() != null && !wfObj.getCurrentState().getValue().equals("END")) {
            assignmentList = this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date());
            for (Assignment assignment : assignmentList) {
                positionList.add(assignment.getPosition());
            }
            if (!positionList.isEmpty() && positionList.contains(wfObj.getCurrentState().getOwnerPosition())) {
                validateUser = false;
            }
        }
        return validateUser;
    }

    public Long getCurrentLoggedInUserId() {
        return ApplicationThreadLocals.getUserId();
    }

    public User getCurrentLoggedInUser() {
        return (User)this.persistenceService.getSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId());
    }

    public Map<String, Integer> getExceptionSOR() {
        List<AppConfigValues> appConfigList = this.getAppConfigValue("Works Management", "EXCEPTIONALSOR");
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        for (AppConfigValues configValue : appConfigList) {
            String[] value = configValue.getValue().split(",");
            resultMap.put(value[0], Integer.valueOf(value[1]));
        }
        return resultMap;
    }

    public List<Map<String, Object>> getWorkProgressTotalPayments(String uuid) throws ApplicationException {
        HashMap<String, String> result = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String payQuery = " select dept.dept_name,nvl(sum(bp.debitamount),0),count(payvh.id) FROM  eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms, voucherheader payvh, miscbilldetail misc, eg_department dept   WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and misc.billvhid=vh.id and misc.payvhid=payvh.id and bp.pc_department=dept.id_dept  and payvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('SALBILL','EXPENSEBILL','SBILL','CONTRACTORBILL','CBILL'))  and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WORKPROGRESS_PROJECT_CODE WHERE UUID like '" + uuid + "')) group by dept.dept_name ";
        List objForExpense = this.persistenceService.getSession().createSQLQuery(payQuery).list();
        if (objForExpense != null && objForExpense.size() != 0) {
            Integer i = 0;
            while (i < objForExpense.size()) {
                result = new HashMap<String, String>();
                result.put("deptName", ((Object[])objForExpense.get(i))[0].toString());
                result.put("amount", ((Object[])objForExpense.get(i))[1].toString());
                result.put("count", ((Object[])objForExpense.get(i))[2].toString());
                resultList.add(result);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return resultList;
        }
        return null;
    }

    public List<Map<String, Object>> getVoucherCounts(String uuid) throws ApplicationException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> resultMap = null;
        String countQry = " select dept.dept_name, count(distinct(vh.id))  FROM eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms, eg_department dept WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id  and bp.pc_department=dept.id_dept and vh.name='Contractor Journal'  and br.STATUSID in(select id from egw_status where lower(code)='approved' and moduletype in('CONTRACTORBILL')) and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WORKPROGRESS_PROJECT_CODE WHERE UUID like '" + uuid + "')  group by dept.dept_name ";
        List queryResult = this.persistenceService.getSession().createSQLQuery(countQry).list();
        if (queryResult != null && queryResult.size() != 0) {
            Integer i = 0;
            while (i < queryResult.size()) {
                resultMap = new HashMap<String, Object>();
                resultMap.put("deptName", ((Object[])queryResult.get(i))[0].toString());
                resultMap.put("count", new Integer(((Object[])queryResult.get(i))[1].toString()));
                resultList.add(resultMap);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return resultList;
        }
        return null;
    }

    public List<Map<String, Map<String, BigDecimal>>> getTotalCJVCountAndAmounts(String uuid) throws ApplicationException {
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Integer i;
        HashMap<String, HashMap<String, BigDecimal>> resultMap = null;
        HashMap<String, BigDecimal> simpleMap = null;
        ArrayList<Map<String, Map<String, BigDecimal>>> resultList = new ArrayList<Map<String, Map<String, BigDecimal>>>();
        String payQuery = " select dept.dept_name , nvl(sum(bp.debitamount),0)  FROM  eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms , eg_department dept  WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and bp.pc_department=dept.id_dept  and vh.name='Contractor Journal'   and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('CONTRACTORBILL'))  and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WORKPROGRESS_PROJECT_CODE WHERE UUID like '" + uuid + "')) and bp.accountdetailkeyid in ( select bp1.ACCOUNTDETAILKEYID FROM eg_billregister br1,  eg_billdetails bd1, eg_billpayeedetails bp1 ,voucherheader vh1,eg_billregistermis ms1  WHERE br1.id =bd1.billid AND bd1.id =bp1.BILLDETAILID    and vh1.id=ms1.VOUCHERHEADERID and ms1.BILLID=br1.id and vh1.name='Contractor Journal' and vh1.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " AND br1.STATUSID IN (SELECT id FROM egw_status WHERE lower(code)='approved' AND moduletype  IN('CONTRACTORBILL'))  and br1.billtype in ('FinalBill', 'Final Bill') and bp1.ACCOUNTDETAILKEYID = bp.ACCOUNTDETAILKEYID  and bp1.ACCOUNTDETAILTYPEID=bp.ACCOUNTDETAILTYPEID ) group by dept.dept_name  order by dept.dept_name  ";
        String countQuery = " select dept.dept_name , count(vh.id) FROM  eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms, eg_department dept   WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and bp.pc_department=dept.id_dept  and vh.name='Contractor Journal'  and br.billtype in ('FinalBill', 'Final Bill')  and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('CONTRACTORBILL'))  and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WORKPROGRESS_PROJECT_CODE WHERE UUID like '" + uuid + "'))  group by dept.dept_name order by dept.dept_name ";
        List payQueryResult = this.persistenceService.getSession().createSQLQuery(payQuery).list();
        List countQueryResult = this.persistenceService.getSession().createSQLQuery(countQuery).list();
        ArrayList<String> deptNameList = new ArrayList<String>();
        if (payQueryResult != null && payQueryResult.size() > 0) {
            i = 0;
            while (i < payQueryResult.size()) {
                deptNameList.add(((Object[])payQueryResult.get(i))[0].toString());
                n4 = i;
                n3 = i = Integer.valueOf(i + 1);
            }
        }
        if (countQueryResult != null && countQueryResult.size() > 0) {
            i = 0;
            while (i < countQueryResult.size()) {
                deptNameList.add(((Object[])countQueryResult.get(i))[0].toString());
                n4 = i;
                n3 = i = Integer.valueOf(i + 1);
            }
        }
        if (deptNameList == null || deptNameList.size() <= 0) {
            return null;
        }
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.addAll(deptNameList);
        deptNameList.clear();
        deptNameList.addAll(tempSet);
        BigDecimal[] payArray = new BigDecimal[deptNameList.size()];
        BigDecimal[] countArray = new BigDecimal[deptNameList.size()];
        Integer i2 = 0;
        while (i2 < deptNameList.size()) {
            payArray[i2.intValue()] = BigDecimal.ZERO;
            countArray[i2.intValue()] = BigDecimal.ZERO;
            Integer n5 = i2;
            Integer n6 = i2 = Integer.valueOf(i2 + 1);
        }
        String deptName = null;
        Integer index = null;
        Integer i3 = null;
        i3 = 0;
        while (i3 < payQueryResult.size()) {
            deptName = ((Object[])payQueryResult.get(i3))[0].toString();
            index = deptNameList.indexOf(deptName);
            payArray[index.intValue()] = new BigDecimal(((Object[])payQueryResult.get(i3))[1].toString());
            n2 = i3;
            n = i3 = Integer.valueOf(i3 + 1);
        }
        i3 = 0;
        while (i3 < countQueryResult.size()) {
            deptName = ((Object[])countQueryResult.get(i3))[0].toString();
            index = deptNameList.indexOf(deptName);
            countArray[index.intValue()] = new BigDecimal(((Object[])countQueryResult.get(i3))[1].toString());
            n2 = i3;
            n = i3 = Integer.valueOf(i3 + 1);
        }
        i3 = 0;
        while (i3 < deptNameList.size()) {
            deptName = (String)deptNameList.get(i3);
            simpleMap = new HashMap<String, BigDecimal>();
            simpleMap.put("amount", payArray[i3]);
            simpleMap.put("count", countArray[i3]);
            resultMap = new HashMap<String, HashMap<String, BigDecimal>>();
            resultMap.put(deptName, simpleMap);
            resultList.add(resultMap);
            n2 = i3;
            n = i3 = Integer.valueOf(i3 + 1);
        }
        return resultList;
    }

    public List<Map<String, Object>> getWorkProgressTotal(String uuid) throws ApplicationException {
        HashMap<String, String> result = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String payQuery = " select dept.dept_name,nvl(sum(bp.debitamount),0),count(payvh.id) FROM  eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms, voucherheader payvh, miscbilldetail misc, eg_department dept   WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and misc.billvhid=vh.id and misc.payvhid=payvh.id and bp.pc_department=dept.id_dept  and payvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('SALBILL','EXPENSEBILL','SBILL','CONTRACTORBILL','CBILL'))  and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WORKPROGRESS_PROJECT_CODE WHERE UUID like '" + uuid + "')) group by dept.dept_name ";
        List objForExpense = this.persistenceService.getSession().createSQLQuery(payQuery).list();
        if (objForExpense != null && objForExpense.size() != 0) {
            Integer i = 0;
            while (i < objForExpense.size()) {
                result = new HashMap<String, String>();
                result.put("deptName", ((Object[])objForExpense.get(i))[0].toString());
                result.put("amount", ((Object[])objForExpense.get(i))[1].toString());
                result.put("count", ((Object[])objForExpense.get(i))[2].toString());
                resultList.add(result);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return resultList;
        }
        return null;
    }

    public List<Map<String, Object>> getWorkProgressAbstractReport2TotalPayments(String uuid, Date fromDate, Date toDate) throws ApplicationException {
        HashMap<String, String> result = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String payQuery = "select \"Department\" as \"DEP\",sum(\"Approved Payment Amount\")as \"APP_PAY\",sum(\"No of Approved Payment\") as \"APP_PAY_COUNT\", sum(\"Concurrence Payment Amount\")as \"CON_AMT\",sum(\"No of Concurrence Given\")as \"CON_PAY_COUNT\" FROM( select dept.dept_name as \"Department\",nvl(sum(bp.debitamount),0) \"Approved Payment Amount\",count(distinct payvh.id) \"No of Approved Payment\", 0 \"Concurrence Payment Amount\", 0 \"No of Concurrence Given\"  FROM eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms, voucherheader payvh, miscbilldetail misc, eg_department dept   WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and misc.billvhid=vh.id and misc.payvhid=payvh.id and bp.pc_department=dept.id_dept  and payvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('EXPENSEBILL','CONTRACTORBILL','CBILL'))  and br.BILLDATE between '" + this.dateFormatter.format(fromDate) + "' and '" + this.dateFormatter.format(toDate) + "'  and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WORKPROGRESS_PROJECT_CODE WHERE UUID like '" + uuid + "')) group by dept.dept_name  UNION ALL  select dept.dept_name as \"Department\",0 \"Approved Payment Amount\",0 \"No of Approved Payment\" ,nvl(sum(bp.debitamount),0) \"Concurrence Payment Amount\",count(distinct payvh.id) \"No of Concurrence Given\"  FROM eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms, voucherheader payvh, miscbilldetail misc, eg_department dept,paymentheader ph    WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and misc.billvhid=vh.id and misc.payvhid=payvh.id and bp.pc_department=dept.id_dept  and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('EXPENSEBILL','CONTRACTORBILL','CBILL'))  and br.BILLDATE between '" + this.dateFormatter.format(fromDate) + "' and '" + this.dateFormatter.format(toDate) + "'  and bd.DEBITAMOUNT>0  and ph.VOUCHERHEADERID=payvh.id and (payvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " or (payvh.status=" + FinancialConstants.PREAPPROVEDVOUCHERSTATUS + " and ph.CONCURRENCEDATE is not null)) and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WORKPROGRESS_PROJECT_CODE WHERE UUID like '" + uuid + "')) group by dept.dept_name  )group by \"Department\"";
        logger.debug((Object)("Payment query inside getWorkProgressAbstractReport2TotalPayments :" + payQuery));
        List objForExpense = this.persistenceService.getSession().createSQLQuery(payQuery).list();
        if (objForExpense != null && objForExpense.size() != 0) {
            Integer i = 0;
            while (i < objForExpense.size()) {
                result = new HashMap<String, String>();
                result.put("deptName", ((Object[])objForExpense.get(i))[0].toString());
                result.put("amount", ((Object[])objForExpense.get(i))[1].toString());
                result.put("count", ((Object[])objForExpense.get(i))[2].toString());
                result.put("concAmount", ((Object[])objForExpense.get(i))[3].toString());
                result.put("concCount", ((Object[])objForExpense.get(i))[4].toString());
                resultList.add(result);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return resultList;
        }
        return null;
    }

    public BigDecimal getTotalPaymentForProjectCode(Long projcodeId) throws ApplicationException {
        String payQuery = " select nvl(sum(nvl(bp.debitamount,0)),0)   FROM eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms,  voucherheader payvh, miscbilldetail misc, eg_department dept   WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and misc.billvhid=vh.id  and misc.payvhid=payvh.id and bp.pc_department=dept.id_dept  and payvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('EXPENSEBILL','CONTRACTORBILL','CBILL'))  and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in('" + projcodeId + "'))  ";
        logger.debug((Object)("Payment query inside getTotalPaymentForProjectCode :" + payQuery));
        List objForExpense = this.persistenceService.getSession().createSQLQuery(payQuery).list();
        if (objForExpense != null && objForExpense.size() != 0 && objForExpense.get(0) != null && !objForExpense.get(0).toString().equalsIgnoreCase("0")) {
            BigDecimal result = new BigDecimal(objForExpense.get(0).toString());
            return result;
        }
        return null;
    }

    public List<Map<String, Object>> getWorkProgressAbstractReport2VoucherCounts(String uuid, Date fromDate, Date toDate) throws ApplicationException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> resultMap = null;
        String countQry = " select dept.dept_name, count(distinct(vh.id)), nvl(sum(bp.debitamount),0)  FROM eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms, eg_department dept WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id  and bp.pc_department=dept.id_dept and vh.name='Contractor Journal'  and br.STATUSID in(select id from egw_status where lower(code)='approved' and moduletype in('CONTRACTORBILL'))  and br.BILLDATE between '" + this.dateFormatter.format(fromDate) + "' and '" + this.dateFormatter.format(toDate) + "' and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WORKPROGRESS_PROJECT_CODE WHERE UUID like '" + uuid + "')  group by dept.dept_name ";
        List queryResult = this.persistenceService.getSession().createSQLQuery(countQry).list();
        if (queryResult != null && queryResult.size() != 0) {
            Integer i = 0;
            while (i < queryResult.size()) {
                resultMap = new HashMap<String, Object>();
                resultMap.put("deptName", ((Object[])queryResult.get(i))[0].toString());
                resultMap.put("count", new Integer(((Object[])queryResult.get(i))[1].toString()));
                resultMap.put("amount", ((Object[])queryResult.get(i))[2].toString());
                resultList.add(resultMap);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return resultList;
        }
        return null;
    }

    public List<Map<String, Object>> getWorkProgSpillOverTotalPayments(String uuid, Date fromDate, Date toDate) throws ApplicationException {
        HashMap<String, String> result = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String payQuery = " select \"Dept\",sum(\"Approved_Pay\") as \"APP_PAY\",sum(\"No_Approved_Pay\") as \"APP_PAY_COUNT\", sum(\"Concurrence_Pay_Amount\")as \"CON_AMT\",sum(\"No_Concurrence_Pay\")as \"CON_PAY_COUNT\" FROM( select dept.dept_name as \"Dept\",nvl(sum(bp.debitamount),0) as \"Approved_Pay\",count(distinct payvh.id) \"No_Approved_Pay\" ,0 \"Concurrence_Pay_Amount\",0 \"No_Concurrence_Pay\" FROM eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms,  voucherheader payvh, miscbilldetail misc, eg_department dept   WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id  and misc.billvhid=vh.id and misc.payvhid=payvh.id and bp.pc_department=dept.id_dept   and payvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('EXPENSEBILL','CONTRACTORBILL','CBILL'))  and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and br.BILLDATE between '" + this.dateFormatter.format(fromDate) + "' and '" + this.dateFormatter.format(toDate) + "'  and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' )  and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WRKPROG_PROJCODE_SPILLOVER WHERE UUID like '" + uuid + "'))  group by dept.dept_name  UNION ALL select dept.dept_name as \"Dept\",0 as \"Approved_Pay\",0 \"No_Approved_Pay\" ,nvl(sum(bp.debitamount),0) \"Concurrence_Payment_Amount\",count(distinct payvh.id) \"No_Concurrence_Given\" FROM eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms,  voucherheader payvh, miscbilldetail misc, eg_department dept,paymentheader ph   WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id  and misc.billvhid=vh.id and misc.payvhid=payvh.id and bp.pc_department=dept.id_dept   and payvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('EXPENSEBILL','CONTRACTORBILL','CBILL'))  and bd.DEBITAMOUNT>0   and ph.VOUCHERHEADERID=payvh.id and (payvh.status=" + FinancialConstants.CREATEDVOUCHERSTATUS + " or (payvh.status=" + FinancialConstants.PREAPPROVEDVOUCHERSTATUS + " and ph.CONCURRENCEDATE is not null)) and br.BILLDATE between '" + this.dateFormatter.format(fromDate) + "' and '" + this.dateFormatter.format(toDate) + "'  and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' )  and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WRKPROG_PROJCODE_SPILLOVER WHERE UUID like '" + uuid + "')) group by dept.dept_name  )group by \"Dept\"";
        logger.debug((Object)("Payment query inside getWorkProgSpillOverTotalPayments :" + payQuery));
        List objForExpense = this.persistenceService.getSession().createSQLQuery(payQuery).list();
        if (objForExpense != null && objForExpense.size() != 0) {
            Integer i = 0;
            while (i < objForExpense.size()) {
                result = new HashMap<String, String>();
                result.put("deptName", ((Object[])objForExpense.get(i))[0].toString());
                result.put("amount", ((Object[])objForExpense.get(i))[1].toString());
                result.put("count", ((Object[])objForExpense.get(i))[2].toString());
                result.put("concAmount", ((Object[])objForExpense.get(i))[3].toString());
                result.put("concCount", ((Object[])objForExpense.get(i))[4].toString());
                resultList.add(result);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return resultList;
        }
        return null;
    }

    public List<Map<String, Object>> getVoucherCountsForSpillOver(String uuid, Date fromDate, Date toDate) throws ApplicationException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> resultMap = null;
        String countQry = " select dept.dept_name, count(distinct(vh.id)), nvl(sum(bp.debitamount),0) FROM eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms, eg_department dept WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id  and bp.pc_department=dept.id_dept and vh.name='Contractor Journal'  and br.STATUSID in(select id from egw_status where lower(code)='approved' and moduletype in('CONTRACTORBILL')) and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and br.BILLDATE between '" + this.dateFormatter.format(fromDate) + "' and '" + this.dateFormatter.format(toDate) + "'  and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE' )  and bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WRKPROG_PROJCODE_SPILLOVER WHERE UUID like '" + uuid + "')  group by dept.dept_name ";
        List queryResult = this.persistenceService.getSession().createSQLQuery(countQry).list();
        if (queryResult != null && queryResult.size() != 0) {
            Integer i = 0;
            while (i < queryResult.size()) {
                resultMap = new HashMap<String, Object>();
                resultMap.put("deptName", ((Object[])queryResult.get(i))[0].toString());
                resultMap.put("count", new Integer(((Object[])queryResult.get(i))[1].toString()));
                resultMap.put("amount", ((Object[])queryResult.get(i))[2].toString());
                resultList.add(resultMap);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return resultList;
        }
        return null;
    }

    public Fund getCapitalFund() {
        Fund fund = null;
        fund = (Fund)this.persistenceService.find("from Fund where name like '%Capital Fund'");
        return fund;
    }

    public List<Map<String, Object>> getBudgetDetailsForFinYear(String uuid, Date fromDate, Date toDate) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> resultMap = null;
        String query = "select dp.DEPT_NAME, sum(bp.DEBITAMOUNT),  sum(budd.APPROVEDAMOUNT)+ (decode(sum(bapp.addition_amount-bapp.deduction_amount),null,0,sum(bapp.addition_amount-bapp.deduction_amount)) )  from eg_billregister br, eg_billdetails bd, eg_billpayeedetails bp, eg_billregistermis bm, eg_department dp,  egf_budgetdetail budd left outer join EGF_BUDGET_REAPPROPRIATION bapp on budd.id=bapp.budgetdetail  where bp.BILLDETAILID=bd.id and bd.BILLID=br.id and br.BILLDATE between '" + this.dateFormatter.format(fromDate) + "' and '" + this.dateFormatter.format(toDate) + "'  and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE')   and bm.BILLID=br.id and br.STATUSID in (select id from egw_status where lower(code)='approved' and moduletype in('CONTRACTORBILL')) and dp.ID_DEPT=bm.DEPARTMENTID  and budd.EXECUTING_DEPARTMENT=dp.ID_DEPT and bd.FUNCTIONID=budd.FUNCTION and bm.FUNDID=budd.FUND  and budd.BUDGET in(select id from egf_budget where financialyearid=(select id from financialyear  where startingDate >='" + this.dateFormatter.format(fromDate) + "' and endingDate <='" + this.dateFormatter.format(toDate) + "') and isBERE='BE')  and bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WRKPROG_PROJCODE_SPILLOVER WHERE UUID like '" + uuid + "')  group by dp.DEPT_NAME order by dp.DEPT_NAME";
        List queryResult = this.persistenceService.getSession().createSQLQuery(query).list();
        if (queryResult != null && queryResult.size() != 0) {
            Integer i = 0;
            while (i < queryResult.size()) {
                resultMap = new HashMap<String, Object>();
                resultMap.put("deptName", ((Object[])queryResult.get(i))[0].toString());
                resultMap.put("BudgetAmount", new BigDecimal(((Object[])queryResult.get(i))[1].toString()));
                resultMap.put("BudgetAvailable", new BigDecimal(((Object[])queryResult.get(i))[2].toString()));
                resultList.add(resultMap);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return resultList;
        }
        return null;
    }

    public List<Map<String, Object>> getSpillOverWorkValue(String uuid, Date fromDate, Date toDate) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> resultMap = null;
        BigDecimal spillOverValue = BigDecimal.ZERO;
        String query1 = "select deptName, nvl(sum(estimate),0)+nvl(sum(ohvalue),0), count(distinct estId)  from( select dp.dept_name as deptName, ae.id as estId, (ae.value) as estimate, sum(oh.value) as ohvalue  from egw_abstractestimate ae LEFT OUTER JOIN egw_overheadvalues oh ON ae.id=oh.abstractestimate_id,  eg_department dp WHERE ae.status_id = (select id from egw_status where lower(code)='admin_sanctioned' and moduletype in('AbstractEstimate'))  and ae.approveddate<'" + this.dateFormatter.format(fromDate) + "'  and ae.PARENTID is null  and dp.id_dept=ae.executingdepartment  and EXISTS (SELECT EST_ID FROM EGW_WRKPROG_PROJCODE_SPILLOVER WHERE EST_ID=ae.id and UUID like '" + uuid + "'  and NOT EXISTS(select pyd.accountdetailkeyid from eg_billregister egbr, eg_billpayeedetails pyd, eg_billdetails ebd  where egbr.id=ebd.billid and pyd.billdetailid=ebd.id and lower(egbr.billtype)='final bill'  and egbr.statusid = (select id from egw_status where lower(code)='approved' and moduletype in('CONTRACTORBILL'))  and egbr.EXPENDITURETYPE='Works' and egbr.BILLDATE<'" + this.dateFormatter.format(fromDate) + "' and pyd.accountdetailkeyid=PC_ID  and pyd.accountdetailtypeid=(SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE')) )  group by dp.dept_name,ae.id,ae.value )  group by deptname order by deptname";
        String query2 = "select dp.dept_name, nvl(sum(bpd.DEBITAMOUNT),0) FROM egw_abstractestimate ae , egw_financialdetail fd, eg_department dp,eg_billregister br,eg_billdetails bd, eg_billpayeedetails bpd,  paymentheader ph1,miscbilldetail md,eg_billregistermis bmis,voucherheader pvh  WHERE ae.status_id = (select id from egw_status where lower(code)='admin_sanctioned' and moduletype in('AbstractEstimate'))  and ae.approveddate<'" + this.dateFormatter.format(fromDate) + "'  and bd.BILLID=br.id and bd.id=bpd.BILLDETAILID and bpd.ACCOUNTDETAILKEYID=ae.PROJECTCODE_ID and EXISTS  (SELECT PC_ID FROM EGW_WRKPROG_PROJCODE_SPILLOVER WHERE UUID like '" + uuid + "' AND PC_ID=bpd.ACCOUNTDETAILKEYID  and NOT EXISTS(select pyd.accountdetailkeyid from eg_billregister egbr, eg_billpayeedetails pyd, eg_billdetails ebd  where egbr.id=ebd.billid and pyd.billdetailid=ebd.id and lower(egbr.billtype)='final bill'  and egbr.statusid = (select id from egw_status where lower(code)='approved' and moduletype in('CONTRACTORBILL'))  and egbr.EXPENDITURETYPE='Works' and egbr.BILLDATE<'" + this.dateFormatter.format(fromDate) + "' and pyd.accountdetailkeyid=PC_ID  and pyd.accountdetailtypeid=(SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE'))) and bpd.ACCOUNTDETAILTYPEID=(SELECT id FROM accountdetailtype WHERE name ='PROJECTCODE' AND description='PROJECTCODE')  and bpd.DEBITAMOUNT>0 and EXISTS (select id from egw_status where lower(code)='approved' and moduletype in('CONTRACTORBILL','EXPENSEBILL','SBILL','SALBILL') and id=br.STATUSID)  and fd.ABSTRACTESTIMATE_ID=ae.id and ae.PARENTID is null  and bpd.pc_department=dp.id_dept  and bmis.billid=br.id and md.PAYVHID=ph1.voucherheaderid and md.BILLVHID=bmis.voucherheaderid and pvh.id=ph1.voucherheaderid  and pvh.status=0  and pvh.VOUCHERDATE < '" + this.dateFormatter.format(fromDate) + "' group by dp.dept_name order by dp.dept_name ";
        List queryResult1 = this.persistenceService.getSession().createSQLQuery(query1).list();
        List queryResult2 = this.persistenceService.getSession().createSQLQuery(query2).list();
        if (queryResult1 != null && queryResult1.size() != 0) {
            Integer i = 0;
            while (i < queryResult1.size()) {
                Integer n;
                spillOverValue = BigDecimal.ZERO;
                if (queryResult2 != null && queryResult2.size() != 0) {
                    Integer j = 0;
                    while (j < queryResult2.size()) {
                        if (((Object[])queryResult1.get(i))[0].toString().equals(((Object[])queryResult2.get(j))[0].toString())) {
                            spillOverValue = new BigDecimal(((Object[])queryResult1.get(i))[1].toString()).subtract(new BigDecimal(((Object[])queryResult2.get(j))[1].toString()));
                        }
                        n = j;
                        Integer n2 = j = Integer.valueOf(j + 1);
                    }
                } else {
                    spillOverValue = new BigDecimal(((Object[])queryResult1.get(i))[1].toString());
                }
                resultMap = new HashMap<String, Object>();
                resultMap.put("deptName", ((Object[])queryResult1.get(i))[0].toString());
                resultMap.put("spillOverEstimateCount", new Integer(((Object[])queryResult1.get(i))[2].toString()));
                resultMap.put("spillOverWorkValue", spillOverValue);
                resultList.add(resultMap);
                Integer n3 = i;
                n = i = Integer.valueOf(i + 1);
            }
            return resultList;
        }
        return null;
    }

    public BigDecimal getPaymentInfoforProjectCode(List<Object> projectCodeIdList, Date asOnDate) throws ApplicationException {
        if (projectCodeIdList == null || projectCodeIdList.size() == 0) {
            throw new ApplicationException("ProjectCode Id list is null or empty");
        }
        if (asOnDate == null) {
            throw new ApplicationException("asOnDate is null");
        }
        String strAsOnDate = Constants.DDMMYYYYFORMAT1.format(asOnDate);
        String strProjectCodeIds = this.getInSubQuery(projectCodeIdList, " bpd.ACCOUNTDETAILKEYID ", false);
        String query = " SELECT NVL(SUM(bpd.DEBITAMOUNT),0)  FROM eg_billregister br,    eg_billdetails bd,    eg_billpayeedetails bpd,    paymentheader ph1,    miscbilldetail md,    eg_billregistermis bmis,    voucherheader pvh  WHERE bd.BILLID =br.id  AND bd.id =bpd.BILLDETAILID " + strProjectCodeIds + " AND bpd.ACCOUNTDETAILKEYID NOT IN      (SELECT pyd.accountdetailkeyid      FROM eg_billregister egbr,        eg_billpayeedetails pyd,        eg_billdetails ebd      WHERE egbr.id           =ebd.billid      AND pyd.billdetailid    =ebd.id      AND lower(egbr.billtype)='final bill'      AND egbr.statusid      IN        (SELECT id        FROM egw_status        WHERE lower(code)='approved'        AND moduletype  IN('CONTRACTORBILL')        )      AND egbr.EXPENDITURETYPE   ='Works'      AND egbr.BILLDATE          <'" + strAsOnDate + "'      AND pyd.accountdetailkeyid =bpd.ACCOUNTDETAILKEYID      AND pyd.accountdetailtypeid=        (SELECT id        FROM accountdetailtype        WHERE name     ='PROJECTCODE'        AND description='PROJECTCODE'        )      )  AND bpd.ACCOUNTDETAILTYPEID=    (SELECT id    FROM accountdetailtype    WHERE name     ='PROJECTCODE'    AND description='PROJECTCODE'    )  AND bpd.DEBITAMOUNT>0  AND br.STATUSID   IN    (SELECT id    FROM egw_status    WHERE lower(code)='approved'    AND moduletype  IN('CONTRACTORBILL','EXPENSEBILL','SBILL','SALBILL')    )  AND bmis.billid           =br.id  AND md.PAYVHID            =ph1.voucherheaderid  AND md.BILLVHID           =bmis.voucherheaderid  AND pvh.id                =ph1.voucherheaderid  AND pvh.status            =0  AND pvh.VOUCHERDATE       < '" + strAsOnDate + "' ";
        List paymtAmtArray = this.persistenceService.getSession().createSQLQuery(query).list();
        return paymtAmtArray == null ? null : (BigDecimal)paymtAmtArray.get(0);
    }

    public BigDecimal getPaymentInfoforProjectCodeSubQuery(String projectCodeIdStr, Date asOnDate) throws ApplicationException {
        if (projectCodeIdStr == null) {
            throw new ApplicationException("ProjectCode Id Str is null ");
        }
        if (asOnDate == null) {
            throw new ApplicationException("asOnDate is null");
        }
        String strAsOnDate = Constants.DDMMYYYYFORMAT1.format(asOnDate);
        String query = " SELECT NVL(SUM(bpd.DEBITAMOUNT),0)  FROM eg_billregister br,    eg_billdetails bd,    eg_billpayeedetails bpd,    paymentheader ph1,    miscbilldetail md,    eg_billregistermis bmis,    voucherheader pvh  WHERE bd.BILLID =br.id  AND bd.id =bpd.BILLDETAILID  AND bpd.ACCOUNTDETAILKEYID  IN (" + projectCodeIdStr + ") AND bpd.ACCOUNTDETAILKEYID NOT IN      (SELECT pyd.accountdetailkeyid      FROM eg_billregister egbr,        eg_billpayeedetails pyd,        eg_billdetails ebd      WHERE egbr.id           =ebd.billid      AND pyd.billdetailid    =ebd.id      AND lower(egbr.billtype)='final bill'      AND egbr.statusid      IN        (SELECT id        FROM egw_status        WHERE lower(code)='approved'        AND moduletype  IN('CONTRACTORBILL')        )      AND egbr.EXPENDITURETYPE   ='Works'      AND egbr.BILLDATE          <'" + strAsOnDate + "'      AND pyd.accountdetailkeyid =bpd.ACCOUNTDETAILKEYID      AND pyd.accountdetailtypeid=        (SELECT id        FROM accountdetailtype        WHERE name     ='PROJECTCODE'        AND description='PROJECTCODE'        )      )  AND bpd.ACCOUNTDETAILTYPEID=    (SELECT id    FROM accountdetailtype    WHERE name     ='PROJECTCODE'    AND description='PROJECTCODE'    )  AND bpd.DEBITAMOUNT>0  AND br.STATUSID   IN    (SELECT id    FROM egw_status    WHERE lower(code)='approved'    AND moduletype  IN('CONTRACTORBILL','EXPENSEBILL','SBILL','SALBILL')    )  AND bmis.billid           =br.id  AND md.PAYVHID            =ph1.voucherheaderid  AND md.BILLVHID           =bmis.voucherheaderid  AND pvh.id                =ph1.voucherheaderid  AND pvh.status            =0  AND pvh.VOUCHERDATE       < '" + strAsOnDate + "' ";
        List paymtAmtArray = this.persistenceService.getSession().createSQLQuery(query).list();
        return paymtAmtArray == null ? null : (BigDecimal)paymtAmtArray.get(0);
    }

    public String getInSubQuery(List<Object> idList, String param, boolean isApostropheRequired) {
        String apostropheOrNot;
        StringBuffer inClause = new StringBuffer("");
        String string = apostropheOrNot = isApostropheRequired ? "'" : "";
        if (idList != null && idList.size() > 0 && param != null) {
            int size = idList.size();
            inClause.append(" and (" + param + " in ( ");
            for (int i = 0; i < size; ++i) {
                if (i % 1000 == 0 && i != 0) {
                    inClause.append(") or " + param + " in (").append(apostropheOrNot + idList.get(i).toString() + apostropheOrNot);
                } else {
                    inClause.append(apostropheOrNot + idList.get(i).toString() + apostropheOrNot);
                }
                if (i == size - 1) {
                    inClause.append(")) ");
                    continue;
                }
                if (i % 1000 == 999) continue;
                inClause.append(",");
            }
        }
        return inClause.toString();
    }

    public List<Department> getAllDeptmentsForLoggedInUser() {
        List assignmentsList = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(this.getCurrentLoggedInUserId());
        this.employeeService.getEmployeeById(this.getCurrentLoggedInUserId());
        ArrayList<Department> departmentList = new ArrayList<Department>();
        if (assignmentsList != null) {
            for (Assignment assignment : assignmentsList) {
                if (assignment.getPrimary()) {
                    departmentList.add(0, assignment.getDepartment());
                    continue;
                }
                departmentList.add(assignment.getDepartment());
            }
        }
        return departmentList;
    }

    public Department getDepartmentByName(String deptName) {
        Department dept = null;
        dept = (Department)this.persistenceService.find("from Department where name=?", new Object[]{deptName});
        return dept;
    }

    public Map<String, String> getBoundaryDepartment() {
        List<AppConfigValues> appConfigList = this.getAppConfigValue("Works Management", "REGION_BOUNDARY_DEPARTMENT_NAME");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (AppConfigValues configValue : appConfigList) {
            String[] value = configValue.getValue().split(",");
            resultMap.put(value[0], value[1]);
        }
        return resultMap;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public List<CFinancialYear> getAllFinancialYearsForWorks() {
        Query query = this.persistenceService.getSession().createQuery("from CFinancialYear where trunc(startingDate)>='01-Apr-2010' order by id desc");
        return query.list();
    }

    public List<Map<String, Map<String, BigDecimal>>> getCJVCountAndAmountsForSpillOver(String uuid, Date fromDate, Date toDate) throws ApplicationException {
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Integer i;
        HashMap<String, HashMap<String, BigDecimal>> resultMap = null;
        HashMap<String, BigDecimal> simpleMap = null;
        ArrayList<Map<String, Map<String, BigDecimal>>> resultList = new ArrayList<Map<String, Map<String, BigDecimal>>>();
        String payQuery = " select dept.dept_name , nvl(sum(bp.debitamount),0)  FROM  eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms , eg_department dept  WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and bp.pc_department=dept.id_dept  and vh.name='Contractor Journal'   and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('CONTRACTORBILL'))  and br.billdate between '" + this.dateFormatter.format(fromDate) + "' and '" + this.dateFormatter.format(toDate) + "' and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WRKPROG_PROJCODE_SPILLOVER WHERE UUID like '" + uuid + "')) and bp.accountdetailkeyid in ( select bp1.ACCOUNTDETAILKEYID FROM eg_billregister br1,  eg_billdetails bd1, eg_billpayeedetails bp1 ,voucherheader vh1,eg_billregistermis ms1  WHERE br1.id =bd1.billid AND bd1.id =bp1.BILLDETAILID    and vh1.id=ms1.VOUCHERHEADERID and ms1.BILLID=br1.id and vh1.name='Contractor Journal' and vh1.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " AND br1.STATUSID IN (SELECT id FROM egw_status WHERE lower(code)='approved' AND moduletype  IN('CONTRACTORBILL'))  and br1.billtype in ('FinalBill', 'Final Bill') and bp1.ACCOUNTDETAILKEYID = bp.ACCOUNTDETAILKEYID  and bp1.ACCOUNTDETAILTYPEID=bp.ACCOUNTDETAILTYPEID ) group by dept.dept_name  order by dept.dept_name  ";
        String countQuery = " select dept.dept_name , count(vh.id) FROM  eg_billregister br,eg_billdetails bd, eg_billpayeedetails bp,voucherheader vh,eg_billregistermis ms, eg_department dept   WHERE br.id=bd.billid and bd.id=bp.BILLDETAILID and vh.id=ms.VOUCHERHEADERID and ms.BILLID=br.id and bp.pc_department=dept.id_dept  and vh.name='Contractor Journal'  and br.billtype in ('FinalBill', 'Final Bill')  and br.STATUSID in(select id from egw_status where lower(code)='approved' and  moduletype in('CONTRACTORBILL'))  and br.billdate between '" + this.dateFormatter.format(fromDate) + "' and '" + this.dateFormatter.format(toDate) + "' and bd.DEBITAMOUNT>0  and vh.STATUS=" + FinancialConstants.CREATEDVOUCHERSTATUS + " and bp.ACCOUNTDETAILTYPEID= (SELECT id FROM accountdetailtype  WHERE name ='PROJECTCODE' AND description='PROJECTCODE' ) and (bp.ACCOUNTDETAILKEYID in(SELECT PC_ID FROM EGW_WRKPROG_PROJCODE_SPILLOVER WHERE UUID like '" + uuid + "'))  group by dept.dept_name order by dept.dept_name ";
        List payQueryResult = this.persistenceService.getSession().createSQLQuery(payQuery).list();
        List countQueryResult = this.persistenceService.getSession().createSQLQuery(countQuery).list();
        ArrayList<String> deptNameList = new ArrayList<String>();
        if (payQueryResult != null && payQueryResult.size() > 0) {
            i = 0;
            while (i < payQueryResult.size()) {
                deptNameList.add(((Object[])payQueryResult.get(i))[0].toString());
                n4 = i;
                n3 = i = Integer.valueOf(i + 1);
            }
        }
        if (countQueryResult != null && countQueryResult.size() > 0) {
            i = 0;
            while (i < countQueryResult.size()) {
                deptNameList.add(((Object[])countQueryResult.get(i))[0].toString());
                n4 = i;
                n3 = i = Integer.valueOf(i + 1);
            }
        }
        if (deptNameList == null || deptNameList.size() <= 0) {
            return null;
        }
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.addAll(deptNameList);
        deptNameList.clear();
        deptNameList.addAll(tempSet);
        BigDecimal[] payArray = new BigDecimal[deptNameList.size()];
        BigDecimal[] countArray = new BigDecimal[deptNameList.size()];
        Integer i2 = 0;
        while (i2 < deptNameList.size()) {
            payArray[i2.intValue()] = BigDecimal.ZERO;
            countArray[i2.intValue()] = BigDecimal.ZERO;
            Integer n5 = i2;
            Integer n6 = i2 = Integer.valueOf(i2 + 1);
        }
        String deptName = null;
        Integer index = null;
        Integer i3 = null;
        i3 = 0;
        while (i3 < payQueryResult.size()) {
            deptName = ((Object[])payQueryResult.get(i3))[0].toString();
            index = deptNameList.indexOf(deptName);
            payArray[index.intValue()] = new BigDecimal(((Object[])payQueryResult.get(i3))[1].toString());
            n2 = i3;
            n = i3 = Integer.valueOf(i3 + 1);
        }
        i3 = 0;
        while (i3 < countQueryResult.size()) {
            deptName = ((Object[])countQueryResult.get(i3))[0].toString();
            index = deptNameList.indexOf(deptName);
            countArray[index.intValue()] = new BigDecimal(((Object[])countQueryResult.get(i3))[1].toString());
            n2 = i3;
            n = i3 = Integer.valueOf(i3 + 1);
        }
        i3 = 0;
        while (i3 < deptNameList.size()) {
            deptName = (String)deptNameList.get(i3);
            simpleMap = new HashMap<String, BigDecimal>();
            simpleMap.put("amount", payArray[i3]);
            simpleMap.put("count", countArray[i3]);
            resultMap = new HashMap<String, HashMap<String, BigDecimal>>();
            resultMap.put(deptName, simpleMap);
            resultList.add(resultMap);
            n2 = i3;
            n = i3 = Integer.valueOf(i3 + 1);
        }
        return resultList;
    }

    public String toCurrency(double money) {
        double rounded = (double)Math.round(money * 100.0) / 100.0;
        DecimalFormat formatter = new DecimalFormat("0.00");
        formatter.setDecimalSeparatorAlwaysShown(true);
        return formatter.format(rounded);
    }

    public Collection<String> getStatusNameDetails(String[] statusNames) {
        return CollectionUtils.select(Arrays.asList(statusNames), statusName -> (String)statusName != null);
    }

    public Collection<Date> getStatusDateDetails(Date[] statusDates) {
        return CollectionUtils.select(Arrays.asList(statusDates), statusDate -> (Date)statusDate != null);
    }
}

