/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.tender;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.pims.model.PersonalInformation;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.tender.EstimateLineItemsForTR;
import org.egov.works.models.tender.EstimateLineItemsForWP;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.tender.TenderEstimate;
import org.egov.works.models.tender.TenderResponseActivity;
import org.egov.works.models.tender.TenderResponseContractors;
import org.egov.works.models.tender.WorksPackageDetails;
import org.egov.works.models.workflow.WorkFlow;

public class TenderResponse
extends WorkFlow {
    private static final long serialVersionUID = -6047271184417257561L;
    @Valid
    private TenderEstimate tenderEstimate;
    private double percQuotedRate;
    private double percNegotiatedAmountRate;
    @Required(message="tenderResponse.negotiationDate.null")
    @DateFormat(message="invalid.fieldvalue.negotiationDate")
    private Date negotiationDate;
    private String negotiationNumber;
    private String narration;
    private String status;
    private double totalAmount;
    private Collection<EstimateLineItemsForWP> activitiesForWorkorder;
    private double workOrderAmount;
    @Valid
    private List<TenderResponseActivity> tenderResponseActivities = new LinkedList<TenderResponseActivity>();
    @Valid
    private List<TenderResponseContractors> tenderResponseContractors = new LinkedList<TenderResponseContractors>();
    private PersonalInformation negotiationPreparedBy;
    private Integer approverUserId;
    private Long documentNumber;
    private EgwStatus egwStatus;
    private String formattedTotalAmount;
    private double tenderNegotiatedValue;
    private Date approvedDate;
    private List<String> tenderNegotiationsActions = new ArrayList<String>();
    private List<WorksPackageDetails> worksPackageDetails = new LinkedList<WorksPackageDetails>();
    private Set<OfflineStatus> offlineStatuses = new HashSet<OfflineStatus>();

    public PersonalInformation getNegotiationPreparedBy() {
        return this.negotiationPreparedBy;
    }

    public void setNegotiationPreparedBy(PersonalInformation negotiationPreparedBy) {
        this.negotiationPreparedBy = negotiationPreparedBy;
    }

    public TenderEstimate getTenderEstimate() {
        return this.tenderEstimate;
    }

    public void setTenderEstimate(TenderEstimate tenderEstimate) {
        this.tenderEstimate = tenderEstimate;
    }

    public double getPercQuotedRate() {
        return this.percQuotedRate;
    }

    public String getFormattedPercQuotedRate() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(10);
        return nf.format(this.percQuotedRate);
    }

    public String getFormattedPercNegotiatedAmountRate() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(10);
        return nf.format(this.percNegotiatedAmountRate);
    }

    public void setPercQuotedRate(double percQuotedRate) {
        this.percQuotedRate = percQuotedRate;
    }

    public double getPercNegotiatedAmountRate() {
        return this.percNegotiatedAmountRate;
    }

    public void setPercNegotiatedAmountRate(double percNegotiatedAmountRate) {
        this.percNegotiatedAmountRate = percNegotiatedAmountRate;
    }

    public Date getNegotiationDate() {
        return this.negotiationDate;
    }

    public void setNegotiationDate(Date negotiationDate) {
        this.negotiationDate = negotiationDate;
    }

    public List<TenderResponseActivity> getTenderResponseActivities() {
        return this.tenderResponseActivities;
    }

    public void setTenderResponseActivities(List<TenderResponseActivity> tenderResponseActivities) {
        this.tenderResponseActivities = tenderResponseActivities;
    }

    public void addTenderResponseActivity(TenderResponseActivity tenderResponseActivity) {
        this.tenderResponseActivities.add(tenderResponseActivity);
    }

    public String getNegotiationNumber() {
        return this.negotiationNumber;
    }

    public void setNegotiationNumber(String negotiationNumber) {
        this.negotiationNumber = negotiationNumber;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (!this.tenderResponseContractors.isEmpty() && (this.tenderResponseContractors.get(0) != null && this.tenderResponseContractors.get(0).getContractor() != null && this.tenderResponseContractors.get(0).getContractor().getId() == null || this.tenderResponseContractors.get(0).getContractor().getId() == 0L || this.tenderResponseContractors.get(0).getContractor().getId() == -1L)) {
            validationErrors.add(new ValidationError("contractor", "tenderResponse.contractor.null"));
        } else if (this.tenderResponseContractors == null) {
            validationErrors.add(new ValidationError("contractor", "tenderResponse.contractor.null"));
        }
        return validationErrors;
    }

    @Override
    public String getStateDetails() {
        return "Tender Negotiation : " + this.getNegotiationNumber();
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public Integer getApproverUserId() {
        return this.approverUserId;
    }

    public void setApproverUserId(Integer approverUserId) {
        this.approverUserId = approverUserId;
    }

    public Long getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(Long documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Collection<EstimateLineItemsForWP> getActivitiesForWorkorder() {
        return this.activitiesForWorkorder;
    }

    public void setActivitiesForWorkorder(Collection<EstimateLineItemsForWP> activitiesForWorkorder) {
        this.activitiesForWorkorder = activitiesForWorkorder;
    }

    public double getWorkOrderAmount() {
        return this.workOrderAmount;
    }

    public void setWorkOrderAmount(double workOrderAmount) {
        this.workOrderAmount = workOrderAmount;
    }

    public List<String> getTenderNegotiationsActions() {
        return this.tenderNegotiationsActions;
    }

    public void setTenderNegotiationsActions(List<String> tenderNegotiationsActions) {
        this.tenderNegotiationsActions = tenderNegotiationsActions;
    }

    public List<TenderResponseContractors> getTenderResponseContractors() {
        return this.tenderResponseContractors;
    }

    public void setTenderResponseContractors(List<TenderResponseContractors> tenderResponseContractors) {
        this.tenderResponseContractors = tenderResponseContractors;
    }

    public void addTenderResponseContractors(TenderResponseContractors tenderResponseContractors) {
        this.tenderResponseContractors.add(tenderResponseContractors);
    }

    public Money getTotalNegotiatedQuantity() {
        double qty = 0.0;
        for (TenderResponseActivity tra : this.tenderResponseActivities) {
            qty += tra.getNegotiatedQuantity();
        }
        Money totalNegotiatedQuantity = new Money(qty);
        return totalNegotiatedQuantity;
    }

    public Collection<EstimateLineItemsForTR> getNegotiationDetails() {
        HashMap<Long, EstimateLineItemsForTR> resultMap = new HashMap<Long, EstimateLineItemsForTR>();
        for (TenderResponseActivity tra : this.getTenderResponseActivities()) {
            EstimateLineItemsForTR estlineItem = new EstimateLineItemsForTR();
            if (tra.getActivity().getSchedule() != null) {
                if (resultMap.containsKey(tra.getActivity().getSchedule().getId())) {
                    EstimateLineItemsForTR preEstlineItem = (EstimateLineItemsForTR)resultMap.get(tra.getActivity().getSchedule().getId());
                    preEstlineItem.setQuantity(tra.getActivity().getQuantity() + preEstlineItem.getQuantity());
                    if (DateUtils.compareDates((Date)tra.getActivity().getAbstractEstimate().getEstimateDate(), (Date)preEstlineItem.getEstimateDate())) {
                        preEstlineItem.setRate(tra.getActivity().getSORCurrentRate().getValue());
                        preEstlineItem.setAmt(preEstlineItem.getQuantity() * tra.getActivity().getRate());
                        preEstlineItem.setActivity(tra.getActivity());
                        if (tra.getActivity().getSchedule().hasValidMarketRateFor(tra.getActivity().getAbstractEstimate().getEstimateDate())) {
                            preEstlineItem.setMarketRate(preEstlineItem.getQuantity() * tra.getActivity().getSORCurrentMarketRate().getValue());
                        } else {
                            preEstlineItem.setMarketRate(tra.getActivity().getAmount().getValue());
                        }
                    }
                    preEstlineItem.setTenderResponseQuotes(tra.getTenderResponseQuotes());
                    preEstlineItem.setNegotiatedRate(tra.getNegotiatedRate());
                    resultMap.put(tra.getActivity().getSchedule().getId(), preEstlineItem);
                } else {
                    this.addEstLineItem(tra.getActivity(), estlineItem);
                    estlineItem.setNegotiatedRate(tra.getNegotiatedRate());
                    estlineItem.setTenderResponseQuotes(tra.getTenderResponseQuotes());
                    resultMap.put(tra.getActivity().getSchedule().getId(), estlineItem);
                }
            }
            if (tra.getActivity().getNonSor() == null) continue;
            this.addEstLineItem(tra.getActivity(), estlineItem);
            estlineItem.setNegotiatedRate(tra.getNegotiatedRate());
            estlineItem.setTenderResponseQuotes(tra.getTenderResponseQuotes());
            resultMap.put(tra.getActivity().getNonSor().getId(), estlineItem);
        }
        return this.getEstLineItemsWithSrlNo(resultMap.values());
    }

    public List<WorksPackageDetails> getWorksPackageDetails() {
        return this.worksPackageDetails;
    }

    public void setWorksPackageDetails(List<WorksPackageDetails> worksPackageDetails) {
        this.worksPackageDetails = worksPackageDetails;
    }

    private void addEstLineItem(Activity act, EstimateLineItemsForTR estlineItem) {
        if (act.getSchedule() == null) {
            estlineItem.setCode("");
            estlineItem.setSummary("");
            estlineItem.setDescription(act.getNonSor().getDescription());
            estlineItem.setRate(act.getRate());
            estlineItem.setMarketRate(act.getAmount().getValue());
        } else {
            estlineItem.setCode(act.getSchedule().getCode());
            estlineItem.setDescription(act.getSchedule().getDescription());
            estlineItem.setRate(act.getSORCurrentRate().getValue());
            if (act.getSchedule().hasValidMarketRateFor(act.getAbstractEstimate().getEstimateDate())) {
                estlineItem.setMarketRate(act.getQuantity() * act.getSORCurrentMarketRate().getValue());
            } else {
                estlineItem.setMarketRate(act.getAmount().getValue());
            }
            estlineItem.setSummary(act.getSchedule().getSummary());
        }
        estlineItem.setActivity(act);
        estlineItem.setAmt(act.getQuantity() * act.getRate());
        estlineItem.setEstimateDate(act.getAbstractEstimate().getEstimateDate());
        estlineItem.setQuantity(act.getQuantity());
        estlineItem.setUom(act.getUom().getUom());
        estlineItem.setConversionFactor(act.getConversionFactor());
    }

    private Collection<EstimateLineItemsForTR> getEstLineItemsWithSrlNo(Collection<EstimateLineItemsForTR> actList) {
        int i = 1;
        ArrayList<EstimateLineItemsForTR> latestEstLineItemList = new ArrayList<EstimateLineItemsForTR>();
        for (EstimateLineItemsForTR act : actList) {
            act.setSrlNo(i);
            latestEstLineItemList.add(act);
            ++i;
        }
        return latestEstLineItemList;
    }

    public Set<OfflineStatus> getOfflineStatuses() {
        return this.offlineStatuses;
    }

    public void setOfflineStatuses(Set<OfflineStatus> offlineStatuses) {
        this.offlineStatuses = offlineStatuses;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public String getFormattedTotalAmount() {
        return this.formattedTotalAmount;
    }

    public void setFormattedTotalAmount(String formattedTotalAmount) {
        this.formattedTotalAmount = formattedTotalAmount;
    }

    public double getTenderNegotiatedValue() {
        return this.tenderNegotiatedValue;
    }

    public void setTenderNegotiatedValue(double tenderNegotiatedValue) {
        this.tenderNegotiatedValue = tenderNegotiatedValue;
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public static enum Actions {
        SAVE,
        SUBMIT_FOR_APPROVAL,
        REJECT,
        CANCEL,
        approval;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum TenderResponseStatus {
        CREATED,
        APPROVED,
        REJECTED,
        CANCELLED;

    }
}

