/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.autonumber.impl;

import java.io.Serializable;
import javax.script.ScriptContext;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.script.service.ScriptService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.autonumber.EstimateNumberGenerator;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EstimateNumberGeneratorImpl
implements EstimateNumberGenerator {
    private static final String ESTIMATE_NUMBER_SEQ_PREFIX = "SEQ_ESTIMATE_NUMBER";
    @Autowired
    private SequenceNumberGenerator sequenceGenerator;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private ScriptService scriptService;

    @Override
    public String getEstimateNumber(AbstractEstimate estimate, CFinancialYear financialYear) {
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"estimate", estimate, "finYear", financialYear, "sequenceGenerator", this.sequenceGenerator, "dbSequenceGenerator", this.dbSequenceGenerator});
        return this.scriptService.executeScript("works.estimatenumber.generator", scriptContext).toString();
    }

    @Override
    @Transactional(readOnly=true)
    public String getNextNumber(LineEstimate lineEstimate, CFinancialYear financialYear) {
        String financialYearRange = financialYear.getFinYearRange();
        String[] finYearRange = financialYearRange.split("-");
        String sequenceName = "SEQ_ESTIMATE_NUMBER_" + finYearRange[0] + "_" + finYearRange[1];
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        return String.format("%s/%s/%05d", lineEstimate.getExecutingDepartment().getCode(), financialYearRange, sequenceNumber);
    }
}

