/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.admin.master.entity.User;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimateTechnicalSanction;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.entity.MultiYearEstimate;
import org.egov.works.abstractestimate.repository.AbstractEstimateRepository;
import org.egov.works.abstractestimate.service.EstimateTechnicalSanctionService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EstimateService {
    @PersistenceContext
    private EntityManager entityManager;
    private final AbstractEstimateRepository abstractEstimateRepository;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private EstimateTechnicalSanctionService estimateTechnicalSanctionService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public EstimateService(AbstractEstimateRepository abstractEstimateRepository) {
        this.abstractEstimateRepository = abstractEstimateRepository;
    }

    public AbstractEstimate getAbstractEstimateById(Long id) {
        return (AbstractEstimate)((Object)this.abstractEstimateRepository.findOne(id));
    }

    @Transactional
    public AbstractEstimate createAbstractEstimateOnLineEstimateTechSanction(LineEstimateDetails lineEstimateDetails, int i) {
        AbstractEstimate savedAbstractEstimate = (AbstractEstimate)((Object)this.abstractEstimateRepository.save((Object)this.populateAbstractEstimate(lineEstimateDetails)));
        this.saveTechnicalSanction(savedAbstractEstimate, i);
        return savedAbstractEstimate;
    }

    private AbstractEstimate populateAbstractEstimate(LineEstimateDetails lineEstimateDetails) {
        AbstractEstimate abstractEstimate = new AbstractEstimate();
        abstractEstimate.setEstimateDate(lineEstimateDetails.getLineEstimate().getLineEstimateDate());
        abstractEstimate.setEstimateNumber(lineEstimateDetails.getEstimateNumber());
        abstractEstimate.setName(lineEstimateDetails.getNameOfWork());
        abstractEstimate.setDescription(lineEstimateDetails.getNameOfWork());
        abstractEstimate.setWard(lineEstimateDetails.getLineEstimate().getWard());
        abstractEstimate.setNatureOfWork(lineEstimateDetails.getLineEstimate().getNatureOfWork());
        if (lineEstimateDetails.getLineEstimate().getLocation() != null) {
            abstractEstimate.setLocation(lineEstimateDetails.getLineEstimate().getLocation().getName());
        }
        abstractEstimate.setParentCategory(lineEstimateDetails.getLineEstimate().getTypeOfWork());
        abstractEstimate.setCategory(lineEstimateDetails.getLineEstimate().getSubTypeOfWork());
        abstractEstimate.setExecutingDepartment(lineEstimateDetails.getLineEstimate().getExecutingDepartment());
        abstractEstimate.setWorkValue(lineEstimateDetails.getActualEstimateAmount().doubleValue());
        abstractEstimate.setEstimateValue(lineEstimateDetails.getActualEstimateAmount());
        abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString()));
        abstractEstimate.setProjectCode(lineEstimateDetails.getProjectCode());
        abstractEstimate.setApprovedDate(lineEstimateDetails.getLineEstimate().getTechnicalSanctionDate());
        abstractEstimate.setLineEstimateDetails(lineEstimateDetails);
        abstractEstimate.addFinancialDetails(this.populateEstimateFinancialDetails(abstractEstimate));
        abstractEstimate.addMultiYearEstimate(this.populateMultiYearEstimate(abstractEstimate));
        return abstractEstimate;
    }

    private FinancialDetail populateEstimateFinancialDetails(AbstractEstimate abstractEstimate) {
        FinancialDetail financialDetail = new FinancialDetail();
        financialDetail.setAbstractEstimate(abstractEstimate);
        financialDetail.setFund(abstractEstimate.getLineEstimateDetails().getLineEstimate().getFund());
        financialDetail.setFunction(abstractEstimate.getLineEstimateDetails().getLineEstimate().getFunction());
        financialDetail.setBudgetGroup(abstractEstimate.getLineEstimateDetails().getLineEstimate().getBudgetHead());
        financialDetail.setScheme(abstractEstimate.getLineEstimateDetails().getLineEstimate().getScheme());
        financialDetail.setSubScheme(abstractEstimate.getLineEstimateDetails().getLineEstimate().getSubScheme());
        return financialDetail;
    }

    private MultiYearEstimate populateMultiYearEstimate(AbstractEstimate abstractEstimate) {
        MultiYearEstimate multiYearEstimate = new MultiYearEstimate();
        multiYearEstimate.setAbstractEstimate(abstractEstimate);
        multiYearEstimate.setFinancialYear(this.financialYearHibernateDAO.getFinYearByDate(abstractEstimate.getEstimateDate()));
        multiYearEstimate.setPercentage(100.0);
        return multiYearEstimate;
    }

    private EstimateTechnicalSanction saveTechnicalSanction(AbstractEstimate abstractEstimate, int i) {
        EstimateTechnicalSanction estimateTechnicalSanction = new EstimateTechnicalSanction();
        estimateTechnicalSanction.setAbstractEstimate(abstractEstimate);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(abstractEstimate.getLineEstimateDetails().getLineEstimate().getTechnicalSanctionNumber());
        if (i > 0) {
            stringBuilder.append("/");
            stringBuilder.append(i);
        }
        estimateTechnicalSanction.setTechnicalSanctionNumber(stringBuilder.toString());
        estimateTechnicalSanction.setTechnicalSanctionDate(abstractEstimate.getLineEstimateDetails().getLineEstimate().getTechnicalSanctionDate());
        estimateTechnicalSanction.setTechnicalSanctionBy(abstractEstimate.getLineEstimateDetails().getLineEstimate().getTechnicalSanctionBy());
        return this.estimateTechnicalSanctionService.save(estimateTechnicalSanction);
    }

    public AbstractEstimate getAbstractEstimateByEstimateNumber(String estimateNumber) {
        return this.abstractEstimateRepository.findByEstimateNumberAndEgwStatus_codeNotLike(estimateNumber, AbstractEstimate.EstimateStatus.CANCELLED.toString());
    }

    public AbstractEstimate getAbstractEstimateByEstimateNumberAndStatus(String estimateNumber) {
        return this.abstractEstimateRepository.findByLineEstimateDetails_EstimateNumberAndEgwStatus_codeEquals(estimateNumber, AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString());
    }

    public AbstractEstimate getAbstractEstimateByLineEstimateDetailsForCancelLineEstimate(Long id) {
        return this.abstractEstimateRepository.findByLineEstimateDetails_IdAndEgwStatus_codeEquals(id, AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString());
    }

    public List<User> getCreatedByForEstimatePhotograph() {
        return this.abstractEstimateRepository.findCreatedByForEstimatePhotograph(AbstractEstimate.EstimateStatus.TECH_SANCTIONED.toString());
    }
}

