/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.util.List;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.model.budget.BudgetUsage;
import org.egov.works.lineestimate.entity.LineEstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.repository.LineEstimateAppropriationRepository;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.lineestimate.service.LineEstimateAppropriationService;
import org.egov.works.lineestimate.service.WorkOrderIdentificationNumberGenerator;
import org.egov.works.models.estimate.ProjectCode;
import org.egov.works.services.ProjectCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LineEstimateDetailService {
    private final LineEstimateDetailsRepository lineEstimateDetailsRepository;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    @Autowired
    private ProjectCodeService projectCodeService;
    @Autowired
    private LineEstimateAppropriationRepository lineEstimateAppropriationRepository;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private LineEstimateAppropriationService lineEstimateAppropriationService;
    @Autowired
    private WorkOrderIdentificationNumberGenerator workOrderIdentificationNumberGenerator;

    @Autowired
    public LineEstimateDetailService(LineEstimateDetailsRepository lineEstimateDetailsRepository) {
        this.lineEstimateDetailsRepository = lineEstimateDetailsRepository;
    }

    @Transactional
    public void save(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.save((Object)lineEstimateDetails);
    }

    @Transactional
    public void update(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.saveAndFlush((Object)lineEstimateDetails);
    }

    @Transactional
    public void delete(LineEstimateDetails lineEstimateDetails) {
        this.lineEstimateDetailsRepository.delete((Object)lineEstimateDetails);
    }

    @Transactional
    public void delete(List<LineEstimateDetails> lineEstimateDetailsList) {
        this.lineEstimateDetailsRepository.delete(lineEstimateDetailsList);
    }

    public LineEstimateDetails getById(Long id) {
        return (LineEstimateDetails)((Object)this.lineEstimateDetailsRepository.findOne(id));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void setProjectCode(LineEstimateDetails lineEstimateDetails) {
        ProjectCode projectCode = null;
        if (lineEstimateDetails.getProjectCode() != null && lineEstimateDetails.getLineEstimate().isSpillOverFlag()) {
            projectCode = lineEstimateDetails.getProjectCode();
            projectCode.setCode(lineEstimateDetails.getProjectCode().getCode());
        } else {
            projectCode = new ProjectCode();
            projectCode.setCode(this.workOrderIdentificationNumberGenerator.generateWorkOrderIdentificationNumber(lineEstimateDetails));
            lineEstimateDetails.setProjectCode(projectCode);
        }
        projectCode.setCodeName(lineEstimateDetails.getNameOfWork());
        projectCode.setDescription(lineEstimateDetails.getNameOfWork());
        projectCode.setActive(true);
        projectCode.setEgwStatus(this.lineEstimateAppropriationService.getStatusByModuleAndCode(ProjectCode.class.getSimpleName(), "CREATED"));
        this.projectCodeService.persist((Object)projectCode);
        this.createAccountDetailKey(projectCode);
    }

    protected void createAccountDetailKey(ProjectCode proj) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName("PROJECTCODE");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(proj.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }

    @Transactional
    public void persistBudgetAppropriationDetails(LineEstimateDetails lineEstimateDetails, BudgetUsage budgetUsage) {
        LineEstimateAppropriation lineEstimateAppropriation = null;
        lineEstimateAppropriation = this.lineEstimateAppropriationService.findLatestByLineEstimateDetails_EstimateNumber(lineEstimateDetails.getEstimateNumber());
        if (lineEstimateAppropriation != null) {
            lineEstimateAppropriation.setBudgetUsage(budgetUsage);
        } else {
            lineEstimateAppropriation = new LineEstimateAppropriation();
            lineEstimateAppropriation.setLineEstimateDetails(lineEstimateDetails);
            lineEstimateAppropriation.setBudgetUsage(budgetUsage);
        }
        this.lineEstimateAppropriationRepository.save((Object)lineEstimateAppropriation);
    }

    @Transactional
    public boolean checkConsumeEncumbranceBudget(LineEstimateDetails lineEstimateDetails, Long finyrId, double budgApprAmnt, List<Long> budgetheadid) {
        boolean flag = true;
        BudgetUsage budgetUsage = this.budgetDetailsDAO.consumeEncumbranceBudget(this.lineEstimateAppropriationService.generateBudgetAppropriationNumber(lineEstimateDetails), finyrId, Integer.valueOf(11), lineEstimateDetails.getEstimateNumber(), Integer.valueOf(Integer.parseInt(lineEstimateDetails.getLineEstimate().getExecutingDepartment().getId().toString())), lineEstimateDetails.getLineEstimate().getFunction() == null ? null : lineEstimateDetails.getLineEstimate().getFunction().getId(), null, lineEstimateDetails.getLineEstimate().getScheme() == null ? null : lineEstimateDetails.getLineEstimate().getScheme().getId(), lineEstimateDetails.getLineEstimate().getSubScheme() == null ? null : lineEstimateDetails.getLineEstimate().getSubScheme().getId(), lineEstimateDetails.getLineEstimate().getWard() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimateDetails.getLineEstimate().getWard().getId().toString())), budgetheadid, lineEstimateDetails.getLineEstimate().getFund() == null ? null : lineEstimateDetails.getLineEstimate().getFund().getId(), budgApprAmnt);
        if (budgetUsage == null) {
            return false;
        }
        this.persistBudgetAppropriationDetails(lineEstimateDetails, budgetUsage);
        return true;
    }

    public LineEstimateDetails getLineEstimateDetailsByProjectCode(String workIdentificationNumber) {
        return this.lineEstimateDetailsRepository.findByProjectCode_codeAndLineEstimate_Status_CodeNotLike(workIdentificationNumber, "CANCELLED");
    }

    public LineEstimateDetails getLineEstimateDetailsByEstimateNumber(String estimateNumber) {
        return this.lineEstimateDetailsRepository.findByEstimateNumberAndLineEstimate_Status_CodeNot(estimateNumber, "CANCELLED");
    }
}

