/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.works.abstractestimate.entity.AbstractEstimate;

@Entity
@Table(name="EGW_MULTIYEAR_ESTIMATE")
@SequenceGenerator(name="SEQ_EGW_MULTIYEAR_ESTIMATE", sequenceName="SEQ_EGW_MULTIYEAR_ESTIMATE", allocationSize=1)
public class MultiYearEstimate
extends AbstractAuditable {
    private static final long serialVersionUID = 1117104354989747533L;
    public static final String SEQ_EGW_MULTIYEARESTIMATE = "SEQ_EGW_MULTIYEAR_ESTIMATE";
    @Id
    @GeneratedValue(generator="SEQ_EGW_MULTIYEAR_ESTIMATE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="abstractEstimate")
    private AbstractEstimate abstractEstimate;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="financialYear")
    private CFinancialYear financialYear;
    @NotNull
    @Min(value=0L, message="multiYeareEstimate.percentage.not.negative")
    private double percentage;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public List<ValidationError> validate() {
        if (this.percentage < 0.0) {
            return Arrays.asList(new ValidationError("percentage", "multiYeareEstimate.percentage.percentage_greater_than_0"));
        }
        if (this.percentage > 100.0) {
            return Arrays.asList(new ValidationError("percentage", "multiYeareEstimate.percentage.percentage_less_than_100"));
        }
        return new ArrayList<ValidationError>();
    }
}

