/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.egov.commons.Fundsource;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.works.abstractestimate.entity.FinancialDetail;

@Entity
@Table(name="EGW_ESTIMATE_FINANCINGSOURCE")
@SequenceGenerator(name="SEQ_EGW_ESTIMATE_FINANCINGSOURCE", sequenceName="SEQ_EGW_ESTIMATE_FINANCINGSOURCE", allocationSize=1)
public class FinancingSource
extends AbstractAuditable {
    private static final long serialVersionUID = -2860972695192985495L;
    public static final String SEQ_EGW_ESTIMATEFINANCINGSOURCE = "SEQ_EGW_ESTIMATE_FINANCINGSOURCE";
    @Id
    @GeneratedValue(generator="SEQ_EGW_ESTIMATE_FINANCINGSOURCE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @Min(value=0L, message="financingsource.percentage.not.negative")
    private double percentage;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fundSource")
    private Fundsource fundSource;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="financialDetail")
    private FinancialDetail financialDetail;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public Fundsource getFundSource() {
        return this.fundSource;
    }

    public void setFundSource(Fundsource fundSource) {
        this.fundSource = fundSource;
    }

    public FinancialDetail getFinancialDetail() {
        return this.financialDetail;
    }

    public void setFinancialDetail(FinancialDetail financialDetail) {
        this.financialDetail = financialDetail;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.fundSource == null || this.fundSource.getCode() == null) {
            validationErrors.add(new ValidationError("invalidpercentage", "financingsource.fundsource.null"));
        }
        if (this.percentage <= 0.0 || this.percentage > 100.0) {
            validationErrors.add(new ValidationError("invalidpercentage", "financingsource.invalid.percentage"));
        }
        return validationErrors;
    }
}

