/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.BudgetUsage;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateAppropriation;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.models.estimate.DepositWorksUsage;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.DepositWorksUsageService;
import org.egov.works.services.RevisionEstimateService;
import org.egov.works.services.WorksService;
import org.egov.works.services.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class RevisionEstimateServiceImpl
extends BaseServiceImpl<RevisionAbstractEstimate, Long>
implements RevisionEstimateService {
    private AbstractEstimateService abstractEstimateService;
    private WorksService worksService;
    private EgovCommon egovCommon;
    private DepositWorksUsageService depositWorksUsageService;
    private PersistenceService<AbstractEstimateAppropriation, Long> estimateAppropriationService;
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private FinancialYearHibernateDAO finHibernateDao;
    private static final String MODULE_NAME = "Works";
    private static final String KEY_NAME = "SKIP_BUDGET_CHECK";

    public RevisionEstimateServiceImpl(PersistenceService<RevisionAbstractEstimate, Long> persistenceService) {
        super(persistenceService);
    }

    @Override
    public void consumeBudget(RevisionAbstractEstimate revisionEstimate) {
        AbstractEstimate parentEstimate = revisionEstimate.getParent();
        String appropriationNumber = this.abstractEstimateService.getBudgetAppropriationNumber(parentEstimate);
        if (this.isDepositWorksType(parentEstimate)) {
            this.checkForBudgetaryAppropriationForDepositWorks(revisionEstimate, appropriationNumber);
        } else {
            this.consumeBudgetForNormalWorks(revisionEstimate, appropriationNumber);
        }
    }

    @Override
    public void releaseBudget(RevisionAbstractEstimate revisionEstimate) {
        AbstractEstimate parentEstimate = revisionEstimate.getParent();
        String appropriationNumber = this.abstractEstimateService.getLatestEstimateAppropriationNumber(revisionEstimate);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BC/");
        stringBuilder.append(appropriationNumber);
        String budgetRejectionNumber = stringBuilder.toString();
        FinancialDetail financialDetail = parentEstimate.getFinancialDetails().get(0);
        if (this.isDepositWorksType(parentEstimate)) {
            this.releaseDepositWorksAmountOnReject(revisionEstimate, financialDetail, budgetRejectionNumber);
        } else {
            this.releaseBudgetOnReject(revisionEstimate, financialDetail, budgetRejectionNumber);
        }
    }

    private boolean releaseDepositWorksAmountOnReject(RevisionAbstractEstimate revisionEstimate, FinancialDetail financialDetail, String budgetRejectionNumber) throws ValidationException {
        boolean flag = false;
        Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("DEPOSITCODE");
        AbstractEstimateAppropriation estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestDepositWorksUsageForEstimate", new Object[]{revisionEstimate.getId()}));
        if (estimateAppropriation == null) {
            return flag;
        }
        BigDecimal creditBalance = this.egovCommon.getDepositAmountForDepositCode(new Date(), financialDetail.getCoa().getGlcode(), financialDetail.getFund().getCode(), accountdetailtype.getId(), Integer.valueOf(financialDetail.getAbstractEstimate().getDepositCode().getId().intValue()));
        double releaseAmount = estimateAppropriation.getDepositWorksUsage().getConsumedAmount().doubleValue();
        DepositWorksUsage depositWorksUsage = new DepositWorksUsage();
        depositWorksUsage.setTotalDepositAmount(creditBalance);
        depositWorksUsage.setConsumedAmount(BigDecimal.ZERO);
        depositWorksUsage.setReleasedAmount(new BigDecimal(releaseAmount));
        depositWorksUsage.setAppropriationNumber(budgetRejectionNumber);
        depositWorksUsage.setAbstractEstimate(revisionEstimate);
        depositWorksUsage.setAppropriationDate(new Date());
        depositWorksUsage.setFinancialYear(estimateAppropriation.getDepositWorksUsage().getFinancialYear());
        depositWorksUsage.setCoa(financialDetail.getCoa());
        depositWorksUsage.setDepositCode(financialDetail.getAbstractEstimate().getDepositCode());
        depositWorksUsage = this.depositWorksUsageService.persist(depositWorksUsage);
        this.persistReleaseDepositWorksAmountDetails(revisionEstimate, financialDetail, depositWorksUsage);
        flag = true;
        return flag;
    }

    private void persistReleaseDepositWorksAmountDetails(RevisionAbstractEstimate revisionEstimate, FinancialDetail financialDetail, DepositWorksUsage depositWorksUsage) {
        AbstractEstimateAppropriation estimateAppropriation = null;
        BigDecimal creditBalance = depositWorksUsage.getTotalDepositAmount();
        BigDecimal utilizedAmt = this.depositWorksUsageService.getTotalUtilizedAmountForDepositWorks(financialDetail, new Date());
        BigDecimal balance = creditBalance.subtract(utilizedAmt);
        estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestDepositWorksUsageForEstimate", new Object[]{revisionEstimate.getId()}));
        estimateAppropriation.setBalanceAvailable(balance);
        estimateAppropriation.setDepositWorksUsage(depositWorksUsage);
        this.estimateAppropriationService.persist((Object)estimateAppropriation);
    }

    private boolean consumeBudgetForNormalWorks(RevisionAbstractEstimate revisionEstimate, String appropriationNumber) {
        boolean flag = false;
        Long finYearId = this.finHibernateDao.getFinYearByDate(new Date()).getId();
        ArrayList<Long> budgetHeadId = new ArrayList<Long>();
        FinancialDetail financialDetail = revisionEstimate.getParent().getFinancialDetails().get(0);
        budgetHeadId.add(financialDetail.getBudgetGroup().getId());
        BudgetUsage budgetUsage = this.budgetDetailsDAO.consumeEncumbranceBudget(appropriationNumber == null ? null : appropriationNumber, finYearId, Integer.valueOf(11), revisionEstimate.getEstimateNumber(), Integer.valueOf(Integer.parseInt(financialDetail.getAbstractEstimate().getUserDepartment().getId().toString())), financialDetail.getFunction() == null ? null : financialDetail.getFunction().getId(), financialDetail.getFunctionary() == null ? null : financialDetail.getFunctionary().getId(), financialDetail.getScheme() == null ? null : financialDetail.getScheme().getId(), financialDetail.getSubScheme() == null ? null : financialDetail.getSubScheme().getId(), financialDetail.getAbstractEstimate().getWard() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getAbstractEstimate().getWard().getId().toString())), financialDetail.getBudgetGroup() == null ? null : budgetHeadId, financialDetail.getFund() == null ? null : financialDetail.getFund().getId(), revisionEstimate.getTotalAmount().getValue());
        if (budgetUsage == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("changeFDHeader.budget.consumption.failed", "Insufficient funds available")));
        }
        this.persistBudgetAppropriationDetails(revisionEstimate, revisionEstimate.getParent(), budgetUsage);
        flag = true;
        return flag;
    }

    private void persistBudgetAppropriationDetails(RevisionAbstractEstimate revisionEstimate, AbstractEstimate parentEstimate, BudgetUsage budgetUsage) {
        AbstractEstimateAppropriation estimateAppropriation = null;
        Integer finYearId = budgetUsage.getFinancialYearId();
        Date endingDate = this.finHibernateDao.getFinancialYearById(Long.valueOf(finYearId.longValue())).getEndingDate();
        estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getBudgetUsageForEstimateByFinYear", new Object[]{revisionEstimate.getId(), (int)finYearId}));
        if (estimateAppropriation != null) {
            estimateAppropriation.setBalanceAvailable(this.abstractEstimateService.getBudgetAvailable(parentEstimate, endingDate));
            estimateAppropriation.setBudgetUsage(budgetUsage);
        } else {
            estimateAppropriation = new AbstractEstimateAppropriation();
            estimateAppropriation.setAbstractEstimate(revisionEstimate);
            estimateAppropriation.setBalanceAvailable(this.abstractEstimateService.getBudgetAvailable(parentEstimate, endingDate));
            estimateAppropriation.setBudgetUsage(budgetUsage);
        }
        this.estimateAppropriationService.persist((Object)estimateAppropriation);
    }

    private boolean checkForBudgetaryAppropriationForDepositWorks(RevisionAbstractEstimate revisionEstimate, String appropriationNumber) throws ValidationException {
        boolean flag = false;
        Date appDate = new Date();
        double depApprAmnt = 0.0;
        Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("DEPOSITCODE");
        depApprAmnt = revisionEstimate.getTotalAmount().getValue();
        FinancialDetail financialDetail = revisionEstimate.getParent().getFinancialDetails().get(0);
        BigDecimal creditBalance = this.egovCommon.getDepositAmountForDepositCode(new Date(), financialDetail.getCoa().getGlcode(), financialDetail.getFund().getCode(), accountdetailtype.getId(), Integer.valueOf(financialDetail.getAbstractEstimate().getDepositCode().getId().intValue()));
        BigDecimal utilizedAmt = this.depositWorksUsageService.getTotalUtilizedAmountForDepositWorks(financialDetail, appDate);
        BigDecimal balance = BigDecimal.ZERO;
        if (utilizedAmt == null) {
            balance = creditBalance;
            utilizedAmt = BigDecimal.ZERO;
        } else {
            balance = creditBalance.subtract(utilizedAmt);
        }
        if (balance.doubleValue() >= depApprAmnt) {
            DepositWorksUsage depositWorksUsage = new DepositWorksUsage();
            CFinancialYear budgetApprDate_finYear = this.finHibernateDao.getFinYearByDate(appDate);
            depositWorksUsage.setTotalDepositAmount(creditBalance);
            depositWorksUsage.setConsumedAmount(new BigDecimal(depApprAmnt));
            depositWorksUsage.setReleasedAmount(BigDecimal.ZERO);
            depositWorksUsage.setAppropriationNumber(appropriationNumber);
            depositWorksUsage.setAbstractEstimate(revisionEstimate);
            depositWorksUsage.setAppropriationDate(appDate);
            depositWorksUsage.setFinancialYear(budgetApprDate_finYear);
            depositWorksUsage.setDepositCode(financialDetail.getAbstractEstimate().getDepositCode());
            depositWorksUsage.setCoa(financialDetail.getCoa());
            depositWorksUsage = this.depositWorksUsageService.persist(depositWorksUsage);
            this.persistDepositCodeAppDetails(depositWorksUsage, financialDetail);
            flag = true;
        }
        if (!flag) {
            throw new ValidationException(Arrays.asList(new ValidationError("reEstimate.estimate.validate.budget.amount", "Insufficient funds available")));
        }
        return flag;
    }

    private void persistDepositCodeAppDetails(DepositWorksUsage depositWorksUsage, FinancialDetail financialDetail) {
        AbstractEstimateAppropriation estimateAppropriation = null;
        int finYearId = this.finHibernateDao.getFinYearByDate(new Date()).getId().intValue();
        BigDecimal creditBalance = depositWorksUsage.getTotalDepositAmount();
        AbstractEstimate abstractEstimate = depositWorksUsage.getAbstractEstimate();
        BigDecimal utilizedAmt = this.depositWorksUsageService.getTotalUtilizedAmountForDepositWorks(financialDetail, depositWorksUsage.getCreatedDate());
        BigDecimal balance = BigDecimal.ZERO;
        if (utilizedAmt == null) {
            balance = creditBalance;
            utilizedAmt = BigDecimal.ZERO;
        } else {
            balance = creditBalance.subtract(utilizedAmt);
        }
        estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getDepositWorksUsageForEstimateByFinYear", new Object[]{abstractEstimate.getId(), finYearId}));
        if (estimateAppropriation != null) {
            estimateAppropriation.setBalanceAvailable(balance);
            estimateAppropriation.setDepositWorksUsage(depositWorksUsage);
        } else {
            estimateAppropriation = new AbstractEstimateAppropriation();
            estimateAppropriation.setAbstractEstimate(abstractEstimate);
            estimateAppropriation.setBalanceAvailable(balance);
            estimateAppropriation.setDepositWorksUsage(depositWorksUsage);
        }
        this.estimateAppropriationService.persist((Object)estimateAppropriation);
    }

    private boolean releaseBudgetOnReject(RevisionAbstractEstimate revisionEstimate, FinancialDetail financialDetail, String budgetRejectionNumber) throws ValidationException {
        boolean flag = false;
        AbstractEstimateAppropriation estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{revisionEstimate.getId()}));
        if (estimateAppropriation == null) {
            return flag;
        }
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(financialDetail.getBudgetGroup().getId());
        BudgetUsage budgetUsage = null;
        budgetUsage = this.budgetDetailsDAO.releaseEncumbranceBudget(budgetRejectionNumber == null ? null : budgetRejectionNumber, Long.valueOf(estimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(11), revisionEstimate.getEstimateNumber(), Integer.valueOf(Integer.parseInt(financialDetail.getAbstractEstimate().getUserDepartment().getId().toString())), financialDetail.getFunction() == null ? null : financialDetail.getFunction().getId(), financialDetail.getFunctionary() == null ? null : financialDetail.getFunctionary().getId(), financialDetail.getScheme() == null ? null : financialDetail.getScheme().getId(), financialDetail.getSubScheme() == null ? null : financialDetail.getSubScheme().getId(), financialDetail.getAbstractEstimate().getWard() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getAbstractEstimate().getWard().getId().toString())), financialDetail.getBudgetGroup() == null ? null : budgetheadid, financialDetail.getFund() == null ? null : financialDetail.getFund().getId(), estimateAppropriation.getBudgetUsage().getConsumedAmount().doubleValue());
        if (financialDetail.getAbstractEstimate() != null) {
            this.persistBudgetReleaseDetails(revisionEstimate, financialDetail.getAbstractEstimate(), budgetUsage);
        }
        flag = true;
        return flag;
    }

    private void persistBudgetReleaseDetails(RevisionAbstractEstimate revisionEstimate, AbstractEstimate parentEstimate, BudgetUsage budgetUsage) {
        AbstractEstimateAppropriation estimateAppropriation = null;
        estimateAppropriation = (AbstractEstimateAppropriation)((Object)this.estimateAppropriationService.findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{revisionEstimate.getId()}));
        Integer finYearId = estimateAppropriation.getBudgetUsage().getFinancialYearId();
        Date endingDate = this.finHibernateDao.getFinancialYearById(Long.valueOf(finYearId.longValue())).getEndingDate();
        estimateAppropriation.setBalanceAvailable(this.abstractEstimateService.getBudgetAvailable(parentEstimate, endingDate));
        estimateAppropriation.setBudgetUsage(budgetUsage);
        this.estimateAppropriationService.persist((Object)estimateAppropriation);
    }

    @Override
    public boolean isDepositWorksType(AbstractEstimate estimate) {
        boolean isDepositWorks = false;
        List<String> depositTypeList = this.getAppConfigValuesToSkipBudget();
        for (String type : depositTypeList) {
            if (!type.equals(estimate.getNatureOfWork().getName())) continue;
            isDepositWorks = true;
        }
        return isDepositWorks;
    }

    @Override
    public boolean getShowBudgetFolio(AbstractEstimate revisionEstimate) {
        if (revisionEstimate != null && revisionEstimate.getEgwStatus() != null && revisionEstimate.getParent() != null && !this.isDepositWorksType(revisionEstimate.getParent())) {
            return this.estimateAppropriationService.findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{revisionEstimate.getId()}) != null;
        }
        return false;
    }

    @Override
    public boolean getShowDepositFolio(AbstractEstimate revisionEstimate) {
        if (revisionEstimate != null && revisionEstimate.getEgwStatus() != null && revisionEstimate.getParent() != null && this.isDepositWorksType(revisionEstimate.getParent())) {
            return this.estimateAppropriationService.findByNamedQuery("getLatestDepositWorksUsageForEstimate", new Object[]{revisionEstimate.getId()}) != null;
        }
        return false;
    }

    private List<String> getAppConfigValuesToSkipBudget() {
        return this.worksService.getNatureOfWorkAppConfigValues(MODULE_NAME, KEY_NAME);
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public void setDepositWorksUsageService(DepositWorksUsageService depositWorksUsageService) {
        this.depositWorksUsageService = depositWorksUsageService;
    }

    public void setEstimateAppropriationService(PersistenceService<AbstractEstimateAppropriation, Long> estimateAppropriationService) {
        this.estimateAppropriationService = estimateAppropriationService;
    }

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }
}

