/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.models.measurementbook.MBDetails;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderActivity;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.services.MeasurementBookService;
import org.egov.works.services.WorksService;
import org.egov.works.services.impl.BaseServiceImpl;

public class MeasurementBookServiceImpl
extends BaseServiceImpl<MBHeader, Long>
implements MeasurementBookService {
    private static final Logger logger = Logger.getLogger(MeasurementBookServiceImpl.class);
    public static final String WORKORDER_NO = "WORKORDER_NO";
    public static final String CONTRACTOR_ID = "CONTRACTOR_ID";
    public static final String CREATE_DATE = "CREATE_DATE";
    public static final String MB_REF_NO = "MB_REF_NO";
    public static final String MB_PAGE_NO = "MB_PAGE_NO";
    public static final String STATUS = "STATUS";
    public static final String BILLDATE = "BILLDATE";
    public static final String BILLSTATUS = "BILLSTATUS";
    public static final String BILLNO = "BILLNO";
    public static final String ALL_STATUS = "ALL_STATUS";
    public static final String FROM_DATE = "FROM_DATE";
    public static final String TO_DATE = "TO_DATE";
    public static final String EST_NO = "EST_NO";
    public static final String DEPT_ID = "DEPT_ID";
    private WorksService worksService;

    public MeasurementBookServiceImpl(PersistenceService<MBHeader, Long> persistenceService) {
        super(persistenceService);
    }

    @Override
    public List<String> searchMB(Map<String, Object> criteriaMap, List<Object> paramList) {
        logger.debug((Object)"-------Inside searchMB method-----------------------");
        ArrayList<String> mbHeaderQryList = new ArrayList<String>();
        String countQry = "select count(distinct mbh) from MBHeader mbh where mbh.id != null and mbh.egwStatus.code != 'NEW' ";
        String resultQry = "select distinct mbh from MBHeader mbh where mbh.id != null and mbh.egwStatus.code != 'NEW'";
        StringBuffer commonFilter = new StringBuffer();
        if (criteriaMap.get(WORKORDER_NO) != null) {
            commonFilter = commonFilter.append(" and mbh.workOrder.workOrderNumber like ?");
            paramList.add("%" + criteriaMap.get(WORKORDER_NO) + "%");
        }
        if (criteriaMap.get(CONTRACTOR_ID) != null && !"-1".equals(criteriaMap.get(CONTRACTOR_ID))) {
            commonFilter = commonFilter.append(" and mbh.workOrder.contractor.id = ?");
            paramList.add(criteriaMap.get(CONTRACTOR_ID));
        }
        if (criteriaMap.get(DEPT_ID) != null && !"-1".equals(criteriaMap.get(DEPT_ID))) {
            commonFilter = commonFilter.append(" and mbh.workOrderEstimate.estimate.executingDepartment.id = ?");
            paramList.add(criteriaMap.get(DEPT_ID));
        }
        if (criteriaMap.get(CREATE_DATE) != null) {
            commonFilter = commonFilter.append(" and mbh.mbDate = ?");
            paramList.add(criteriaMap.get(CREATE_DATE));
        }
        if (criteriaMap.get(FROM_DATE) != null && criteriaMap.get(TO_DATE) == null) {
            commonFilter = commonFilter.append(" and mbh.mbDate >= ? ");
            paramList.add(criteriaMap.get(FROM_DATE));
        } else if (criteriaMap.get(TO_DATE) != null && criteriaMap.get(FROM_DATE) == null) {
            commonFilter = commonFilter.append(" and mbh.mbDate <= ? ");
            paramList.add(criteriaMap.get(TO_DATE));
        } else if (criteriaMap.get(FROM_DATE) != null && criteriaMap.get(TO_DATE) != null) {
            commonFilter = commonFilter.append(" and mbh.mbDate between ? and ? ");
            paramList.add(criteriaMap.get(FROM_DATE));
            paramList.add(criteriaMap.get(TO_DATE));
        }
        if (criteriaMap.get(EST_NO) != null) {
            commonFilter = commonFilter.append(" and mbh.workOrderEstimate.estimate.estimateNumber like ?");
            paramList.add("%" + criteriaMap.get(EST_NO) + "%");
        }
        if (criteriaMap.get(MB_REF_NO) != null) {
            commonFilter = commonFilter.append(" and mbh.mbRefNo = ?");
            paramList.add(criteriaMap.get(MB_REF_NO));
        }
        if (criteriaMap.get(MB_PAGE_NO) != null) {
            commonFilter = commonFilter.append(" and ? between mbh.fromPageNo and mbh.toPageNo ");
            paramList.add(criteriaMap.get(MB_PAGE_NO));
        }
        if ("1".equals(criteriaMap.get(ALL_STATUS))) {
            commonFilter = commonFilter.append(" and mbh.egBillregister.id is not null");
        } else if (!"-1".equals(criteriaMap.get(STATUS)) && criteriaMap.get(STATUS) != null && (criteriaMap.get(STATUS).equals(MBHeader.MeasurementBookStatus.APPROVED.toString()) || criteriaMap.get(STATUS).equals(MBHeader.MeasurementBookStatus.CANCELLED.toString()))) {
            commonFilter = commonFilter.append(" and mbh.egwStatus.code = ?");
            paramList.add(criteriaMap.get(STATUS));
        } else if (!"-1".equals(criteriaMap.get(STATUS)) && criteriaMap.get(STATUS) != null) {
            commonFilter = commonFilter.append(" and mbh.egwStatus.code = ?");
            paramList.add(criteriaMap.get(STATUS));
        }
        if (criteriaMap.get(BILLDATE) != null) {
            commonFilter = commonFilter.append(" and trunc(mbh.egBillregister.billdate) = ?");
            paramList.add(criteriaMap.get(BILLDATE));
        }
        if (criteriaMap.get(BILLSTATUS) != null && !criteriaMap.get(BILLSTATUS).equals("-1")) {
            commonFilter = commonFilter.append(" and mbh.egBillregister.status.code like ?");
            paramList.add("%" + criteriaMap.get(BILLSTATUS) + "%");
        }
        if (criteriaMap.get(BILLNO) != null) {
            commonFilter = commonFilter.append(" and mbh.egBillregister.billnumber= ? ");
            paramList.add(criteriaMap.get(BILLNO));
        }
        commonFilter = commonFilter.append(" order by mbh.mbDate ");
        String searchQry = "select distinct mbh from MBHeader mbh where mbh.id != null and mbh.egwStatus.code != 'NEW'" + commonFilter;
        String countResultQry = "select count(distinct mbh) from MBHeader mbh where mbh.id != null and mbh.egwStatus.code != 'NEW' " + commonFilter;
        mbHeaderQryList.add(searchQry);
        mbHeaderQryList.add(countResultQry);
        return mbHeaderQryList;
    }

    @Override
    public double prevCumulativeQuantity(Long woActivityId, Long mbHeaderId) {
        Object[] params;
        Double pQuant;
        if (mbHeaderId == null) {
            mbHeaderId = -1L;
        }
        if ((pQuant = (Double)this.genericService.findByNamedQuery("prevCumulativeQuantity", params = new Object[]{mbHeaderId, mbHeaderId, "CANCELLED", woActivityId})) == null) {
            return 0.0;
        }
        return pQuant;
    }

    @Override
    public double prevCumulativeQuantityIncludingCQ(Long woActivityId, Long mbHeaderId, Long activityId, WorkOrder workOrder) {
        if (mbHeaderId == null) {
            mbHeaderId = -1L;
        }
        Object[] params = new Object[]{mbHeaderId, mbHeaderId, "CANCELLED", workOrder, workOrder, woActivityId, activityId};
        Double pQuant = (Double)this.genericService.findByNamedQuery("prevCumulativeQuantityForCQ", params);
        params = new Object[]{mbHeaderId, mbHeaderId, "CANCELLED", activityId};
        Double pQuantRE = (Double)this.genericService.findByNamedQuery("prevCumulativeQuantityForREs", params);
        if (pQuant != null && pQuantRE != null) {
            pQuant = pQuant + pQuantRE;
        }
        if (pQuant == null && pQuantRE != null) {
            pQuant = pQuantRE;
        }
        if (pQuant == null) {
            return 0.0;
        }
        return pQuant;
    }

    @Override
    public double totalEstimatedQuantityForRE(Long woActivityId, Long estimateId, Long activityId, WorkOrder workOrder) {
        if (estimateId == null) {
            estimateId = -1L;
        }
        Object[] params = null;
        Double estQuantity = null;
        params = new Object[]{estimateId, workOrder, workOrder, woActivityId, activityId};
        estQuantity = (Double)this.genericService.findByNamedQuery("totalEstimatedQuantityInRE", params);
        Double estQuantityRE = null;
        params = workOrder.getParent() != null ? new Object[]{estimateId, workOrder.getParent(), workOrder.getParent(), activityId} : new Object[]{estimateId, workOrder, workOrder, activityId};
        estQuantityRE = (Double)this.genericService.findByNamedQuery("totalEstimatedQuantityForREinRE", params);
        if (estQuantity != null && estQuantityRE != null) {
            estQuantity = estQuantity + estQuantityRE;
        }
        if (estQuantity == null && estQuantityRE != null) {
            estQuantity = estQuantityRE;
        }
        if (estQuantity == null) {
            return 0.0;
        }
        return estQuantity;
    }

    @Override
    public double totalEstimatedQuantityForPreviousREs(Long woActivityId, Long estimateId, Long activityId, WorkOrder workOrder) {
        if (estimateId == null) {
            estimateId = -1L;
        }
        Object[] params = null;
        Double estQuantity = null;
        params = new Object[]{estimateId, workOrder, workOrder, woActivityId, activityId};
        estQuantity = (Double)this.genericService.findByNamedQuery("totalEstimatedQuantityInRE", params);
        Double estQuantityRE = null;
        params = new Object[]{estimateId, workOrder, workOrder, activityId};
        estQuantityRE = (Double)this.genericService.findByNamedQuery("totalEstimatedQuantityForPreviousREs", params);
        if (estQuantity != null && estQuantityRE != null) {
            estQuantity = estQuantity + estQuantityRE;
        }
        if (estQuantity == null && estQuantityRE != null) {
            estQuantity = estQuantityRE;
        }
        if (estQuantity == null) {
            return 0.0;
        }
        return estQuantity;
    }

    @Override
    public List<WorkOrderEstimate> getWorkOrderEstimatesForMB(List<WorkOrderEstimate> workOrderEstimateList) {
        ArrayList<WorkOrderEstimate> woEstimateList = new ArrayList<WorkOrderEstimate>();
        ArrayList<WorkOrderEstimate> usedWOEstimateList = new ArrayList<WorkOrderEstimate>();
        Double approvedQuantity = 0.0;
        Double usedQuantity = 0.0;
        Double extraPercentage = this.worksService.getConfigval();
        for (WorkOrderEstimate woe : workOrderEstimateList) {
            List<MBHeader> mbHeaderList;
            for (WorkOrderActivity woActivity : woe.getWorkOrderActivities()) {
                approvedQuantity = approvedQuantity + woActivity.getApprovedQuantity();
            }
            if (extraPercentage > 0.0) {
                approvedQuantity = approvedQuantity * (1.0 + extraPercentage / 100.0);
            }
            if ((mbHeaderList = this.findAllByNamedQuery("getMBbyWorkOrderEstID", woe.getId(), "CANCELLED", this.getFinalBillTypeConfigValue(), "CANCELLED")) != null && !mbHeaderList.isEmpty()) {
                usedQuantity = this.getUsedQuantity(usedQuantity, mbHeaderList);
                for (MBHeader mbHeader : mbHeaderList) {
                    for (MBDetails mbDetails : mbHeader.getMbDetails()) {
                        if ("Required".equals(this.worksService.getWorksConfigValue("ORDER_NUMBER_REQUIRED"))) {
                            this.addUnlimitedWorkOrderEstimatesForMB(woEstimateList, usedWOEstimateList, woe, mbHeader, mbDetails);
                            continue;
                        }
                        this.addLimitedWorkOrderEstimatesForMB(woEstimateList, usedWOEstimateList, approvedQuantity, usedQuantity, woe, mbHeader, mbDetails);
                    }
                }
                continue;
            }
            if (woEstimateList.contains((Object)woe)) continue;
            this.addNewWorkOrderEstimatesForMB(woEstimateList, woe);
        }
        for (WorkOrderEstimate woe : usedWOEstimateList) {
            woEstimateList.remove((Object)woe);
        }
        return woEstimateList;
    }

    private void addNewWorkOrderEstimatesForMB(List<WorkOrderEstimate> woEstimateList, WorkOrderEstimate woe) {
        if (woe.getMbHeaders().isEmpty()) {
            woEstimateList.add(woe);
        } else {
            for (MBHeader mbh : woe.getMbHeaders()) {
                if (mbh.getEgwStatus() == null || !mbh.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.CANCELLED.toString()) || woEstimateList.contains((Object)woe)) continue;
                woEstimateList.add(woe);
            }
        }
    }

    private void addUnlimitedWorkOrderEstimatesForMB(List<WorkOrderEstimate> woEstimateList, List<WorkOrderEstimate> usedWOEstimateList, WorkOrderEstimate woe, MBHeader mbHeader, MBDetails mbDetails) {
        if (mbHeader.getEgwStatus() != null && mbHeader.getEgwStatus().getCode().equalsIgnoreCase(MBHeader.MeasurementBookStatus.APPROVED.toString())) {
            if (!woEstimateList.contains((Object)woe)) {
                woEstimateList.add(woe);
            }
        } else if (woEstimateList.contains((Object)woe)) {
            usedWOEstimateList.add(woe);
        }
    }

    private void addLimitedWorkOrderEstimatesForMB(List<WorkOrderEstimate> woEstimateList, List<WorkOrderEstimate> usedWOEstimateList, Double approvedQuantity, Double usedQuantity, WorkOrderEstimate woe, MBHeader mbHeader, MBDetails mbDetails) {
        if (usedQuantity < approvedQuantity && woe.getWorkOrderActivities().contains((Object)mbDetails.getWorkOrderActivity()) && mbHeader.getEgwStatus() != null && mbHeader.getEgwStatus().getCode().equalsIgnoreCase(MBHeader.MeasurementBookStatus.APPROVED.toString())) {
            if (!woEstimateList.contains((Object)woe)) {
                woEstimateList.add(woe);
            }
        } else if (woEstimateList.contains((Object)woe)) {
            usedWOEstimateList.add(woe);
        }
    }

    private Double getUsedQuantity(Double usedQuantity, List<MBHeader> mbHeaderList) {
        Double usedQty = usedQuantity;
        for (MBHeader mbHeader : mbHeaderList) {
            if (mbHeader == null || mbHeader.getEgwStatus() == null || mbHeader.getEgwStatus().getCode().equalsIgnoreCase(MBHeader.MeasurementBookStatus.CANCELLED.toString())) continue;
            for (MBDetails mbDetails : mbHeader.getMbDetails()) {
                usedQty = usedQty + mbDetails.getQuantity();
            }
        }
        return usedQty;
    }

    @Override
    public List<WorkOrderEstimate> getWorkOrderEstimatesForBill(List<WorkOrderEstimate> workOrderEstimateList) {
        ArrayList<WorkOrderEstimate> woEstimateList = new ArrayList<WorkOrderEstimate>();
        for (WorkOrderEstimate woe : workOrderEstimateList) {
            List mbHeaderList = this.findAllByNamedQuery("getMBbyWorkOrderEstID", woe.getId(), "CANCELLED", this.getFinalBillTypeConfigValue(), "CANCELLED");
            if (mbHeaderList == null || mbHeaderList.isEmpty()) continue;
            for (MBHeader mbHeader : mbHeaderList) {
                if (mbHeader.getEgBillregister() != null && mbHeader.getEgBillregister().getBillstatus().equals(MBHeader.MeasurementBookStatus.CANCELLED.toString()) && !woEstimateList.contains((Object)woe)) {
                    woEstimateList.add(woe);
                }
                for (MBDetails mbDetails : mbHeader.getMbDetails()) {
                    if (!woe.getWorkOrderActivities().contains((Object)mbDetails.getWorkOrderActivity()) || mbHeader.getEgwStatus() == null || !mbHeader.getEgwStatus().getCode().equalsIgnoreCase(MBHeader.MeasurementBookStatus.APPROVED.toString()) || mbHeader.getEgBillregister() != null || woEstimateList.contains((Object)woe)) continue;
                    woEstimateList.add(woe);
                }
            }
        }
        return woEstimateList;
    }

    @Override
    public List<WorkOrderEstimate> getWOEstForBillExludingLegacyMB(List<WorkOrderEstimate> workOrderEstimateList) {
        ArrayList<WorkOrderEstimate> woEstimateList = new ArrayList<WorkOrderEstimate>();
        for (WorkOrderEstimate woe : workOrderEstimateList) {
            List mbHeaderList = this.findAllByNamedQuery("getMBWithoutLegacyByWOEstID", woe.getId(), "CANCELLED", this.getFinalBillTypeConfigValue(), "CANCELLED");
            if (mbHeaderList == null || mbHeaderList.isEmpty()) continue;
            for (MBHeader mbHeader : mbHeaderList) {
                if (mbHeader.getEgBillregister() != null && mbHeader.getEgBillregister().getBillstatus().equals(MBHeader.MeasurementBookStatus.CANCELLED.toString()) && !woEstimateList.contains((Object)woe)) {
                    woEstimateList.add(woe);
                }
                for (MBDetails mbDetails : mbHeader.getMbDetails()) {
                    if (!woe.getWorkOrderActivities().contains((Object)mbDetails.getWorkOrderActivity()) && mbDetails.getWorkOrderActivity().getActivity().getRevisionType() == null || mbHeader.getEgwStatus() == null || !mbHeader.getEgwStatus().getCode().equalsIgnoreCase(MBHeader.MeasurementBookStatus.APPROVED.toString()) || mbHeader.getEgBillregister() != null || woEstimateList.contains((Object)woe)) continue;
                    woEstimateList.add(woe);
                }
            }
        }
        return woEstimateList;
    }

    @Override
    public MBHeader calculateMBDetails(MBHeader mbHeader, boolean isPersistedObject) {
        List<MBDetails> mbDetailList = mbHeader.getMbDetails();
        double lPrevCumlvQuant = 0.0;
        for (MBDetails detail : mbDetailList) {
            if (detail.getWorkOrderActivity().getActivity().getParent() == null) {
                lPrevCumlvQuant = this.prevCumulativeQuantityIncludingCQ(detail.getWorkOrderActivity().getId(), mbHeader.getId(), detail.getWorkOrderActivity().getActivity().getId(), detail.getWorkOrderActivity().getWorkOrderEstimate().getWorkOrder());
                detail.setTotalEstQuantity(this.totalEstimatedQuantity(detail.getWorkOrderActivity().getId(), mbHeader.getId(), detail.getWorkOrderActivity().getActivity().getId(), detail.getWorkOrderActivity().getWorkOrderEstimate().getWorkOrder()));
            } else {
                detail.getWorkOrderActivity().setParent((WorkOrderActivity)((Object)this.genericService.find("from WorkOrderActivity where activity.id=? and (workOrderEstimate.id=? or workOrderEstimate.estimate.parent.id=?)", new Object[]{detail.getWorkOrderActivity().getActivity().getParent().getId(), mbHeader.getWorkOrderEstimate().getId(), mbHeader.getWorkOrderEstimate().getEstimate().getId()})));
                lPrevCumlvQuant = this.prevCumulativeQuantityIncludingCQ(detail.getWorkOrderActivity().getId(), mbHeader.getId(), detail.getWorkOrderActivity().getActivity().getParent().getId(), detail.getWorkOrderActivity().getWorkOrderEstimate().getWorkOrder());
                detail.setTotalEstQuantity(this.totalEstimatedQuantity(detail.getWorkOrderActivity().getId(), mbHeader.getId(), detail.getWorkOrderActivity().getActivity().getParent().getId(), detail.getWorkOrderActivity().getWorkOrderEstimate().getWorkOrder()));
            }
            detail.setPrevCumlvQuantity(lPrevCumlvQuant);
            detail.setCurrCumlvQuantity(lPrevCumlvQuant + detail.getQuantity());
            detail.setAmtForCurrQuantity(detail.getQuantity() * detail.getWorkOrderActivity().getApprovedRate());
            detail.setCumlvAmtForCurrCumlvQuantity((lPrevCumlvQuant + detail.getQuantity()) * detail.getWorkOrderActivity().getApprovedRate());
        }
        return mbHeader;
    }

    @Override
    public double totalEstimatedQuantity(Long woActivityId, Long mbHeaderId, Long activityId, WorkOrder workOrder) {
        Date currentTimestamp = null;
        MBHeader mbHeader = null;
        if (mbHeaderId == null) {
            mbHeaderId = -1L;
            currentTimestamp = new Date();
        } else {
            mbHeader = (MBHeader)((Object)this.persistenceService.find(" from MBHeader where id = ?", new Object[]{mbHeaderId}));
            currentTimestamp = mbHeader.getCreatedDate();
        }
        Object[] params = null;
        Double estQuantity = null;
        params = new Object[]{workOrder, woActivityId, activityId};
        estQuantity = (Double)this.genericService.findByNamedQuery("totalEstimatedQuantity", params);
        Double estQuantityRE = null;
        params = workOrder.getParent() != null ? new Object[]{currentTimestamp, workOrder.getParent(), workOrder.getParent(), activityId} : new Object[]{currentTimestamp, workOrder, workOrder, activityId};
        estQuantityRE = (Double)this.genericService.findByNamedQuery("totalEstimatedQuantityForRE", params);
        if (estQuantity != null && estQuantityRE != null) {
            estQuantity = estQuantity + estQuantityRE;
        }
        if (estQuantity == null && estQuantityRE != null) {
            estQuantity = estQuantityRE;
        }
        if (estQuantity == null) {
            return 0.0;
        }
        return estQuantity;
    }

    @Override
    public boolean isMBExistForLineItem(String workOrderNumber, long lineItemId) {
        boolean flag = false;
        List mbHeaderList = null;
        ArrayList<Object> paramList = new ArrayList<Object>();
        String dynQuery = "select distinct mbHeader from MBHeader mbHeader, WorkOrder wo  join wo.workOrderActivities woa left join woa.activity.schedule schedule left join woa.activity.nonSor nonSor where mbHeader.id !=null and mbHeader.workOrder.workOrderNumber like ? and mbHeader.egwStatus.code like ?";
        paramList.add("%" + workOrderNumber + "%");
        paramList.add("NEW");
        if (lineItemId > 0L) {
            dynQuery = dynQuery + " and (schedule.id = ? or nonSor.id = ?)";
            paramList.add(lineItemId);
            paramList.add(lineItemId);
        }
        logger.debug((Object)("1--inside action dynquery is" + dynQuery));
        if (paramList.isEmpty()) {
            mbHeaderList = this.genericService.findAllBy(dynQuery, new Object[0]);
        } else {
            Object[] params = new Object[paramList.size()];
            params = paramList.toArray(params);
            mbHeaderList = this.genericService.findAllBy(dynQuery, params);
        }
        if (mbHeaderList != null && !mbHeaderList.isEmpty()) {
            flag = true;
        }
        return flag;
    }

    @Override
    public Boolean approvalLimitCrossed(MBDetails details) {
        Boolean result = false;
        Double approvedQuantity = 0.0;
        Double approvedQuantityWithoutPercentage = this.totalEstimatedQuantity(details.getWorkOrderActivity().getId(), details.getMbHeader() == null ? null : details.getMbHeader().getId(), details.getWorkOrderActivity().getActivity().getId(), details.getWorkOrderActivity().getWorkOrderEstimate().getWorkOrder());
        Double extraPercentage = this.worksService.getConfigval();
        approvedQuantity = extraPercentage > 0.0 ? Double.valueOf(approvedQuantityWithoutPercentage * (1.0 + extraPercentage / 100.0)) : approvedQuantityWithoutPercentage;
        if (details.getPrevCumlvQuantity() + details.getQuantity() > approvedQuantityWithoutPercentage) {
            result = true;
        }
        if (details.getPrevCumlvQuantity() + details.getQuantity() > approvedQuantity) {
            result = null;
        }
        return result;
    }

    @Override
    public List<MBHeader> getApprovedMBList(Long workOrderId, Long workOrderEstimateId, Date asOnDate) {
        Object[] params = new Object[]{"APPROVED", asOnDate, workOrderId, workOrderEstimateId};
        List mbList = this.persistenceService.findAllByNamedQuery("getApprovedMBList", params);
        ArrayList<MBHeader> mbListForBill = new ArrayList<MBHeader>();
        if (mbList != null && !mbList.isEmpty()) {
            for (MBHeader mbHeader : mbList) {
                if (mbHeader.getEgBillregister() != null && mbHeader.getEgBillregister().getStatus() != null && mbHeader.getEgBillregister().getStatus().getCode().equals("CANCELLED")) {
                    mbListForBill.add(mbHeader);
                }
                if (mbHeader.getEgBillregister() != null) continue;
                mbListForBill.add(mbHeader);
            }
        }
        return mbListForBill;
    }

    @Override
    public List<MBHeader> getPartBillList(Long workOrderId, String billtype) {
        Object[] params = new Object[]{"APPROVED", workOrderId, "CANCELLED", billtype};
        return this.persistenceService.findAllByNamedQuery("getPartBillList", params);
    }

    @Override
    public Date getLatestBillDateForMB(Long workOrderId) {
        return (Date)this.genericService.findByNamedQuery("getAllBilledMBs", new Object[]{"APPROVED", workOrderId});
    }

    @Override
    public Date getLatestBillDateForMBPassingWOEstimate(Long workOrderEstimateId) {
        return (Date)this.genericService.findByNamedQuery("getAllBilledMBsForWOEstimate", new Object[]{"APPROVED", workOrderEstimateId});
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String getFinalBillTypeConfigValue() {
        return this.worksService.getWorksConfigValue("FinalBillType");
    }

    @Override
    public BigDecimal getTotalMBAmountForPrevMBs(WorkOrderEstimate workOrderEstimate, double negoPerc, String tenderType) {
        List mbHeaderList = this.persistenceService.findAllByNamedQuery("getAllApprovedMBHeaders", new Object[]{"APPROVED", workOrderEstimate.getWorkOrder().getId(), workOrderEstimate.getEstimate().getId()});
        BigDecimal tenderedAmount = BigDecimal.ZERO;
        BigDecimal mbAmount = BigDecimal.ZERO;
        BigDecimal tenderedMBAmount = BigDecimal.ZERO;
        BigDecimal totalMBAmount = BigDecimal.ZERO;
        if (tenderType.equalsIgnoreCase("Percentage-Tender")) {
            for (MBHeader mbhObj : mbHeaderList) {
                for (MBDetails mbd : mbhObj.getMbDetails()) {
                    if (mbd.getWorkOrderActivity().getActivity().getRevisionType() != null) continue;
                    tenderedAmount = tenderedAmount.add(BigDecimal.valueOf(mbd.getAmount()));
                }
                mbAmount = mbAmount.add(mbhObj.getTotalMBAmount());
            }
            if (tenderedAmount != null) {
                tenderedMBAmount = tenderedAmount.add(tenderedAmount.multiply(BigDecimal.valueOf(negoPerc / 100.0)));
            }
            totalMBAmount = tenderedMBAmount.add(mbAmount.subtract(tenderedAmount));
        } else {
            for (MBHeader mbhObj : mbHeaderList) {
                totalMBAmount = totalMBAmount.add(mbhObj.getTotalMBAmount());
            }
        }
        return totalMBAmount.setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getTotalMBAmount(Long workOrderId, Long estimateId) {
        BigDecimal totalMBAmount = BigDecimal.ZERO;
        totalMBAmount = (BigDecimal)this.genericService.find("select sum(mbAmount) from MBHeader where egwStatus.code != 'CANCELLED' and  workOrderEstimate.workOrder.id=? and  workOrderEstimate.estimate.id= ? ", new Object[]{workOrderId, estimateId});
        return totalMBAmount;
    }

    @Override
    public Date getWorkCommencedDate(Long woId) {
        Date workCommencedDate = (Date)this.genericService.find(" select stat.statusDate from OfflineStatus stat where stat.objectId = ? and stat.objectType = ? and stat.egwStatus.code = ? ", new Object[]{woId, "WorkOrder", "Work commenced"});
        return workCommencedDate;
    }

    @Override
    public Date getLastMBCreatedDate(Long woId, Long estId) {
        Date latestMBDate = (Date)this.genericService.find(" select max(mbh.mbDate) from MBHeader mbh where mbh.workOrder.id= ? and mbh.workOrderEstimate.estimate.id=? and mbh.workOrderEstimate.estimate.egwStatus.code= ? and mbh.egwStatus.code = ? ", new Object[]{woId, estId, "ADMIN_SANCTIONED", "APPROVED"});
        return latestMBDate;
    }
}

