/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.commons.service.EntityTypeService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AssetsForEstimate;
import org.egov.works.models.estimate.ProjectCode;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectCodeService
extends PersistenceService<ProjectCode, Long>
implements EntityTypeService {
    @Autowired
    private PersistenceService<AssetsForEstimate, Long> assetsForEstimateService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;

    public ProjectCodeService() {
        super(ProjectCode.class);
    }

    public List<ProjectCode> getAllActiveEntities(Integer accountDetailTypeId) {
        return this.findAllBy("from ProjectCode where active=true", new Object[0]);
    }

    public List<ProjectCode> filterActiveEntities(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        Integer pageSize = maxRecords > 0 ? Integer.valueOf(maxRecords) : null;
        String param = "%" + filterKey.toUpperCase() + "%";
        String qry = "select distinct pc from ProjectCode pc where active=true and upper(pc.code) like ? order by code";
        return this.findPageBy("select distinct pc from ProjectCode pc where active=true and upper(pc.code) like ? order by code", 0, pageSize, new Object[]{param}).getList();
    }

    public List getAssetCodesForProjectCode(Integer accountDetailKey) throws ValidationException {
        if (accountDetailKey == null || accountDetailKey <= 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("projectcode.invalid", "Invalid Account Detail Key")));
        }
        ProjectCode projectCode = (ProjectCode)((Object)this.find("from ProjectCode where id=?", new Object[]{accountDetailKey.longValue()}));
        if (projectCode == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("projectcode.doesnt.exist", "No Project Code exists for given Account Detail Key")));
        }
        if (projectCode.getEstimates() == null || projectCode.getEstimates().size() == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("projectcode.no.link.abstractEstimate", "Estimate is not linked with given Account Detail Key")));
        }
        ArrayList<AbstractEstimate> estimates = new ArrayList<AbstractEstimate>(projectCode.getEstimates());
        List<AssetsForEstimate> assetValues = ((AbstractEstimate)((Object)estimates.get(0))).getAssetValues();
        if (assetValues == null || assetValues.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> assetCodes = new ArrayList<String>();
        for (AssetsForEstimate asset : assetValues) {
            assetCodes.add(asset.getAsset().getCode());
        }
        return assetCodes;
    }

    public List<ProjectCode> getAllActiveProjectCodes(int fundId, Long functionId, int functionaryId, int fieldId, int deptId) {
        String projectCodeQry = null;
        ArrayList<Number> paramList = new ArrayList<Number>();
        projectCodeQry = "select pc from ProjectCode pc where pc in (select ae.projectCode from AbstractEstimate as ae inner join ae.financialDetails as fd where ae.state.value not in('CANCELLED')";
        if (fundId != 0) {
            projectCodeQry = projectCodeQry + " and fd.fund.id= ?";
            paramList.add(fundId);
        }
        if (functionId != 0L) {
            projectCodeQry = projectCodeQry + " and fd.function.id= ?";
            paramList.add(functionId);
        }
        if (functionaryId != 0) {
            projectCodeQry = projectCodeQry + " and fd.functionary.id= ?";
            paramList.add(functionaryId);
        }
        if (fieldId != 0) {
            projectCodeQry = projectCodeQry + " and ae.ward.id= ?";
            paramList.add(fieldId);
        }
        if (deptId != 0) {
            projectCodeQry = projectCodeQry + " and ae.executingDepartment.id= ?";
            paramList.add(deptId);
        }
        projectCodeQry = projectCodeQry + ")";
        if (paramList.isEmpty()) {
            return this.findAllBy(projectCodeQry, new Object[0]);
        }
        Object[] params = new Object[paramList.size()];
        params = paramList.toArray(params);
        return this.findAllBy(projectCodeQry, params);
    }

    public List getAssetListByProjectCode(Long projectCodeId) throws NoSuchObjectException {
        ArrayList<String> assetCodeList = new ArrayList<String>();
        ProjectCode pc = (ProjectCode)((Object)this.find("from ProjectCode where id=?", new Object[]{projectCodeId}));
        if (pc == null) {
            throw new NoSuchObjectException("projectcode.notfound");
        }
        List assetsForEstimateList = this.assetsForEstimateService.findAllByNamedQuery("ASSETS_FOR_PROJECTCODE", new Object[]{projectCodeId});
        if (assetsForEstimateList.isEmpty()) {
            throw new NoSuchObjectException("assetsforestimate.projectcode.asset.notfound");
        }
        for (AssetsForEstimate assetsForEstimate : assetsForEstimateList) {
            assetCodeList.add(assetsForEstimate.getAsset().getCode());
        }
        return assetCodeList;
    }

    public List<ProjectCode> validateEntityForRTGS(List<Long> idsList) throws ValidationException {
        return null;
    }

    public List<ProjectCode> getEntitiesById(List<Long> idsList) throws ValidationException {
        return null;
    }

    public ProjectCode findByCode(String code) {
        String query = "from ProjectCode as p where upper(p.code) = '" + code.toUpperCase() + "'";
        return (ProjectCode)((Object)this.find(query));
    }

    public ProjectCode findActiveProjectCodeByCode(String code) {
        return (ProjectCode)((Object)this.find("from ProjectCode as p where active=true and upper(p.code) = ?", new Object[]{code.toUpperCase()}));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void createProjectCode(String code, String name) {
        ProjectCode projectCode = new ProjectCode();
        projectCode.setCode(code);
        projectCode.setCodeName(name);
        projectCode.setDescription(name);
        projectCode.setActive(true);
        projectCode.setEgwStatus(this.worksUtils.getStatusByModuleAndCode(ProjectCode.class.getSimpleName(), "CREATED"));
        this.persist((Object)projectCode);
        this.createAccountDetailKey(projectCode);
    }

    protected void createAccountDetailKey(ProjectCode proj) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName("PROJECTCODE");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(proj.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }
}

