/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.workorder;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.eis.entity.Employee;
import org.egov.infra.persistence.entity.Auditable;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.workorder.WorkOrderActivity;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.hibernate.validator.constraints.Length;

public class WorkOrder
extends StateAware
implements Auditable {
    private static final long serialVersionUID = -3955155765490287178L;
    private Long id;
    @NotNull
    private Contractor contractor;
    @Required(message="workOrder.workOrderDate.null")
    @DateFormat(message="invalid.fieldvalue.workOrderDate")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="invalid.workOrderDate")
    private Date workOrderDate;
    @NotNull
    private String workOrderNumber;
    private String packageNumber;
    private String tenderNumber;
    private String negotiationNumber;
    @Length(max=1024, message="workOrderDetails.length")
    private String workOrderDetails;
    private Integer contractPeriod;
    @Length(max=1024, message="agreementDetails.length")
    private String agreementDetails;
    @Length(max=1024, message="paymentTerms.length")
    private String paymentTerms;
    @Min(value=0L, message="workorder.emdAmountDeposited.non.negative")
    private double emdAmountDeposited;
    @Min(value=0L, message="workorder.non.negative")
    private double securityDeposit;
    @Min(value=0L, message="workorder.non.negative")
    private double labourWelfareFund;
    @Required(message="workorder.engineerIncharge.null")
    private Employee engineerIncharge;
    @Min(value=0L, message="workorder.non.negative")
    private double defectLiabilityPeriod;
    @NotNull
    @Min(value=1L)
    private double workOrderAmount;
    @NotNull
    private EgwStatus egwStatus;
    private double tenderFinalizedPercentage;
    @DateFormat(message="invalid.fieldvalue.workOrderDate")
    private Date approvedDate;
    private String fileNumber;
    @DateFormat(message="invalid.fieldvalue.fileDate")
    private Date fileDate;
    @Length(max=1024, message="bankguarantee.length")
    private String bankGuarantee;
    private String estimateNumber;
    private WorkOrder parent;
    private Date expectedCompletionDate;
    private String tenderType;
    private String owner;
    private String status;
    private transient String percentageSign;
    private List<WorkOrderEstimate> workOrderEstimates = new LinkedList<WorkOrderEstimate>();
    private Set<OfflineStatus> offlineStatuses = new HashSet<OfflineStatus>();
    private List<String> workOrderActions = new ArrayList<String>();
    private Set<WorkOrder> revisionWOs = new HashSet<WorkOrder>();
    private Set<MBHeader> mbHeaders = new HashSet<MBHeader>();
    private transient List<DocumentDetails> documentDetails = new ArrayList<DocumentDetails>(0);
    private String cancellationReason;
    private String cancellationRemarks;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Contractor getContractor() {
        return this.contractor;
    }

    public void setContractor(Contractor contractor) {
        this.contractor = contractor;
    }

    public Date getWorkOrderDate() {
        return this.workOrderDate;
    }

    public void setWorkOrderDate(Date workOrderDate) {
        this.workOrderDate = workOrderDate;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public String getPackageNumber() {
        return this.packageNumber;
    }

    public void setPackageNumber(String packageNumber) {
        this.packageNumber = packageNumber;
    }

    public String getTenderNumber() {
        return this.tenderNumber;
    }

    public void setTenderNumber(String tenderNumber) {
        this.tenderNumber = tenderNumber;
    }

    public String getNegotiationNumber() {
        return this.negotiationNumber;
    }

    public void setNegotiationNumber(String negotiationNumber) {
        this.negotiationNumber = negotiationNumber;
    }

    public String getWorkOrderDetails() {
        return this.workOrderDetails;
    }

    public void setWorkOrderDetails(String workOrderDetails) {
        this.workOrderDetails = workOrderDetails;
    }

    public Integer getContractPeriod() {
        return this.contractPeriod;
    }

    public void setContractPeriod(Integer contractPeriod) {
        this.contractPeriod = contractPeriod;
    }

    public String getAgreementDetails() {
        return this.agreementDetails;
    }

    public void setAgreementDetails(String agreementDetails) {
        this.agreementDetails = agreementDetails;
    }

    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public double getEmdAmountDeposited() {
        return this.emdAmountDeposited;
    }

    public void setEmdAmountDeposited(double emdAmountDeposited) {
        this.emdAmountDeposited = emdAmountDeposited;
    }

    public double getSecurityDeposit() {
        return this.securityDeposit;
    }

    public void setSecurityDeposit(double securityDeposit) {
        this.securityDeposit = securityDeposit;
    }

    public double getLabourWelfareFund() {
        return this.labourWelfareFund;
    }

    public void setLabourWelfareFund(double labourWelfareFund) {
        this.labourWelfareFund = labourWelfareFund;
    }

    public Employee getEngineerIncharge() {
        return this.engineerIncharge;
    }

    public void setEngineerIncharge(Employee engineerIncharge) {
        this.engineerIncharge = engineerIncharge;
    }

    public double getDefectLiabilityPeriod() {
        return this.defectLiabilityPeriod;
    }

    public void setDefectLiabilityPeriod(double defectLiabilityPeriod) {
        this.defectLiabilityPeriod = defectLiabilityPeriod;
    }

    public double getWorkOrderAmount() {
        return this.workOrderAmount;
    }

    public void setWorkOrderAmount(double workOrderAmount) {
        this.workOrderAmount = workOrderAmount;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public WorkOrder getParent() {
        return this.parent;
    }

    public void setParent(WorkOrder parent) {
        this.parent = parent;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public double getTenderFinalizedPercentage() {
        return this.tenderFinalizedPercentage;
    }

    public void setTenderFinalizedPercentage(double tenderFinalizedPercentage) {
        this.tenderFinalizedPercentage = tenderFinalizedPercentage;
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public String getTenderType() {
        return this.tenderType;
    }

    public void setTenderType(String tenderType) {
        this.tenderType = tenderType;
    }

    public String getFileNumber() {
        return this.fileNumber;
    }

    public void setFileNumber(String fileNumber) {
        this.fileNumber = fileNumber;
    }

    public Date getFileDate() {
        return this.fileDate;
    }

    public void setFileDate(Date fileDate) {
        this.fileDate = fileDate;
    }

    public String getBankGuarantee() {
        return this.bankGuarantee;
    }

    public void setBankGuarantee(String bankGuarantee) {
        this.bankGuarantee = bankGuarantee;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<WorkOrderEstimate> getWorkOrderEstimates() {
        return this.workOrderEstimates;
    }

    public void setWorkOrderEstimates(List<WorkOrderEstimate> workOrderEstimates) {
        this.workOrderEstimates = workOrderEstimates;
    }

    public Set<OfflineStatus> getOfflineStatuses() {
        return this.offlineStatuses;
    }

    public void setOfflineStatuses(Set<OfflineStatus> offlineStatuses) {
        this.offlineStatuses = offlineStatuses;
    }

    public List<String> getWorkOrderActions() {
        return this.workOrderActions;
    }

    public void setWorkOrderActions(List<String> workOrderActions) {
        this.workOrderActions = workOrderActions;
    }

    public Set<WorkOrder> getRevisionWOs() {
        return this.revisionWOs;
    }

    public void setRevisionWOs(Set<WorkOrder> revisionWOs) {
        this.revisionWOs = revisionWOs;
    }

    public void setExpectedCompletionDate(Date expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public void addWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimates.add(workOrderEstimate);
    }

    public Set<MBHeader> getMbHeaders() {
        return this.mbHeaders;
    }

    public void setMbHeaders(Set<MBHeader> mbHeaders) {
        this.mbHeaders = mbHeaders;
    }

    public String getFormattedString(double value) {
        double rounded = (double)Math.round(value * 100.0) / 100.0;
        DecimalFormat formatter = new DecimalFormat("0.00");
        formatter.setDecimalSeparatorAlwaysShown(true);
        return formatter.format(rounded);
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.contractor != null && (this.contractor.getId() == null || this.contractor.getId() == 0L || this.contractor.getId() == -1L)) {
            validationErrors.add(new ValidationError("contractor", "workOrder.contractor.null"));
        } else if (this.contractor == null) {
            validationErrors.add(new ValidationError("contractor", "workOrder.contractor.null"));
        }
        return validationErrors;
    }

    public String getStateDetails() {
        return "Work Order: " + this.getWorkOrderNumber();
    }

    public Money getTotalWorkOrderQuantity() {
        double qty = 0.0;
        for (WorkOrderEstimate workOrderEstimate : this.workOrderEstimates) {
            for (WorkOrderActivity woa : workOrderEstimate.getWorkOrderActivities()) {
                if (woa.getActivity() != null && woa.getActivity().getRevisionType() != null && woa.getActivity().getRevisionType().equals((Object)RevisionType.REDUCED_QUANTITY)) {
                    qty -= woa.getApprovedQuantity();
                    continue;
                }
                qty += woa.getApprovedQuantity();
            }
        }
        Money totalWorkOrderQuantity = new Money(qty);
        return totalWorkOrderQuantity;
    }

    public Date getExpectedCompletionDate() {
        if (this.getContractPeriod() > 0) {
            Date date;
            this.expectedCompletionDate = date = DateUtils.add((Date)this.getWorkOrderDate(), (int)5, (int)this.getContractPeriod());
        }
        return this.expectedCompletionDate;
    }

    public String toString() {
        return "WorkOrder ( Id : " + this.getId() + "Work Order No: " + this.workOrderNumber + ")";
    }

    public String getPercentageSign() {
        return this.percentageSign;
    }

    public void setPercentageSign(String percentageSign) {
        this.percentageSign = percentageSign;
    }

    public List<DocumentDetails> getDocumentDetails() {
        return this.documentDetails;
    }

    public void setDocumentDetails(List<DocumentDetails> documentDetails) {
        this.documentDetails = documentDetails;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancellationRemarks() {
        return this.cancellationRemarks;
    }

    public void setCancellationRemarks(String cancellationRemarks) {
        this.cancellationRemarks = cancellationRemarks;
    }
}

