/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.measurementbook;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.infra.persistence.validator.annotation.GreaterThan;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.WorkOrderActivity;
import org.hibernate.validator.constraints.Length;

public class MBDetails
extends BaseModel {
    private static final long serialVersionUID = -5088074625605584344L;
    @Required(message="mbdetails.mbheader.null")
    private MBHeader mbHeader;
    @Required(message="mbdetails.activity.null")
    private WorkOrderActivity workOrderActivity;
    @GreaterThan(value=0L, message="mbdetails.quantity.non.negative")
    private double quantity;
    private double rate;
    @Length(max=400, message="mbdetails.remark.length")
    private String remarks;
    private double prevCumlvQuantity;
    private double currCumlvQuantity;
    private double amtForCurrQuantity;
    private double cumlvAmtForCurrCumlvQuantity;
    private Date mbdetailsDate;
    @OptionalPattern(regex="[0-9a-zA-Z/]+", message="mbdetails.ordernumber")
    private String OrderNumber;
    private double totalEstQuantity;
    private double amount = 0.0;

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.mbHeader != null && (this.mbHeader.getId() == null || this.mbHeader.getId() == 0L || this.mbHeader.getId() == -1L)) {
            validationErrors.add(new ValidationError("mbHeader", "mbdetails.mbheader.null"));
        }
        if (this.workOrderActivity != null && (this.workOrderActivity.getId() == null || this.workOrderActivity.getId() == 0L || this.workOrderActivity.getId() == -1L)) {
            validationErrors.add(new ValidationError("workOrderActivity", "mbdetails.activity.null"));
        }
        return validationErrors;
    }

    public void setMbHeader(MBHeader mbHeader) {
        this.mbHeader = mbHeader;
    }

    public MBHeader getMbHeader() {
        return this.mbHeader;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public WorkOrderActivity getWorkOrderActivity() {
        return this.workOrderActivity;
    }

    public void setWorkOrderActivity(WorkOrderActivity workOrderActivity) {
        this.workOrderActivity = workOrderActivity;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public double getPrevCumlvQuantity() {
        return this.prevCumlvQuantity;
    }

    public void setPrevCumlvQuantity(double prevCumlvQuantity) {
        this.prevCumlvQuantity = prevCumlvQuantity;
    }

    public double getCurrCumlvQuantity() {
        return this.currCumlvQuantity;
    }

    public void setCurrCumlvQuantity(double currCumlvQuantity) {
        this.currCumlvQuantity = currCumlvQuantity;
    }

    public double getAmtForCurrQuantity() {
        return this.amtForCurrQuantity;
    }

    public void setAmtForCurrQuantity(double amtForCurrQuantity) {
        this.amtForCurrQuantity = amtForCurrQuantity;
    }

    public double getCumlvAmtForCurrCumlvQuantity() {
        return this.cumlvAmtForCurrCumlvQuantity;
    }

    public void setCumlvAmtForCurrCumlvQuantity(double cumlvAmtForCurrCumlvQuantity) {
        this.cumlvAmtForCurrCumlvQuantity = cumlvAmtForCurrCumlvQuantity;
    }

    public Date getMbdetailsDate() {
        return this.mbdetailsDate;
    }

    public void setMbdetailsDate(Date mbdetailsDate) {
        this.mbdetailsDate = mbdetailsDate;
    }

    public String getOrderNumber() {
        return this.OrderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.OrderNumber = orderNumber;
    }

    public double getTotalEstQuantity() {
        return this.totalEstQuantity;
    }

    public void setTotalEstQuantity(double totalEstQuantity) {
        this.totalEstQuantity = totalEstQuantity;
    }

    public double getAmount() {
        this.amount = this.workOrderActivity.getActivity().getNonSor() == null ? this.workOrderActivity.getApprovedRate() * this.quantity * this.workOrderActivity.getConversionFactor() : this.workOrderActivity.getApprovedRate() * this.quantity;
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }
}

