/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.models.masters.Overhead;

public class OverheadRate
extends BaseModel {
    private static final long serialVersionUID = 5980950787039146268L;
    @Valid
    @Required(message="validity.period.not.null")
    private Period validity;
    private Overhead overhead;
    @Min(value=0L, message="overhead.percentage.not.negative")
    private double percentage;
    @Valid
    private Money lumpsumAmount;
    private Long overheadId;

    public Long getOverheadId() {
        return this.overheadId;
    }

    public void setOverheadId(Long overheadId) {
        this.overheadId = overheadId;
    }

    public OverheadRate() {
    }

    public OverheadRate(double percentage, Money lumpsum) {
        this.percentage = percentage;
        this.lumpsumAmount = lumpsum;
    }

    public Overhead getOverhead() {
        return this.overhead;
    }

    public void setOverhead(Overhead overhead) {
        this.overhead = overhead;
    }

    public Money getLumpsumAmount() {
        return this.lumpsumAmount;
    }

    public void setLumpsumAmount(Money lumpsumAmount) {
        this.lumpsumAmount = lumpsumAmount;
    }

    public Period getValidity() {
        return this.validity;
    }

    public void setValidity(Period validity) {
        this.validity = validity;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.percentage < 0.0 || this.percentage > 100.0) {
            validationErrors.add(new ValidationError("percentage", "estimate.overhead.percentage.lessthan.100"));
        }
        if (this.percentage == 0.0 && (this.lumpsumAmount == null || this.lumpsumAmount.getValue() == 0.0)) {
            validationErrors.add(new ValidationError("percentage", "estimate.overhead.percentage_or_lumpsum_needed"));
        }
        if (this.percentage > 0.0 && this.lumpsumAmount != null && this.lumpsumAmount.getValue() > 0.0) {
            validationErrors.add(new ValidationError("percentage", "estimate.overhead.only_one_of_percentage_or_lumpsum_needed"));
        }
        if (this.validity == null || this.validity != null && !OverheadRate.compareDates(this.validity.getStartDate(), this.validity.getEndDate())) {
            validationErrors.add(new ValidationError("validity", "estimate.overhead.invalid_date_range"));
        }
        if (!validationErrors.isEmpty()) {
            return validationErrors;
        }
        return null;
    }

    public static boolean compareDates(Date startDate, Date endDate) {
        if (startDate == null) {
            return false;
        }
        if (endDate == null) {
            return true;
        }
        return !endDate.before(startDate);
    }
}

