/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.models.masters.ExpenditureType;
import org.egov.works.models.masters.OverheadRate;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

@Unique(fields={"name"}, id="id", tableName="EGW_OVERHEAD", columnName={"NAME"}, message="overhead.name.isunique")
public class Overhead
extends BaseModel {
    private static final long serialVersionUID = 985152668665306509L;
    public static final String BY_DATE_AND_TYPE = "BY_DATE_AND_TYPE";
    public static final String OVERHEADS_BY_DATE = "OVERHEADS_BY_DATE";
    private String name;
    private String description;
    private CChartOfAccounts accountCode;
    private ExpenditureType expenditureType;
    private List<OverheadRate> overheadRates = new LinkedList<OverheadRate>();

    public Overhead() {
    }

    public Overhead(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @NotEmpty(message="overhead.name.not.empty")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotEmpty(message="overhead.description.not.empty")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull(message="overhead.account.not.empty")
    public CChartOfAccounts getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(CChartOfAccounts accountCode) {
        this.accountCode = accountCode;
    }

    @NotNull(message="overhead.expenditure.not.empty")
    public ExpenditureType getExpenditureType() {
        return this.expenditureType;
    }

    public void setExpenditureType(ExpenditureType expenditureType) {
        this.expenditureType = expenditureType;
    }

    public List<OverheadRate> getOverheadRates() {
        return this.overheadRates;
    }

    public void setOverheadRates(List<OverheadRate> overheadRates) {
        this.overheadRates = overheadRates;
    }

    private List<ValidationError> checkForNoRatesPresent() {
        if (this.overheadRates != null && this.overheadRates.isEmpty()) {
            return Arrays.asList(new ValidationError("overheadrate", "estimate.overhead.altleastone_overheadrate_needed"));
        }
        return null;
    }

    private List<ValidationError> validateOverheadRates() {
        List<ValidationError> errorList = null;
        boolean openEndedRangeFlag = false;
        for (OverheadRate overheadRate : this.overheadRates) {
            if (overheadRate.getValidity().getEndDate() == null && openEndedRangeFlag) {
                return Arrays.asList(new ValidationError("openendedrange", "estimate.overheadrate.multiple.openendedrange"));
            }
            if (overheadRate.getValidity().getEndDate() == null) {
                openEndedRangeFlag = true;
            }
            if ((errorList = overheadRate.validate()) == null) continue;
            return errorList;
        }
        return errorList;
    }

    private List<ValidationError> validateDateRanges() {
        ArrayList<Period> validDates = new ArrayList<Period>();
        validDates.add(0, this.overheadRates.get(0).getValidity());
        Date existingStartDate = null;
        Date checkStartDate = null;
        Date checkEndDate = null;
        Period existingPeriod = null;
        Period checkPeriod1 = null;
        boolean flag1 = true;
        int k = 1;
        for (int i = 1; i < this.overheadRates.size(); ++i) {
            checkStartDate = this.overheadRates.get(i).getValidity().getStartDate();
            checkEndDate = this.overheadRates.get(i).getValidity().getEndDate();
            checkPeriod1 = new Period(checkStartDate, checkEndDate);
            for (int j = 0; j < validDates.size(); ++j) {
                existingStartDate = ((Period)validDates.get(j)).getStartDate();
                existingPeriod = (Period)validDates.get(0);
                if (this.isWithin(existingPeriod, checkStartDate) || this.isWithin(checkPeriod1, existingStartDate)) {
                    flag1 = false;
                    break;
                }
                if (checkEndDate == null || !this.isWithin(existingPeriod, checkEndDate)) continue;
                flag1 = false;
                break;
            }
            if (!flag1) {
                return Arrays.asList(new ValidationError("dateoverlap", "estimate.overhead.dates.overlap"));
            }
            validDates.add(k++, checkPeriod1);
        }
        return null;
    }

    private void removeEmptyRates() {
        LinkedList<OverheadRate> emptyRateObjs = new LinkedList<OverheadRate>();
        for (OverheadRate overheadRate : this.overheadRates) {
            if (overheadRate.getPercentage() != 0.0 || overheadRate.getLumpsumAmount() != null && overheadRate.getLumpsumAmount().getValue() != 0.0 || overheadRate.getValidity() != null && overheadRate.getValidity().getStartDate() != null && overheadRate.getValidity().getEndDate() != null) continue;
            emptyRateObjs.add(overheadRate);
        }
        this.overheadRates.removeAll(emptyRateObjs);
    }

    public List<ValidationError> validate() {
        List<Object> errorList = new ArrayList();
        this.removeEmptyRates();
        errorList = this.checkForNoRatesPresent();
        if (errorList != null) {
            return errorList;
        }
        errorList = this.validateOverheadRates();
        if (errorList != null) {
            return errorList;
        }
        errorList = this.validateDateRanges();
        if (errorList != null) {
            return errorList;
        }
        return errorList;
    }

    public boolean isWithin(Period period, Date dateTime) {
        LocalDate start = new LocalDate((Object)period.getStartDate());
        LocalDate end = new LocalDate((Object)period.getEndDate());
        LocalDate date = new LocalDate((Object)dateTime);
        if (period.getEndDate() == null) {
            return start.compareTo((ReadablePartial)date) <= 0;
        }
        return start.compareTo((ReadablePartial)date) <= 0 && end.compareTo((ReadablePartial)date) >= 0;
    }

    public void setOverheadRate(List<OverheadRate> overheadRates) {
        this.overheadRates = overheadRates;
    }

    public void addOverheadRate(OverheadRate overheadRate) {
        this.overheadRates.add(overheadRate);
    }

    public String getValidPercentage(Date estimateDate) {
        for (OverheadRate overheadRate : this.overheadRates) {
            if (overheadRate == null || !this.isWithin(overheadRate.getValidity(), estimateDate) || !(overheadRate.getPercentage() > 0.0)) continue;
            return String.valueOf(overheadRate.getPercentage());
        }
        return "";
    }

    public OverheadRate getOverheadRateOn(Date estimateDate) {
        if (estimateDate == null) {
            throw new ApplicationRuntimeException("no.rate.for.date");
        }
        for (OverheadRate overheadRate : this.overheadRates) {
            if (overheadRate == null || !this.isWithin(overheadRate.getValidity(), estimateDate)) continue;
            return overheadRate;
        }
        return null;
    }
}

