/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.ContractorGrade;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.models.masters.Contractor;
import org.hibernate.validator.constraints.Length;

public class ContractorDetail
extends BaseModel {
    private static final long serialVersionUID = -3375445155375225162L;
    private Contractor contractor;
    private Department department;
    @Length(max=50, message="contractorDetail.registrationNumber.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="contractorDetail.registrationNumber.alphaNumeric")
    private String registrationNumber;
    private EgwStatus status;
    private ContractorGrade grade;
    private List<ValidationError> errorList;
    @Valid
    private Period validity;
    private String category;

    public Contractor getContractor() {
        return this.contractor;
    }

    public void setContractor(Contractor contractor) {
        this.contractor = contractor;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public ContractorGrade getGrade() {
        return this.grade;
    }

    public void setGrade(ContractorGrade grade) {
        this.grade = grade;
    }

    public Period getValidity() {
        return this.validity;
    }

    public void setValidity(Period validity) {
        this.validity = validity;
    }

    public List<ValidationError> getErrorList() {
        if (this.errorList != null) {
            return this.errorList;
        }
        return new ArrayList<ValidationError>();
    }

    public void setErrorList(List<ValidationError> errorList) {
        this.errorList = errorList;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<ValidationError> validate() {
        List<ValidationError> validationErrors = this.getErrorList();
        if (this.department == null || this.department.getId() == null) {
            validationErrors.add(new ValidationError("department", "contractorDetails.department.required"));
        }
        if (this.status == null || this.status.getId() == null) {
            validationErrors.add(new ValidationError("status", "contractorDetails.status.required"));
        }
        if (this.validity == null || this.validity != null && this.validity.getStartDate() == null) {
            validationErrors.add(new ValidationError("validity", "contractorDetails.fromDate_empty"));
        } else if (this.validity == null || this.validity != null && !ContractorDetail.compareDates(this.validity.getStartDate(), this.validity.getEndDate())) {
            validationErrors.add(new ValidationError("validity", "contractorDetails.invalid_fromdate_range"));
        }
        if (validationErrors.isEmpty()) {
            return null;
        }
        return validationErrors;
    }

    public static boolean compareDates(Date startDate, Date endDate) {
        if (startDate == null) {
            return false;
        }
        if (endDate == null) {
            return true;
        }
        return !endDate.before(startDate);
    }
}

