/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import java.util.LinkedList;
import java.util.List;
import org.egov.commons.Bank;
import org.egov.commons.EgwStatus;
import org.egov.commons.utils.EntityType;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.models.masters.ContractorDetail;
import org.egov.works.models.masters.ExemptionForm;
import org.hibernate.validator.constraints.Length;

@Unique(fields={"code"}, id="id", tableName="EGW_CONTRACTOR", columnName={"CODE"}, message="contractor.code.isunique")
public class Contractor
extends BaseModel
implements EntityType {
    private static final long serialVersionUID = 6858362239507609219L;
    @Length(max=50, message="contractor.code.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="contractor.code.alphaNumeric")
    private String code;
    @Required(message="contractor.name.null")
    @Length(max=100, message="contractor.name.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="contractor.name.alphaNumeric")
    private String name;
    @Length(max=250, message="contractor.correspondenceAddress.length")
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="contractor.correspondenceAddress.alphaNumeric")
    private String correspondenceAddress;
    @Length(max=250, message="contractor.paymentAddress.length")
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="contractor.paymentAddress.alphaNumeric")
    private String paymentAddress;
    @Length(max=100, message="contractor.contactPerson.length")
    @OptionalPattern(regex="[0-9a-zA-Z ]+", message="contractor.contactPerson.alphaNumeric")
    private String contactPerson;
    @OptionalPattern(regex="^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$", message="contractor.email.invalid")
    @Length(max=100, message="contractor.email.length")
    private String email;
    @Length(max=1024, message="contractor.narration.length")
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="contractor.narration.alphaNumeric")
    private String narration;
    @Length(max=10, message="contractor.panNumber.length")
    @OptionalPattern(regex="[a-zA-Z]{5}[0-9]{4}[a-zA-Z]{1}", message="contractor.panNumber.alphaNumeric")
    private String panNumber;
    @Length(max=14, message="contractor.tinNumber.length")
    @OptionalPattern(regex="[0-9a-zA-Z]+", message="contractor.tinNumber.alphaNumeric")
    private String tinNumber;
    private Bank bank;
    @Length(max=15, message="contractor.ifscCode.length")
    @OptionalPattern(regex="[0-9a-zA-Z]+", message="contractor.ifscCode.alphaNumeric")
    private String ifscCode;
    @Length(max=22, message="contractor.bankAccount.length")
    @OptionalPattern(regex="[0-9a-zA-Z]+", message="contractor.bankAccount.alphaNumeric")
    private String bankAccount;
    @Length(max=50, message="contractor.pwdApprovalCode.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="contractor.pwdApprovalCode.alphaNumeric")
    private String pwdApprovalCode;
    private ExemptionForm exemptionForm;
    private List<ContractorDetail> contractorDetails = new LinkedList<ContractorDetail>();
    @Length(max=10)
    @OptionalPattern(regex="^((\\+)?(\\d{2}[-]))?(\\d{10}){1}?$", message="depositworks.roadcut.invalid.mobileno")
    private String mobileNumber;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCorrespondenceAddress() {
        return this.correspondenceAddress;
    }

    public void setCorrespondenceAddress(String correspondenceAddress) {
        this.correspondenceAddress = correspondenceAddress;
    }

    public String getPaymentAddress() {
        return this.paymentAddress;
    }

    public void setPaymentAddress(String paymentAddress) {
        this.paymentAddress = paymentAddress;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public String getPanNumber() {
        return this.panNumber;
    }

    public void setPanNumber(String panNumber) {
        this.panNumber = panNumber;
    }

    public String getTinNumber() {
        return this.tinNumber;
    }

    public void setTinNumber(String tinNumber) {
        this.tinNumber = tinNumber;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public String getIfscCode() {
        return this.ifscCode;
    }

    public void setIfscCode(String ifscCode) {
        this.ifscCode = ifscCode;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getPwdApprovalCode() {
        return this.pwdApprovalCode;
    }

    public void setPwdApprovalCode(String pwdApprovalCode) {
        this.pwdApprovalCode = pwdApprovalCode;
    }

    public List<ContractorDetail> getContractorDetails() {
        return this.contractorDetails;
    }

    public ExemptionForm getExemptionForm() {
        return this.exemptionForm;
    }

    public void setExemptionForm(ExemptionForm exemptionForm) {
        this.exemptionForm = exemptionForm;
    }

    public void setContractorDetails(List<ContractorDetail> contractorDetails) {
        this.contractorDetails = contractorDetails;
    }

    public void addContractorDetail(ContractorDetail contractorDetail) {
        this.contractorDetails.add(contractorDetail);
    }

    public List<ValidationError> validate() {
        List<ValidationError> errorList = null;
        if (this.contractorDetails != null && !this.contractorDetails.isEmpty()) {
            for (ContractorDetail contractorDetail : this.contractorDetails) {
                errorList = contractorDetail.validate();
                if (errorList == null) continue;
                return errorList;
            }
        }
        return errorList;
    }

    public String getBankaccount() {
        return this.bankAccount;
    }

    public String getBankname() {
        if (this.bank == null) {
            return "";
        }
        return this.bank.getName();
    }

    public String getIfsccode() {
        return this.ifscCode;
    }

    public String getPanno() {
        return this.panNumber;
    }

    public String getTinno() {
        return this.tinNumber;
    }

    public String getModeofpay() {
        return null;
    }

    public Integer getEntityId() {
        return this.id.intValue();
    }

    public String getEntityDescription() {
        return this.getName();
    }

    public EgwStatus getEgwStatus() {
        return null;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }
}

