/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.master.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.service.EntityTypeService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.autonumber.ContractorCodeGenerator;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.masters.ExemptionForm;
import org.egov.works.services.WorksService;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContractorService
extends PersistenceService<Contractor, Long>
implements EntityTypeService {
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private WorksService worksService;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    public static final Map<String, String> exemptionForm = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 408579850562980945L;
        {
            this.put(ExemptionForm.INCOME_TAX.toString(), ExemptionForm.INCOME_TAX.toString().replace("_", " "));
            this.put(ExemptionForm.EARNEST_MONEY_DEPOSIT.toString(), ExemptionForm.EARNEST_MONEY_DEPOSIT.toString().replace("_", " "));
            this.put(ExemptionForm.VAT.toString(), ExemptionForm.VAT.toString().replace("_", " "));
        }
    };

    public ContractorService() {
        super(Contractor.class);
    }

    public List<Contractor> getAllActiveEntities(Integer accountDetailTypeId) {
        return this.findAllBy("select distinct contractorDet.contractor from ContractorDetail contractorDet where contractorDet.status.description=? and contractorDet.status.moduletype=?", new Object[]{"Active", "Contractor"});
    }

    public List<Contractor> filterActiveEntities(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        Integer pageSize = maxRecords > 0 ? Integer.valueOf(maxRecords) : null;
        String param = "%" + filterKey.toUpperCase() + "%";
        String qry = "select distinct cont from Contractor cont, ContractorDetail contractorDet where cont.id=contractorDet.contractor.id and contractorDet.status.description=? and contractorDet.status.moduletype=? and (upper(cont.code) like ? or upper(cont.name) like ?) order by cont.code,cont.name";
        return this.findPageBy("select distinct cont from Contractor cont, ContractorDetail contractorDet where cont.id=contractorDet.contractor.id and contractorDet.status.description=? and contractorDet.status.moduletype=? and (upper(cont.code) like ? or upper(cont.name) like ?) order by cont.code,cont.name", 0, pageSize, new Object[]{"Active", "Contractor", param, param}).getList();
    }

    public List getAssetCodesForProjectCode(Integer accountdetailkey) throws ValidationException {
        return null;
    }

    public List<Contractor> validateEntityForRTGS(List<Long> idsList) throws ValidationException {
        List entities = null;
        Query entitysQuery = this.getSession().createQuery(" from Contractor where panNumber is null or bank is null and id in ( :IDS )");
        entitysQuery.setParameterList("IDS", idsList);
        entities = entitysQuery.list();
        return entities;
    }

    public List<Contractor> getEntitiesById(List<Long> idsList) throws ValidationException {
        List entities = null;
        Query entitysQuery = this.getSession().createQuery(" from Contractor where id in ( :IDS )");
        entitysQuery.setParameterList("IDS", idsList);
        entities = entitysQuery.list();
        return entities;
    }

    public List<Contractor> getAllContractors() {
        List entities = null;
        Query entityQuery = this.getSession().createQuery(" from Contractor con order by code asc");
        entities = entityQuery.list();
        return entities;
    }

    public List<Contractor> getContractorListForCriterias(Map<String, Object> criteriaMap) {
        List contractorList = null;
        String contractorStr = null;
        ArrayList<Object> paramList = new ArrayList<Object>();
        String contractorName = (String)criteriaMap.get("contractorName");
        String contractorCode = (String)criteriaMap.get("contractorCode");
        Long departmentId = (Long)criteriaMap.get("departmentId");
        Integer statusId = (Integer)criteriaMap.get("statusId");
        Long gradeId = (Long)criteriaMap.get("gradeId");
        contractorStr = " select distinct contractor from Contractor contractor ";
        if (statusId != null || departmentId != null || gradeId != null) {
            contractorStr = contractorStr + " left outer join fetch contractor.contractorDetails as detail ";
        }
        if (statusId != null || departmentId != null || gradeId != null || contractorCode != null && !contractorCode.equals("") || contractorName != null && !contractorName.equals("")) {
            contractorStr = contractorStr + " where contractor.code is not null";
        }
        if (StringUtils.isNotEmpty((String)contractorCode)) {
            contractorStr = contractorStr + " and UPPER(contractor.code) like ?";
            paramList.add("%" + contractorCode.toUpperCase() + "%");
        }
        if (StringUtils.isNotEmpty((String)contractorName)) {
            contractorStr = contractorStr + " and UPPER(contractor.name) like ?";
            paramList.add("%" + contractorName.toUpperCase() + "%");
        }
        if (statusId != null) {
            contractorStr = contractorStr + " and detail.status.id = ?";
            paramList.add(statusId);
        }
        if (departmentId != null) {
            contractorStr = contractorStr + " and detail.department.id = ?";
            paramList.add(departmentId);
        }
        if (gradeId != null) {
            contractorStr = contractorStr + " and detail.grade.id = ?";
            paramList.add(gradeId);
        }
        if (paramList.isEmpty()) {
            contractorList = this.findAllBy(contractorStr, new Object[0]);
        } else {
            Object[] params = new Object[paramList.size()];
            params = paramList.toArray(params);
            contractorList = this.findAllBy(contractorStr, params);
        }
        return contractorList;
    }

    public SearchQuery prepareQuery(Map<String, Object> criteriaMap) {
        String contractorStr = null;
        ArrayList<Object> paramList = new ArrayList<Object>();
        String contractorName = (String)criteriaMap.get("contractorName");
        String contractorCode = (String)criteriaMap.get("contractorCode");
        Long departmentId = (Long)criteriaMap.get("departmentId");
        Integer statusId = (Integer)criteriaMap.get("statusId");
        Long gradeId = (Long)criteriaMap.get("gradeId");
        contractorStr = " from ContractorDetail detail ";
        if (statusId != null || departmentId != null || gradeId != null || contractorCode != null && !contractorCode.equals("") || contractorName != null && !contractorName.equals("")) {
            contractorStr = contractorStr + " where detail.contractor.code is not null";
        }
        if (contractorCode != null && !contractorCode.equals("")) {
            contractorStr = contractorStr + " and UPPER(detail.contractor.code) like ?";
            paramList.add("%" + contractorCode.toUpperCase() + "%");
        }
        if (contractorName != null && !contractorName.equals("")) {
            contractorStr = contractorStr + " and UPPER(detail.contractor.name) like ?";
            paramList.add("%" + contractorName.toUpperCase() + "%");
        }
        if (statusId != null) {
            contractorStr = contractorStr + " and detail.status.id = ? ";
            paramList.add(statusId);
        }
        if (departmentId != null) {
            contractorStr = contractorStr + " and detail.department.id = ? ";
            paramList.add(departmentId);
        }
        if (gradeId != null) {
            contractorStr = contractorStr + " and detail.grade.id = ? ";
            paramList.add(gradeId);
        }
        String query = "select distinct detail.contractor " + contractorStr;
        String countQuery = "select count(distinct detail.contractor) " + contractorStr;
        return new SearchQueryHQL(query, countQuery, paramList);
    }

    public void searchContractor(Map<String, Object> criteriaMap) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Inside searchContractor");
        }
        String contractorName = (String)criteriaMap.get("contractorName");
        String contractorCode = (String)criteriaMap.get("contractorCode");
        Long departmentId = (Long)criteriaMap.get("departmentId");
        Long gradeId = (Long)criteriaMap.get("gradeId");
        Date searchDate = (Date)criteriaMap.get("searchDate");
        List<AppConfigValues> configList = this.worksService.getAppConfigValue("Works", "CONTRACTOR_STATUS");
        String status = configList.get(0).getValue();
        Criteria criteria = this.getSession().createCriteria(Contractor.class);
        if (StringUtils.isNotEmpty((String)contractorCode)) {
            criteria.add(Restrictions.sqlRestriction((String)"lower({alias}.code) like lower(?)", (Object)("%" + contractorCode.trim() + "%"), (Type)StringType.INSTANCE));
        }
        if (StringUtils.isNotEmpty((String)contractorName)) {
            criteria.add(Restrictions.sqlRestriction((String)"lower({alias}.name) like lower(?)", (Object)("%" + contractorName.trim() + "%"), (Type)StringType.INSTANCE));
        }
        criteria.createAlias("contractorDetails", "detail").createAlias("detail.status", "status");
        criteria.add((Criterion)Restrictions.eq((String)"status.description", (Object)status));
        if (departmentId != null) {
            criteria.add((Criterion)Restrictions.eq((String)"detail.department.id", (Object)departmentId));
        }
        if (gradeId != null) {
            criteria.add((Criterion)Restrictions.eq((String)"detail.grade.id", (Object)gradeId));
        }
        if (searchDate != null) {
            criteria.add((Criterion)Restrictions.le((String)"detail.validity.startDate", (Object)searchDate)).add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)"detail.validity.endDate", (Object)searchDate), (Criterion)Restrictions.isNull((String)"detail.validity.endDate")));
        }
        criteria.addOrder(Order.asc((String)"name"));
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        criteria.list();
    }

    public void createAccountDetailKey(Contractor cont) {
        Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("contractor");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(cont.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }

    public List<Contractor> getContractorsByCodeOrName(String queryString) {
        return this.filterActiveEntities(queryString, 0, null);
    }

    public List<Contractor> getContractorsByCode(String queryString) {
        return this.filterActiveEntitiesByCode(queryString, 0, null);
    }

    public List<Contractor> filterActiveEntitiesByCode(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        Integer pageSize = maxRecords > 0 ? Integer.valueOf(maxRecords) : null;
        String param = "%" + filterKey.toUpperCase() + "%";
        String qry = "select distinct cont from Contractor cont, ContractorDetail contractorDet where cont.id=contractorDet.contractor.id and contractorDet.status.description=? and contractorDet.status.moduletype=? and upper(cont.code) like ? order by cont.code,cont.name";
        return this.findPageBy("select distinct cont from Contractor cont, ContractorDetail contractorDet where cont.id=contractorDet.contractor.id and contractorDet.status.description=? and contractorDet.status.moduletype=? and upper(cont.code) like ? order by cont.code,cont.name", 0, pageSize, new Object[]{"Active", "Contractor", param}).getList();
    }

    public String generateContractorCode(Contractor contractor) {
        ContractorCodeGenerator c = (ContractorCodeGenerator)this.beanResolver.getAutoNumberServiceFor(ContractorCodeGenerator.class);
        return c.getNextNumber(contractor);
    }

    public String getContractorMasterAutoCodeGenerateValue() {
        String autoGenerateContractorCodeValue = this.worksApplicationProperties.contractorMasterCodeAutoGenerated();
        if (!StringUtils.isBlank((String)autoGenerateContractorCodeValue)) {
            return autoGenerateContractorCodeValue;
        }
        return null;
    }

    public String[] getContractorMasterCategoryValues() {
        String[] contractorMasterCategoryValues = this.worksApplicationProperties.contractorMasterCategoryValues();
        if (contractorMasterCategoryValues != null && !Arrays.asList(contractorMasterCategoryValues).contains("")) {
            return contractorMasterCategoryValues;
        }
        return contractorMasterCategoryValues;
    }

    public String getContractorClassShortName(String contractorGrade) {
        String[] contractorMasterClassValues = this.worksApplicationProperties.contractorMasterClassValues();
        if (contractorMasterClassValues != null && !Arrays.asList(contractorMasterClassValues).contains("")) {
            HashMap<String, String> contractorClassKeyValuePair = new HashMap<String, String>();
            for (String s : contractorMasterClassValues) {
                contractorClassKeyValuePair.put(s.split(":")[0], s.split(":")[1]);
            }
            return (String)contractorClassKeyValuePair.get(contractorGrade);
        }
        return null;
    }

    public String[] getcontractorMasterSetMandatoryFields() {
        String[] contractorMasterMandatoryFields = this.worksApplicationProperties.getContractorMasterMandatoryFields();
        if (contractorMasterMandatoryFields != null && !Arrays.asList(contractorMasterMandatoryFields).contains("")) {
            return contractorMasterMandatoryFields;
        }
        return contractorMasterMandatoryFields;
    }

    public String[] getcontractorMasterSetHiddenFields() {
        String[] contractorMasterHiddenFields = this.worksApplicationProperties.getContractorMasterHideFields();
        if (contractorMasterHiddenFields != null && !Arrays.asList(contractorMasterHiddenFields).contains("")) {
            return contractorMasterHiddenFields;
        }
        return contractorMasterHiddenFields;
    }

    public String[] getContractorMasterMandatoryFields() {
        TreeSet<String> set = new TreeSet<String>(Arrays.asList(this.getcontractorMasterSetMandatoryFields()));
        set.removeAll(Arrays.asList(this.getcontractorMasterSetHiddenFields()));
        return set.toArray(new String[set.size()]);
    }

    public Contractor getContractorByCode(String code) {
        return (Contractor)((Object)this.find("from Contractor as cont where upper(cont.code) = ?", new Object[]{code.toUpperCase()}));
    }

    @Transactional
    public Contractor createContractor(Contractor contractor) {
        Contractor savedContractor = (Contractor)((Object)this.persist((Object)contractor));
        this.createAccountDetailKey(savedContractor);
        return savedContractor;
    }

    @Transactional
    public Contractor updateContractor(Contractor contractor) {
        return (Contractor)((Object)this.persist((Object)contractor));
    }
}

