/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.master.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.egov.commons.ContractorGrade;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;

public class ContractorGradeService
extends PersistenceService<ContractorGrade, Long> {
    @PersistenceContext
    private EntityManager entityManager;

    public ContractorGradeService() {
        super(ContractorGrade.class);
    }

    public ContractorGradeService(Class<ContractorGrade> type) {
        super(type);
    }

    public ContractorGrade getContractorGradeById(Long contractorGradeId) {
        ContractorGrade contractorGrade = (ContractorGrade)this.entityManager.find(ContractorGrade.class, (Object)contractorGradeId);
        return contractorGrade;
    }

    public List<ContractorGrade> getAllContractorGrades() {
        Query query = this.entityManager.createQuery("from ContractorGrade order by upper(grade)");
        List contractorGradeList = query.getResultList();
        return contractorGradeList;
    }

    public SearchQuery prepareSearchQuery(Map<String, Object> criteriaMap) {
        StringBuffer contractorGradeSql = new StringBuffer(100);
        String contractorGradeStr = "";
        ArrayList<Object> paramList = new ArrayList<Object>();
        contractorGradeSql.append(" from ContractorGrade cg");
        String grade = (String)criteriaMap.get("grade");
        Double minAmount = (Double)criteriaMap.get("minAmount");
        Double maxAmount = (Double)criteriaMap.get("maxAmount");
        if (grade != null && !grade.trim().equals("") || minAmount != -1.0 || maxAmount != -1.0) {
            contractorGradeSql.append(" where 1=1");
        }
        if (grade != null && !grade.trim().equals("")) {
            contractorGradeSql.append(" and UPPER(cg.grade) like ?");
            paramList.add("%" + grade.trim().toUpperCase() + "%");
        }
        if (minAmount != -1.0) {
            contractorGradeSql.append(" and cg.minAmount = ?");
            paramList.add(BigDecimal.valueOf(minAmount));
        }
        if (maxAmount != -1.0) {
            contractorGradeSql.append(" and cg.maxAmount = ?");
            paramList.add(BigDecimal.valueOf(maxAmount));
        }
        contractorGradeSql.append(" group by cg.id");
        contractorGradeStr = contractorGradeSql.toString();
        String countQuery = "select count(*) " + contractorGradeStr;
        return new SearchQueryHQL(contractorGradeStr, countQuery, paramList);
    }

    public ContractorGrade findByContractorClass(String contractorClass) {
        String query = "from ContractorGrade as cg where upper(cg.grade) = '" + contractorClass.toUpperCase() + "'";
        return (ContractorGrade)this.find(query);
    }
}

