/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.elasticsearch.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.works.elasticsearch.model.WorksIndexsRequest;
import org.egov.works.elasticsearch.model.WorksMilestoneIndex;
import org.egov.works.elasticsearch.model.WorksMilestoneIndexResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class WorksMilestoneIndexService {
    private static final String JAN01TO15ACTUAL = "jan01to15actual";
    private static final String JAN01TO15TARGET = "jan01to15target";
    private static final String JAN16TO31ACTUAL = "jan16to31actual";
    private static final String JAN16TO31TARGET = "jan16to31target";
    private static final String FEB01TO15ACTUAL = "feb01to15actual";
    private static final String FEB01TO15TARGET = "feb01to15target";
    private static final String FEB16TO28OR29ACTUAL = "feb16to28or29actual";
    private static final String FEB16TO28OR29TARGET = "feb16to28or29target";
    private static final String MAR01TO15ACTUAL = "mar01to15actual";
    private static final String MAR01TO15TARGET = "mar01to15target";
    private static final String MAR16TO31ACTUAL = "mar16to31actual";
    private static final String MAR16TO31TARGET = "mar16to31target";
    private static final String APR01TO15ACTUAL = "apr01to15actual";
    private static final String APR01TO15TARGET = "apr01to15target";
    private static final String APR16TO30ACTUAL = "apr16to30actual";
    private static final String APR16TO30TARGET = "apr16to30target";
    private static final String MAY01TO15ACTUAL = "may01to15actual";
    private static final String MAY01TO15TARGET = "may01to15target";
    private static final String MAY16TO31ACTUAL = "may16to31actual";
    private static final String MAY16TO31TARGET = "may16to31target";
    private static final String JUN01TO15ACTUAL = "jun01to15actual";
    private static final String JUN01TO15TARGET = "jun01to15target";
    private static final String JUN16TO30ACTUAL = "jun16to30actual";
    private static final String JUN16TO30TARGET = "jun16to30target";
    private static final String JUL01TO15ACTUAL = "jul01to15actual";
    private static final String JUL01TO15TARGET = "jul01to15target";
    private static final String JUL16TO31ACTUAL = "jul16to31actual";
    private static final String JUL16TO31TARGET = "jul16to31target";
    private static final String AUG01TO15ACTUAL = "aug01to15actual";
    private static final String AUG01TO15TARGET = "aug01to15target";
    private static final String AUG16TO31ACTUAL = "aug16to31actual";
    private static final String AUG16TO31TARGET = "aug16to31target";
    private static final String SEP01TO15ACTUAL = "sep01to15actual";
    private static final String SEP01TO15TARGET = "sep01to15target";
    private static final String SEP16TO30ACTUAL = "sep16to30actual";
    private static final String SEP16TO30TARGET = "sep16to30target";
    private static final String OCT01TO15ACTUAL = "oct01to15actual";
    private static final String OCT01TO15TARGET = "oct01to15target";
    private static final String OCT16TO31ACTUAL = "oct16to31actual";
    private static final String OCT16TO31TARGET = "oct16to31target";
    private static final String NOV01TO15ACTUAL = "nov01to15actual";
    private static final String NOV01TO15TARGET = "nov01to15target";
    private static final String NOV16TO30ACTUAL = "nov16to30actual";
    private static final String NOV16TO30TARGET = "nov16to30target";
    private static final String DEC01TO15ACTUAL = "dec01to15actual";
    private static final String DEC01TO15TARGET = "dec01to15target";
    private static final String DEC16TO31ACTUAL = "dec16to31actual";
    private static final String DEC16TO31TARGET = "dec16to31target";
    private static final String BY_AGGREGATION_FIELD = "by_aggregationField";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorksMilestoneIndexService.class);
    public static final String WORKSMILESTONE_INDEX_NAME = "worksmilestone";
    public static final String WORKSTRANSACTION_INDEX_NAME = "workstransaction";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public List<WorksMilestoneIndexResponse> getAggregationResults(WorksIndexsRequest worksIndexsRequest, String orderingAggregationName) {
        String fieldName;
        WorksMilestoneIndexResponse wmIndexResponse;
        LongTerms laggr;
        List resultBuckets;
        StringTerms saggr;
        ArrayList<WorksMilestoneIndexResponse> finalResponses = new ArrayList<WorksMilestoneIndexResponse>();
        ArrayList<WorksMilestoneIndexResponse> worksTransactionResponses = new ArrayList<WorksMilestoneIndexResponse>();
        ArrayList<WorksMilestoneIndexResponse> worksMilestoneResponses = new ArrayList<WorksMilestoneIndexResponse>();
        HashMap<String, WorksMilestoneIndexResponse> worksMilestoneResponseMap = new HashMap<String, WorksMilestoneIndexResponse>();
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClauseForTransaction(worksIndexsRequest);
        AggregationBuilder aggregation = ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)BY_AGGREGATION_FIELD).field(orderingAggregationName)).size(1000).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalestimatedcostinlakhs").field("estimatevalue"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalworkordervalueinlakhs").field("loaamount"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalbillamountinlakhs").field("loatotalbillamt"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalpaidamountinlakhs").field("loatotalpaidamt"));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSTRANSACTION_INDEX_NAME}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)SortBuilders.fieldSort((String)orderingAggregationName).order(SortOrder.DESC)).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations worksAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        if (!orderingAggregationName.equals("lineestimatedetailid")) {
            saggr = (StringTerms)worksAggr.get(BY_AGGREGATION_FIELD);
            resultBuckets = saggr.getBuckets();
        } else {
            laggr = (LongTerms)worksAggr.get(BY_AGGREGATION_FIELD);
            resultBuckets = laggr.getBuckets();
        }
        for (Terms.Bucket entry : resultBuckets) {
            wmIndexResponse = new WorksMilestoneIndexResponse();
            wmIndexResponse.setReporttype(worksIndexsRequest.getReportType());
            fieldName = String.valueOf(entry.getKey());
            wmIndexResponse.setName(fieldName);
            Sum totalEstimatedCostInLakhsAggregation = (Sum)entry.getAggregations().get("totalestimatedcostinlakhs");
            Sum totalWorkorderValueInLakhsAggregation = (Sum)entry.getAggregations().get("totalworkordervalueinlakhs");
            Sum totalBillAmountInLakhsAggregation = (Sum)entry.getAggregations().get("totalbillamountinlakhs");
            Sum totalPaidAmountInLakhsAggregation = (Sum)entry.getAggregations().get("totalpaidamountinlakhs");
            wmIndexResponse.setTotalnoofworks(entry.getDocCount());
            wmIndexResponse.setTotalestimatedcostinlakhs(totalEstimatedCostInLakhsAggregation.getValue());
            wmIndexResponse.setTotalworkordervalueinlakhs(totalWorkorderValueInLakhsAggregation.getValue());
            wmIndexResponse.setTotalbillamountinlakhs(totalBillAmountInLakhsAggregation.getValue());
            wmIndexResponse.setTotalpaidamountinlakhs(totalPaidAmountInLakhsAggregation.getValue());
            worksTransactionResponses.add(wmIndexResponse);
        }
        boolQuery = this.prepareWhereClauseForMilestone(worksIndexsRequest);
        aggregation = ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)BY_AGGREGATION_FIELD).field(orderingAggregationName)).size(1000).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JAN01TO15ACTUAL).field(JAN01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JAN01TO15TARGET).field(JAN01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JAN16TO31ACTUAL).field(JAN16TO31ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JAN16TO31TARGET).field(JAN16TO31TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)FEB01TO15ACTUAL).field(FEB01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)FEB01TO15TARGET).field(FEB01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)FEB16TO28OR29ACTUAL).field(FEB16TO28OR29ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)FEB16TO28OR29TARGET).field(FEB16TO28OR29TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)MAR01TO15ACTUAL).field(MAR01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)MAR01TO15TARGET).field(MAR01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)MAR16TO31ACTUAL).field(MAR16TO31ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)MAR16TO31TARGET).field(MAR16TO31TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)APR01TO15ACTUAL).field(APR01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)APR01TO15TARGET).field(APR01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)APR16TO30ACTUAL).field(APR16TO30ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)APR16TO30TARGET).field(APR16TO30TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)MAY01TO15ACTUAL).field(MAY01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)MAY01TO15TARGET).field(MAY01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)MAY16TO31ACTUAL).field(MAY16TO31ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)MAY16TO31TARGET).field(MAY16TO31TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JUN01TO15ACTUAL).field(JUN01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JUN01TO15TARGET).field(JUN01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JUN16TO30ACTUAL).field(JUN16TO30ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JUN16TO30TARGET).field(JUN16TO30TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JUL01TO15ACTUAL).field(JUL01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JUL01TO15TARGET).field(JUL01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JUL16TO31ACTUAL).field(JUL16TO31ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)JUL16TO31TARGET).field(JUL16TO31TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)AUG01TO15ACTUAL).field(AUG01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)AUG01TO15TARGET).field(AUG01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)AUG16TO31ACTUAL).field(AUG16TO31ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)AUG16TO31TARGET).field(AUG16TO31TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)SEP01TO15ACTUAL).field(SEP01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)SEP01TO15TARGET).field(SEP01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)SEP16TO30ACTUAL).field(SEP16TO30ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)SEP16TO30TARGET).field(SEP16TO30TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)OCT01TO15ACTUAL).field(OCT01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)OCT01TO15TARGET).field(OCT01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)OCT16TO31ACTUAL).field(OCT16TO31ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)OCT16TO31TARGET).field(OCT16TO31TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)NOV01TO15ACTUAL).field(NOV01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)NOV01TO15TARGET).field(NOV01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)NOV16TO30ACTUAL).field(NOV16TO30ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)NOV16TO30TARGET).field(NOV16TO30TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)DEC01TO15ACTUAL).field(DEC01TO15ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)DEC01TO15TARGET).field(DEC01TO15TARGET))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)DEC16TO31ACTUAL).field(DEC16TO31ACTUAL))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)DEC16TO31TARGET).field(DEC16TO31TARGET));
        searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSMILESTONE_INDEX_NAME}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)SortBuilders.fieldSort((String)orderingAggregationName).order(SortOrder.DESC)).addAggregation((AbstractAggregationBuilder)aggregation).build();
        worksAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        if (!orderingAggregationName.equals("lineestimatedetailid")) {
            saggr = (StringTerms)worksAggr.get(BY_AGGREGATION_FIELD);
            resultBuckets = saggr.getBuckets();
        } else {
            laggr = (LongTerms)worksAggr.get(BY_AGGREGATION_FIELD);
            resultBuckets = laggr.getBuckets();
        }
        for (Terms.Bucket entry : resultBuckets) {
            wmIndexResponse = new WorksMilestoneIndexResponse();
            wmIndexResponse.setReporttype(worksIndexsRequest.getReportType());
            fieldName = String.valueOf(entry.getKey());
            wmIndexResponse.setName(fieldName);
            Avg jan01to15actual = (Avg)entry.getAggregations().get(JAN01TO15ACTUAL);
            Avg jan01to15target = (Avg)entry.getAggregations().get(JAN01TO15TARGET);
            Avg jan16to31actual = (Avg)entry.getAggregations().get(JAN16TO31ACTUAL);
            Avg jan16to31target = (Avg)entry.getAggregations().get(JAN16TO31TARGET);
            Avg feb01to15actual = (Avg)entry.getAggregations().get(FEB01TO15ACTUAL);
            Avg feb01to15target = (Avg)entry.getAggregations().get(FEB01TO15TARGET);
            Avg feb16to28or29actual = (Avg)entry.getAggregations().get(FEB16TO28OR29ACTUAL);
            Avg feb16to28or29target = (Avg)entry.getAggregations().get(FEB16TO28OR29TARGET);
            Avg mar01to15actual = (Avg)entry.getAggregations().get(MAR01TO15ACTUAL);
            Avg mar01to15target = (Avg)entry.getAggregations().get(MAR01TO15TARGET);
            Avg mar16to31actual = (Avg)entry.getAggregations().get(MAR16TO31ACTUAL);
            Avg mar16to31target = (Avg)entry.getAggregations().get(MAR16TO31TARGET);
            Avg apr01to15actual = (Avg)entry.getAggregations().get(APR01TO15ACTUAL);
            Avg apr01to15target = (Avg)entry.getAggregations().get(APR01TO15TARGET);
            Avg apr16to30actual = (Avg)entry.getAggregations().get(APR16TO30ACTUAL);
            Avg apr16to30target = (Avg)entry.getAggregations().get(APR16TO30TARGET);
            Avg may01to15actual = (Avg)entry.getAggregations().get(MAY01TO15ACTUAL);
            Avg may01to15target = (Avg)entry.getAggregations().get(MAY01TO15TARGET);
            Avg may16to31actual = (Avg)entry.getAggregations().get(MAY16TO31ACTUAL);
            Avg may16to31target = (Avg)entry.getAggregations().get(MAY16TO31TARGET);
            Avg jun01to15actual = (Avg)entry.getAggregations().get(JUN01TO15ACTUAL);
            Avg jun01to15target = (Avg)entry.getAggregations().get(JUN01TO15TARGET);
            Avg jun16to30actual = (Avg)entry.getAggregations().get(JUN16TO30ACTUAL);
            Avg jun16to30target = (Avg)entry.getAggregations().get(JUN16TO30TARGET);
            Avg jul01to15actual = (Avg)entry.getAggregations().get(JUL01TO15ACTUAL);
            Avg jul01to15target = (Avg)entry.getAggregations().get(JUL01TO15TARGET);
            Avg jul16to31actual = (Avg)entry.getAggregations().get(JUL16TO31ACTUAL);
            Avg jul16to31target = (Avg)entry.getAggregations().get(JUL16TO31TARGET);
            Avg aug01to15actual = (Avg)entry.getAggregations().get(AUG01TO15ACTUAL);
            Avg aug01to15target = (Avg)entry.getAggregations().get(AUG01TO15TARGET);
            Avg aug16to31actual = (Avg)entry.getAggregations().get(AUG16TO31ACTUAL);
            Avg aug16to31target = (Avg)entry.getAggregations().get(AUG16TO31TARGET);
            Avg sep01to15actual = (Avg)entry.getAggregations().get(SEP01TO15ACTUAL);
            Avg sep01to15target = (Avg)entry.getAggregations().get(SEP01TO15TARGET);
            Avg sep16to30actual = (Avg)entry.getAggregations().get(SEP16TO30ACTUAL);
            Avg sep16to30target = (Avg)entry.getAggregations().get(SEP16TO30TARGET);
            Avg oct01to15actual = (Avg)entry.getAggregations().get(OCT01TO15ACTUAL);
            Avg oct01to15target = (Avg)entry.getAggregations().get(OCT01TO15TARGET);
            Avg oct16to31actual = (Avg)entry.getAggregations().get(OCT16TO31ACTUAL);
            Avg oct16to31target = (Avg)entry.getAggregations().get(OCT16TO31TARGET);
            Avg nov01to15actual = (Avg)entry.getAggregations().get(NOV01TO15ACTUAL);
            Avg nov01to15target = (Avg)entry.getAggregations().get(NOV01TO15TARGET);
            Avg nov16to30actual = (Avg)entry.getAggregations().get(NOV16TO30ACTUAL);
            Avg nov16to30target = (Avg)entry.getAggregations().get(NOV16TO30TARGET);
            Avg dec01to15actual = (Avg)entry.getAggregations().get(DEC01TO15ACTUAL);
            Avg dec01to15target = (Avg)entry.getAggregations().get(DEC01TO15TARGET);
            Avg dec16to31actual = (Avg)entry.getAggregations().get(DEC16TO31ACTUAL);
            Avg dec16to31target = (Avg)entry.getAggregations().get(DEC16TO31TARGET);
            wmIndexResponse.setTotalnoofworks(entry.getDocCount());
            wmIndexResponse.setJan01to15actual(jan01to15actual.getValue());
            wmIndexResponse.setJan01to15target(jan01to15target.getValue());
            wmIndexResponse.setJan16to31actual(jan16to31actual.getValue());
            wmIndexResponse.setJan16to31target(jan16to31target.getValue());
            wmIndexResponse.setFeb01to15actual(feb01to15actual.getValue());
            wmIndexResponse.setFeb01to15target(feb01to15target.getValue());
            wmIndexResponse.setFeb16to28or29actual(feb16to28or29actual.getValue());
            wmIndexResponse.setFeb16to28or29target(feb16to28or29target.getValue());
            wmIndexResponse.setMar01to15actual(mar01to15actual.getValue());
            wmIndexResponse.setMar01to15target(mar01to15target.getValue());
            wmIndexResponse.setMar16to31actual(mar16to31actual.getValue());
            wmIndexResponse.setMar16to31target(mar16to31target.getValue());
            wmIndexResponse.setApr01to15actual(apr01to15actual.getValue());
            wmIndexResponse.setApr01to15target(apr01to15target.getValue());
            wmIndexResponse.setApr16to30actual(apr16to30actual.getValue());
            wmIndexResponse.setApr16to30target(apr16to30target.getValue());
            wmIndexResponse.setMay01to15actual(may01to15actual.getValue());
            wmIndexResponse.setMay01to15target(may01to15target.getValue());
            wmIndexResponse.setMay16to31actual(may16to31actual.getValue());
            wmIndexResponse.setMay16to31target(may16to31target.getValue());
            wmIndexResponse.setJun01to15actual(jun01to15actual.getValue());
            wmIndexResponse.setJun01to15target(jun01to15target.getValue());
            wmIndexResponse.setJun16to30actual(jun16to30actual.getValue());
            wmIndexResponse.setJun16to30target(jun16to30target.getValue());
            wmIndexResponse.setJul01to15actual(jul01to15actual.getValue());
            wmIndexResponse.setJul01to15target(jul01to15target.getValue());
            wmIndexResponse.setJul16to31actual(jul16to31actual.getValue());
            wmIndexResponse.setJul16to31target(jul16to31target.getValue());
            wmIndexResponse.setAug01to15actual(aug01to15actual.getValue());
            wmIndexResponse.setAug01to15target(aug01to15target.getValue());
            wmIndexResponse.setAug16to31actual(aug16to31actual.getValue());
            wmIndexResponse.setAug16to31target(aug16to31target.getValue());
            wmIndexResponse.setSep01to15actual(sep01to15actual.getValue());
            wmIndexResponse.setSep01to15target(sep01to15target.getValue());
            wmIndexResponse.setSep16to30actual(sep16to30actual.getValue());
            wmIndexResponse.setSep16to30target(sep16to30target.getValue());
            wmIndexResponse.setOct01to15actual(oct01to15actual.getValue());
            wmIndexResponse.setOct01to15target(oct01to15target.getValue());
            wmIndexResponse.setOct16to31actual(oct16to31actual.getValue());
            wmIndexResponse.setOct16to31target(oct16to31target.getValue());
            wmIndexResponse.setNov01to15actual(nov01to15actual.getValue());
            wmIndexResponse.setNov01to15target(nov01to15target.getValue());
            wmIndexResponse.setNov16to30actual(nov16to30actual.getValue());
            wmIndexResponse.setNov16to30target(nov16to30target.getValue());
            wmIndexResponse.setDec01to15actual(dec01to15actual.getValue());
            wmIndexResponse.setDec01to15target(dec01to15target.getValue());
            wmIndexResponse.setDec16to31actual(dec16to31actual.getValue());
            wmIndexResponse.setDec16to31target(dec16to31target.getValue());
            worksMilestoneResponses.add(wmIndexResponse);
        }
        this.prepareResponseMap(worksIndexsRequest, worksMilestoneResponses, worksMilestoneResponseMap);
        this.prepareResultList(worksIndexsRequest, worksTransactionResponses, worksMilestoneResponseMap, finalResponses);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getAggregationResults() is : " + timeTaken + " (millisecs) ");
        }
        return finalResponses;
    }

    public List<WorksMilestoneIndexResponse> getAggregationResultsForUlb(WorksIndexsRequest worksIndexsRequest, List<WorksMilestoneIndexResponse> resultList) {
        HashMap<Integer, WorksMilestoneIndexResponse> resultMap = new HashMap<Integer, WorksMilestoneIndexResponse>();
        for (WorksMilestoneIndexResponse worksMilestoneIndexResponse : resultList) {
            resultMap.put(worksMilestoneIndexResponse.getLineestimatedetailid(), worksMilestoneIndexResponse);
        }
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClauseForMilestone(worksIndexsRequest);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSMILESTONE_INDEX_NAME}).withPageable((Pageable)new PageRequest(0, resultList.size())).withQuery((QueryBuilder)boolQuery).build();
        List worksMilestoneIndexs = this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, WorksMilestoneIndex.class);
        for (WorksMilestoneIndex worksMilestoneIndex : worksMilestoneIndexs) {
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJan01to15actual(worksMilestoneIndex.getJan01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJan01to15target(worksMilestoneIndex.getJan01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJan16to31actual(worksMilestoneIndex.getJan16to31actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJan16to31target(worksMilestoneIndex.getJan16to31target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setFeb01to15actual(worksMilestoneIndex.getFeb01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setFeb01to15target(worksMilestoneIndex.getFeb01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setFeb16to28or29actual(worksMilestoneIndex.getFeb16to28or29actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setFeb16to28or29target(worksMilestoneIndex.getFeb16to28or29target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setMar01to15actual(worksMilestoneIndex.getMar01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setMar01to15target(worksMilestoneIndex.getMar01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setMar16to31actual(worksMilestoneIndex.getMar16to31actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setMar16to31target(worksMilestoneIndex.getMar16to31target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setApr01to15actual(worksMilestoneIndex.getApr01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setApr01to15target(worksMilestoneIndex.getApr01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setApr16to30actual(worksMilestoneIndex.getApr16to30actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setApr16to30target(worksMilestoneIndex.getApr16to30target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setMay01to15actual(worksMilestoneIndex.getMay01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setMay01to15target(worksMilestoneIndex.getMay01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setMay16to31actual(worksMilestoneIndex.getMay16to31actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setMay16to31target(worksMilestoneIndex.getMay16to31target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJun01to15actual(worksMilestoneIndex.getJun01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJun01to15target(worksMilestoneIndex.getJun01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJun16to30actual(worksMilestoneIndex.getJun16to30actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJun16to30target(worksMilestoneIndex.getJun16to30target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJul01to15actual(worksMilestoneIndex.getJul01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJul01to15target(worksMilestoneIndex.getJul01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJul16to31actual(worksMilestoneIndex.getJul16to31actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setJul16to31target(worksMilestoneIndex.getJul16to31target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setAug01to15actual(worksMilestoneIndex.getAug01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setAug01to15target(worksMilestoneIndex.getAug01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setAug16to31actual(worksMilestoneIndex.getAug16to31actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setAug16to31target(worksMilestoneIndex.getAug16to31target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setSep01to15actual(worksMilestoneIndex.getSep01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setSep01to15target(worksMilestoneIndex.getSep01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setSep16to30actual(worksMilestoneIndex.getSep16to30actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setSep16to30target(worksMilestoneIndex.getSep16to30target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setOct01to15actual(worksMilestoneIndex.getOct01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setOct01to15target(worksMilestoneIndex.getOct01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setOct16to31actual(worksMilestoneIndex.getOct16to31actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setOct16to31target(worksMilestoneIndex.getOct16to31target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setNov01to15actual(worksMilestoneIndex.getNov01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setNov01to15target(worksMilestoneIndex.getNov01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setNov16to30actual(worksMilestoneIndex.getNov16to30actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setNov16to30target(worksMilestoneIndex.getNov16to30target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setDec01to15actual(worksMilestoneIndex.getDec01to15actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setDec01to15target(worksMilestoneIndex.getDec01to15target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setDec16to31actual(worksMilestoneIndex.getDec16to31actual());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setDec16to31target(worksMilestoneIndex.getDec16to31target());
            ((WorksMilestoneIndexResponse)resultMap.get(worksMilestoneIndex.getLineestimatedetailid())).setIsmilestonecreated("Yes");
        }
        resultList = new ArrayList<WorksMilestoneIndexResponse>();
        for (Integer n : resultMap.keySet()) {
            resultList.add((WorksMilestoneIndexResponse)resultMap.get(n));
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getAggregationResultsForUlb() is : " + timeTaken + " (millisecs) ");
        }
        return resultList;
    }

    private void prepareResultList(WorksIndexsRequest worksIndexsRequest, List<WorksMilestoneIndexResponse> worksTransactionResponses, Map<String, WorksMilestoneIndexResponse> worksMilestoneResponseMap, List<WorksMilestoneIndexResponse> finalResponses) {
        for (WorksMilestoneIndexResponse transactionResponse : worksTransactionResponses) {
            WorksMilestoneIndexResponse finalResponse;
            if (worksMilestoneResponseMap.get(this.prepareGroupingKey(worksIndexsRequest, transactionResponse)) != null) {
                WorksMilestoneIndexResponse milestoneResponse;
                finalResponse = milestoneResponse = worksMilestoneResponseMap.get(this.prepareGroupingKey(worksIndexsRequest, transactionResponse));
                finalResponse.setTotalbillamountinlakhs(transactionResponse.getTotalbillamountinlakhs());
                finalResponse.setTotalestimatedcostinlakhs(transactionResponse.getTotalestimatedcostinlakhs());
                finalResponse.setTotalpaidamountinlakhs(transactionResponse.getTotalpaidamountinlakhs());
                finalResponse.setTotalworkordervalueinlakhs(transactionResponse.getTotalworkordervalueinlakhs());
                finalResponse.setMilestonenotcreatedcount(transactionResponse.getTotalnoofworks() - milestoneResponse.getTotalnoofworks());
                finalResponse.setTotalnoofworks(transactionResponse.getTotalnoofworks());
            } else {
                finalResponse = transactionResponse;
                finalResponse.setMilestonenotcreatedcount(transactionResponse.getTotalnoofworks());
            }
            finalResponses.add(finalResponse);
        }
    }

    private void prepareResponseMap(WorksIndexsRequest worksIndexsRequest, List<WorksMilestoneIndexResponse> worksTransactionResponses, Map<String, WorksMilestoneIndexResponse> worksTransactionResponseMap) {
        for (WorksMilestoneIndexResponse response : worksTransactionResponses) {
            worksTransactionResponseMap.put(this.prepareGroupingKey(worksIndexsRequest, response), response);
        }
    }

    private String prepareGroupingKey(WorksIndexsRequest worksMilestoneIndexRequest, WorksMilestoneIndexResponse response) {
        StringBuilder groupingKey = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)worksMilestoneIndexRequest.getTypeofwork())) {
            groupingKey.append(worksMilestoneIndexRequest.getTypeofwork());
        }
        if (StringUtils.isNotBlank((CharSequence)worksMilestoneIndexRequest.getDistname())) {
            groupingKey.append(worksMilestoneIndexRequest.getDistname());
        }
        if (StringUtils.isNotBlank((CharSequence)worksMilestoneIndexRequest.getUlbname())) {
            groupingKey.append(worksMilestoneIndexRequest.getUlbname());
        }
        if (worksMilestoneIndexRequest.getUlbcodes() != null && !worksMilestoneIndexRequest.getUlbcodes().isEmpty()) {
            for (String ulbcode : worksMilestoneIndexRequest.getUlbcodes()) {
                groupingKey.append(ulbcode);
            }
        }
        groupingKey.append(response.getName());
        return groupingKey.toString();
    }

    private BoolQueryBuilder prepareWhereClauseForMilestone(WorksIndexsRequest worksIndexsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getTypeofwork())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatetypeofworkname", (Object)worksIndexsRequest.getTypeofwork()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getDistname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"distname", (Object)worksIndexsRequest.getDistname()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getUlbname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbname", (Object)worksIndexsRequest.getUlbname()));
        }
        if (worksIndexsRequest.getUlbcodes() != null && !worksIndexsRequest.getUlbcodes().isEmpty()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"ulbcode", worksIndexsRequest.getUlbcodes()));
        }
        if (worksIndexsRequest.getLineestimatedetailid() != null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatedetailid", (Object)worksIndexsRequest.getLineestimatedetailid()));
        }
        if (worksIndexsRequest.getLineestimatedetailids() != null && !worksIndexsRequest.getLineestimatedetailids().isEmpty()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"lineestimatedetailid", worksIndexsRequest.getLineestimatedetailids()));
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"milestonestatus", (Object)"APPROVED"));
        return boolQuery;
    }

    private BoolQueryBuilder prepareWhereClauseForTransaction(WorksIndexsRequest worksIndexsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getTypeofwork())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatetypeofworkname", (Object)worksIndexsRequest.getTypeofwork()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getDistname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"distname", (Object)worksIndexsRequest.getDistname()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getUlbname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbname", (Object)worksIndexsRequest.getUlbname()));
        }
        if (worksIndexsRequest.getUlbcodes() != null && !worksIndexsRequest.getUlbcodes().isEmpty()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"ulbcode", worksIndexsRequest.getUlbcodes()));
        }
        if (worksIndexsRequest.getLineestimatedetailid() != null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatedetailid", (Object)worksIndexsRequest.getLineestimatedetailid()));
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"loastatus", (Object)"APPROVED"));
        return boolQuery;
    }
}

