/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.config.properties;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

@Configuration
@PropertySource(name="worksApplicationProperties", value={"classpath:config/application-config-works.properties", "classpath:config/egov-erp-${user.name}.properties", "classpath:config/application-config-${client.id}.properties", "classpath:config/egov-erp-override.properties"}, ignoreResourceNotFound=true)
public class WorksApplicationProperties {
    @Autowired
    private Environment environment;

    public String[] getContractorMasterMandatoryFields() {
        return this.environment.getProperty("contractormaster.fields.mandatory").split(",");
    }

    public String[] getContractorMasterHideFields() {
        return this.environment.getProperty("contractormaster.fields.hide").split(",");
    }

    public String getDefaultApproverDepartment() {
        return this.environment.getProperty("default.approver.department");
    }

    public String[] lineEstimateHideFields() {
        return this.environment.getProperty("lineestimate.fields.hide").split(",");
    }

    public String lineEstimateMultipleWorkDetailsAllowed() {
        return this.environment.getProperty("lineestimate.workdetails.addrow");
    }

    public String contractorMasterCodeAutoGenerated() {
        return this.environment.getProperty("contractormaster.code.autogenerated");
    }

    public String[] contractorMasterCategoryValues() {
        return this.environment.getProperty("contractormaster.category.values").split(",");
    }

    public String[] contractorMasterClassValues() {
        return this.environment.getProperty("contractormaster.class.values").split(",");
    }
}

