/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.autonumber.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.works.autonumber.LineEstimateNumberGenerator;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LineEstimateNumberGeneratorImpl
implements LineEstimateNumberGenerator {
    private static final String LINEESTIMATE_NUMBER_SEQ_PREFIX = "SEQ_LINEESTIMATE_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;

    @Override
    @Transactional
    public String getNextNumber(LineEstimate lineEstimate) {
        CFinancialYear financialYear = this.financialYearHibernateDAO.getFinYearByDate(lineEstimate.getLineEstimateDate());
        String[] finYearRange = financialYear.getFinYearRange().split("-");
        String sequenceName = "SEQ_LINEESTIMATE_NUMBER_" + finYearRange[0] + "_" + finYearRange[1];
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        return String.format("LE/%s/%05d/%02d/%s", lineEstimate.getExecutingDepartment().getCode(), sequenceNumber, this.getMonthOfTransaction(lineEstimate.getLineEstimateDate()), financialYear.getFinYearRange());
    }

    private int getMonthOfTransaction(Date lineEstimateDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(lineEstimateDate);
        return cal.get(2) + 1;
    }
}

