/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.models.masters.Overhead;
import org.egov.works.models.masters.OverheadRate;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

@Entity
@Table(name="EGW_ESTIMATE_OVERHEADS")
@SequenceGenerator(name="SEQ_EGW_ESTIMATE_OVERHEADS", sequenceName="SEQ_EGW_ESTIMATE_OVERHEADS", allocationSize=1)
public class OverheadValue
extends AbstractAuditable {
    private static final long serialVersionUID = 5585187999492385271L;
    public static final String SEQ_EGW_ESTIMATEOVERHEADS = "SEQ_EGW_ESTIMATE_OVERHEADS";
    @Id
    @GeneratedValue(generator="SEQ_EGW_ESTIMATE_OVERHEADS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="overhead")
    private Overhead overhead;
    @NotNull
    private double amount;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="abstractEstimate")
    private AbstractEstimate abstractEstimate;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public Overhead getOverhead() {
        return this.overhead;
    }

    public void setOverhead(Overhead overhead) {
        this.overhead = overhead;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public OverheadRate getOverheadRateOn(Date estimateDate) {
        for (OverheadRate overheadRate : this.overhead.getOverheadRates()) {
            if (overheadRate == null || !this.isWithin(overheadRate.getValidity(), estimateDate)) continue;
            return overheadRate;
        }
        return null;
    }

    public boolean isWithin(Period period, Date dateTime) {
        LocalDate start = new LocalDate((Object)period.getStartDate());
        LocalDate end = new LocalDate((Object)period.getEndDate());
        LocalDate date = new LocalDate((Object)dateTime);
        if (period.getEndDate() == null) {
            return start.compareTo((ReadablePartial)date) <= 0;
        }
        return start.compareTo((ReadablePartial)date) <= 0 && end.compareTo((ReadablePartial)date) >= 0;
    }

    public List<ValidationError> validate() {
        return new ArrayList<ValidationError>();
    }
}

