/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.elasticsearch.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.egov.works.elasticsearch.model.WorksIndexsRequest;
import org.egov.works.elasticsearch.model.WorksMilestoneIndexResponse;
import org.egov.works.elasticsearch.model.WorksTransactionIndex;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class WorksTransactionIndexService {
    public static final String DFT_DATE_FORMAT = "dd/MM/yyyy HH.mm.ss";
    private static final String BY_AGGREGATION_FIELD = "by_aggregationField";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorksTransactionIndexService.class);
    public static final String WORKSTRANSACTION_INDEX_NAME = "workstransaction";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public List<WorksMilestoneIndexResponse> getWorksTransactionDetails(WorksIndexsRequest worksIndexsRequest) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(worksIndexsRequest);
        ArrayList<WorksMilestoneIndexResponse> resultList = new ArrayList<WorksMilestoneIndexResponse>();
        Long startTime = System.currentTimeMillis();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSTRANSACTION_INDEX_NAME}).withQuery((QueryBuilder)boolQuery).build();
        Long count = this.elasticsearchTemplate.count((SearchQuery)searchQuery);
        searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSTRANSACTION_INDEX_NAME}).withPageable((Pageable)new PageRequest(0, count.intValue())).withQuery((QueryBuilder)boolQuery).build();
        List worksTransactionIndexs = this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, WorksTransactionIndex.class);
        for (WorksTransactionIndex response : worksTransactionIndexs) {
            WorksMilestoneIndexResponse wmIndexResponse = new WorksMilestoneIndexResponse();
            wmIndexResponse.setLineestimatedetailid(response.getLineestimatedetailid());
            wmIndexResponse.setTypeofwork(response.getLineestimatetypeofworkname());
            wmIndexResponse.setUlbname(response.getUlbname());
            wmIndexResponse.setUlbcode(response.getUlbcode());
            wmIndexResponse.setDistrictname(response.getDistname());
            wmIndexResponse.setFund(response.getLineestimatefund());
            wmIndexResponse.setScheme(response.getLineestimatescheme());
            wmIndexResponse.setSubscheme(response.getLineestimatesubscheme());
            wmIndexResponse.setWard(response.getLineestimateboundary());
            wmIndexResponse.setEstimatenumber(response.getEstimatenumber());
            wmIndexResponse.setWin(response.getEstimatewin());
            wmIndexResponse.setNameofthework(response.getNameofthework());
            wmIndexResponse.setContractornamecode(response.getLoanameofagency() + "/" + response.getLoacontractor());
            wmIndexResponse.setAgreementnumber(response.getLoanumber());
            wmIndexResponse.setAgreementdate(response.getAgreementdate());
            wmIndexResponse.setWorkstatus(response.getWorkstatus());
            wmIndexResponse.setContractperiod(response.getLoacontractperiod());
            wmIndexResponse.setLatestupdatedtimestamp(new SimpleDateFormat(DFT_DATE_FORMAT, Locale.getDefault()).format(response.getCreateddate()));
            wmIndexResponse.setTotalestimatedcostinlakhs(response.getEstimatevalue());
            wmIndexResponse.setTotalworkordervalueinlakhs(response.getLoaamount());
            wmIndexResponse.setTotalbillamountinlakhs(response.getLoatotalbillamt());
            wmIndexResponse.setTotalpaidamountinlakhs(response.getLoatotalpaidamt());
            resultList.add(wmIndexResponse);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getWorksTransactionDetails is : " + timeTaken + " (millisecs) ");
        }
        return resultList;
    }

    public List<WorksMilestoneIndexResponse> getAggregationResults(WorksIndexsRequest worksIndexsRequest, List<WorksMilestoneIndexResponse> resultList, String orderingAggregationName) {
        List resultBuckets;
        HashMap<Integer, WorksMilestoneIndexResponse> resultMap = new HashMap<Integer, WorksMilestoneIndexResponse>();
        for (WorksMilestoneIndexResponse response2 : resultList) {
            resultMap.put(response2.getLineestimatedetailid(), response2);
        }
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(worksIndexsRequest);
        AggregationBuilder aggregation = ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)BY_AGGREGATION_FIELD).field(orderingAggregationName)).size(1000).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalestimatedcostinlakhs").field("estimatevalue"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalworkordervalueinlakhs").field("loaamount"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalbillamountinlakhs").field("loatotalbillamt"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalpaidamountinlakhs").field("loatotalpaidamt"));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSTRANSACTION_INDEX_NAME}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)SortBuilders.fieldSort((String)orderingAggregationName).order(SortOrder.DESC)).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations worksAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        if (!orderingAggregationName.equals("lineestimatedetailid")) {
            StringTerms saggr = (StringTerms)worksAggr.get(BY_AGGREGATION_FIELD);
            resultBuckets = saggr.getBuckets();
        } else {
            LongTerms laggr = (LongTerms)worksAggr.get(BY_AGGREGATION_FIELD);
            resultBuckets = laggr.getBuckets();
        }
        for (Terms.Bucket entry : resultBuckets) {
            String fieldName = String.valueOf(entry.getKey());
            ((WorksMilestoneIndexResponse)resultMap.get(Integer.valueOf(fieldName))).setReporttype(worksIndexsRequest.getReportType());
            ((WorksMilestoneIndexResponse)resultMap.get(Integer.valueOf(fieldName))).setName(fieldName);
            Sum totalEstimatedCostInLakhsAggregation = (Sum)entry.getAggregations().get("totalestimatedcostinlakhs");
            Sum totalWorkorderValueInLakhsAggregation = (Sum)entry.getAggregations().get("totalworkordervalueinlakhs");
            Sum totalBillAmountInLakhsAggregation = (Sum)entry.getAggregations().get("totalbillamountinlakhs");
            Sum totalPaidAmountInLakhsAggregation = (Sum)entry.getAggregations().get("totalpaidamountinlakhs");
            ((WorksMilestoneIndexResponse)resultMap.get(Integer.valueOf(fieldName))).setTotalnoofworks(entry.getDocCount());
            ((WorksMilestoneIndexResponse)resultMap.get(Integer.valueOf(fieldName))).setTotalestimatedcostinlakhs(totalEstimatedCostInLakhsAggregation.getValue());
            ((WorksMilestoneIndexResponse)resultMap.get(Integer.valueOf(fieldName))).setTotalworkordervalueinlakhs(totalWorkorderValueInLakhsAggregation.getValue());
            ((WorksMilestoneIndexResponse)resultMap.get(Integer.valueOf(fieldName))).setTotalbillamountinlakhs(totalBillAmountInLakhsAggregation.getValue());
            ((WorksMilestoneIndexResponse)resultMap.get(Integer.valueOf(fieldName))).setTotalpaidamountinlakhs(totalPaidAmountInLakhsAggregation.getValue());
        }
        resultList = new ArrayList<WorksMilestoneIndexResponse>();
        for (Integer key : resultMap.keySet()) {
            resultList.add((WorksMilestoneIndexResponse)resultMap.get(key));
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getAggregationResults() is : " + timeTaken + " (millisecs) ");
        }
        return resultList;
    }

    private BoolQueryBuilder prepareWhereClause(WorksIndexsRequest worksIndexsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getTypeofwork())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatetypeofworkname", (Object)worksIndexsRequest.getTypeofwork()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getDistname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"distname", (Object)worksIndexsRequest.getDistname()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getUlbname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbname", (Object)worksIndexsRequest.getUlbname()));
        }
        if (worksIndexsRequest.getLineestimatedetailid() != null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatedetailid", (Object)worksIndexsRequest.getLineestimatedetailid()));
        }
        if (worksIndexsRequest.getLineestimatedetailids() != null && !worksIndexsRequest.getLineestimatedetailids().isEmpty()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"lineestimatedetailid", worksIndexsRequest.getLineestimatedetailids()));
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"loastatus", (Object)"APPROVED"));
        return boolQuery;
    }
}

