/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.workorder.repository;

import java.util.List;
import org.egov.works.masters.entity.Contractor;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface WorkOrderEstimateRepository
extends JpaRepository<WorkOrderEstimate, Long> {
    public WorkOrderEstimate findByWorkOrder_IdAndEstimate_IdAndWorkOrder_EgwStatus_Code(Long var1, Long var2, String var3);

    public WorkOrderEstimate findByEstimate_IdAndWorkOrder_EgwStatus_Code(Long var1, String var2);

    public WorkOrderEstimate findByWorkOrder_Id(Long var1);

    @Query(value="select distinct(woe.workOrder.workOrderNumber) from WorkOrderEstimate as woe where woe.workOrder.parent.id is null and upper(woe.workOrder.workOrderNumber) like upper(:workOrderNumber) and  woe.workOrder.egwStatus.code =:workOrderStatus and not exists (select distinct(cbr.workOrderEstimate.workOrder) from ContractorBillRegister as cbr where woe.id = cbr.workOrderEstimate.id and upper(cbr.billstatus) != :billStatus and cbr.billtype = :billtype)")
    public List<String> findWorkOrderNumbersToCreateMB(@Param(value="workOrderNumber") String var1, @Param(value="workOrderStatus") String var2, @Param(value="billStatus") String var3, @Param(value="billtype") String var4);

    @Query(value="select distinct(cbr.workOrderEstimate.workOrder.workOrderNumber) from ContractorBillRegister as cbr where upper(cbr.billstatus) != :status and cbr.billtype = :billtype")
    public List<String> getCancelledWorkOrderNumbersByBillType(@Param(value="status") String var1, @Param(value="billtype") String var2);

    @Query(value="select distinct(woe.workOrder.workOrderNumber) from WorkOrderEstimate as woe where woe.workOrder.parent.id is null and upper(woe.workOrder.workOrderNumber) like upper(:workOrderNumber) and woe.workOrder.egwStatus.code in(:workOrderStatus) and woe.workOrder.id = (select distinct(os.objectId) from OfflineStatus as os where os.id = (select max(status.id) from OfflineStatus status where status.objectType = :objectType and status.objectId = woe.workOrder.id) and os.objectId = woe.workOrder.id and lower(os.egwStatus.code) = :offlineStatus and os.objectType = :objectType )")
    public List<String> findWordOrderByStatus(@Param(value="workOrderNumber") String var1, @Param(value="workOrderStatus") String var2, @Param(value="offlineStatus") String var3, @Param(value="objectType") String var4);

    @Query(value="select distinct(woe.estimate.estimateNumber) from WorkOrderEstimate as woe where woe.estimate.parent.id is null and upper(woe.estimate.estimateNumber) like upper(:estimateNumber) and woe.workOrder.egwStatus.code in(:workOrderStatus) and woe.workOrder.id = (select distinct(os.objectId) from OfflineStatus as os where os.id = (select max(status.id) from OfflineStatus status where status.objectType = :objectType and status.objectId = woe.workOrder.id) and os.objectId = woe.workOrder.id and lower(os.egwStatus.code) = :offlineStatus and os.objectType = :objectType )")
    public List<String> findEstimatesByWorkOrderStatus(@Param(value="estimateNumber") String var1, @Param(value="workOrderStatus") String var2, @Param(value="offlineStatus") String var3, @Param(value="objectType") String var4);

    public List<WorkOrderEstimate> findByEstimate_EstimateNumberContainingIgnoreCaseAndWorkOrder_EgwStatus_codeEquals(String var1, String var2);

    @Query(value="select distinct(woe.workOrder.contractor) as contractor from WorkOrderEstimate as woe where upper(woe.workOrder.contractor.name) like upper(:contractorname) or upper(woe.workOrder.contractor.code) like upper(:contractorname)  and woe.workOrder.egwStatus.code in (:workOrderStatus) and woe.workOrder.id = (select distinct(os.objectId) from OfflineStatus as os where os.id = (select max(status.id) from OfflineStatus status where status.objectType = :objectType and status.objectId = woe.workOrder.id) and os.objectId = woe.workOrder.id and lower(os.egwStatus.code) = :offlineStatus and os.objectType = :objectType )")
    public List<Contractor> findContractorByWorkOrderStatus(@Param(value="contractorname") String var1, @Param(value="workOrderStatus") String var2, @Param(value="offlineStatus") String var3, @Param(value="objectType") String var4);

    public WorkOrderEstimate findByEstimate_EstimateNumberAndWorkOrder_EgwStatus_codeNotLike(String var1, String var2);

    @Query(value="select distinct(woe.workOrder.workOrderNumber) from WorkOrderEstimate as woe where woe.estimate.parent.id is null and upper(woe.workOrder.workOrderNumber) like upper(:workOrderNumber) and  woe.workOrder.egwStatus.code =:workOrderStatus and not exists (select distinct(cbr.workOrderEstimate.workOrder) from ContractorBillRegister as cbr where woe.id = cbr.workOrderEstimate.id and upper(cbr.billstatus) != :billStatus and cbr.billtype = :billtype)")
    public List<String> findWorkOrderNumbersToCreateRE(@Param(value="workOrderNumber") String var1, @Param(value="workOrderStatus") String var2, @Param(value="billStatus") String var3, @Param(value="billtype") String var4);

    @Query(value="select distinct(woe.workOrder.contractor) as contractor from WorkOrderEstimate as woe where upper(woe.workOrder.contractor.name) like upper(:contractorname) or upper(woe.workOrder.contractor.code) like upper(:contractorname)  and woe.workOrder.egwStatus.code =:workOrderStatus ")
    public List<Contractor> findContractorsByWorkOrderStatus(@Param(value="contractorname") String var1, @Param(value="workOrderStatus") String var2);

    @Query(value="select distinct(woe) from WorkOrderEstimate as woe where upper(woe.estimate.estimateNumber) = :estimateNumber and woe.workOrder.egwStatus.code = :workOrderStatus and woe.workOrder.parent is null")
    public WorkOrderEstimate findWorkOrderEstimateByEstimateNumber(@Param(value="estimateNumber") String var1, @Param(value="workOrderStatus") String var2);

    @Query(value="select distinct(woe) from WorkOrderEstimate as woe where upper(woe.estimate.estimateNumber) = :estimateNumber and woe.workOrder.egwStatus.code != :workOrderStatus")
    public List<WorkOrderEstimate> findWorkOrderEstimatesToCancelAbstractEstimate(@Param(value="estimateNumber") String var1, @Param(value="workOrderStatus") String var2);
}

