/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.workorder.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.workorder.entity.AssetsForWorkOrder;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;

@Entity
@Table(name="EGW_WORKORDER_ESTIMATE")
@NamedQueries(value={@NamedQuery(name="getWorkOrderEstimateByWorkOrderId", query=" from WorkOrderEstimate woe where woe.workOrder.id = ? "), @NamedQuery(name="getWorkOrderEstimateById", query=" from WorkOrderEstimate woe where woe.estimate.id = ? "), @NamedQuery(name="getWorkOrderEstimateByEstAndWO", query="  from WorkOrderEstimate woe where woe.estimate.id = ? and woe.workOrder.id = ? ")})
@SequenceGenerator(name="SEQ_WORKORDER_ESTIMATE", sequenceName="SEQ_WORKORDER_ESTIMATE", allocationSize=1)
public class WorkOrderEstimate
extends AbstractAuditable {
    private static final long serialVersionUID = 2083096871794612166L;
    public static final String SEQ_WORKORDER_ESTIMATE = "SEQ_WORKORDER_ESTIMATE";
    public static final String GETWORKORDERESTIMATEBYWORKORDERID = "getWorkOrderEstimateByWorkOrderId";
    public static final String GETWORKORDERESTIMATEBYID = "getWorkOrderEstimateById";
    public static final String GETWORKORDERESTIMATEBYESTANDWO = "getWorkOrderEstimateByEstAndWO";
    @Id
    @GeneratedValue(generator="SEQ_WORKORDER_ESTIMATE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="WORKORDER_ID", nullable=false)
    private WorkOrder workOrder;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ABSTRACTESTIMATE_ID", nullable=false)
    private AbstractEstimate estimate;
    @Column(name="WORK_COMPLETION_DATE")
    @Temporal(value=TemporalType.DATE)
    private Date workCompletionDate;
    @NotNull
    @Column(name="ESTIMATE_WO_AMOUNT")
    private double estimateWOAmount;
    @JsonIgnore
    @OrderBy(value="id")
    @OneToMany(mappedBy="workOrderEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=WorkOrderActivity.class)
    private List<WorkOrderActivity> workOrderActivities = new ArrayList<WorkOrderActivity>(0);
    @Valid
    @JsonIgnore
    @OrderBy(value="id")
    @OneToMany(mappedBy="workOrderEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=AssetsForWorkOrder.class)
    private List<AssetsForWorkOrder> assetValues = new ArrayList<AssetsForWorkOrder>(0);
    @JsonIgnore
    @OrderBy(value="id")
    @OneToMany(mappedBy="workOrderEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=Milestone.class)
    private List<Milestone> milestone = new ArrayList<Milestone>(0);
    @Transient
    private Milestone latestMilestone;
    @JsonIgnore
    @OneToMany(mappedBy="workOrderEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=ContractorAdvanceRequisition.class)
    private List<ContractorAdvanceRequisition> contractorAdvanceRequisitions = new ArrayList<ContractorAdvanceRequisition>();
    @JsonIgnore
    @OneToMany(mappedBy="workOrderEstimate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=MBHeader.class)
    private List<MBHeader> mbHeaders = new ArrayList<MBHeader>(0);

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public AbstractEstimate getEstimate() {
        return this.estimate;
    }

    public void setEstimate(AbstractEstimate estimate) {
        this.estimate = estimate;
    }

    public List<WorkOrderActivity> getWorkOrderActivities() {
        return this.workOrderActivities;
    }

    public void setWorkOrderActivities(List<WorkOrderActivity> workOrderActivities) {
        this.workOrderActivities = workOrderActivities;
    }

    public void addWorkOrderActivity(WorkOrderActivity workOrderActivity) {
        this.workOrderActivities.add(workOrderActivity);
    }

    public Money getTotalWorkValue() {
        double amt = 0.0;
        for (WorkOrderActivity workOrderActivity : this.workOrderActivities) {
            amt += workOrderActivity.getApprovedAmount();
        }
        return new Money(amt);
    }

    public List<MBHeader> getMbHeaders() {
        return this.mbHeaders;
    }

    public void setMbHeaders(List<MBHeader> mbHeaders) {
        this.mbHeaders = mbHeaders;
    }

    public Date getWorkCompletionDate() {
        return this.workCompletionDate;
    }

    public void setWorkCompletionDate(Date workCompletionDate) {
        this.workCompletionDate = workCompletionDate;
    }

    public List<AssetsForWorkOrder> getAssetValues() {
        return this.assetValues;
    }

    public void setAssetValues(List<AssetsForWorkOrder> assetValues) {
        this.assetValues = assetValues;
    }

    public void addAssetValue(AssetsForWorkOrder assetValue) {
        this.assetValues.add(assetValue);
    }

    public List<Milestone> getMilestone() {
        return this.milestone;
    }

    public void setMilestone(List<Milestone> milestone) {
        this.milestone = milestone;
    }

    public Milestone getLatestMilestone() {
        ArrayList<Milestone> milestoneList = new ArrayList<Milestone>();
        milestoneList.addAll(this.getMilestone());
        if (!milestoneList.isEmpty()) {
            Collections.sort(milestoneList, Milestone.milestoneComparator);
            this.latestMilestone = (Milestone)milestoneList.get(milestoneList.size() - 1);
        }
        return this.latestMilestone;
    }

    public void setLatestMilestone(Milestone latestMilestone) {
        this.latestMilestone = latestMilestone;
    }

    public List<ContractorAdvanceRequisition> getContractorAdvanceRequisitions() {
        return this.contractorAdvanceRequisitions;
    }

    public void setContractorAdvanceRequisitions(List<ContractorAdvanceRequisition> contractorAdvanceRequisitions) {
        this.contractorAdvanceRequisitions = contractorAdvanceRequisitions;
    }

    public double getEstimateWOAmount() {
        return this.estimateWOAmount;
    }

    public void setEstimateWOAmount(double estimateWOAmount) {
        this.estimateWOAmount = estimateWOAmount;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

