/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.workorder.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.GreaterThan;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.entity.WorkOrderMeasurementSheet;

@Entity
@Table(name="EGW_WORKORDER_ACTIVITY")
@NamedQueries(value={@NamedQuery(name="getallWorkOrderActivityWithMB", query=" Select mbDetails.workOrderActivity.id,sum(mbDetails.quantity) from MBDetails mbDetails where mbDetails.mbHeader.workOrderEstimate.id=? and mbDetails.mbHeader.egwStatus.code = ? group by mbDetails.workOrderActivity "), @NamedQuery(name="getallWorkOrderActivityWithoutMB", query="from WorkOrderActivity woe where woe.workOrderEstimate.id=? and woe.workOrderEstimate.workOrder.egwStatus.code!=? and woe.id not in  (Select distinct(mbDetails.workOrderActivity.id) from MBDetails mbDetails where mbDetails.mbHeader.workOrderEstimate.id=?  and mbDetails.mbHeader.egwStatus.code = ?) "), @NamedQuery(name="getAssignedQuantityForActivity", query=" Select sum(woa.approvedQuantity) from WorkOrderActivity woa where woa.workOrderEstimate.workOrder.negotiationNumber=? AND woa.workOrderEstimate.workOrder.egwStatus.code !=? group by woa.activity having woa.activity.id = ? "), @NamedQuery(name="getTotalQuantityForWO", query=" Select sum(woa.approvedQuantity) from WorkOrderActivity woa where woa.workOrderEstimate.workOrder.negotiationNumber=? AND woa.workOrderEstimate.workOrder.egwStatus.code !=? "), @NamedQuery(name="getTotalQuantityForNewWO", query="  Select sum(woa.approvedQuantity) from WorkOrderActivity woa where woa.workOrderEstimate.workOrder.negotiationNumber=? AND woa.workOrderEstimate.workOrder.egwStatus.code =?  ")})
@SequenceGenerator(name="SEQ_EGW_WORKORDER_ACTIVITY", sequenceName="SEQ_EGW_WORKORDER_ACTIVITY", allocationSize=1)
public class WorkOrderActivity
extends AbstractAuditable {
    private static final long serialVersionUID = -5986495021099638251L;
    public static final String SEQ_EGW_WORKORDER_ACTIVITY = "SEQ_EGW_WORKORDER_ACTIVITY";
    public static final String GETALLWORKORDERACTIVITYWITHMB = "getallWorkOrderActivityWithMB";
    public static final String GETALLWORKORDERACTIVITYWITHOUTMB = "getallWorkOrderActivityWithoutMB";
    public static final String GETASSIGNEDQUANTITYFORACTIVITY = "getAssignedQuantityForActivity";
    public static final String GETTOTALQUANTITYFORWO = "getTotalQuantityForWO";
    public static final String GETTOTALQUANTITYFORNEWWO = "getTotalQuantityForNewWO";
    @Id
    @GeneratedValue(generator="SEQ_EGW_WORKORDER_ACTIVITY", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="WORKORDER_ESTIMATE_ID", nullable=false)
    private WorkOrderEstimate workOrderEstimate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ESTIMATE_ACTIVITY_ID", nullable=false)
    private Activity activity;
    @Required(message="WorkOrderActivity.approvedRate.not.null")
    @GreaterThan(value=0L, message="WorkOrderActivity.approvedRate.non.negative")
    @Column(name="APPROVED_RATE")
    private double approvedRate;
    @Required(message="WorkOrderActivity.approvedQuantity.not.null")
    @GreaterThan(value=0L, message="WorkOrderActivity.approvedQuantity.non.negative")
    @Column(name="APPROVED_QUANTITY")
    private double approvedQuantity;
    @Column(name="APPROVED_AMOUNT")
    private double approvedAmount;
    private String remarks;
    @Transient
    private double unAssignedQuantity;
    @Transient
    private WorkOrderActivity parent;
    @Transient
    private double totalEstQuantity;
    @Transient
    private double prevCumlvQuantity;
    private transient Long mbHeaderId;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="woActivity", targetEntity=WorkOrderMeasurementSheet.class)
    private List<WorkOrderMeasurementSheet> workOrderMeasurementSheets = new ArrayList<WorkOrderMeasurementSheet>();

    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public double getApprovedRate() {
        return this.approvedRate;
    }

    public void setApprovedRate(double approvedRate) {
        this.approvedRate = approvedRate;
    }

    public double getApprovedQuantity() {
        return this.approvedQuantity;
    }

    public void setApprovedQuantity(double approvedQuantity) {
        this.approvedQuantity = approvedQuantity;
    }

    public double getApprovedAmount() {
        return this.approvedAmount;
    }

    public void setApprovedAmount(double approvedAmount) {
        this.approvedAmount = approvedAmount;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public double getUnAssignedQuantity() {
        return this.unAssignedQuantity;
    }

    public void setUnAssignedQuantity(double unAssignedQuantity) {
        this.unAssignedQuantity = unAssignedQuantity;
    }

    public double getConversionFactor() {
        if (this.workOrderEstimate.getWorkOrder().getParent() != null && this.activity.getRevisionType() != null && (this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString()) || this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.LUMP_SUM_ITEM.toString()))) {
            return this.activity.getConversionFactorForRE(this.workOrderEstimate.getWorkOrder().getParent().getWorkOrderDate());
        }
        if (this.workOrderEstimate.getWorkOrder().getParent() != null && this.workOrderEstimate.getEstimate().getParent() != null && this.activity.getRevisionType() != null && (this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.ADDITIONAL_QUANTITY.toString()) || this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.REDUCED_QUANTITY.toString()))) {
            return this.activity.getConversionFactorForRE(this.workOrderEstimate.getEstimate().getParent().getEstimateDate());
        }
        return this.activity.getConversionFactor();
    }

    public double getScheduleOfRate() {
        double sorRate = 0.0;
        if (this.getActivity().getAbstractEstimate().getParent() == null) {
            sorRate = this.getActivity().getEstimateRate();
        } else {
            Date workOrderDate = new Date();
            workOrderDate = this.getWorkOrderEstimate().getWorkOrder().getParent().getWorkOrderDate();
            sorRate = this.activity.getRevisionType() != null && (this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString()) || this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.LUMP_SUM_ITEM.toString())) ? this.getActivity().getSORRateForDate(workOrderDate).getValue() : (this.getActivity().getAbstractEstimate().getParent() != null && this.activity.getRevisionType() != null && (this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.ADDITIONAL_QUANTITY.toString()) || this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.REDUCED_QUANTITY.toString())) ? this.getActivity().getSORRateForDate(this.workOrderEstimate.getEstimate().getParent().getEstimateDate()).getValue() : this.getActivity().getEstimateRate());
        }
        return sorRate;
    }

    public WorkOrderActivity getParent() {
        return this.parent;
    }

    public void setParent(WorkOrderActivity parent) {
        this.parent = parent;
    }

    public double getTotalEstQuantity() {
        return this.totalEstQuantity;
    }

    public double getPrevCumlvQuantity() {
        return this.prevCumlvQuantity;
    }

    public void setTotalEstQuantity(double totalEstQuantity) {
        this.totalEstQuantity = totalEstQuantity;
    }

    public void setPrevCumlvQuantity(double prevCumlvQuantity) {
        this.prevCumlvQuantity = prevCumlvQuantity;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMbHeaderId() {
        return this.mbHeaderId;
    }

    public void setMbHeaderId(Long mbHeaderId) {
        this.mbHeaderId = mbHeaderId;
    }

    public List<WorkOrderMeasurementSheet> getWorkOrderMeasurementSheets() {
        return this.workOrderMeasurementSheets;
    }

    public void setWorkOrderMeasurementSheets(List<WorkOrderMeasurementSheet> workOrderMeasurementSheets) {
        this.workOrderMeasurementSheets = workOrderMeasurementSheets;
    }
}

