/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.workorder.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.eis.entity.Employee;
import org.egov.infra.persistence.entity.Auditable;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.masters.entity.Contractor;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGW_WORKORDER")
@Inheritance(strategy=InheritanceType.JOINED)
@NamedQueries(value={@NamedQuery(name="getContractorsWithWO", query=" select distinct wo.contractor from WorkOrder wo where wo.parent is null "), @NamedQuery(name="getUniqueWO", query=" select distinct wo from WorkOrder wo where wo.parent is null "), @NamedQuery(name="getApprovedContractorsWithWO", query=" select distinct wo.contractor from WorkOrder wo where wo.parent is null and wo.egwStatus.code='APPROVED' "), @NamedQuery(name="GET_All_CONTRACTORS", query=" select distinct wo.contractor from WorkOrder wo join wo.contractor.contractorDetails as detail where wo.parent is null and detail.status.description = ? and current_date >= detail.validity.startDate and (detail.validity.endDate is null or detail.validity.endDate >= current_date )")})
@SequenceGenerator(name="SEQ_EGW_WORKORDER", sequenceName="SEQ_EGW_WORKORDER", allocationSize=1)
public class WorkOrder
extends StateAware
implements Auditable {
    private static final long serialVersionUID = -3955155765490287178L;
    public static final String SEQ_EGW_WORKORDER = "SEQ_EGW_WORKORDER";
    public static final String GETCONTRACTORSWITHWO = "getContractorsWithWO";
    public static final String GETUNIQUEWO = "getUniqueWO";
    public static final String GET_All_CONTRACTORS = "GET_All_CONTRACTORS";
    public static final String GETAPPROVEDCONTRACTORSWITHWO = "getApprovedContractorsWithWO";
    @Id
    @GeneratedValue(generator="SEQ_EGW_WORKORDER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONTRACTOR_ID", nullable=false)
    private Contractor contractor;
    @Required(message="workOrder.workOrderDate.null")
    @DateFormat(message="invalid.fieldvalue.workOrderDate")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="invalid.workOrderDate")
    @Temporal(value=TemporalType.DATE)
    @Column(name="WORKORDER_DATE")
    private Date workOrderDate;
    @NotNull
    @Length(max=256)
    @Column(name="WORKORDER_NUMBER")
    private String workOrderNumber;
    @Column(name="WP_NUMBER")
    private String packageNumber;
    @Column(name="TENDER_NUMBER")
    private String tenderNumber;
    @Column(name="NEGOTIATION_NUMBER")
    private String negotiationNumber;
    @Column(name="WORK_ORDER_DETAILS")
    @Length(max=1024, message="workOrderDetails.length")
    private String workOrderDetails;
    @Column(name="CONTRACT_PERIOD")
    private Integer contractPeriod;
    @Column(name="AGREEMENT_DETAILS")
    @Length(max=1024, message="agreementDetails.length")
    private String agreementDetails;
    @Column(name="PAYMENT_TERMS")
    @Length(max=1024, message="paymentTerms.length")
    private String paymentTerms;
    @Column(name="EMD_AMOUNT_DEPOSITED")
    @Min(value=0L, message="workorder.emdAmountDeposited.non.negative")
    private double emdAmountDeposited;
    @Column(name="SECURITY_DEPOSIT")
    @Min(value=0L, message="workorder.non.negative")
    private double securityDeposit;
    @Column(name="LABOUR_WELFARE_FUND")
    @Min(value=0L, message="workorder.non.negative")
    private double labourWelfareFund;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ENGINEERINCHARGE", nullable=false)
    @Required(message="workorder.engineerIncharge.null")
    private Employee engineerIncharge;
    @Column(name="DEFECT_LIABILITY_PERIOD")
    @Min(value=0L, message="workorder.non.negative")
    private double defectLiabilityPeriod;
    @NotNull
    @Min(value=1L)
    @Column(name="WORKORDER_AMOUNT")
    private double workOrderAmount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATUS_ID", nullable=false)
    private EgwStatus egwStatus;
    private double tenderFinalizedPercentage;
    @Column(name="APPROVED_DATE")
    @DateFormat(message="invalid.fieldvalue.workOrderDate")
    @Temporal(value=TemporalType.DATE)
    private Date approvedDate;
    @Length(max=100)
    private String fileNumber;
    @DateFormat(message="invalid.fieldvalue.fileDate")
    @Temporal(value=TemporalType.DATE)
    private Date fileDate;
    @Length(max=1024, message="bankguarantee.length")
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="workorder.bankguarantee.alphaNumeric")
    private String bankGuarantee;
    @Length(max=100)
    private String estimateNumber;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARENTID")
    private WorkOrder parent;
    @Transient
    private Date expectedCompletionDate;
    @Transient
    private String tenderType;
    @Transient
    private String owner;
    @Transient
    private String status;
    @Transient
    private String percentageSign;
    @JsonIgnore
    @OrderBy(value="id")
    @OneToMany(mappedBy="workOrder", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=WorkOrderEstimate.class)
    private List<WorkOrderEstimate> workOrderEstimates = new ArrayList<WorkOrderEstimate>(0);
    @JsonIgnore
    @Transient
    private List<OfflineStatus> offlineStatuses = new ArrayList<OfflineStatus>();
    @Transient
    private List<String> workOrderActions = new ArrayList<String>();
    @JsonIgnore
    @OrderBy(value="id")
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=WorkOrder.class)
    private List<WorkOrder> revisionWOs = new ArrayList<WorkOrder>();
    @JsonIgnore
    @OrderBy(value="id")
    @OneToMany(mappedBy="workOrder", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=MBHeader.class)
    private List<MBHeader> mbHeaders = new ArrayList<MBHeader>();
    private final transient List<DocumentDetails> documentDetails = new ArrayList<DocumentDetails>(0);
    @Length(max=50)
    private String cancellationReason;
    @Length(max=256)
    private String cancellationRemarks;
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;
    @Column(name="TOTAL_INCLUDING_RE")
    private Double totalIncludingRE;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Contractor getContractor() {
        return this.contractor;
    }

    public void setContractor(Contractor contractor) {
        this.contractor = contractor;
    }

    public Date getWorkOrderDate() {
        return this.workOrderDate;
    }

    public void setWorkOrderDate(Date workOrderDate) {
        this.workOrderDate = workOrderDate;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public String getPackageNumber() {
        return this.packageNumber;
    }

    public void setPackageNumber(String packageNumber) {
        this.packageNumber = packageNumber;
    }

    public String getTenderNumber() {
        return this.tenderNumber;
    }

    public void setTenderNumber(String tenderNumber) {
        this.tenderNumber = tenderNumber;
    }

    public String getNegotiationNumber() {
        return this.negotiationNumber;
    }

    public void setNegotiationNumber(String negotiationNumber) {
        this.negotiationNumber = negotiationNumber;
    }

    public String getWorkOrderDetails() {
        return this.workOrderDetails;
    }

    public void setWorkOrderDetails(String workOrderDetails) {
        this.workOrderDetails = workOrderDetails;
    }

    public Integer getContractPeriod() {
        return this.contractPeriod;
    }

    public void setContractPeriod(Integer contractPeriod) {
        this.contractPeriod = contractPeriod;
    }

    public String getAgreementDetails() {
        return this.agreementDetails;
    }

    public void setAgreementDetails(String agreementDetails) {
        this.agreementDetails = agreementDetails;
    }

    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public double getEmdAmountDeposited() {
        return this.emdAmountDeposited;
    }

    public void setEmdAmountDeposited(double emdAmountDeposited) {
        this.emdAmountDeposited = emdAmountDeposited;
    }

    public double getSecurityDeposit() {
        return this.securityDeposit;
    }

    public void setSecurityDeposit(double securityDeposit) {
        this.securityDeposit = securityDeposit;
    }

    public double getLabourWelfareFund() {
        return this.labourWelfareFund;
    }

    public void setLabourWelfareFund(double labourWelfareFund) {
        this.labourWelfareFund = labourWelfareFund;
    }

    public Employee getEngineerIncharge() {
        return this.engineerIncharge;
    }

    public void setEngineerIncharge(Employee engineerIncharge) {
        this.engineerIncharge = engineerIncharge;
    }

    public double getDefectLiabilityPeriod() {
        return this.defectLiabilityPeriod;
    }

    public void setDefectLiabilityPeriod(double defectLiabilityPeriod) {
        this.defectLiabilityPeriod = defectLiabilityPeriod;
    }

    public double getWorkOrderAmount() {
        return this.workOrderAmount;
    }

    public void setWorkOrderAmount(double workOrderAmount) {
        this.workOrderAmount = workOrderAmount;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public WorkOrder getParent() {
        return this.parent;
    }

    public void setParent(WorkOrder parent) {
        this.parent = parent;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public double getTenderFinalizedPercentage() {
        return this.tenderFinalizedPercentage;
    }

    public void setTenderFinalizedPercentage(double tenderFinalizedPercentage) {
        this.tenderFinalizedPercentage = tenderFinalizedPercentage;
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public String getTenderType() {
        return this.tenderType;
    }

    public void setTenderType(String tenderType) {
        this.tenderType = tenderType;
    }

    public String getFileNumber() {
        return this.fileNumber;
    }

    public void setFileNumber(String fileNumber) {
        this.fileNumber = fileNumber;
    }

    public Date getFileDate() {
        return this.fileDate;
    }

    public void setFileDate(Date fileDate) {
        this.fileDate = fileDate;
    }

    public String getBankGuarantee() {
        return this.bankGuarantee;
    }

    public void setBankGuarantee(String bankGuarantee) {
        this.bankGuarantee = bankGuarantee;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<WorkOrderEstimate> getWorkOrderEstimates() {
        return this.workOrderEstimates;
    }

    public void setWorkOrderEstimates(List<WorkOrderEstimate> workOrderEstimates) {
        this.workOrderEstimates = workOrderEstimates;
    }

    public List<OfflineStatus> getOfflineStatuses() {
        return this.offlineStatuses;
    }

    public void setOfflineStatuses(List<OfflineStatus> offlineStatuses) {
        this.offlineStatuses = offlineStatuses;
    }

    public List<String> getWorkOrderActions() {
        return this.workOrderActions;
    }

    public void setWorkOrderActions(List<String> workOrderActions) {
        this.workOrderActions = workOrderActions;
    }

    public List<WorkOrder> getRevisionWOs() {
        return this.revisionWOs;
    }

    public void setRevisionWOs(List<WorkOrder> revisionWOs) {
        this.revisionWOs = revisionWOs;
    }

    public void setExpectedCompletionDate(Date expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public void addWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimates.add(workOrderEstimate);
    }

    public List<MBHeader> getMbHeaders() {
        return this.mbHeaders;
    }

    public void setMbHeaders(List<MBHeader> mbHeaders) {
        this.mbHeaders = mbHeaders;
    }

    public String getFormattedString(double value) {
        double rounded = (double)Math.round(value * 100.0) / 100.0;
        DecimalFormat formatter = new DecimalFormat("0.00");
        formatter.setDecimalSeparatorAlwaysShown(true);
        return formatter.format(rounded);
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.contractor != null && (this.contractor.getId() == null || this.contractor.getId() == 0L || this.contractor.getId() == -1L)) {
            validationErrors.add(new ValidationError("contractor", "workOrder.contractor.null"));
        } else if (this.contractor == null) {
            validationErrors.add(new ValidationError("contractor", "workOrder.contractor.null"));
        }
        return validationErrors;
    }

    public String getStateDetails() {
        return "Work Order: " + this.getWorkOrderNumber();
    }

    public Money getTotalWorkOrderQuantity() {
        double qty = 0.0;
        for (WorkOrderEstimate workOrderEstimate : this.workOrderEstimates) {
            for (WorkOrderActivity woa : workOrderEstimate.getWorkOrderActivities()) {
                if (woa.getActivity() != null && woa.getActivity().getRevisionType() != null && woa.getActivity().getRevisionType().equals((Object)RevisionType.REDUCED_QUANTITY)) {
                    qty -= woa.getApprovedQuantity();
                    continue;
                }
                qty += woa.getApprovedQuantity();
            }
        }
        Money totalWorkOrderQuantity = new Money(qty);
        return totalWorkOrderQuantity;
    }

    public Date getExpectedCompletionDate() {
        if (this.getContractPeriod() > 0) {
            Date date;
            this.expectedCompletionDate = date = DateUtils.add((Date)this.getWorkOrderDate(), (int)5, (int)this.getContractPeriod());
        }
        return this.expectedCompletionDate;
    }

    public String toString() {
        return "WorkOrder ( Id : " + this.getId() + "Work Order No: " + this.workOrderNumber + ")";
    }

    public String getPercentageSign() {
        return this.percentageSign;
    }

    public void setPercentageSign(String percentageSign) {
        this.percentageSign = percentageSign;
    }

    public List<DocumentDetails> getDocumentDetails() {
        return this.documentDetails;
    }

    public void setDocumentDetails(List<DocumentDetails> documentDetails) {
        this.documentDetails.clear();
        if (documentDetails != null) {
            this.documentDetails.addAll(documentDetails);
        }
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancellationRemarks() {
        return this.cancellationRemarks;
    }

    public void setCancellationRemarks(String cancellationRemarks) {
        this.cancellationRemarks = cancellationRemarks;
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public Double getTotalIncludingRE() {
        return this.totalIncludingRE;
    }

    public void setTotalIncludingRE(Double totalIncludingRE) {
        this.totalIncludingRE = totalIncludingRE;
    }

    public static enum OfflineStatuses {
        ACCEPTANCE_LETTER_ISSUED,
        ACCEPTANCE_LETTER_ACKNOWLEDGED,
        AGREEMENT_ORDER_SIGNED,
        WORK_ORDER_ACKNOWLEDGED,
        SITE_HANDED_OVER,
        WORK_COMMENCED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

