/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;

public class WorksService {
    private static final Logger logger = Logger.getLogger(WorksService.class);
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private PersistenceService persistenceService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;

    public List<AppConfigValues> getAppConfigValue(String moduleName, String key) {
        return this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, key);
    }

    public String getWorksConfigValue(String key) {
        List<AppConfigValues> configList = this.getAppConfigValue("Works Management", key);
        if (!configList.isEmpty()) {
            return configList.get(0).getValue();
        }
        return null;
    }

    public Accountdetailtype getAccountdetailtypeByName(String name) {
        return this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName(name);
    }

    public String getEmpNameDesignation(Position position, Date date) {
        String empName = "";
        String designationName = "";
        DeptDesig deptDesig = position.getDeptDesig();
        Designation designationMaster = deptDesig.getDesignation();
        designationName = designationMaster.getName();
        Employee employee = this.assignmentService.getPrimaryAssignmentForPositionAndDate(position.getId(), date).getEmployee();
        if (employee != null && employee.getName() != null) {
            empName = employee.getName();
        }
        return empName + "@" + designationName;
    }

    public void createAccountDetailKey(Long id, String type) {
        Accountdetailtype accountdetailtype = this.getAccountdetailtypeByName(type);
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(id.intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }

    public List getWorksRoles() {
        String configVal = this.getWorksConfigValue("WORKS_ROLES");
        ArrayList<String> rolesList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)configVal)) {
            String[] configVals;
            for (String configVal2 : configVals = configVal.split(",")) {
                rolesList.add(configVal2);
            }
        }
        return rolesList;
    }

    public List<String> getTendertypeList() {
        String tenderConfigValues = this.getWorksConfigValue("TENDER_TYPE");
        return Arrays.asList(tenderConfigValues.split(","));
    }

    public boolean validateWorkflowForUser(StateAware wfObj, User user) {
        boolean validateUser = true;
        List assignmentList = null;
        ArrayList<Position> positionList = new ArrayList<Position>();
        if (user != null && wfObj.getCurrentState() != null && !wfObj.getCurrentState().getValue().equals("END")) {
            assignmentList = this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date());
            for (Assignment assignment : assignmentList) {
                positionList.add(assignment.getPosition());
            }
            if (!positionList.isEmpty() && positionList.contains(wfObj.getCurrentState().getOwnerPosition())) {
                validateUser = false;
            }
        }
        return validateUser;
    }

    public Long getCurrentLoggedInUserId() {
        return ApplicationThreadLocals.getUserId();
    }

    public User getCurrentLoggedInUser() {
        return (User)this.persistenceService.getSession().load(User.class, (Serializable)ApplicationThreadLocals.getUserId());
    }

    public Map<String, Integer> getExceptionSOR() {
        List<AppConfigValues> appConfigList = this.getAppConfigValue("Works Management", "EXCEPTIONALUOMS");
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        for (AppConfigValues configValue : appConfigList) {
            String[] value = configValue.getValue().split(",");
            resultMap.put(value[0], Integer.valueOf(value[1]));
        }
        return resultMap;
    }

    public List<Department> getAllDeptmentsForLoggedInUser() {
        List assignmentsList = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(this.getCurrentLoggedInUserId());
        this.employeeService.getEmployeeById(this.getCurrentLoggedInUserId());
        ArrayList<Department> departmentList = new ArrayList<Department>();
        if (assignmentsList != null) {
            for (Assignment assignment : assignmentsList) {
                if (assignment.getPrimary()) {
                    departmentList.add(0, assignment.getDepartment());
                    continue;
                }
                departmentList.add(assignment.getDepartment());
            }
        }
        return departmentList;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public String toCurrency(double money) {
        double rounded = (double)Math.round(money * 100.0) / 100.0;
        DecimalFormat formatter = new DecimalFormat("0.00");
        formatter.setDecimalSeparatorAlwaysShown(true);
        return formatter.format(rounded);
    }

    public Collection<String> getStatusNameDetails(String[] statusNames) {
        return CollectionUtils.select(Arrays.asList(statusNames), statusName -> (String)statusName != null);
    }

    public Collection<Date> getStatusDateDetails(Date[] statusDates) {
        return CollectionUtils.select(Arrays.asList(statusDates), statusDate -> (Date)statusDate != null);
    }

    public Assignment getLatestAssignmentForCurrentLoginUser() {
        Long currentLoginUserId = this.getCurrentLoggedInUserId();
        Assignment assignment = null;
        if (currentLoginUserId != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForEmployee(currentLoginUserId);
        }
        return assignment;
    }

    public CFinancialYear getFinancialYearByDate(Date asOnDate) {
        return this.financialYearHibernateDAO.getFinYearByDate(asOnDate);
    }
}

