/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.revisionestimate.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.RevisionWorkOrder;
import org.egov.works.revisionestimate.repository.RevisionWorkOrderRepository;
import org.egov.works.revisionestimate.service.RevisionEstimateService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RevisionWorkOrderService {
    @PersistenceContext
    private EntityManager entityManager;
    private final RevisionWorkOrderRepository revisionWorkOrderRepository;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private RevisionEstimateService revisionEstimateService;

    @Autowired
    public RevisionWorkOrderService(RevisionWorkOrderRepository revisionWorkOrderRepository) {
        this.revisionWorkOrderRepository = revisionWorkOrderRepository;
    }

    @Transactional
    public RevisionWorkOrder create(RevisionWorkOrder revisionWorkOrder) {
        return (RevisionWorkOrder)((Object)this.revisionWorkOrderRepository.save((Object)revisionWorkOrder));
    }

    public RevisionWorkOrder getRevisionWorkOrderByParent(Long id) {
        return this.revisionWorkOrderRepository.findByParent_Id(id);
    }

    public RevisionWorkOrder getRevisionWorkOrderById(Long id) {
        return (RevisionWorkOrder)((Object)this.revisionWorkOrderRepository.findOne(id));
    }

    public String getRevisionEstimatesForWorkOrder(Long workorderId) {
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByWorkOrderId(workorderId);
        List<RevisionAbstractEstimate> revisionEstimates = this.revisionEstimateService.findRevisionEstimatesByParentAndStatus(workOrderEstimate.getEstimate().getId());
        String revisionEstimateNumbers = "";
        for (RevisionAbstractEstimate revisionAbstractEstimate : revisionEstimates) {
            revisionEstimateNumbers = revisionEstimateNumbers + revisionAbstractEstimate.getEstimateNumber() + ",";
        }
        if (revisionEstimateNumbers.endsWith(",")) {
            revisionEstimateNumbers = revisionEstimateNumbers.substring(0, revisionEstimateNumbers.length() - 2);
        }
        return revisionEstimateNumbers;
    }

    public List<RevisionWorkOrder> findApprovedRevisionEstimatesByParent(Long id) {
        return this.revisionWorkOrderRepository.findByParent_IdAndStatus(id, RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString());
    }
}

