/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.reports.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.enums.LineEstimateStatus;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.reports.entity.ContractorWiseAbstractReport;
import org.egov.works.reports.entity.ContractorWiseAbstractSearchResult;
import org.egov.works.reports.entity.EstimateAbstractReport;
import org.egov.works.reports.entity.WorkProgressRegister;
import org.egov.works.reports.entity.WorkProgressRegisterSearchRequest;
import org.egov.works.reports.entity.enums.WorkStatus;
import org.egov.works.reports.repository.WorkProgressRegisterRepository;
import org.egov.works.workorder.entity.WorkOrder;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkProgressRegisterService {
    @Autowired
    private LineEstimateDetailsRepository lineEstimateDetailsRepository;
    @Autowired
    private WorkProgressRegisterRepository workProgressRegisterRepository;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @PersistenceContext
    private EntityManager entityManager;

    public List<String> findWorkIdentificationNumbersToSearchLineEstimatesForLoa(String code) {
        List<String> workIdNumbers = this.lineEstimateDetailsRepository.findWorkIdentificationNumbersToSearchWorkProgressRegister("%" + code + "%", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
        return workIdNumbers;
    }

    @Transactional
    public List<WorkProgressRegister> searchWorkProgressRegister(WorkProgressRegisterSearchRequest workProgressRegisterSearchRequest) {
        if (workProgressRegisterSearchRequest != null) {
            Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkProgressRegister.class);
            if (workProgressRegisterSearchRequest.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"department.id", (Object)workProgressRegisterSearchRequest.getDepartment()));
            }
            if (workProgressRegisterSearchRequest.getWorkIdentificationNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"winCode", (Object)workProgressRegisterSearchRequest.getWorkIdentificationNumber()).ignoreCase());
            }
            if (workProgressRegisterSearchRequest.getContractor() != null) {
                criteria.createAlias("contractor", "contractor");
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"contractor.code", (String)workProgressRegisterSearchRequest.getContractor(), (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)"contractor.name", (String)workProgressRegisterSearchRequest.getContractor(), (MatchMode)MatchMode.ANYWHERE)));
            }
            if (workProgressRegisterSearchRequest.getAdminSanctionFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"adminSanctionDate", (Object)workProgressRegisterSearchRequest.getAdminSanctionFromDate()));
            }
            if (workProgressRegisterSearchRequest.getAdminSanctionToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"adminSanctionDate", (Object)workProgressRegisterSearchRequest.getAdminSanctionToDate()));
            }
            if (workProgressRegisterSearchRequest.isSpillOverFlag()) {
                criteria.add((Criterion)Restrictions.eq((String)"spillOverFlag", (Object)workProgressRegisterSearchRequest.isSpillOverFlag()));
            }
            if (workProgressRegisterSearchRequest.getWorkStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"workstatus", (Object)workProgressRegisterSearchRequest.getWorkStatus()));
            }
            criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            return criteria.list();
        }
        return new ArrayList<WorkProgressRegister>();
    }

    public Date getReportSchedulerRunDate() {
        Query query = null;
        query = ((Session)this.entityManager.unwrap(Session.class)).createQuery("from WorkProgressRegister ");
        List obj = query.setMaxResults(1).list();
        Date runDate = null;
        if (obj != null) {
            runDate = ((WorkProgressRegister)((Object)obj.get(0))).getCreatedDate();
        }
        return runDate;
    }

    @Transactional
    public List<EstimateAbstractReport> searchEstimateAbstractReportByDepartmentWise(EstimateAbstractReport estimateAbstractReport) {
        Query query = null;
        query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.getQueryForDepartmentWiseReport(estimateAbstractReport)).addScalar("departmentName", (Type)StringType.INSTANCE).addScalar("lineEstimates", (Type)StringType.INSTANCE).addScalar("adminSanctionedEstimates", (Type)StringType.INSTANCE).addScalar("leAdminSanctionedAmountInCrores", (Type)StringType.INSTANCE).addScalar("aeAdminSanctionedAmountInCrores", (Type)StringType.INSTANCE).addScalar("workValueOfAdminSanctionedAEInCrores", (Type)StringType.INSTANCE).addScalar("technicalSanctionedEstimates", (Type)StringType.INSTANCE).addScalar("loaCreated", (Type)StringType.INSTANCE).addScalar("loaNotCreated", (Type)StringType.INSTANCE).addScalar("workNotCommenced", (Type)StringType.INSTANCE).addScalar("agreementValueInCrores", (Type)StringType.INSTANCE).addScalar("workInProgress", (Type)StringType.INSTANCE).addScalar("workCompleted", (Type)StringType.INSTANCE).addScalar("billsCreated", (Type)StringType.INSTANCE).addScalar("billValueInCrores", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(EstimateAbstractReport.class));
        query = this.setParameterForDepartmentWiseReport(estimateAbstractReport, query);
        return query.list();
    }

    private Query setParameterForDepartmentWiseReport(EstimateAbstractReport estimateAbstractReport, Query query) {
        if (estimateAbstractReport != null) {
            if (estimateAbstractReport.isSpillOverFlag()) {
                query.setBoolean("spilloverflag", true);
            }
            if (estimateAbstractReport.getDepartment() != null) {
                query.setLong("department", estimateAbstractReport.getDepartment().longValue());
            }
            if (estimateAbstractReport.getAdminSanctionFromDate() != null) {
                query.setDate("fromDate", estimateAbstractReport.getAdminSanctionFromDate());
            }
            if (estimateAbstractReport.getAdminSanctionToDate() != null) {
                query.setDate("toDate", estimateAbstractReport.getAdminSanctionToDate());
            }
            if (estimateAbstractReport.getScheme() != null) {
                query.setLong("scheme", (long)estimateAbstractReport.getScheme().intValue());
            }
            if (estimateAbstractReport.getSubScheme() != null) {
                query.setLong("subScheme", (long)estimateAbstractReport.getSubScheme().intValue());
            }
            if (estimateAbstractReport.getWorkCategory() != null) {
                query.setString("workcategory", estimateAbstractReport.getWorkCategory());
            }
            if (estimateAbstractReport.getBeneficiary() != null) {
                query.setString("beneficiary", estimateAbstractReport.getBeneficiary());
            }
            if (estimateAbstractReport.getNatureOfWork() != null) {
                query.setLong("natureofwork", estimateAbstractReport.getNatureOfWork().longValue());
            }
            if (estimateAbstractReport.getWorkStatus() != null && !estimateAbstractReport.getWorkStatus().equalsIgnoreCase("")) {
                query.setString("workstatus", estimateAbstractReport.getWorkStatus().replace("_", " "));
            }
        }
        return query;
    }

    private Query setParameterForTypeOfWorkWiseReport(EstimateAbstractReport estimateAbstractReport, Query query) {
        if (estimateAbstractReport != null) {
            if (estimateAbstractReport.isSpillOverFlag()) {
                query.setBoolean("spilloverflag", true);
            }
            if (estimateAbstractReport.getTypeOfWork() != null) {
                query.setLong("typeofwork", estimateAbstractReport.getTypeOfWork().longValue());
            }
            if (estimateAbstractReport.getSubTypeOfWork() != null) {
                query.setLong("subtypeofwork", estimateAbstractReport.getSubTypeOfWork().longValue());
            }
            if (estimateAbstractReport.getDepartments() != null && !estimateAbstractReport.getDepartments().toString().equalsIgnoreCase("[null]") && !estimateAbstractReport.getDepartments().toString().equalsIgnoreCase("[]")) {
                ArrayList<Long> departmentIds = new ArrayList<Long>();
                for (Department dept : estimateAbstractReport.getDepartments()) {
                    departmentIds.add(dept.getId());
                }
                query.setParameterList("departmentIds", departmentIds);
            }
            if (estimateAbstractReport.getAdminSanctionFromDate() != null) {
                query.setDate("fromDate", estimateAbstractReport.getAdminSanctionFromDate());
            }
            if (estimateAbstractReport.getAdminSanctionToDate() != null) {
                query.setDate("toDate", estimateAbstractReport.getAdminSanctionToDate());
            }
            if (estimateAbstractReport.getScheme() != null) {
                query.setLong("scheme", (long)estimateAbstractReport.getScheme().intValue());
            }
            if (estimateAbstractReport.getSubScheme() != null) {
                query.setLong("subScheme", (long)estimateAbstractReport.getSubScheme().intValue());
            }
            if (estimateAbstractReport.getWorkCategory() != null) {
                query.setString("workcategory", estimateAbstractReport.getWorkCategory());
            }
            if (estimateAbstractReport.getBeneficiary() != null) {
                query.setString("beneficiary", estimateAbstractReport.getBeneficiary());
            }
            if (estimateAbstractReport.getNatureOfWork() != null) {
                query.setLong("natureofwork", estimateAbstractReport.getNatureOfWork().longValue());
            }
            if (estimateAbstractReport.getWorkStatus() != null && !estimateAbstractReport.getWorkStatus().equalsIgnoreCase("")) {
                query.setString("workstatus", estimateAbstractReport.getWorkStatus().replace("_", " "));
            }
        }
        return query;
    }

    @Transactional
    public List<EstimateAbstractReport> searchEstimateAbstractReportByTypeOfWorkWise(EstimateAbstractReport estimateAbstractReport) {
        Query query = null;
        if (estimateAbstractReport.getDepartments() != null && !estimateAbstractReport.getDepartments().toString().equalsIgnoreCase("[null]") && !estimateAbstractReport.getDepartments().toString().equalsIgnoreCase("[]")) {
            query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.getQueryForTypeOfWorkWiseReport(estimateAbstractReport)).addScalar("typeOfWorkName", (Type)StringType.INSTANCE).addScalar("subTypeOfWorkName", (Type)StringType.INSTANCE).addScalar("departmentName", (Type)StringType.INSTANCE).addScalar("lineEstimates", (Type)StringType.INSTANCE).addScalar("adminSanctionedEstimates", (Type)StringType.INSTANCE).addScalar("leAdminSanctionedAmountInCrores", (Type)StringType.INSTANCE).addScalar("aeAdminSanctionedAmountInCrores", (Type)StringType.INSTANCE).addScalar("workValueOfAdminSanctionedAEInCrores", (Type)StringType.INSTANCE).addScalar("technicalSanctionedEstimates", (Type)StringType.INSTANCE).addScalar("loaCreated", (Type)StringType.INSTANCE).addScalar("agreementValueInCrores", (Type)StringType.INSTANCE).addScalar("loaNotCreated", (Type)StringType.INSTANCE).addScalar("workNotCommenced", (Type)StringType.INSTANCE).addScalar("workInProgress", (Type)StringType.INSTANCE).addScalar("workCompleted", (Type)StringType.INSTANCE).addScalar("billsCreated", (Type)StringType.INSTANCE).addScalar("billValueInCrores", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(EstimateAbstractReport.class));
            query = this.setParameterForTypeOfWorkWiseReport(estimateAbstractReport, query);
        } else {
            query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.getQueryForTypeOfWorkWiseReport(estimateAbstractReport)).addScalar("typeOfWorkName", (Type)StringType.INSTANCE).addScalar("subTypeOfWorkName", (Type)StringType.INSTANCE).addScalar("lineEstimates", (Type)StringType.INSTANCE).addScalar("adminSanctionedEstimates", (Type)StringType.INSTANCE).addScalar("leAdminSanctionedAmountInCrores", (Type)StringType.INSTANCE).addScalar("aeAdminSanctionedAmountInCrores", (Type)StringType.INSTANCE).addScalar("workValueOfAdminSanctionedAEInCrores", (Type)StringType.INSTANCE).addScalar("technicalSanctionedEstimates", (Type)StringType.INSTANCE).addScalar("loaCreated", (Type)StringType.INSTANCE).addScalar("agreementValueInCrores", (Type)StringType.INSTANCE).addScalar("loaNotCreated", (Type)StringType.INSTANCE).addScalar("workNotCommenced", (Type)StringType.INSTANCE).addScalar("workInProgress", (Type)StringType.INSTANCE).addScalar("workCompleted", (Type)StringType.INSTANCE).addScalar("billsCreated", (Type)StringType.INSTANCE).addScalar("billValueInCrores", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(EstimateAbstractReport.class));
            query = this.setParameterForTypeOfWorkWiseReport(estimateAbstractReport, query);
        }
        return query.list();
    }

    private String getQueryForDepartmentWiseReport(EstimateAbstractReport estimateAbstractReport) {
        StringBuilder filterConditions = new StringBuilder();
        if (estimateAbstractReport != null) {
            if (estimateAbstractReport.getDepartment() != null) {
                filterConditions.append(" AND details.department =:department ");
            }
            if (estimateAbstractReport.getAdminSanctionFromDate() != null) {
                filterConditions.append(" AND details.adminsanctiondate >=:fromDate ");
            }
            if (estimateAbstractReport.getAdminSanctionToDate() != null) {
                filterConditions.append(" AND details.adminsanctiondate <=:toDate ");
            }
            if (estimateAbstractReport.getScheme() != null) {
                filterConditions.append(" AND details.scheme =:scheme ");
            }
            if (estimateAbstractReport.getSubScheme() != null) {
                filterConditions.append(" AND details.subScheme =:subScheme ");
            }
            if (estimateAbstractReport.getWorkCategory() != null) {
                filterConditions.append(" AND details.workcategory =:workcategory ");
            }
            if (estimateAbstractReport.getBeneficiary() != null) {
                filterConditions.append(" AND details.beneficiary =:beneficiary ");
            }
            if (estimateAbstractReport.getNatureOfWork() != null) {
                filterConditions.append(" AND details.natureofwork =:natureofwork ");
            }
            if (estimateAbstractReport.isSpillOverFlag()) {
                filterConditions.append(" AND details.spilloverflag =:spilloverflag ");
            }
            if (estimateAbstractReport.getWorkStatus() != null && !estimateAbstractReport.getWorkStatus().equalsIgnoreCase("")) {
                filterConditions.append(" AND details.workstatus =:workstatus ");
            }
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT departmentName AS departmentName, ");
        query.append(" SUM(lineEstimates)                 AS lineEstimates ,  ");
        query.append(" SUM(lineEstimateDetails)           AS lineEstimateDetails ,  ");
        query.append(" SUM(leAdminSanctionedAmountInCrores) AS leAdminSanctionedAmountInCrores,  ");
        query.append(" SUM(adminSanctionedEstimates)        AS adminSanctionedEstimates,  ");
        query.append(" SUM(aeAdminSanctionedAmountInCrores) AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" SUM(workValueOfAdminSanctionedAEInCrores) AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" SUM(technicalSanctionedEstimates)  AS technicalSanctionedEstimates,  ");
        query.append(" SUM(loaCreated)                    AS loaCreated,  ");
        query.append(" SUM(agreementValueInCrores)        AS agreementValueInCrores,  ");
        query.append(" SUM(loaNotCreated)                 AS loaNotCreated, ");
        query.append(" SUM(workNotCommenced)              AS workNotCommenced, ");
        query.append(" SUM(workInProgress)                AS workInProgress,  ");
        query.append(" SUM(workCompleted)                 AS workCompleted ,  ");
        query.append(" SUM(billsCreated)                  AS billsCreated,  ");
        query.append(" SUM(billValueInCrores)             AS billValueInCrores  ");
        query.append(" FROM  ");
        query.append(" (  ");
        query.append(" SELECT details.departmentName        AS departmentName,  ");
        query.append(" COUNT(DISTINCT details.leid)         AS lineEstimates,  ");
        query.append(" COUNT(details.ledid)                 AS lineEstimateDetails,  ");
        query.append(" SUM(details.adminSanctionAmount)/10000000 AS leAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                    AS adminSanctionedEstimates,  ");
        query.append(" 0                                    AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                    AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                    AS technicalSanctionedEstimates,  ");
        query.append(" 0                                    AS loaCreated,  ");
        query.append(" 0                                    AS agreementValueInCrores, ");
        query.append(" 0                                    AS loaNotCreated, ");
        query.append(" 0                                    AS workNotCommenced, ");
        query.append(" 0                                    AS workInProgress, ");
        query.append(" 0                                    AS workCompleted , ");
        query.append(" 0                                    AS billsCreated, ");
        query.append(" 0                                    AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append("   egw_status status ");
        query.append(" WHERE details.lineestimatestatus = status.code ");
        query.append(" AND status.code       IN ('TECHNICAL_SANCTIONED','ADMINISTRATIVE_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName        AS departmentName, ");
        query.append(" 0                                    AS lineEstimates, ");
        query.append(" 0                                    AS lineEstimateDetails, ");
        query.append(" 0                                    AS leAdminSanctionedAmountInCrores, ");
        query.append(" COUNT(details.estimatestatuscode)    AS adminSanctionedEstimates, ");
        query.append(" SUM(details.estimatevalue)/10000000  AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" SUM(details.workvalue)/10000000      AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                    AS technicalSanctionedEstimates, ");
        query.append(" 0                                    AS loaCreated, ");
        query.append(" 0                                    AS agreementValueInCrores, ");
        query.append(" 0                                    AS loaNotCreated, ");
        query.append(" 0                                    AS workNotCommenced, ");
        query.append(" 0                                    AS workInProgress, ");
        query.append(" 0                                    AS workCompleted , ");
        query.append(" 0                                    AS billsCreated, ");
        query.append(" 0                                    AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append(" egw_status status ");
        query.append(" WHERE details.estimatestatuscode = status.code ");
        query.append(" AND status.code       IN ('ADMIN_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName AS departmentName, ");
        query.append(" 0                           AS lineEstimates, ");
        query.append(" 0                           AS lineEstimateDetails, ");
        query.append(" 0                           AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                           AS adminSanctionedEstimates, ");
        query.append(" 0                           AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                           AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" COUNT(details.estimatestatuscode)     AS technicalSanctionedEstimates, ");
        query.append(" 0                           AS loaCreated, ");
        query.append(" 0                           AS agreementValueInCrores, ");
        query.append(" 0                           AS loaNotCreated, ");
        query.append(" 0                           AS workNotCommenced, ");
        query.append(" 0                           AS workInProgress, ");
        query.append(" 0                           AS workCompleted , ");
        query.append(" 0                           AS billsCreated, ");
        query.append(" 0                           AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append(" egw_status status ");
        query.append(" WHERE details.estimatestatuscode = status.code ");
        query.append(" AND status.code       IN ('ADMIN_SANCTIONED','TECH_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName         AS departmentName, ");
        query.append(" 0                                     AS lineEstimates, ");
        query.append(" 0                                     AS lineEstimateDetails, ");
        query.append(" 0                                     AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                                     AS adminSanctionedEstimates, ");
        query.append(" 0                                     AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                     AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                     AS technicalSanctionedEstimates, ");
        query.append(" COUNT(details.ledid)                  AS loaCreated, ");
        query.append(" SUM(details.agreementamount)/10000000 AS agreementValueInCrores, ");
        query.append(" 0                                     AS loaNotCreated, ");
        query.append(" 0                                     AS workNotCommenced, ");
        query.append(" 0                                     AS workInProgress, ");
        query.append(" 0                                     AS workCompleted, ");
        query.append(" 0                                     AS billsCreated, ");
        query.append(" 0                                     AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.agreementnumber IS NOT NULL ");
        query.append(" AND details.wostatuscode       = 'APPROVED' ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName         AS departmentName, ");
        query.append(" 0                                     AS lineEstimates, ");
        query.append(" 0                                     AS lineEstimateDetails, ");
        query.append(" 0                                     AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                                     AS adminSanctionedEstimates, ");
        query.append(" 0                                     AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                     AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                     AS technicalSanctionedEstimates, ");
        query.append(" 0                                     AS loaCreated, ");
        query.append(" 0                                     AS agreementValueInCrores, ");
        query.append(" COUNT(details.ledid)                  AS loaNotCreated, ");
        query.append(" 0                                     AS workNotCommenced, ");
        query.append(" 0                                     AS workInProgress, ");
        query.append(" 0                                     AS workCompleted, ");
        query.append(" 0                                     AS billsCreated, ");
        query.append(" 0                                     AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workstatus       = '" + WorkStatus.LOA_Not_Created.toString() + "' ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName         AS departmentName, ");
        query.append(" 0                                     AS lineEstimates, ");
        query.append(" 0                                     AS lineEstimateDetails, ");
        query.append(" 0                                     AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                                     AS adminSanctionedEstimates, ");
        query.append(" 0                                     AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                     AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                     AS technicalSanctionedEstimates, ");
        query.append(" 0                                     AS loaCreated, ");
        query.append(" 0                                     AS agreementValueInCrores, ");
        query.append(" 0                                     AS loaNotCreated, ");
        query.append(" COUNT(details.ledid)                  AS workNotCommenced, ");
        query.append(" 0                                     AS workInProgress, ");
        query.append(" 0                                     AS workCompleted, ");
        query.append(" 0                                     AS billsCreated, ");
        query.append(" 0                                     AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workstatus       = '" + WorkStatus.Not_Commenced.toString() + "' ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName AS departmentName, ");
        query.append(" 0                             AS lineEstimates, ");
        query.append(" 0                             AS lineEstimateDetails, ");
        query.append(" 0                             AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                             AS adminSanctionedEstimates, ");
        query.append(" 0                             AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                             AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                             AS technicalSanctionedEstimates, ");
        query.append(" 0                             AS loaCreated, ");
        query.append(" 0                             AS agreementValueInCrores, ");
        query.append(" 0                             AS loaNotCreated, ");
        query.append(" 0                             AS workNotCommenced, ");
        query.append(" COUNT(DISTINCT details.ledid) AS workInProgress, ");
        query.append(" 0                             AS workCompleted, ");
        query.append(" 0                             AS billsCreated, ");
        query.append(" 0                             AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workstatus       = '" + WorkStatus.In_Progress.toString() + "' ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName AS departmentName, ");
        query.append(" 0                             AS lineEstimates, ");
        query.append(" 0                             AS lineEstimateDetails, ");
        query.append(" 0                             AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                             AS adminSanctionedEstimates, ");
        query.append(" 0                             AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                             AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                             AS technicalSanctionedEstimates, ");
        query.append(" 0                             AS loaCreated, ");
        query.append(" 0                             AS agreementValueInCrores, ");
        query.append(" 0                             AS loaNotCreated, ");
        query.append(" 0                             AS workNotCommenced, ");
        query.append(" 0                             AS workInProgress, ");
        query.append(" COUNT(DISTINCT details.ledid) AS workCompleted, ");
        query.append(" 0                             AS billsCreated, ");
        query.append(" 0                             AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workstatus       = '" + WorkStatus.Completed.toString() + "' ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName       AS departmentName, ");
        query.append(" 0                                   AS lineEstimates, ");
        query.append(" 0                                   AS lineEstimateDetails, ");
        query.append(" 0                                   AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                                   AS adminSanctionedEstimates, ");
        query.append(" 0                                   AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                   AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                   AS technicalSanctionedEstimates, ");
        query.append(" 0                                   AS loaCreated, ");
        query.append(" 0                                   AS agreementValueInCrores, ");
        query.append(" 0                                   AS loaNotCreated, ");
        query.append(" 0                                   AS workNotCommenced, ");
        query.append(" 0                                   AS workInProgress, ");
        query.append(" 0                                   AS workCompleted , ");
        query.append(" COUNT(DISTINCT billdetail.billid)   AS billsCreated, ");
        query.append(" SUM(billdetail.billamount)/10000000 AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details , ");
        query.append(" egw_mv_billdetail billdetail ");
        query.append(" WHERE billdetail.ledid = details.ledid ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" ) final ");
        query.append(" GROUP BY departmentname  ");
        return query.toString();
    }

    private String getQueryForTypeOfWorkWiseReport(EstimateAbstractReport estimateAbstractReport) {
        StringBuilder filterConditions = new StringBuilder();
        StringBuilder selectQuery = new StringBuilder();
        StringBuilder groupByQuery = new StringBuilder();
        StringBuilder mainSelectQuery = new StringBuilder();
        StringBuilder mainGroupByQuery = new StringBuilder();
        if (estimateAbstractReport.getDepartments() != null && !estimateAbstractReport.getDepartments().toString().equalsIgnoreCase("[null]") && !estimateAbstractReport.getDepartments().toString().equalsIgnoreCase("[]")) {
            filterConditions.append(" AND details.department in ( :departmentIds ) ");
            selectQuery.append(" SELECT details.typeOfWorkName       AS typeOfWorkName,  ");
            selectQuery.append(" details.subTypeOfWorkName         AS subTypeOfWorkName,  ");
            selectQuery.append(" details.departmentName         AS departmentName,  ");
            mainSelectQuery.append(" SELECT typeOfWorkName       AS typeOfWorkName,  ");
            mainSelectQuery.append(" subTypeOfWorkName         AS subTypeOfWorkName,  ");
            mainSelectQuery.append(" departmentName         AS departmentName,  ");
            groupByQuery.append(" GROUP BY details.typeOfWorkName,details.subTypeOfWorkName,details.departmentName ");
            mainGroupByQuery.append(" GROUP BY typeofworkname,subtypeofworkname,departmentname ");
        } else {
            selectQuery.append(" SELECT details.typeOfWorkName       AS typeOfWorkName,  ");
            selectQuery.append(" details.subTypeOfWorkName         AS subTypeOfWorkName,  ");
            mainSelectQuery.append(" SELECT typeOfWorkName       AS typeOfWorkName,  ");
            mainSelectQuery.append(" subTypeOfWorkName         AS subTypeOfWorkName,  ");
            groupByQuery.append(" GROUP BY details.typeOfWorkName,details.subTypeOfWorkName ");
            mainGroupByQuery.append(" GROUP BY typeofworkname,subtypeofworkname ");
        }
        if (estimateAbstractReport != null) {
            if (estimateAbstractReport.getTypeOfWork() != null) {
                filterConditions.append(" AND details.typeofwork =:typeofwork ");
            }
            if (estimateAbstractReport.getSubTypeOfWork() != null) {
                filterConditions.append(" AND details.subtypeofwork =:subtypeofwork ");
            }
            if (estimateAbstractReport.getAdminSanctionFromDate() != null) {
                filterConditions.append(" AND details.adminsanctiondate >=:fromDate ");
            }
            if (estimateAbstractReport.getAdminSanctionToDate() != null) {
                filterConditions.append(" AND details.adminsanctiondate <=:toDate ");
            }
            if (estimateAbstractReport.getScheme() != null) {
                filterConditions.append(" AND details.scheme =:scheme ");
            }
            if (estimateAbstractReport.getSubScheme() != null) {
                filterConditions.append(" AND details.subScheme =:subScheme ");
            }
            if (estimateAbstractReport.getWorkCategory() != null) {
                filterConditions.append(" AND details.workcategory =:workcategory ");
            }
            if (estimateAbstractReport.getBeneficiary() != null) {
                filterConditions.append(" AND details.beneficiary =:beneficiary ");
            }
            if (estimateAbstractReport.getNatureOfWork() != null) {
                filterConditions.append(" AND details.natureofwork =:natureofwork ");
            }
            if (estimateAbstractReport.isSpillOverFlag()) {
                filterConditions.append(" AND details.spilloverflag =:spilloverflag ");
            }
            if (estimateAbstractReport.getWorkStatus() != null && !estimateAbstractReport.getWorkStatus().equalsIgnoreCase("")) {
                filterConditions.append(" AND details.workstatus =:workstatus ");
            }
        }
        StringBuilder query = new StringBuilder();
        query.append(mainSelectQuery.toString());
        query.append(" SUM(lineEstimates)                 AS lineEstimates ,  ");
        query.append(" SUM(lineEstimateDetails)           AS lineEstimateDetails ,  ");
        query.append(" SUM(leAdminSanctionedAmountInCrores) AS leAdminSanctionedAmountInCrores,  ");
        query.append(" SUM(adminSanctionedEstimates)        AS adminSanctionedEstimates,  ");
        query.append(" SUM(aeAdminSanctionedAmountInCrores) AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" SUM(workValueOfAdminSanctionedAEInCrores) AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" SUM(technicalSanctionedEstimates)  AS technicalSanctionedEstimates,  ");
        query.append(" SUM(loaCreated)                    AS loaCreated,  ");
        query.append(" SUM(agreementValueInCrores)        AS agreementValueInCrores,  ");
        query.append(" SUM(loaNotCreated)                 AS loaNotCreated, ");
        query.append(" SUM(workNotCommenced)              AS workNotCommenced, ");
        query.append(" SUM(workInProgress)                AS workInProgress,  ");
        query.append(" SUM(workCompleted)                 AS workCompleted ,  ");
        query.append(" SUM(billsCreated)                  AS billsCreated,  ");
        query.append(" SUM(billValueInCrores)             AS billValueInCrores  ");
        query.append(" FROM  ");
        query.append(" (  ");
        query.append(selectQuery.toString());
        query.append(" COUNT(DISTINCT details.leid)         AS lineEstimates,  ");
        query.append(" COUNT(details.ledid)                 AS lineEstimateDetails,  ");
        query.append(" SUM(details.adminSanctionAmount)/10000000 AS leAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                    AS adminSanctionedEstimates,  ");
        query.append(" 0                                    AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                    AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                    AS technicalSanctionedEstimates,  ");
        query.append(" 0                                    AS loaCreated,  ");
        query.append(" 0                                    AS agreementValueInCrores, ");
        query.append(" 0                                    AS loaNotCreated, ");
        query.append(" 0                                    AS workNotCommenced, ");
        query.append(" 0                                    AS workInProgress, ");
        query.append(" 0                                    AS workCompleted , ");
        query.append(" 0                                    AS billsCreated, ");
        query.append(" 0                                    AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append("   egw_status status ");
        query.append(" WHERE details.lineestimatestatus = status.code ");
        query.append(" AND status.code       IN ('TECHNICAL_SANCTIONED','ADMINISTRATIVE_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                                    AS lineEstimates, ");
        query.append(" 0                                    AS lineEstimateDetails, ");
        query.append(" 0                                    AS leAdminSanctionedAmountInCrores, ");
        query.append(" COUNT(details.estimatestatuscode)    AS adminSanctionedEstimates, ");
        query.append(" SUM(details.estimatevalue)/10000000  AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" SUM(details.workvalue)/10000000      AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                    AS technicalSanctionedEstimates, ");
        query.append(" 0                                    AS loaCreated, ");
        query.append(" 0                                    AS agreementValueInCrores, ");
        query.append(" 0                                    AS loaNotCreated, ");
        query.append(" 0                                    AS workNotCommenced, ");
        query.append(" 0                                    AS workInProgress, ");
        query.append(" 0                                    AS workCompleted , ");
        query.append(" 0                                    AS billsCreated, ");
        query.append(" 0                                    AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append(" egw_status status ");
        query.append(" WHERE details.estimatestatuscode = status.code ");
        query.append(" AND status.code       IN ('ADMIN_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                           AS lineEstimates, ");
        query.append(" 0                           AS lineEstimateDetails, ");
        query.append(" 0                           AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                           AS adminSanctionedEstimates,  ");
        query.append(" 0                           AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                           AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" COUNT(details.estimatestatuscode)     AS technicalSanctionedEstimates, ");
        query.append(" 0                           AS loaCreated, ");
        query.append(" 0                           AS agreementValueInCrores, ");
        query.append(" 0                           AS loaNotCreated, ");
        query.append(" 0                           AS workNotCommenced, ");
        query.append(" 0                           AS workInProgress, ");
        query.append(" 0                           AS workCompleted , ");
        query.append(" 0                           AS billsCreated, ");
        query.append(" 0                           AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append(" egw_status status ");
        query.append(" WHERE details.estimatestatuscode = status.code ");
        query.append(" AND status.code       IN ('ADMIN_SANCTIONED','TECH_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                                     AS lineEstimates, ");
        query.append(" 0                                     AS lineEstimateDetails, ");
        query.append(" 0                                     AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                                     AS adminSanctionedEstimates,  ");
        query.append(" 0                                     AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                     AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                     AS technicalSanctionedEstimates, ");
        query.append(" COUNT(details.ledid)                  AS loaCreated, ");
        query.append(" SUM(details.agreementamount)/10000000 AS agreementValueInCrores, ");
        query.append(" 0                                     AS loaNotCreated, ");
        query.append(" 0                                     AS workNotCommenced, ");
        query.append(" 0                                     AS workInProgress, ");
        query.append(" 0                                     AS workCompleted, ");
        query.append(" 0                                     AS billsCreated, ");
        query.append(" 0                                     AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.agreementnumber IS NOT NULL ");
        query.append(" AND details.wostatuscode       = 'APPROVED' ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                                     AS lineEstimates, ");
        query.append(" 0                                     AS lineEstimateDetails, ");
        query.append(" 0                                     AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                                     AS adminSanctionedEstimates,  ");
        query.append(" 0                                     AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                     AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                     AS technicalSanctionedEstimates, ");
        query.append(" 0                                     AS loaCreated, ");
        query.append(" 0                                     AS agreementValueInCrores, ");
        query.append(" COUNT(details.ledid)                  AS loaNotCreated, ");
        query.append(" 0                                     AS workNotCommenced, ");
        query.append(" 0                                     AS workInProgress, ");
        query.append(" 0                                     AS workCompleted, ");
        query.append(" 0                                     AS billsCreated, ");
        query.append(" 0                                     AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workstatus       = '" + WorkStatus.LOA_Not_Created.toString() + "' ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                                     AS lineEstimates, ");
        query.append(" 0                                     AS lineEstimateDetails, ");
        query.append(" 0                                     AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                                     AS adminSanctionedEstimates,  ");
        query.append(" 0                                     AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                     AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                     AS technicalSanctionedEstimates, ");
        query.append(" 0                                     AS loaCreated, ");
        query.append(" 0                                     AS agreementValueInCrores, ");
        query.append(" 0                                     AS loaNotCreated, ");
        query.append(" COUNT(details.ledid)                  AS workNotCommenced, ");
        query.append(" 0                                     AS workInProgress, ");
        query.append(" 0                                     AS workCompleted, ");
        query.append(" 0                                     AS billsCreated, ");
        query.append(" 0                                     AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workstatus       = '" + WorkStatus.Not_Commenced.toString() + "' ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                                     AS lineEstimates, ");
        query.append(" 0                                     AS lineEstimateDetails, ");
        query.append(" 0                                     AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                                     AS adminSanctionedEstimates,  ");
        query.append(" 0                                     AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                     AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                     AS technicalSanctionedEstimates, ");
        query.append(" 0                                     AS loaCreated, ");
        query.append(" 0                                     AS agreementValueInCrores, ");
        query.append(" 0                                     AS loaNotCreated, ");
        query.append(" 0                                     AS workNotCommenced, ");
        query.append(" COUNT(details.ledid)                  AS workInProgress, ");
        query.append(" 0                                     AS workCompleted, ");
        query.append(" 0                                     AS billsCreated, ");
        query.append(" 0                                     AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workstatus       = '" + WorkStatus.In_Progress.toString() + "' ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                             AS lineEstimates, ");
        query.append(" 0                             AS lineEstimateDetails, ");
        query.append(" 0                             AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                             AS adminSanctionedEstimates,  ");
        query.append(" 0                             AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                             AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                             AS technicalSanctionedEstimates, ");
        query.append(" 0                             AS loaCreated, ");
        query.append(" 0                             AS agreementValueInCrores, ");
        query.append(" 0                             AS loaNotCreated, ");
        query.append(" 0                             AS workNotCommenced, ");
        query.append(" 0                             AS workInProgress, ");
        query.append(" COUNT(DISTINCT details.ledid) AS workCompleted, ");
        query.append(" 0                             AS billsCreated, ");
        query.append(" 0                             AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workstatus = '" + WorkStatus.Completed.toString() + "' ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                                   AS lineEstimates, ");
        query.append(" 0                                   AS lineEstimateDetails, ");
        query.append(" 0                                   AS leAdminSanctionedAmountInCrores, ");
        query.append(" 0                                   AS adminSanctionedEstimates,  ");
        query.append(" 0                                   AS aeAdminSanctionedAmountInCrores,  ");
        query.append(" 0                                   AS workValueOfAdminSanctionedAEInCrores, ");
        query.append(" 0                                   AS technicalSanctionedEstimates, ");
        query.append(" 0                                   AS loaCreated, ");
        query.append(" 0                                   AS agreementValueInCrores, ");
        query.append(" 0                                   AS loaNotCreated, ");
        query.append(" 0                                   AS workNotCommenced, ");
        query.append(" 0                                   AS workInProgress, ");
        query.append(" 0                                   AS workCompleted , ");
        query.append(" COUNT(DISTINCT billdetail.billid)   AS billsCreated, ");
        query.append(" SUM(billdetail.billamount)/10000000 AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details , ");
        query.append(" egw_mv_billdetail billdetail ");
        query.append(" WHERE billdetail.ledid = details.ledid ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" ) final ");
        query.append(mainGroupByQuery.toString());
        return query.toString();
    }

    public WorkProgressRegister getWorkProgressRegisterByLineEstimateDetailsId(LineEstimateDetails led) {
        return this.workProgressRegisterRepository.findByLineEstimateDetails(led);
    }

    public WorkProgressRegister getWorkProgressRegisterByAbstractEstimate(AbstractEstimate abstractEstimate) {
        return this.workProgressRegisterRepository.findByAbstractEstimate(abstractEstimate);
    }

    public List<ContractorWiseAbstractSearchResult> searchContractorWiseAbstractReport(ContractorWiseAbstractReport contractorWiseAbstractReport) {
        Query query = null;
        query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.getContractorListWithAllstatus(contractorWiseAbstractReport)).addScalar("contractorName", (Type)StringType.INSTANCE).addScalar("contractorCode", (Type)StringType.INSTANCE).addScalar("electionWard", (Type)StringType.INSTANCE).addScalar("approvedEstimates", (Type)IntegerType.INSTANCE).addScalar("approvedAmount", (Type)BigDecimalType.INSTANCE).addScalar("siteNotHandedOverEstimates", (Type)IntegerType.INSTANCE).addScalar("siteNotHandedOverAmount", (Type)BigDecimalType.INSTANCE).addScalar("notWorkCommencedEstimates", (Type)IntegerType.INSTANCE).addScalar("notWorkCommencedAmount", (Type)BigDecimalType.INSTANCE).addScalar("workCommencedEstimates", (Type)IntegerType.INSTANCE).addScalar("workCommencedAmount", (Type)BigDecimalType.INSTANCE).addScalar("lagecyWorkCommencedEstimates", (Type)IntegerType.INSTANCE).addScalar("lagecyWorkCommencedAmount", (Type)BigDecimalType.INSTANCE).addScalar("workCompletedEstimates", (Type)IntegerType.INSTANCE).addScalar("workCompletedAmount", (Type)BigDecimalType.INSTANCE).addScalar("balanceWorkEstimates", (Type)IntegerType.INSTANCE).addScalar("balanceWorkAmount", (Type)BigDecimalType.INSTANCE).addScalar("liableAmount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(ContractorWiseAbstractSearchResult.class));
        query = this.setQueryParametersForContractorWiseReport(contractorWiseAbstractReport, query);
        return query.list();
    }

    private String getContractorListWithAllstatus(ContractorWiseAbstractReport contractorWiseAbstractReport) {
        StringBuilder filterConditions = new StringBuilder();
        if (contractorWiseAbstractReport != null) {
            if (contractorWiseAbstractReport.getFinancialYearId() != null) {
                filterConditions.append(" AND details.adminSanctionDate >= :fromDate");
                filterConditions.append(" AND details.adminSanctionDate <= :toDate ");
            }
            if (contractorWiseAbstractReport.getNatureOfWork() != null) {
                filterConditions.append(" AND details.natureOfWork =:natureOfWork");
            }
            if (StringUtils.isNotBlank((CharSequence)contractorWiseAbstractReport.getWorkStatus())) {
                filterConditions.append(" AND details.workstatus =:workstatus ");
            }
            if (StringUtils.isNotBlank((CharSequence)contractorWiseAbstractReport.getContractor())) {
                filterConditions.append(" AND (details.contractorname like (:contractor) OR details.contractorcode like (:contractor))");
            }
            if (contractorWiseAbstractReport.getElectionWardId() != null) {
                filterConditions.append(" AND details.ward =:ward ");
            }
        }
        String getLOACreatedQuery = this.getLOACreatedQuery(filterConditions.toString(), contractorWiseAbstractReport);
        return getLOACreatedQuery;
    }

    private Query setQueryParametersForContractorWiseReport(ContractorWiseAbstractReport contractorWiseAbstractReport, Query query) {
        if (contractorWiseAbstractReport != null) {
            if (contractorWiseAbstractReport.getFinancialYearId() != null) {
                CFinancialYear finYear = this.cFinancialYearService.findOne(contractorWiseAbstractReport.getFinancialYearId());
                query.setParameter("fromDate", (Object)finYear.getStartingDate());
                query.setParameter("toDate", (Object)finYear.getEndingDate());
            }
            if (contractorWiseAbstractReport.getElectionWardId() != null) {
                query.setParameter("ward", (Object)contractorWiseAbstractReport.getElectionWardId());
            }
            if (contractorWiseAbstractReport.getNatureOfWork() != null) {
                query.setParameter("natureOfWork", (Object)contractorWiseAbstractReport.getNatureOfWork());
            }
            if (StringUtils.isNotBlank((CharSequence)contractorWiseAbstractReport.getWorkStatus())) {
                query.setParameter("workstatus", (Object)contractorWiseAbstractReport.getWorkStatus());
            }
            if (StringUtils.isNotBlank((CharSequence)contractorWiseAbstractReport.getContractor())) {
                query.setParameter("contractor", (Object)contractorWiseAbstractReport.getContractor());
            }
        }
        return query;
    }

    private String getLOACreatedQuery(String commonFilterConditions, ContractorWiseAbstractReport contractorWiseAbstractReport) {
        StringBuilder query = new StringBuilder();
        StringBuilder groupByFilter = new StringBuilder();
        groupByFilter.append(" GROUP BY boundarytype.name, boundary.name,details.boundaryNum ,details.contractorName ,details.contractorCode");
        if (StringUtils.isBlank((CharSequence)contractorWiseAbstractReport.getContractor())) {
            query.append(" SELECT array_agg(electionWard) AS electionWard,contractorName,contractorCode,");
            query.append(" SUM(approvedEstimates)                 AS approvedEstimates ,  ");
            query.append(" SUM(approvedAmount)                    AS approvedAmount ,  ");
            query.append(" SUM(siteNotHandedOverEstimates)        AS siteNotHandedOverEstimates,  ");
            query.append(" SUM(siteNotHandedOverAmount)           AS siteNotHandedOverAmount,  ");
            query.append(" SUM(notWorkCommencedEstimates)         AS notWorkCommencedEstimates,  ");
            query.append(" SUM(notWorkCommencedAmount)            AS notWorkCommencedAmount, ");
            query.append(" SUM(workCommencedEstimates)            AS workCommencedEstimates,  ");
            query.append(" SUM(workCommencedAmount)               AS workCommencedAmount,  ");
            query.append(" SUM(workCompletedEstimates)            AS workCompletedEstimates,  ");
            query.append(" SUM(workCompletedAmount)               AS workCompletedAmount, ");
            query.append(" SUM(lagecyWorkCommencedEstimates)      AS lagecyWorkCommencedEstimates,  ");
            query.append(" SUM(lagecyWorkCommencedAmount)         AS lagecyWorkCommencedAmount, ");
            query.append(" SUM(balanceWorkEstimates)              AS balanceWorkEstimates, ");
            query.append(" SUM(balanceWorkAmount)                 AS balanceWorkAmount,  ");
            query.append(" SUM(liableAmount)                      AS liableAmount   ");
            query.append(" FROM  ");
            query.append(" (  ");
        }
        StringBuilder selectQuery = new StringBuilder();
        selectQuery.append("SELECT (CASE WHEN upper(boundarytype.name) = 'CITY' THEN boundary.name ELSE CAST(details.boundaryNum AS CHAR) END ) AS electionWard,details.contractorName as contractorName,details.contractorCode as contractorCode,");
        query.append(" SELECT electionWard,contractorName,contractorCode,");
        query.append(" SUM(approvedEstimates)                 AS approvedEstimates ,  ");
        query.append(" SUM(approvedAmount)                    AS approvedAmount ,  ");
        query.append(" SUM(siteNotHandedOverEstimates)        AS siteNotHandedOverEstimates,  ");
        query.append(" SUM(siteNotHandedOverAmount)           AS siteNotHandedOverAmount,  ");
        query.append(" SUM(notWorkCommencedEstimates)         AS notWorkCommencedEstimates,  ");
        query.append(" SUM(notWorkCommencedAmount)            AS notWorkCommencedAmount, ");
        query.append(" SUM(workCommencedEstimates)            AS workCommencedEstimates,  ");
        query.append(" SUM(workCommencedAmount)               AS workCommencedAmount,  ");
        query.append(" SUM(workCompletedEstimates)            AS workCompletedEstimates,  ");
        query.append(" SUM(workCompletedAmount)               AS workCompletedAmount, ");
        query.append(" SUM(lagecyWorkCommencedEstimates)      AS lagecyWorkCommencedEstimates,  ");
        query.append(" SUM(lagecyWorkCommencedAmount)         AS lagecyWorkCommencedAmount, ");
        query.append(" SUM(balanceWorkEstimates)              AS balanceWorkEstimates, ");
        query.append(" SUM(balanceWorkAmount)                 AS balanceWorkAmount,  ");
        query.append(" SUM(liableAmount)                      AS liableAmount   ");
        query.append(" FROM  ");
        query.append(" (  ");
        query.append(selectQuery.toString());
        query.append("COUNT(DISTINCT details.agreementnumber)       AS approvedEstimates,");
        query.append("SUM(details.agreementamount)                  AS approvedAmount,");
        query.append("0                                             AS siteNotHandedOverEstimates,");
        query.append("0                                             AS siteNotHandedOverAmount,");
        query.append("0                                             AS notWorkCommencedEstimates,");
        query.append("0                                             AS notWorkCommencedAmount,");
        query.append("0                                             AS workCommencedEstimates,");
        query.append("0                                             AS workCommencedAmount,");
        query.append("0                                             AS lagecyWorkCommencedEstimates,");
        query.append("0                                             AS lagecyWorkCommencedAmount,");
        query.append("0                                             AS workCompletedEstimates,");
        query.append("0                                             AS workCompletedAmount,");
        query.append("0                                             AS balanceWorkEstimates,");
        query.append("0                                             AS balanceWorkAmount, ");
        query.append("0                                             AS liableAmount ");
        query.append(" FROM egw_mv_work_progress_register details left join egw_contractor_detail cd on cd.contractor_id = details.contractor left join eg_boundary boundary on details.ward = boundary.id left join eg_boundary_type boundarytype on boundary.boundaryType = boundarytype.id ");
        query.append(" WHERE  details.woStatusCode = 'APPROVED' ");
        query.append(commonFilterConditions);
        query.append(groupByFilter.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append("0                                                 AS approvedEstimates,");
        query.append("0                                                 AS approvedAmount,");
        query.append("COUNT(DISTINCT details.agreementnumber)           AS siteNotHandedOverEstimates,");
        query.append("SUM(details.agreementamount)                      AS siteNotHandedOverAmount,");
        query.append("0                                                 AS notWorkCommencedEstimates,");
        query.append("0                                                 AS notWorkCommencedAmount,");
        query.append("0                                                 AS workCommencedEstimates,");
        query.append("0                                                 AS workCommencedAmount,");
        query.append("0                                                 AS lagecyWorkCommencedEstimates,");
        query.append("0                                                 AS lagecyWorkCommencedAmount,");
        query.append("0                                                 AS workCompletedEstimates,");
        query.append("0                                                 AS workCompletedAmount,");
        query.append("0                                                 AS balanceWorkEstimates,");
        query.append("0                                                 AS balanceWorkAmount, ");
        query.append("0                                                 AS liableAmount ");
        query.append(" FROM egw_mv_work_progress_register details left join egw_contractor_detail cd on cd.contractor_id = details.contractor left join eg_boundary boundary on details.ward = boundary.id left join eg_boundary_type boundarytype on boundary.boundaryType = boundarytype.id ");
        query.append(" WHERE details.woStatusCode = 'APPROVED' ");
        query.append(" AND details.woOfflineStatusCode not in ('" + WorkOrder.OfflineStatuses.SITE_HANDED_OVER.toString().toUpperCase() + "','" + WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase() + "') ");
        query.append(commonFilterConditions);
        query.append(groupByFilter.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append("0                                                 AS approvedEstimates,");
        query.append("0                                                 AS approvedAmount,");
        query.append("0                                                 AS siteNotHandedOverEstimates,");
        query.append("0                                                 AS siteNotHandedOverAmount,");
        query.append("COUNT(DISTINCT details.agreementnumber)           AS notWorkCommencedEstimates,");
        query.append("SUM(details.agreementamount)                      AS notWorkCommencedAmount,");
        query.append("0                                                 AS workCommencedEstimates,");
        query.append("0                                                 AS workCommencedAmount,");
        query.append("0                                                 AS lagecyWorkCommencedEstimates,");
        query.append("0                                                 AS lagecyWorkCommencedAmount,");
        query.append("0                                                 AS workCompletedEstimates,");
        query.append("0                                                 AS workCompletedAmount,");
        query.append("0                                                 AS balanceWorkEstimates,");
        query.append("0                                                 AS balanceWorkAmount, ");
        query.append("0                                                 AS liableAmount ");
        query.append(" FROM egw_mv_work_progress_register details left join egw_contractor_detail cd on cd.contractor_id = details.contractor left join eg_boundary boundary on details.ward = boundary.id left join eg_boundary_type boundarytype on boundary.boundaryType = boundarytype.id ");
        query.append(" WHERE details.woStatusCode = 'APPROVED' ");
        query.append(" AND details.woOfflineStatusCode = '" + WorkOrder.OfflineStatuses.SITE_HANDED_OVER.toString().toUpperCase() + "' ");
        query.append(commonFilterConditions);
        query.append(groupByFilter.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append("0                                                 AS approvedEstimates,");
        query.append("0                                                 AS approvedAmount,");
        query.append("0                                                 AS siteNotHandedOverEstimates,");
        query.append("0                                                 AS siteNotHandedOverAmount,");
        query.append("0                                                 AS notWorkCommencedEstimates,");
        query.append("0                                                 AS notWorkCommencedAmount,");
        query.append("COUNT(DISTINCT details.agreementnumber)           AS workCommencedEstimates,");
        query.append("SUM(details.agreementamount)                      AS workCommencedAmount,");
        query.append("0                                                 AS lagecyWorkCommencedEstimates,");
        query.append("0                                                 AS lagecyWorkCommencedAmount,");
        query.append("0                                                 AS workCompletedEstimates,");
        query.append("0                                                 AS workCompletedAmount,");
        query.append("0                                                 AS balanceWorkEstimates,");
        query.append("0                                                 AS balanceWorkAmount, ");
        query.append("0                                                 AS liableAmount ");
        query.append(" FROM egw_mv_work_progress_register details left join egw_contractor_detail cd on cd.contractor_id = details.contractor left join eg_boundary boundary on details.ward = boundary.id left join eg_boundary_type boundarytype on boundary.boundaryType = boundarytype.id ");
        query.append(" WHERE details.woStatusCode = 'APPROVED' ");
        query.append(" AND details.woOfflineStatusCode ='" + WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase() + "' ");
        query.append(" AND (details.billtype is NULL OR details.billtype != 'Final Bill' )");
        query.append(" AND details.boqexists = 't' ");
        query.append(commonFilterConditions);
        query.append(groupByFilter.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append("0                                                 AS approvedEstimates,");
        query.append("0                                                 AS approvedAmount,");
        query.append("0                                                 AS siteNotHandedOverEstimates,");
        query.append("0                                                 AS siteNotHandedOverAmount,");
        query.append("0                                                 AS notWorkCommencedEstimates,");
        query.append("0                                                 AS notWorkCommencedAmount,");
        query.append("0                                                 AS workCommencedEstimates,");
        query.append("0                                                 AS workCommencedAmount,");
        query.append("COUNT(DISTINCT details.agreementnumber)           AS lagecyWorkCommencedEstimates,");
        query.append("SUM(details.agreementamount)                      AS lagecyWorkCommencedAmount,");
        query.append("0                                                 AS workCompletedEstimates,");
        query.append("0                                                 AS workCompletedAmount,");
        query.append("0                                                 AS balanceWorkEstimates,");
        query.append("0                                                 AS balanceWorkAmount, ");
        query.append("0                                                 AS liableAmount ");
        query.append(" FROM egw_mv_work_progress_register details left join egw_contractor_detail cd on cd.contractor_id = details.contractor left join eg_boundary boundary on details.ward = boundary.id left join eg_boundary_type boundarytype on boundary.boundaryType = boundarytype.id ");
        query.append(" WHERE details.woStatusCode = 'APPROVED' ");
        query.append(" AND details.billtype != 'Final Bill' AND details.workstatus = '" + WorkStatus.In_Progress.toString() + "' ");
        query.append(" AND details.boqexists = 'f' ");
        query.append(commonFilterConditions);
        query.append(groupByFilter.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append("0                                                 AS approvedEstimates,");
        query.append("0                                                 AS approvedAmount,");
        query.append("0                                                 AS siteNotHandedOverEstimates,");
        query.append("0                                                 AS siteNotHandedOverAmount,");
        query.append("0                                                 AS notWorkCommencedEstimates,");
        query.append("0                                                 AS notWorkCommencedAmount,");
        query.append("0                                                 AS workCommencedEstimates,");
        query.append("0                                                 AS workCommencedAmount,");
        query.append("0                                                 AS lagecyWorkCommencedEstimates,");
        query.append("0                                                 AS lagecyWorkCommencedAmount,");
        query.append("COUNT(DISTINCT details.agreementnumber)           AS workCompletedEstimates,");
        query.append("SUM(details.agreementamount)                      AS workCompletedAmount,");
        query.append("0                                                 AS balanceWorkEstimates,");
        query.append("0                                                 AS balanceWorkAmount, ");
        query.append("0                                                 AS liableAmount ");
        query.append(" FROM egw_mv_work_progress_register details left join egw_contractor_detail cd on cd.contractor_id = details.contractor left join eg_boundary boundary on details.ward = boundary.id left join eg_boundary_type boundarytype on boundary.boundaryType = boundarytype.id ");
        query.append(" WHERE details.woStatusCode = 'APPROVED' ");
        query.append(" AND details.billtype = 'Final Bill' ");
        query.append(commonFilterConditions);
        query.append(groupByFilter.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append("0                                                 AS approvedEstimates,");
        query.append("0                                                 AS approvedAmount,");
        query.append("0                                                 AS siteNotHandedOverEstimates,");
        query.append("0                                                 AS siteNotHandedOverAmount,");
        query.append("0                                                 AS notWorkCommencedEstimates,");
        query.append("0                                                 AS notWorkCommencedAmount,");
        query.append("0                                                 AS workCommencedEstimates,");
        query.append("0                                                 AS workCommencedAmount,");
        query.append("0                                                 AS lagecyWorkCommencedEstimates,");
        query.append("0                                                 AS lagecyWorkCommencedAmount,");
        query.append("0                                                 AS workCompletedEstimates,");
        query.append("0                                                 AS workCompletedAmount,");
        query.append("0                                                 AS balanceWorkEstimates,");
        query.append("0                                                 AS balanceWorkAmount, ");
        query.append("sum(details.totalbillamount)                      AS liableAmount ");
        query.append(" FROM egw_mv_work_progress_register details left join egw_contractor_detail cd on cd.contractor_id = details.contractor left join eg_boundary boundary on details.ward = boundary.id left join eg_boundary_type boundarytype on boundary.boundaryType = boundarytype.id ");
        query.append(" WHERE details.woStatusCode = 'APPROVED' ");
        query.append(" AND details.woOfflineStatusCode ='" + WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase() + "' ");
        query.append(" AND details.billtype != 'Final Bill' ");
        query.append(commonFilterConditions);
        query.append(groupByFilter.toString());
        query.append(" ) final ");
        query.append(" GROUP BY electionWard,contractorName,contractorCode ");
        if (StringUtils.isBlank((CharSequence)contractorWiseAbstractReport.getContractor())) {
            query.append(" ) test ");
            query.append(" GROUP BY contractorName,contractorCode ");
        }
        return query.toString();
    }
}

